/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueAntennaInfoT;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueDeviceInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.upfwk.aue.BoamSubAueBase;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.TransactionWrapper;

public final class RetCascadingWp845Aue
extends BoamSubAueBase {
    private static final String DCI_REFERENCE = "12/109 26-CRH 109 042/1-4";
    public static final int LOW_VERSION = 7000000;
    private static final int HIGH_VERSION = 8012999;
    private static final RetCascadingWp845Aue INSTANCE = new RetCascadingWp845Aue();

    private RetCascadingWp845Aue() {
        super(RetCascadingWp845Aue.class);
    }

    public static RetCascadingWp845Aue instance() {
        return INSTANCE;
    }

    public int getHighVersion() {
        return 8012999;
    }

    public int getLowVersion() {
        return 7000000;
    }

    public String getDciReference() {
        return DCI_REFERENCE;
    }

    protected void triggerConvert(List commands) throws Exception {
        this.traceEnter("triggerConvert(), causing execution");
        commands.add(CommandHandler.createAueCommand(this, 1));
    }

    protected boolean execute(TransactionWrapper tw) throws Exception {
        this.traceEnter("execute()");
        try {
            this.doExecute(tw.getCoordinator());
            return true;
        }
        catch (Exception e) {
            this.info(" \nException thrown during AUE execution: " + e);
            e.printStackTrace();
            return false;
        }
    }

    private void doExecute(Coordinator context) throws Exception {
        this.traceEnter("doExecute()");
        MoIterator moIter = BoamHelper.findMOs((String)"Sector");
        ArrayList<MpswTaAueAntennaInfoT> antennaInfo = new ArrayList<MpswTaAueAntennaInfoT>();
        ArrayList<MpswTaAueDeviceInfoT> DeviceData = new ArrayList<MpswTaAueDeviceInfoT>();
        boolean checkIFRefs = false;
        this.info(" \nFound : " + moIter.size() + " SectorMo's ");
        while (moIter.hasMoreElements()) {
            SectorMo sector = (SectorMo)moIter.nextMo();
            SectorAntennaMo sectorAntennaMo = null;
            RetDeviceMo retDeviceMo = null;
            Object sectorAntennaMoObject = null;
            Object retDeviceMoObject = null;
            try {
                sectorAntennaMoObject = sector.getAttribute("sectorAntennaRef", context);
                retDeviceMoObject = sector.getAttribute("retDeviceRef", context);
            }
            catch (Exception e) {
                this.info(" \nNo sectorAntennaRef and retDeviceRef found, will check for sectorAntennasRef and retDevicesRef,setting checkIFRefs = true ");
                checkIFRefs = true;
            }
            if (checkIFRefs) {
                sectorAntennaMoObject = ((ManagedObject[])sector.getAttribute("sectorAntennasRef", context))[0];
                ManagedObject[] retDevicesRefArr = (ManagedObject[])sector.getAttribute("retDevicesRef", context);
                retDeviceMoObject = retDevicesRefArr.length != 0 ? retDevicesRefArr[0] : null;
            }
            if (sectorAntennaMoObject == null || !(sectorAntennaMoObject instanceof SectorAntennaMo)) {
                this.traceError("Invalid sectorAntennasRef returned by Sector" + sectorAntennaMoObject.getClass());
                throw new Exception("\nInvalid sectorAntennasRef returned by Sector");
            }
            sectorAntennaMo = (SectorAntennaMo)sectorAntennaMoObject;
            if (retDeviceMoObject != null && !(retDeviceMoObject instanceof RetDeviceMo)) {
                this.traceError("Invalid retDevicesRef returned by Sector");
                throw new Exception("\nInvalid retDevicesRef returned by Sector!!. expectwed RetDevice, get:" + ((ManagedObject)retDeviceMoObject).getFullDistinguishedName());
            }
            int saFroId = sectorAntennaMo.getFroId(context);
            int sectorFroId = sector.getFroId(context);
            int externalAntenna = 0;
            int antennaType = sectorAntennaMo.getAntennaType(context);
            int retFroId = -1;
            if (retDeviceMoObject != null) {
                retDeviceMo = (RetDeviceMo)retDeviceMoObject;
                retFroId = retDeviceMo.getFroId(context);
            }
            antennaInfo.add(new MpswTaAueAntennaInfoT(saFroId, sectorFroId, externalAntenna, antennaType));
            DeviceData.add(new MpswTaAueDeviceInfoT(retFroId, sectorFroId, saFroId));
        }
        this.printMpswTaAueAntennaInfoT(antennaInfo);
        this.printMpswTaAueDeviceInfoT(DeviceData);
        AueProxy.instance().setAntennaInfo(antennaInfo.toArray(new MpswTaAueAntennaInfoT[0]));
        AueProxy.instance().setDeviceData(DeviceData.toArray(new MpswTaAueDeviceInfoT[0]));
    }

    private void printMpswTaAueAntennaInfoT(ArrayList antennaInfo) {
        this.info(" \nprintMpswTaAueAntennaInfoT(ArrayList antennaInfo) : ");
        MpswTaAueAntennaInfoT[] value = antennaInfo.toArray(new MpswTaAueAntennaInfoT[0]);
        for (int i = 0; i < value.length; ++i) {
            this.info(" \nMpswTaAueAntennaInfoT[" + i + "].saFroId : " + value[i].saFroId);
            this.info(" \nMpswTaAueAntennaInfoT[" + i + "].sectorFroId : " + value[i].sectorFroId);
            this.info(" \nMpswTaAueAntennaInfoT[" + i + "].antennaType : " + value[i].antennaType);
            this.info(" \nMpswTaAueAntennaInfoT[" + i + "].externalAntenna : " + value[i].externalAntenna);
        }
    }

    private void printMpswTaAueDeviceInfoT(ArrayList DeviceData) {
        this.info(" \nprintMpswTaAueDeviceInfoT(ArrayList DeviceData) : ");
        MpswTaAueDeviceInfoT[] value = DeviceData.toArray(new MpswTaAueDeviceInfoT[0]);
        for (int i = 0; i < value.length; ++i) {
            this.info(" \nMpswTaAueDeviceInfoT[" + i + "].FroId : " + value[i].FroId);
            this.info(" \nMpswTaAueDeviceInfoT[" + i + "].sectorFroId : " + value[i].sectorFroId);
            this.info(" \nMpswTaAueDeviceInfoT[" + i + "].sectorAntennaFroId : " + value[i].sectorAntennaFroId);
        }
    }
}

