/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.impl.CabinetParameterHandlerBase;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;

public class CabinetMoParameterHandler
extends CabinetParameterHandlerBase {
    public static final String CLIMATE_SYSTEM = "climateSystem";
    public static final int CLIMATE_SYSTEM_STANDERD = 0;
    public static final int CLIMATE_SYSTEM_EXTENDED = 1;
    public static final String CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    public static final String CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    public static final int SET_BOAM_PARAMETRS = 1;
    public static final int SET_EC_PARAMETRS = 2;
    public static final int SET_EC_SET_BOAM_PARAMETRS = 3;
    public int[] newStatndardIndexes = new int[50];
    public int[] newStatndardValues = new int[50];
    public int[] newExtendedIndexes = new int[50];
    public int[] newExtendedValues = new int[50];

    public CabinetMoParameterHandler(Class _theAue) {
        super(_theAue);
    }

    public CabinetMoParameterHandler(Class _theAue, int newStandardValue, int newStandardIndex, int newExtendedValue, int newExtendedIndex, String[] rbs) {
        this(_theAue, new int[]{newStandardValue}, new int[]{newStandardIndex}, new int[]{newExtendedValue}, new int[]{newExtendedIndex}, rbs);
    }

    public CabinetMoParameterHandler(Class _theAue, int[] _newStandardValues, int[] _newStandardIndexs, int[] _newExtendedValues, int[] _newExtendedIndexs, String[] rbs) {
        super(_theAue);
        this.rbs_types = rbs;
        this.newStatndardIndexes = _newStandardIndexs;
        this.newStatndardValues = _newStandardValues;
        this.newExtendedIndexes = _newExtendedIndexs;
        this.newExtendedValues = _newExtendedValues;
    }

    public void checkAndUpdateCabinetParameters(int matchType, Coordinator context) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    public void checkAndSetDefaultParameterValueIfProductNameMismatch(int[] newDefaultValue, int[] newDefaultIndex, int matchType, Coordinator context) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    public void checkAndSetDefaultParameterValueIfProductNameMismatch(int newDefaultValue, int newDefaultIndex, int matchType, Coordinator context) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
    }

    public void setCheckedParameter(int[] newValue, int[] newIndex, int matchType, ManagedObject cabinet, int setAction, int climateSystem, Coordinator context) throws NoSuchAttributeException, MoAccessException, MoDataConversionException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (cabinet == null) {
            cabinet = this.getParamaterMO(this.CABINET, matchType, context);
        }
        if (cabinet != null) {
            if (climateSystem == 1) {
                this.newExtendedIndexes = newIndex;
                this.newExtendedValues = newValue;
            } else {
                this.newStatndardIndexes = newIndex;
                this.newStatndardValues = newValue;
            }
            switch (setAction) {
                case 1: {
                    this.updateBoamCabinetParameterMoData(cabinet, context);
                    break;
                }
                case 2: {
                    this.updateEcCabinetParameterMoData(cabinet, context);
                    break;
                }
                case 3: {
                    this.updateEcCabinetParameterMoData(cabinet, context);
                    this.updateBoamCabinetParameterMoData(cabinet, context);
                }
            }
        } else {
            MessageLog.trace((int)9, this.getClass(), (String)("no " + this.CABINET + " instance, nothing to do"));
        }
    }

    public ManagedObject getCabinetMO(Coordinator context, int matchType) throws NoSuchAttributeException, MoAccessException {
        return this.getParamaterMO(this.CABINET, matchType, context);
    }

    public int[] getCabinetParameters(ManagedObject parameterMo, Coordinator context) throws NoSuchAttributeException, MoAccessException {
        return (int[])parameterMo.getAttribute("cabinetParameters", context);
    }

    protected void updateEcCabinetParameterMoData(ManagedObject cabinetParameterMo, Coordinator context) throws NoSuchAttributeException, MoAccessException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        int[] newValues;
        int[] indexes;
        MessageLog.traceEnter((Class)this.theAue, (String)"updateEcCabinetParameterMoData");
        int climateSystem = (Integer)cabinetParameterMo.getAttribute(CLIMATE_SYSTEM, context);
        if (climateSystem == 1) {
            indexes = this.newExtendedIndexes;
            newValues = this.newExtendedValues;
        } else {
            indexes = this.newStatndardIndexes;
            newValues = this.newStatndardValues;
        }
        super.updateEcCabinetParameterMoData(cabinetParameterMo, indexes, newValues, context);
    }

    protected void updateBoamCabinetParameterMoData(ManagedObject cabinet, Coordinator context) throws MoDataConversionException {
        MessageLog.traceEnter((Class)this.theAue, (String)"updateBoamCabinetParameterMoData");
        MoData cabinetMoData = null;
        if (cabinet instanceof BoamManagedObject) {
            cabinetMoData = ((BoamManagedObject)cabinet).getMyMoData();
        } else {
            MessageLog.traceEnter((Class)this.theAue, (String)"reflective call to getMyMoData");
            try {
                Method getMyMoData = cabinet.getClass().getMethod("getMyMoData", new Class[0]);
                cabinetMoData = (MoData)getMyMoData.invoke((Object)cabinet, (Object[])new Class[0]);
            }
            catch (SecurityException e) {
                MessageLog.traceError(this.getClass(), (String)"Caught Exception : ", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                MessageLog.traceError(this.getClass(), (String)"Caught Exception : ", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                MessageLog.traceError(this.getClass(), (String)"Caught Exception : ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                MessageLog.traceError(this.getClass(), (String)"Caught Exception : ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                MessageLog.traceError(this.getClass(), (String)"Caught Exception : ", (Throwable)e);
            }
        }
        this.upDateCabinetModata(cabinetMoData, CABINET_PARAMETERS_PROFILE_STANDARD, this.newStatndardIndexes, this.newStatndardValues, context);
        this.upDateCabinetModata(cabinetMoData, CABINET_PARAMETERS_PROFILE_EXTENDED, this.newExtendedIndexes, this.newExtendedValues, context);
    }

    private void upDateCabinetModata(MoData moData, String attrName, int[] newIndexes, int[] newValues, Coordinator context) throws MoDataConversionException {
        MessageLog.traceEnter((Class)this.theAue, (String)"upDateCabinetMoData()");
        Attribute attr = moData.getAttribute(attrName);
        if (attr == null) {
            MessageLog.trace((int)9, (Class)this.theAue, (String)("Cabinet has no attribute named " + attrName));
        } else {
            if (!(attr instanceof SequenceAttribute)) {
                throw new MoDataConversionException("Cabinet." + attrName + " is not SequenceAttribute");
            }
            Attribute[] attrs = ((SequenceAttribute)attr).getValue(context);
            Attribute[] newAttrs = new Attribute[attrs.length];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            for (int i = 0; i < newIndexes.length; ++i) {
                int index = newIndexes[i];
                if (index >= attrs.length) {
                    throw new MoDataConversionException("attempting to update array element " + index + ", which is >= attrs.length of " + attrs.length);
                }
                if (!(attrs[index] instanceof IntegerAttribute)) {
                    throw new MoDataConversionException("array element is not IntegerAttribute, index:" + index);
                }
                IntegerAttribute intAttr = (IntegerAttribute)attrs[index];
                newAttrs[index] = new IntegerAttribute(intAttr.getName(), intAttr.isAVCNotifier(), newValues[i]);
            }
            ((SequenceAttribute)attr).setValue(newAttrs);
        }
    }
}

