/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.aue.impl;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.aue.fpx.AueProxy;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueAddDpclTpaDevRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateDevSetRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueCreateDeviceRspS;
import se.ericsson.wcdma.rbs.boam.aue.fpx.MpswTaAueDpclTpaDeviceInfoT;
import se.ericsson.wcdma.rbs.boam.aue.impl.CreateMoHelper;
import se.ericsson.wcdma.rbs.boam.aue.impl.DeviceInfoMoHandler;
import se.ericsson.wcdma.rbs.boam.aue.impl.DeviceMoInfoHolder;
import se.ericsson.wcdma.rbs.boam.aue.impl.DeviceMoTypeHolder;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.common.FindMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BoamCollectorBaseMo;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.IntegerAttribute;

public abstract class CreateDevice {
    private static final Class SELF = CreateDevice.class;
    private static int intendedSiganl = 0;
    private static final int SignalMpswTaAueCreateDevice = 1;
    private static final int SignalMpswTaAueAddDpclTpaDev = 2;
    private static DeviceMoTypeHolder[] deviceMoTypeHolder = new DeviceMoTypeHolder[1];

    public static void createMultipleDpclTpaDevices(DeviceMoTypeHolder[] _deviceMoTypeHolder, Coordinator context) throws MoAccessException {
        intendedSiganl = 2;
        deviceMoTypeHolder = _deviceMoTypeHolder;
        for (int i = 0; i < deviceMoTypeHolder.length; ++i) {
            CreateDevice.createMultipleDevices(CreateDevice.deviceMoTypeHolder[i].deviceMoTypeName, CreateDevice.deviceMoTypeHolder[i].deviceSetMoTypeName, CreateDevice.deviceMoTypeHolder[i].deviceGroupMoTypeName, CreateDevice.deviceMoTypeHolder[i].genericDeviceGroupTypeName, CreateDevice.deviceMoTypeHolder[i].startingCardinality, CreateDevice.deviceMoTypeHolder[i].targetCardinality, context);
        }
        try {
            CreateDevice.createDpclTpaDeviceMo(context);
        }
        catch (Exception e) {
            MessageLog.traceError((Class)SELF, (String)"Failed to Send and Receive MpswTaAueAddDpclTpaDevReq/RspS signal");
            throw new SoftwareErrorException();
        }
    }

    public static void createMultipleDevices(String moType, String parentMoType, String grandParentMoType, String genericDeviceGroupType, int startingCardinality, int targetCardinality, Coordinator context) throws MoAccessException {
        if (intendedSiganl == 0) {
            intendedSiganl = 1;
        }
        if (genericDeviceGroupType == null) {
            MessageLog.traceEnter((Class)SELF, (String)("createMultipleDevices(), new moType: " + moType + ", parentMoType: " + parentMoType + ", grandParentMoType: " + grandParentMoType));
        } else {
            MessageLog.traceEnter((Class)SELF, (String)("createMultipleDevices(), new moType: " + moType + ", parentMoType: " + parentMoType + ", grandparent RDN: " + grandParentMoType + "=" + genericDeviceGroupType));
        }
        if (genericDeviceGroupType != null && !grandParentMoType.equals("DeviceGroup")) {
            MessageLog.traceError((Class)SELF, (String)("expected: DeviceGroup, actual: " + grandParentMoType));
            throw new SoftwareErrorException();
        }
        int matchCount = 0;
        MoIterator grandparents = FindMo.findMOs(grandParentMoType);
        while (grandparents.hasMoreElements()) {
            ManagedObject grandparent = (ManagedObject)grandparents.nextElement();
            if (genericDeviceGroupType != null && !grandparent.getNamingAttributeValue().equals(genericDeviceGroupType)) continue;
            ++matchCount;
            MoIterator parents = FindMo.findMOs(parentMoType, grandparent, 1);
            int parentCount = parents.size();
            MessageLog.trace((int)9, (Class)SELF, (String)("number of " + parentMoType + " found under " + grandparent + ": " + parentCount));
            if (parentCount == 0) {
                CreateDevice.createOneDeviceSetWithDevices(grandparent, moType, parentMoType, targetCardinality, context);
                continue;
            }
            while (parents.hasMoreElements()) {
                ManagedObject parent = (ManagedObject)parents.nextElement();
                if (intendedSiganl == 1) {
                    CreateDevice.createChildren(moType, parent, startingCardinality, targetCardinality, context);
                    continue;
                }
                if (intendedSiganl != 2 || !CreateDevice.validateRRUS11AuxPIU(parent.getParent(), context)) continue;
                CreateDevice.createChildren(moType, parent, startingCardinality, targetCardinality, context);
            }
        }
        if (matchCount == 0 && genericDeviceGroupType == null) {
            MessageLog.trace((int)9, (Class)SELF, (String)("no device group of type " + grandParentMoType + " found; nothing to do!"));
        } else if (matchCount == 0 && genericDeviceGroupType != null) {
            MessageLog.trace((int)9, (Class)SELF, (String)("no generic device group of type " + genericDeviceGroupType + " found; nothing to do!"));
        }
    }

    private static void createOneDeviceSetWithDevices(ManagedObject grandparent, String moType, String parentMoType, int targetCardinality, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"createOneDeviceSetWithDevices()");
        BoamCollectorBaseMo moParameters = CreateDevice.createDeviceSetMo(grandparent, parentMoType, "1", context);
        for (int i = 1; i <= targetCardinality; ++i) {
            try {
                CreateDevice.createDeviceMo(moParameters.getLocalDistinguishedName(), moParameters.getFroId(), moType, Integer.toString(i), context);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void createChildren(String moType, ManagedObject parent, int startingCardinality, int targetCardinality, Coordinator context) throws MoAccessException {
        int actualCardinality = CreateDevice.countAndVerifyExistingDevices(parent, moType);
        MessageLog.trace((int)9, (Class)SELF, (String)("Found cardinality of :" + actualCardinality + " for MoType :" + moType + " under parent : " + parent));
        if (actualCardinality == targetCardinality) {
            MessageLog.trace((int)9, (Class)SELF, (String)("cardinality of " + moType + " under " + parent + " is " + targetCardinality + ", no action needed"));
            if (intendedSiganl == 2) {
                AueProxy.instance().createDpclTpaDevices(0, new MpswTaAueDpclTpaDeviceInfoT[0]);
            }
        } else if (actualCardinality == startingCardinality) {
            for (int k = startingCardinality + 1; k <= targetCardinality; ++k) {
                try {
                    CreateDevice.createDeviceMo(parent, moType, Integer.toString(k), context);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            MessageLog.trace((int)9, (Class)SELF, (String)("actual cardinality of " + moType + " under " + parent + " is " + targetCardinality + ", differing from expected cardinality " + startingCardinality + " as well as intended target cardinality " + targetCardinality));
            throw new MoCardinalityViolationException(moType);
        }
    }

    private static int countAndVerifyExistingDevices(ManagedObject parentMo, String targetMoType) throws MoCardinalityViolationException {
        MoIterator devs = FindMo.findMOs(targetMoType, parentMo, 1);
        Vector cDevs = CreateMoHelper.getCMoData(targetMoType, parentMo.getLocalDistinguishedName());
        MessageLog.trace((int)9, (Class)SELF, (String)("Found " + cDevs.size() + " CMoData"));
        Vector ldnList = CreateDevice.combineMoAndCMoData(devs, cDevs);
        int size = ldnList.size();
        boolean[] flags = new boolean[size + 1];
        for (int j = 1; j <= size; ++j) {
            flags[j] = false;
        }
        Iterator iter = ldnList.iterator();
        while (iter.hasNext()) {
            int number;
            String ldn = (String)iter.next();
            String digitString = LDNHelper.getNamingAttributeValue(ldn);
            try {
                number = Integer.parseInt(digitString);
            }
            catch (NumberFormatException e) {
                MessageLog.trace((int)9, (Class)SELF, (String)("naming attribute value is not a well-formed integer: " + ldn));
                throw new MoCardinalityViolationException(targetMoType);
            }
            if (number < 1) {
                MessageLog.trace((int)9, (Class)SELF, (String)("naming attribute value is less than 1: " + ldn));
                throw new MoCardinalityViolationException(targetMoType);
            }
            if (number > size) {
                MessageLog.trace((int)9, (Class)SELF, (String)("naming attribute value is greater than " + size + ": " + ldn));
                throw new MoCardinalityViolationException(targetMoType);
            }
            flags[number] = true;
        }
        for (int j = 1; j <= size; ++j) {
            if (flags[j]) continue;
            MessageLog.trace((int)9, (Class)SELF, (String)("there is no device with naming attribute value: " + j));
            throw new MoCardinalityViolationException(parentMo.getType());
        }
        return ldnList.size();
    }

    private static Vector combineMoAndCMoData(MoIterator devs, Vector cDevs) {
        Vector<String> result = new Vector<String>();
        Object iter = devs;
        while (iter.hasMoreElements()) {
            ManagedObject mo = iter.nextMo();
            result.add(mo.getLocalDistinguishedName());
        }
        iter = cDevs.iterator();
        while (iter.hasNext()) {
            CMoData cMoData = (CMoData)iter.next();
            result.add(cMoData.getLocalDistinguishedName());
            MessageLog.trace((int)9, (Class)SELF, (String)("Found CMoData: " + cMoData.getLocalDistinguishedName()));
        }
        return result;
    }

    private static BoamCollectorBaseMo createDeviceSetMo(ManagedObject parent, String moType, String newMoIdentity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)("createDeviceSetMo(), parent: " + parent + ", type: " + moType + ", id: " + newMoIdentity));
        if (parent == null) {
            MessageLog.traceError((Class)SELF, (String)"parent must not be null");
            throw new IllegalParentException("null");
        }
        if (!(parent instanceof MaoHasFro)) {
            MessageLog.traceError((Class)SELF, (String)"parent MO must implement MaoHasFro");
            throw new IllegalParentException(parent.getType());
        }
        int parentFroId = ((MaoHasFro)parent).getFroId(context);
        ManagedObject grandParent = parent.getParent();
        if (grandParent == null) {
            MessageLog.traceError((Class)SELF, (String)"grandparent must not be null");
            throw new IllegalParentException("null");
        }
        if (!(grandParent instanceof AuxPlugInUnitMo)) {
            MessageLog.traceError((Class)SELF, (String)"grandparent MO must implement AuxPlugInUnitMo");
            throw new IllegalParentException(grandParent.getType());
        }
        int piuFroId = ((AuxPlugInUnitMo)grandParent).getFroId(context);
        CreateDevice.checkAndWaitForProxy();
        if (!moType.equalsIgnoreCase("AlmDeviceSet")) {
            String msg = "creation of type " + moType + " is not supported";
            MessageLog.traceError((Class)SELF, (String)(msg + "!!"));
            throw new MoCanNotBeCreatedException(moType);
        }
        MpswTaAueCreateDevSetRspS rspSig = AueProxy.instance().createDeviceSet(parentFroId, piuFroId, 49767);
        int froId = rspSig.devSetFroId;
        BoamCollectorBaseMo moParameters = new BoamCollectorBaseMo(parent.getLocalDistinguishedName(), moType, newMoIdentity, froId);
        CMoData cMoData = new CMoData(moParameters.getLocalDistinguishedName(), moParameters.getTypeName(), true, context);
        cMoData.registerPersistentAttr(new IntegerAttribute(MoDataHelper.getFroIdAttrName(moType), false, froId));
        cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
        return moParameters;
    }

    private static void createDeviceMo(ManagedObject parent, String moType, String newMoIdentity, Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)("createDeviceOrDeviceSetMo(), parent: " + parent + ", type: " + moType + ", id: " + newMoIdentity));
        CreateDevice.checkAndWaitForProxy();
        if (!(parent instanceof MaoHasFro)) {
            MessageLog.trace((int)9, (Class)SELF, (String)"Parent MO is of wrong type, should be MaoHasFro. Impossible to extract froId.");
            return;
        }
        int parentFroId = ((MaoHasFro)parent).getFroId(context);
        CreateDevice.createDeviceMo(parent.getLocalDistinguishedName(), parentFroId, moType, newMoIdentity, context);
    }

    /*
     * WARNING - void declaration
     */
    private static void createDeviceMo(String parentLdn, int parentFroId, String moType, String newMoIdentity, Coordinator context) throws Exception {
        int deviceType;
        MessageLog.traceEnter((Class)SELF, (String)("createDeviceOrDeviceSetMo(), parent: " + parentLdn + ", parentFroId: " + parentFroId + ", type: " + moType + ", id: " + newMoIdentity));
        if (moType.equalsIgnoreCase("AiDevice")) {
            deviceType = 7;
        } else if (moType.equalsIgnoreCase("TmaDevice")) {
            deviceType = 14;
        } else if (moType.equalsIgnoreCase("DpclDevice")) {
            deviceType = 5;
        } else if (moType.equalsIgnoreCase("TpaDevice")) {
            deviceType = 8;
        } else if (moType.equalsIgnoreCase("TrDevice")) {
            deviceType = 4;
        } else if (moType.equalsIgnoreCase("AlmDevice")) {
            deviceType = 15;
        } else if (moType.equalsIgnoreCase("OutDevice")) {
            deviceType = 16;
        } else if (moType.equalsIgnoreCase("DbccDevice")) {
            deviceType = 3;
        } else {
            MessageLog.traceError((Class)SELF, (String)("creation of type " + moType + " is not supported!!"));
            throw new MoCanNotBeCreatedException(moType);
        }
        switch (intendedSiganl) {
            case 2: {
                void var5_5;
                DeviceInfoMoHandler.addDevice(parentLdn, parentFroId, moType, (int)var5_5, newMoIdentity);
                break;
            }
            case 1: {
                void var5_5;
                MpswTaAueCreateDeviceRspS rspSig = AueProxy.instance().createDevice(parentFroId, (int)var5_5);
                int froId = rspSig.deviceFroId;
                CreateDevice.updateCollectedMoData(parentLdn, moType, newMoIdentity, froId, context);
            }
        }
    }

    private static void createDpclTpaDeviceMo(Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"createDpclTpaDeviceMo()");
        int totalNumberOfDevices = DeviceInfoMoHandler.totalNumberOfDevices();
        if (totalNumberOfDevices == 0) {
            MessageLog.traceEnter((Class)SELF, (String)"totalNumberOfDevices is 0, signal MpswTaAueAddDpclTpaDevReqs will be sent with totalNumberOfDevices = 0");
            AueProxy.instance().createDpclTpaDevices(0, new MpswTaAueDpclTpaDeviceInfoT[0]);
            return;
        }
        MpswTaAueDpclTpaDeviceInfoT[] allDeviceInfo = DeviceInfoMoHandler.getAllDeviceInfo();
        if (allDeviceInfo == null && totalNumberOfDevices != 0) {
            MessageLog.traceError((Class)SELF, (String)"Expected valid DeviceInfo, found DeviceInfo = null ");
            throw new SoftwareErrorException();
        }
        MpswTaAueAddDpclTpaDevRspS rspSig = AueProxy.instance().createDpclTpaDevices(totalNumberOfDevices, allDeviceInfo);
        if (rspSig == null || rspSig.numberOfElements != totalNumberOfDevices) {
            MessageLog.traceError((Class)SELF, (String)("Invalid responcse signal MpswTaAueAddDpclTpaDevRspS received from Ta_aue " + (rspSig != null ? "sent request for " + totalNumberOfDevices + " devices, yet received responcse with" + rspSig.numberOfElements : ".")));
            throw new SoftwareErrorException();
        }
        MpswTaAueDpclTpaDeviceInfoT dpclTpaDeviceInfoT = null;
        for (int i = 0; i < rspSig.numberOfElements; ++i) {
            try {
                dpclTpaDeviceInfoT = rspSig.deviceInfo[i];
            }
            catch (Exception e) {
                MessageLog.traceError((Class)SELF, (String)"Invalid responcse signal MpswTaAueAddDpclTpaDevRspS received from Ta_aue");
                throw e;
            }
            String moId = "";
            DeviceMoInfoHolder deviceMoInfoHolder = null;
            try {
                deviceMoInfoHolder = DeviceInfoMoHandler.getDeviceInfo(dpclTpaDeviceInfoT.deviceSetFroId, dpclTpaDeviceInfoT.deviceType);
            }
            catch (Exception e) {
                MessageLog.traceError((Class)SELF, (String)("createDevice() could not resolve data for, deviceSetFroId: " + dpclTpaDeviceInfoT.deviceSetFroId + ", deviceType: " + dpclTpaDeviceInfoT.deviceType));
                throw new Exception();
            }
            if (deviceMoInfoHolder != null) {
                moId = (String)deviceMoInfoHolder.newMoIdentity.get(0);
                CreateDevice.updateCollectedMoData(deviceMoInfoHolder.parentLdn, deviceMoInfoHolder.moType, moId, dpclTpaDeviceInfoT.deviceFroId, context);
                continue;
            }
            MessageLog.traceError((Class)SELF, (String)("createDevice() could not resolve data for, deviceSetFroId: " + dpclTpaDeviceInfoT.deviceSetFroId + ", deviceType: " + dpclTpaDeviceInfoT.deviceType));
        }
    }

    private static void updateCollectedMoData(String parentLdn, String moType, String newMoIdentity, int froId, Coordinator context) throws MoAccessException {
        BoamCollectorBaseMo moParameters = new BoamCollectorBaseMo(parentLdn, moType, newMoIdentity, froId);
        CMoData cMoData = new CMoData(moParameters.getLocalDistinguishedName(), moParameters.getTypeName(), true, context);
        cMoData.registerPersistentAttr(new IntegerAttribute(MoDataHelper.getFroIdAttrName(moType), false, froId));
        cMoData.handleTransaction(context, CMoData.WRITE_ACCESS);
    }

    private static boolean validateRRUS11AuxPIU(ManagedObject rruDeviceGrpMo, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"validateRRUS11AuxPIU()");
        AuxPlugInUnitMo auxpiuMo = (AuxPlugInUnitMo)rruDeviceGrpMo.getParent();
        if (auxpiuMo instanceof AuxPlugInUnitMo) {
            int auType = auxpiuMo.getAuType(context);
            if (auType == 10 || auType == 20) {
                return true;
            }
            MessageLog.traceEnter((Class)SELF, (String)("validateRRUS11AuxPIU() returned false, found AuType : " + auType + ", of which is niether RRU nor RRUW"));
        }
        return false;
    }

    private static void checkAndWaitForProxy() throws MoAccessException {
        boolean isProxyAvail = false;
        isProxyAvail = AueProxy.instance().isServicePublished();
        for (int noOfRetry = 600; !isProxyAvail && noOfRetry != 0; --noOfRetry) {
            CommandHandler.sleep(100);
            isProxyAvail = AueProxy.instance().isServicePublished();
        }
        AueProxy.instance().verifyProxyAvaliable();
    }
}

