/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.conv.operations.HO29616Op;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.AddReservedByOp;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.CreateMoDataOp;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.operations.UpdateMoLDNOp;
import se.ericsson.wcdma.rbs.boam.upfwk.data.BooleanAttribute;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;
import se.ericsson.wcdma.rbs.boam.upfwk.data.StringAttribute;

public class DC13089999To13090000
extends DataConverterBase {
    private static final String ANT_FEEDER_CABLE_UPDATE_LDN = "UpdateLDN";
    public static final int FROM_BOAM_REV = 13089999;
    public static final int TO_BOAM_REV = 13090000;
    private static final DC13089999To13090000 INSTANCE = new DC13089999To13090000();
    private static final String ANT_FEEDER_CABLE_EXT = "_EXT";
    private final Macro macro = new Macro();

    private DC13089999To13090000() {
        super(13089999, 13090000);
    }

    public static DC13089999To13090000 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
        CMoData[] cModata = MoConverterUtility.getCMoDataByType("AntFeederCable", context);
        if (cModata != null && cModata.length > 0) {
            for (int i = 0; i < cModata.length; ++i) {
                boolean isLdnUpdate = false;
                BooleanAttribute attr = (BooleanAttribute)cModata[i].getAttribute(ANT_FEEDER_CABLE_UPDATE_LDN);
                if (attr != null) {
                    isLdnUpdate = attr.getValue(context);
                    cModata[i].deregisterAttribute(ANT_FEEDER_CABLE_UPDATE_LDN);
                }
                if (isLdnUpdate) {
                    String oldLdn = cModata[i].getLocalDistinguishedName();
                    String newName = ((StringAttribute)cModata[i].getAttribute("NEWNAME")).getValue(context);
                    this.macro.add(new UpdateMoLDNOp(this.workingMoData, context, oldLdn, newName, true));
                    continue;
                }
                String cModataLdn = cModata[i].getLocalDistinguishedName();
                if (cModataLdn.endsWith(ANT_FEEDER_CABLE_EXT)) {
                    String moDataLdn = cModataLdn.substring(0, cModataLdn.lastIndexOf(ANT_FEEDER_CABLE_EXT));
                    MoData modata = MoConverterUtility.getMoDataByLDN(this.workingMoData, context, moDataLdn);
                    if (modata != null) {
                        Attribute[] attributes = new Attribute[]{modata.getAttribute("userLabel"), modata.getAttribute("connectedToObjectARef"), modata.getAttribute("antennaBranchRef")};
                        this.macro.add(new CreateMoDataOp(this.workingMoData, context, cModataLdn, attributes, 3040401));
                        if (attributes[1] != null) {
                            this.macro.add(new AddReservedByOp(this.workingMoData, context, ((ReferenceAttribute)attributes[1]).getReferenceAsLDN(), cModataLdn));
                        }
                        if (attributes[2] == null) continue;
                        this.macro.add(new AddReservedByOp(this.workingMoData, context, ((ReferenceAttribute)attributes[2]).getReferenceAsLDN(), cModataLdn));
                        continue;
                    }
                    this.traceEnter("Mo not found with LDN=" + moDataLdn);
                    continue;
                }
                this.traceEnter("The CMoData is not as expected, will be igonored, LDN=" + cModataLdn);
            }
        }
        this.macro.add(new HO29616Op(this.workingMoData, context));
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        CommandHandler.execute(this.macro, 1);
    }
}

