/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoConverterUtility;
import se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.data.CMoData;

public class DC15020699To15020700
extends DataConverterBase {
    private static final DC15020699To15020700 INSTANCE = new DC15020699To15020700();
    protected static final int fromConverterRev = 15020699;
    protected static final int toConverterRev = 15020700;
    public static final String AIR_FLAG_NAME = "isAir";
    private static final int COMMON_SUPPORT_MAGIC_REV = 8010001;
    private static final String UP_MO_TYPE_NAME = "UpgradePackage";
    private String[] upMoAttrNames = new String[]{"faultyPIUsLockedByUpgrade", "nonSupportedPIUsLockedByUpgrade", "faultyPIUsLockedBeforeUpgrade", "nonSupportedPIUsLockedBeforeUpgrade"};
    private ArrayList aux = new ArrayList();

    protected DC15020699To15020700() {
        super(15020699, 15020700);
    }

    public static DC15020699To15020700 instance() {
        return INSTANCE;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        if (this.precondition()) {
            this.deleteAuxPiuMoData();
        }
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    public void addAux(String ldn) {
        this.aux.add(ldn);
    }

    public boolean isWantedAux(String ldn) {
        boolean wanted = false;
        Iterator iter = this.aux.iterator();
        while (iter.hasNext()) {
            String aux = (String)iter.next();
            if (-1 == aux.indexOf(ldn)) continue;
            wanted = true;
            break;
        }
        return wanted;
    }

    private boolean precondition() throws TransactionRequiredException {
        this.traceEnter("preConditon");
        boolean isAirAue = false;
        Iterator iter = this.workingMoData.getMoData("Sector").iterator();
        while (iter.hasNext()) {
            MoData sector = (MoData)iter.next();
            StringAttribute ul = (StringAttribute)sector.getAttribute("userLabel");
            if (-1 == ul.getValue(this.context).indexOf("*A_I_R#")) continue;
            isAirAue = true;
            this.trace(sector.getLocalDistinguishedName() + " with air user label\n");
        }
        Iterator iterAux = this.workingMoData.getMoData("AuxPlugInUnit").iterator();
        while (iterAux.hasNext()) {
            se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute airFlag;
            MoData aux = (MoData)iterAux.next();
            int auxPiuAuType = ((IntegerAttribute)aux.getAttribute("auType")).getValue(this.context);
            if (auxPiuAuType != 18 && auxPiuAuType != 20) continue;
            String ldn = aux.getLocalDistinguishedName();
            this.trace(aux.getLocalDistinguishedName() + " check air flag\n");
            CMoData cModata = MoConverterUtility.getCMoDataByLDN(ldn, this.context);
            if (null == cModata || null == (airFlag = cModata.getAttribute(AIR_FLAG_NAME))) continue;
            this.trace(ldn + "add to delete MO list\n");
            this.addAux(ldn);
            cModata.deregisterAttribute(AIR_FLAG_NAME);
            cModata.handleTransaction(this.context, CMoData.WRITE_ACCESS);
        }
        return isAirAue;
    }

    public void deleteAuxPiuMoData() throws Exception {
        this.traceEnter("deleteAuxPiuMoData by filter");
        Iterator iter = this.workingMoData.getMoData("AuxPlugInUnit").iterator();
        while (iter.hasNext()) {
            MoData auxPiu = (MoData)iter.next();
            String ldn = auxPiu.getLocalDistinguishedName();
            if (!this.isWantedAux(ldn) || auxPiu.getRevision() == 8010001) continue;
            MoDataHelper.activateWriteAccess(this.context, auxPiu);
            this.info("Deleting AuxPlugInUnit MoData reference with revision: " + auxPiu.getRevision() + " and LDN: " + auxPiu.getLocalDistinguishedName());
            for (int i = 0; i < this.upMoAttrNames.length; ++i) {
                this.removeAuxPiuRefFromUPMo(auxPiu.getLocalDistinguishedName(), this.upMoAttrNames[i], this.context);
            }
        }
    }

    private void removeAuxPiuRefFromUPMo(String localDistinguishedName, String attrName, Coordinator context) throws MoDataConversionException {
        this.traceEnter("removeAuxPiuRefFromUPMo");
        Iterator iter = this.workingMoData.getMoData(UP_MO_TYPE_NAME).iterator();
        while (iter.hasNext()) {
            MoData upMoData = (MoData)iter.next();
            MoDataHelper.activateWriteAccess(context, upMoData);
            Attribute attr = upMoData.getAttribute(attrName);
            if (attr == null || !(attr instanceof SequenceAttribute)) continue;
            SequenceAttribute auxPiuRefs = (SequenceAttribute)attr;
            ArrayList<ReferenceAttribute> refsToRemove = new ArrayList<ReferenceAttribute>();
            Enumeration e = auxPiuRefs.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof ReferenceAttribute)) continue;
                ReferenceAttribute ref = (ReferenceAttribute)o;
                this.info("Processing reference from: " + attrName + " with LDN: " + ref.getReferenceAsLDN() + " aux piu ldn: " + localDistinguishedName);
                if (!ref.getReferenceAsLDN().equals(localDistinguishedName)) continue;
                this.info("Adding ref attr with LDN: " + ref.getReferenceAsLDN() + " to remove list");
                refsToRemove.add(ref);
            }
            Iterator i = refsToRemove.iterator();
            while (i.hasNext()) {
                this.info("Removing attribute from remove list");
                auxPiuRefs.removeElement((Attribute)i.next());
            }
        }
    }
}

