/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC22039999To22040000
extends DataConverterBase {
    private static final DC22039999To22040000 instance = new DC22039999To22040000();
    private static final String ASSIGN_OP_AS_STRING = "=";
    private static final String DIGITAL_CABLE_TYPE_NAME = "DigitalCable";
    private static final String RFCABLE_TYPE_NAME = "RfCable";
    private static final String RBSSUBRACK_TYPE_NAME = "RbsSubrack";
    protected static final int fromConverterRev = 22039999;
    protected static final int toConverterRev = 22040000;
    private static final String RUW = "RUW";

    protected DC22039999To22040000() {
        super(22039999, 22040000);
    }

    public static DC22039999To22040000 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.findUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("Found no update candidates - No upgrade is necessary.");
        } else {
            this.updateMoLdn(updateCandidates);
        }
    }

    private void updateMoLdn(List dataList) throws Exception {
        this.traceEnter("updateMoLdn()");
        Iterator iter = dataList.iterator();
        while (iter.hasNext()) {
            TopologyMgr mgr = new TopologyMgr(this.workingMoData);
            UpdateCandidate data = (UpdateCandidate)iter.next();
            this.trace("Info : " + data.moData.getLocalDistinguishedName() + " has old identity.");
            String newLDN = this.generateNewLdn(data);
            mgr.changeLdnTopology(data.moData, newLDN);
            this.trace("Info : " + data.moData.getLocalDistinguishedName() + " has now following LDN : " + newLDN);
            this.trace(mgr.getModificationInfo());
        }
    }

    private String generateNewLdn(UpdateCandidate updateCandidate) {
        this.traceEnter("generateNewLdn");
        String source = updateCandidate.moData.getLocalDistinguishedName();
        String oldSubStr = updateCandidate.moData.getMoTypeName() + ASSIGN_OP_AS_STRING + LDNHelper.getNamingAttributeValue(updateCandidate.moData.getLocalDistinguishedName());
        String replacement = updateCandidate.moData.getMoTypeName() + ASSIGN_OP_AS_STRING + updateCandidate.idString;
        return LDNHelper.replaceFirst(source, oldSubStr, replacement);
    }

    private List findUpdateCandidates() throws MoRemovedException {
        this.traceEnter("findUpdateCandidates()");
        ArrayList updateCandidates = new ArrayList();
        this.findUpdateCandidates(DIGITAL_CABLE_TYPE_NAME, updateCandidates);
        this.findUpdateCandidates(RFCABLE_TYPE_NAME, updateCandidates);
        this.findUpdateCandidates(RBSSUBRACK_TYPE_NAME, updateCandidates);
        return updateCandidates;
    }

    private void findUpdateCandidates(String updateMo, ArrayList updateCandidates) {
        this.traceEnter("findUpdateCandidates");
        Iterator updateMoIt = this.workingMoData.getMoData(updateMo).iterator();
        while (updateMoIt.hasNext()) {
            MoData updateMoNeed = (MoData)updateMoIt.next();
            String newUpdateMoId = this.buildNewUpdateMoNeed(updateMoNeed);
            if (newUpdateMoId == null) continue;
            updateCandidates.add(new UpdateCandidate(updateMoNeed, newUpdateMoId));
        }
    }

    private String buildNewUpdateMoNeed(MoData updateMoNeed) {
        this.traceEnter("buildNewUpdateMoNeed()");
        String oldId = LDNHelper.getNamingAttributeValue(updateMoNeed.getLocalDistinguishedName());
        this.trace("Old MO LDN: " + oldId);
        try {
            if (oldId.startsWith(RUW)) {
                String newId = oldId.substring(RUW.length(), oldId.length());
                this.trace("New update MO: " + newId);
                return newId;
            }
            return null;
        }
        catch (StringIndexOutOfBoundsException e) {
            this.traceError("Could not build a new DigitalCable since the old Id is not as expected: " + oldId);
            return null;
        }
    }

    private class UpdateCandidate {
        private MoData moData;
        private String idString;

        public UpdateCandidate(MoData moData, String idString) {
            this.moData = moData;
            this.idString = idString;
        }
    }
}

