/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.helper.TopologyMgr;

public class DC22040799To22040800
extends DataConverterBase {
    private static final DC22040799To22040800 instance = new DC22040799To22040800();
    private static final String ASSIGN_OP_AS_STRING = "=";
    private static final String RFCABLE_TYPE_NAME = "RfCable";
    protected static final int fromConverterRev = 22040799;
    protected static final int toConverterRev = 22040800;

    protected DC22040799To22040800() {
        super(22040799, 22040800);
    }

    public static DC22040799To22040800 instance() {
        return instance;
    }

    protected void initDC(Coordinator context) throws Exception {
        this.traceEnter("initDC()");
        this.context = context;
    }

    protected void doDC() throws Exception {
        this.traceEnter("doDC()");
        List updateCandidates = this.findUpdateCandidates();
        if (updateCandidates.isEmpty()) {
            this.trace("Found no update candidates - No upgrade is necessary.");
        } else {
            this.updateMoLdn(updateCandidates);
        }
    }

    private void updateMoLdn(List dataList) throws Exception {
        this.traceEnter("updateMoLdn()");
        Iterator iter = dataList.iterator();
        while (iter.hasNext()) {
            TopologyMgr mgr = new TopologyMgr(this.workingMoData);
            UpdateCandidate data = (UpdateCandidate)iter.next();
            String OldLDNRfCable = data.moData.getLocalDistinguishedName();
            this.trace("Info : " + OldLDNRfCable + " has old identity.");
            int subRfCableIndex = OldLDNRfCable.lastIndexOf(ASSIGN_OP_AS_STRING);
            String newLDNRfCable = OldLDNRfCable.substring(0, subRfCableIndex + 1).concat(data.idString);
            mgr.changeLdnTopology(data.moData, newLDNRfCable);
            this.trace("Info : " + data.moData.getLocalDistinguishedName() + " has now following LDN : " + newLDNRfCable);
            this.trace(mgr.getModificationInfo());
        }
    }

    private List findUpdateCandidates() throws MoRemovedException {
        this.traceEnter("findUpdateCandidates()");
        ArrayList updateCandidates = new ArrayList();
        this.findUpdateRfCableCandidates(RFCABLE_TYPE_NAME, updateCandidates);
        return updateCandidates;
    }

    private void findUpdateRfCableCandidates(String updateMo, ArrayList updateCandidates) {
        this.traceEnter("findUpdateRfCableCandidates()");
        Iterator updateMoIt = this.workingMoData.getMoData(updateMo).iterator();
        while (updateMoIt.hasNext()) {
            MoData updateMoNeed = (MoData)updateMoIt.next();
            String newUpdateMoId = this.buildNewUpdateMoNeed(updateMoNeed);
            if (newUpdateMoId == null) continue;
            updateCandidates.add(new UpdateCandidate(updateMoNeed, newUpdateMoId));
        }
    }

    private String buildNewUpdateMoNeed(MoData updateMoNeed) {
        this.traceEnter("buildNewUpdateMoNeed()");
        String oldId = LDNHelper.getNamingAttributeValue(updateMoNeed.getLocalDistinguishedName());
        this.trace("Old MO LDN: " + oldId);
        try {
            if (oldId.startsWith("W_")) {
                String newId = "RRU".concat(oldId);
                this.trace("New update MO: " + newId);
                return newId;
            }
            return null;
        }
        catch (StringIndexOutOfBoundsException e) {
            this.traceError("Could not build a new RfCable since the old Id is not as expected: " + oldId);
            return null;
        }
    }

    private class UpdateCandidate {
        private MoData moData;
        private String idString;

        public UpdateCandidate(MoData moData, String idString) {
            this.moData = moData;
            this.idString = idString;
        }
    }
}

