/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.conv;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.conv.operations.CreateDeviceOp;
import se.ericsson.wcdma.rbs.boam.upfwk.command.CommandHandler;
import se.ericsson.wcdma.rbs.boam.upfwk.command.Macro;
import se.ericsson.wcdma.rbs.boam.upfwk.common.ReserveMoHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.conv.DataConverterBase;

public class DC7090998To7090999
extends DataConverterBase {
    private static final Class SELF = DC7090998To7090999.class;
    public static final int FROM_BOAM_REV = 0x6C3336;
    public static final int TO_BOAM_REV = 7090999;
    private static final int TARGET_CARDINALITY = 8;
    private static final Macro MACRO = new Macro();
    private static final DC7090998To7090999 INSTANCE = new DC7090998To7090999();
    private Coordinator context = null;

    private DC7090998To7090999() {
        super(0x6C3336, 7090999);
    }

    public static DC7090998To7090999 instance() {
        return INSTANCE;
    }

    protected void initDC(Coordinator context) throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"initDC()");
        MACRO.add(new CreateDeviceOp(this.workingMoData, context, "OutDevice", "OutDeviceSet", "DeviceGroup", "SAU", 7090999, 8));
        this.context = context;
    }

    protected void doDC() throws Exception {
        MessageLog.traceEnter((Class)SELF, (String)"doDC()");
        CommandHandler.execute(MACRO, 1);
        Iterator rfCableIter = this.workingMoData.getMoData("RfCable").iterator();
        while (rfCableIter.hasNext()) {
            MoData rfCable = (MoData)rfCableIter.next();
            String origRfLDN = rfCable.getLocalDistinguishedName();
            MessageLog.trace((int)9, this.getClass(), (String)("Check rfCable " + rfCable.getLocalDistinguishedName()));
            ReferenceAttribute ObjectARefAttr = (ReferenceAttribute)rfCable.getAttribute("connectedToObjectARef");
            ReferenceAttribute ObjectBRefAttr = (ReferenceAttribute)rfCable.getAttribute("connectedToObjectBRef");
            this.checkReservation(ObjectARefAttr, origRfLDN);
            this.checkReservation(ObjectBRefAttr, origRfLDN);
        }
    }

    public void checkReservation(ReferenceAttribute ObjectRefAttr, String LDN) throws Exception {
        if (ObjectRefAttr != null && ObjectRefAttr.getReferenceAsLDN() != null) {
            String refLdn = ObjectRefAttr.getReferenceAsLDN();
            MessageLog.trace((int)9, this.getClass(), (String)(" refLdn is " + refLdn));
            MoData toBeReservedMo = this.getMoDataByLdn(refLdn);
            if (toBeReservedMo != null) {
                Attribute reserverRfCable = toBeReservedMo.getAttribute("persistentReservers");
                if (reserverRfCable != null) {
                    String reserverLDN;
                    if (reserverRfCable instanceof SequenceAttribute) {
                        if (this.isReservedBy((SequenceAttribute)reserverRfCable, LDN, this.context)) {
                            MessageLog.trace((int)9, (Class)ReserveMoHelper.class, (String)("reservee is " + refLdn + ", the reserver:" + LDN + " is already in the reservedBy list. "));
                        } else {
                            toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                            MessageLog.trace((int)9, this.getClass(), (String)("reservee is " + refLdn + ", did not find LDN " + LDN + " in the reserver list, reserver list size is : " + ((SequenceAttribute)reserverRfCable).size()));
                            ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                            MessageLog.trace((int)9, this.getClass(), (String)(" new reserver list size is : " + ((SequenceAttribute)reserverRfCable).size()));
                        }
                    } else if (reserverRfCable instanceof ReferenceAttribute && !LDN.equals(reserverLDN = ((ReferenceAttribute)reserverRfCable).getReferenceAsLDN())) {
                        toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                        MessageLog.trace((int)9, this.getClass(), (String)" did not find the reserver, make explicit reservation... ");
                        ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                    }
                } else {
                    toBeReservedMo.handleTransaction(this.context, MoData.WRITE_ACCESS);
                    MessageLog.trace((int)9, this.getClass(), (String)" did not find the reserver in the list, make reservation... ");
                    ReserveMoHelper.reserve(toBeReservedMo, LDN, this.context);
                }
            } else {
                MessageLog.traceError(this.getClass(), (String)"did not find the corresponding MO according to LDN");
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)" ref attribute is null, do nothing ");
        }
    }

    private MoData getMoDataByLdn(String moLdn) {
        MessageLog.traceEnter(this.getClass(), (String)"getMoDataByLdn()");
        Vector originalData = this.workingMoData.getOriginalData();
        MoData tmp = null;
        Iterator i = originalData.iterator();
        while (i.hasNext()) {
            tmp = (MoData)i.next();
            if (!tmp.getLocalDistinguishedName().equals(moLdn)) continue;
            return tmp;
        }
        return null;
    }

    public boolean isReservedBy(SequenceAttribute reservedByAttr, String reserverLdn, Coordinator context) throws Exception {
        if (reservedByAttr == null || reserverLdn == null) {
            return false;
        }
        Enumeration e = reservedByAttr.elements();
        while (e.hasMoreElements()) {
            ReferenceAttribute element = (ReferenceAttribute)e.nextElement();
            if (element == null || element.getReferenceAsLDN() == null || !element.getReferenceAsLDN().equals(reserverLdn)) continue;
            return true;
        }
        return false;
    }
}

