/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CabinetMo;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class CabinetFroDataConverter
extends CommonSupportSystemFroDataConverter {
    private static CabinetFroDataConverter _theOne = new CabinetFroDataConverter();
    private ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("cabinetParameters", DatabaseMgr.getSql().varcharType(2048)), new ColumnData("climateSystem", "INTEGER"), new ColumnData("productData", DatabaseMgr.getSql().varcharType(1024))};

    private CabinetFroDataConverter() {
        super("CabinetFroDataConverter");
    }

    public static CommonSupportSystemFroDataConverter instance() {
        return _theOne;
    }

    private String getProductData(CabinetMo cab, Coordinator context) throws MoAccessException {
        StringBuffer result = new StringBuffer("<struct name=\"productData\">");
        result.append("<attr name=\"productionDate\" type=\"STRING\" value=\"" + cab.getProductionDate(context) + "\"/>");
        result.append("<attr name=\"productName\" type=\"STRING\" value=\"" + cab.getProductName(context) + "\"/>");
        result.append("<attr name=\"productNumber\" type=\"STRING\" value=\"" + cab.getProductNumber(context) + "\"/>");
        result.append("<attr name=\"productRevision\" type=\"STRING\" value=\"" + cab.getProductRevision(context) + "\"/>");
        result.append("<attr name=\"serialNumber\" type=\"STRING\" value=\"" + cab.getSerialNumber(context) + "\"/>");
        return result.append("</struct>").toString();
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return "Cabinet";
    }

    protected Object[] getTableData(ManagedObject mo, Coordinator c) throws MoAccessException {
        CabinetMo cab = (CabinetMo)mo;
        String ldn = "ManagedElement=1,Equipment=1,Cabinet=" + cab.getNamingAttributeValue();
        return new Object[]{new Integer(this.nextFroId()), ldn, CabinetFroDataConverter.convertIntArrayToString(cab.getCabinetParameters(null), "cabinetParameters"), new Integer(cab.getClimateSystem(c)), this.getProductData(cab, null)};
    }

    protected void createNewMoData(MoData modata, String ldn, int froId, Coordinator c) throws MoAccessException {
        MoData myNewData = new MoData(ldn, "Cabinet", true, c);
        myNewData.handleTransaction(c, MoData.WRITE_ACCESS);
        IntegerAttribute intAttr = new IntegerAttribute("froId", false);
        myNewData.registerPersistentAttr((Attribute)intAttr);
        intAttr.setValue(froId);
        myNewData.registerPersistentAttr(modata.getAttribute("cabinetParametersProfileStandard"));
        myNewData.registerPersistentAttr(modata.getAttribute("cabinetParametersProfileExtended"));
        myNewData.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "cabinetParameters", "array"), new ApcFroAttributes(froType, "climateSystem", "S32"), new ApcFroAttributes(froType, "productData", "struct")};
    }

    protected String getNewTypeName() {
        return "Cabinet";
    }
}

