/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.frodataconv;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.frodataconv.ApcFroAttributes;
import se.ericsson.wcdma.rbs.boam.frodataconv.ColumnData;
import se.ericsson.wcdma.rbs.boam.frodataconv.CommonSupportSystemFroDataConverter;
import se.ericsson.wcdma.rbs.boam.frodataconv.HwUnitFroDataConverter;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.database.DatabaseMgr;

public class EcPortFroDataConverter
extends CommonSupportSystemFroDataConverter {
    public static final String AUE_NAME = "EcPortFroDataConverter";
    private static CommonSupportSystemFroDataConverter _theOne = new EcPortFroDataConverter();
    private ColumnData[] columnData = new ColumnData[]{new ColumnData("ldn", DatabaseMgr.getSql().varcharType(100)), new ColumnData("hubPosition", DatabaseMgr.getSql().varcharType(20))};
    private final Set usedLdns = new HashSet();

    private EcPortFroDataConverter() {
        super(AUE_NAME);
    }

    public static CommonSupportSystemFroDataConverter instance() {
        return _theOne;
    }

    public static synchronized void newInstance_onlyForTest() {
        _theOne = new EcPortFroDataConverter();
    }

    protected ColumnData[] getColumnData() {
        return this.columnData;
    }

    protected String getTypeName() {
        return null;
    }

    protected Object[] getTableData(ManagedObject nextMo, Coordinator context) throws MoAccessException {
        if (nextMo instanceof AuxPlugInUnitMo) {
            AuxPlugInUnitMo mo = (AuxPlugInUnitMo)nextMo;
            String auxId = EcPortFroDataConverter.getAuType((ManagedObject)mo, context);
            String hubPosition = this.convertHubPositionToSymbolicFormat(mo.getHubPosition(context));
            if (hubPosition == null) {
                return null;
            }
            String hwUnitId = auxId;
            if (auxId.equalsIgnoreCase("SUP")) {
                hwUnitId = this.getSupHwUnitId(mo.getNamingAttributeValue());
            }
            String ldn = this.adaptLdn("ManagedElement=1,Equipment=1,HwUnit=" + hwUnitId + ",EcPort=1");
            return new Object[]{new Integer(this.nextFroId()), ldn, hubPosition};
        }
        if (nextMo instanceof PlugInUnitMo) {
            PlugInUnitMo pluginUnit = (PlugInUnitMo)nextMo;
            String auxId = pluginUnit.getNamingAttributeValue();
            ManagedObject slot = BoamManagedObject.getAncestor((ManagedObject)pluginUnit, (String)"Slot");
            ManagedObject subrack = BoamManagedObject.getAncestor((ManagedObject)pluginUnit, (String)"Subrack");
            return new Object[]{new Integer(this.nextFroId()), "ManagedElement=1,Equipment=1,Subrack=" + subrack.getNamingAttributeValue() + ",Slot=" + slot.getNamingAttributeValue() + ",PlugInUnit=" + auxId + ",EcPort=1", "A0"};
        }
        if (nextMo == null) {
            String ldn = this.adaptLdn("ManagedElement=1,Equipment=1,HwUnit=PDU,EcPort=1");
            return new Object[]{new Integer(this.nextFroId()), ldn, "A2"};
        }
        throw new SoftwareErrorException();
    }

    protected void createNewMoData(MoData ignored, String ldn, int froId, Coordinator c) throws MoAccessException {
        MoData myNewData = new MoData(ldn, "EcPort", true, c);
        myNewData.handleTransaction(c, MoData.WRITE_ACCESS);
        myNewData.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, froId));
        myNewData.setRevision(8010001);
    }

    protected ApcFroAttributes[] getApcFroAttributesData() {
        int froType = this.getFroType();
        return new ApcFroAttributes[]{new ApcFroAttributes(froType, "hubPosition", "STRING")};
    }

    protected String getNewTypeName() {
        return "EcPort";
    }

    private String convertHubPositionToSymbolicFormat(int hubPosition) {
        switch (hubPosition) {
            case 24: {
                return "A";
            }
            case 23: {
                return "B";
            }
            case 22: {
                return "C";
            }
            case 20: {
                return "E";
            }
            case 21: {
                return "D";
            }
            case 34: {
                return "F";
            }
            case 33: {
                return "G";
            }
            case 32: {
                return "H";
            }
            case 31: {
                return "I";
            }
            case 30: {
                return "J";
            }
            case 0: {
                return "A1";
            }
            case 1: {
                return "A2";
            }
            case 2: {
                return "A3";
            }
            case 3: {
                return "A4";
            }
            case 4: {
                return "A5";
            }
            case 5: {
                return "A6";
            }
            case 6: {
                return "A7";
            }
            case 7: {
                return "A8";
            }
            case 8: {
                return "B1";
            }
            case 9: {
                return "B2";
            }
            case 10: {
                return "B3";
            }
            case 11: {
                return "B4";
            }
            case 12: {
                return "B5";
            }
            case 13: {
                return "B6";
            }
            case 14: {
                return "B7";
            }
            case 15: {
                return "B8";
            }
            case 99: {
                return "NA";
            }
        }
        return null;
    }

    private String adaptLdn(String ldn) throws MoAccessException {
        this.traceEnter("adaptLdn(" + ldn + ")");
        List ldnStore = HwUnitFroDataConverter.instance().getLdnStore();
        Iterator iter = ldnStore.iterator();
        while (iter.hasNext()) {
            String hwUnitLdn = (String)iter.next();
            if (this.usedLdns.contains(hwUnitLdn)) {
                this.trace("HwUnit LDN already used in previous adaptation: " + hwUnitLdn);
                continue;
            }
            this.trace("considering HwUnit LDN for match: " + hwUnitLdn);
            String adaptedLdn = LDNHelper.adaptEcPortLdn(ldn, hwUnitLdn);
            if (adaptedLdn == null) {
                this.trace("given LDN does not match the considered HwUnit LDN");
                continue;
            }
            this.usedLdns.add(hwUnitLdn);
            this.trace("given LDN matched, returning: " + adaptedLdn);
            return adaptedLdn;
        }
        this.trace("given LDN was not adapted: " + ldn);
        return ldn;
    }
}

