/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.upfwk.common.LDNHelper;
import se.ericsson.wcdma.rbs.boam.upfwk.common.WorkingMoData;

public abstract class FindMo {
    public static Collection getChildren(String childTypeName, String parentLdn, WorkingMoData cache) {
        ArrayList<MoData> chlidrens = new ArrayList<MoData>();
        Collection mos = cache.getMoData(childTypeName);
        Iterator i = mos.iterator();
        while (i.hasNext()) {
            MoData mo = (MoData)i.next();
            String myParent = LDNHelper.getParentLdn(mo.getLocalDistinguishedName(), childTypeName);
            if (!myParent.equals(parentLdn)) continue;
            chlidrens.add(mo);
        }
        return chlidrens;
    }

    public static int getNoOfChildren(String childTypeName, String parentLdn, WorkingMoData cache) {
        Collection mos = FindMo.getChildren(childTypeName, parentLdn, cache);
        return mos.size();
    }

    public static MoIterator findMOs(String moTypeName, ManagedObject base, int deep) {
        MoTypeFilter moFilter = null;
        MoIterator moIter = null;
        moFilter = new MoTypeFilter(moTypeName);
        moIter = MoRepository.instance().select(base, deep, (MoFilter)moFilter);
        return moIter;
    }

    public static MoIterator findMOs(String moName, int deep) {
        Mib mibObj = null;
        ManagedObject base = null;
        MoIterator moIter = null;
        mibObj = MibMgr.instance().getMib();
        base = mibObj.getRootMo();
        moIter = FindMo.findMOs(moName, base, deep);
        return moIter;
    }

    public static MoIterator findMOs(String moName) {
        Mib mibObj = null;
        ManagedObject base = null;
        MoIterator moIter = null;
        mibObj = MibMgr.instance().getMib();
        base = mibObj.getRootMo();
        moIter = FindMo.findMOs(moName, base, -1);
        return moIter;
    }

    public static MoIterator findMOs(ManagedObject base, int deep) {
        return MoRepository.instance().select(base, deep, null);
    }

    public static MoIterator findMOs(int deep) {
        return FindMo.findMOs(MibMgr.instance().getMib().getRootMo(), deep);
    }

    public static MoIterator findMOs() {
        return FindMo.findMOs(-1);
    }
}

