/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.debug.MessageLog;

public abstract class LDNHelper {
    public static final Class SELF = LDNHelper.class;
    public static final String RDN_SEPARATOR = ",";
    public static final String VALUE_SEPARATOR = "=";
    public static final String INSTANCE_SEPARATOR_NEW = "-";
    public static final String INSTANCE_SEPARATOR_OLD = "_";

    public static String getNamingAttributeValue(String ldName) {
        if (LDNHelper.isEmpty(ldName)) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"getNamingAttributeValue(), The input ldn is null/empty!!");
            return ldName;
        }
        int startPos = ldName.lastIndexOf(VALUE_SEPARATOR);
        if (startPos != -1) {
            String namingValue = ldName.substring(startPos + 1);
            return namingValue;
        }
        return null;
    }

    public static boolean isLdnFormat(String ldName) {
        if (LDNHelper.isEmpty(ldName)) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"isLdnFormat(), The input ldn is null/empty!!");
            return false;
        }
        int startPos = ldName.indexOf(VALUE_SEPARATOR);
        int lastPos = ldName.lastIndexOf(VALUE_SEPARATOR);
        return startPos > 0 && lastPos < ldName.length() - 1;
    }

    public static String getMoTypeName(String ldName) {
        if (LDNHelper.isEmpty(ldName)) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"getMoTypeName(), The input ldn is null/empty!!");
            return ldName;
        }
        int startPos = ldName.lastIndexOf(RDN_SEPARATOR) + 1;
        if (startPos == ldName.length()) {
            return null;
        }
        int endPos = ldName.lastIndexOf(VALUE_SEPARATOR);
        if (endPos > startPos) {
            return ldName.substring(startPos, endPos);
        }
        return null;
    }

    public static String replaceFirst(String source, String oldSubStr, String replacement) {
        if (LDNHelper.isEmpty(source) || LDNHelper.isEmpty(oldSubStr) || LDNHelper.isEmpty(replacement) || source.indexOf(oldSubStr) == -1) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"replaceFirst(), Some input is null/empty!!");
            return source;
        }
        int beginIndex = 0;
        int endIndex = source.indexOf(oldSubStr);
        String subStr1 = source.substring(beginIndex, endIndex);
        beginIndex = endIndex + oldSubStr.length();
        String subStr2 = source.substring(beginIndex, source.length());
        return subStr1.concat(replacement).concat(subStr2);
    }

    public static boolean isEmpty(String intAttr) {
        return intAttr == null || intAttr == "";
    }

    public static String getRelativeDistinguishedName(String source) {
        if (LDNHelper.isEmpty(source)) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"getRelativeDistinguishedName(), The input ldn is null/empty!!");
            return source;
        }
        if (source.indexOf(VALUE_SEPARATOR) == source.lastIndexOf(VALUE_SEPARATOR)) {
            return source;
        }
        int startPos = source.lastIndexOf(RDN_SEPARATOR);
        if (startPos != -1) {
            String rdn = source.substring(startPos + 1);
            return rdn;
        }
        return null;
    }

    public static String getLdnStartFromtType(String source, String typeName) {
        if (LDNHelper.isEmpty(source) || LDNHelper.isEmpty(typeName) || source.indexOf(typeName + VALUE_SEPARATOR) < 0) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"getLdnStartFromtType(), Some input is null/empty!!");
            return source;
        }
        int startIndex = source.indexOf(typeName);
        return source.substring(startIndex, source.length());
    }

    public static String getParentLdn(String source, String typeName) {
        if (LDNHelper.isEmpty(source) || LDNHelper.isEmpty(typeName) || source.indexOf(typeName + VALUE_SEPARATOR) < 0) {
            MessageLog.traceError((Class)LDNHelper.class, (String)"getParentLdn(), Some input is null/empty!!");
            return source;
        }
        if (source.indexOf(typeName + VALUE_SEPARATOR) == 0) {
            return "";
        }
        typeName = typeName + VALUE_SEPARATOR;
        int endIndex = source.indexOf(typeName);
        return source.substring(0, endIndex - 1);
    }

    public static List toList(String ldn) throws MoAccessException {
        if (ldn.length() == 0) {
            MessageLog.traceError((Class)SELF, (String)"LDN is empty string");
            throw new SoftwareErrorException();
        }
        if (ldn.indexOf(RDN_SEPARATOR) == -1) {
            int sep = ldn.indexOf(VALUE_SEPARATOR);
            if (sep == -1) {
                MessageLog.traceError((Class)SELF, (String)("missing '=' in LDN" + ldn));
                throw new SoftwareErrorException();
            }
            if (sep == 0) {
                MessageLog.traceError((Class)SELF, (String)("empty left-part in LDN: " + ldn));
                throw new SoftwareErrorException();
            }
            if (sep == ldn.length() - 1) {
                MessageLog.traceError((Class)SELF, (String)("empty right-part in LDN: " + ldn));
                throw new SoftwareErrorException();
            }
            String left = ldn.substring(0, sep);
            String right = ldn.substring(sep + 1);
            LinkedList<Rdn> result = new LinkedList<Rdn>();
            result.add(new Rdn(left, right));
            return result;
        }
        int sep = ldn.indexOf(RDN_SEPARATOR);
        String head = ldn.substring(0, sep);
        String tail = ldn.substring(sep + 1);
        List tailList = LDNHelper.toList(tail);
        List headList = LDNHelper.toList(head);
        ((LinkedList)tailList).addFirst(headList.get(0));
        return tailList;
    }

    public static String toString(List list) {
        if (list.size() == 1) {
            Rdn rdn = (Rdn)list.get(0);
            return rdn.leftPart + VALUE_SEPARATOR + rdn.rightPart;
        }
        Rdn headRdn = (Rdn)list.get(0);
        List tailList = (List)((LinkedList)list).clone();
        ((LinkedList)tailList).removeFirst();
        return headRdn.leftPart + VALUE_SEPARATOR + headRdn.rightPart + RDN_SEPARATOR + LDNHelper.toString(tailList);
    }

    public static String adaptEcPortLdn(String e, String h) throws MoAccessException {
        List eList = LDNHelper.toList(e);
        List hList = LDNHelper.toList(h);
        if (eList.size() - 1 != hList.size()) {
            return null;
        }
        List result = LDNHelper.adaptEcPortLdn(eList, hList, new LinkedList());
        if (result == null) {
            return null;
        }
        return LDNHelper.toString(result);
    }

    public static String convertAuxPIUIdToHwUnitId(String auxId) throws MoAccessException {
        int firstIndex = auxId.indexOf(INSTANCE_SEPARATOR_OLD);
        int lastIndex = auxId.lastIndexOf(INSTANCE_SEPARATOR_OLD);
        if (firstIndex != -1 && firstIndex == lastIndex) {
            try {
                String auType = auxId.substring(0, lastIndex);
                String number = auxId.substring(lastIndex + 1);
                Integer.parseInt(number);
                return auType + INSTANCE_SEPARATOR_NEW + number;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static List adaptEcPortLdn(List e, List h, List u) {
        if (!LDNHelper.caar(e).equalsIgnoreCase(LDNHelper.caar(h))) {
            return null;
        }
        if (!LDNHelper.caar(e).equalsIgnoreCase("HwUnit") && h.size() == 1) {
            return null;
        }
        if (!LDNHelper.caar(e).equalsIgnoreCase("HwUnit") && !LDNHelper.car(e).equals(LDNHelper.car(h))) {
            return null;
        }
        if (!LDNHelper.caar(e).equalsIgnoreCase("HwUnit") && h.size() > 1) {
            ((LinkedList)u).addLast(LDNHelper.car(e));
            return LDNHelper.adaptEcPortLdn(LDNHelper.cdr(e), LDNHelper.cdr(h), u);
        }
        if (!(LDNHelper.rMatch(LDNHelper.car(e), "BFU") || LDNHelper.rMatch(LDNHelper.car(e), "PSU") || LDNHelper.rMatch(LDNHelper.car(e), "PDU"))) {
            return null;
        }
        if (!LDNHelper.rMatch(LDNHelper.car(h), LDNHelper.car((List)e).rightPart)) {
            return null;
        }
        if (h.size() > 1) {
            return null;
        }
        ((LinkedList)u).addLast(LDNHelper.car(h));
        ((LinkedList)u).addLast(LDNHelper.cadr(e));
        return u;
    }

    private static Rdn car(List x) {
        return (Rdn)((LinkedList)x).getFirst();
    }

    private static String caar(List x) {
        return ((Rdn)((LinkedList)x).getFirst()).leftPart;
    }

    private static List cdr(List x) {
        List result = (List)((LinkedList)x).clone();
        ((LinkedList)result).removeFirst();
        return result;
    }

    private static Rdn cadr(List x) {
        return (Rdn)((LinkedList)LDNHelper.cdr(x)).getFirst();
    }

    private static boolean rMatch(Rdn x, String s) {
        return x.rightPart.startsWith(s);
    }

    public static class Rdn {
        public final String leftPart;
        public final String rightPart;

        public Rdn(String leftPart, String rightPart) throws MoAccessException {
            if (!leftPart.trim().equals(leftPart) || !rightPart.trim().equals(rightPart)) {
                MessageLog.traceError((Class)SELF, (String)("LDN contains whitespace: '" + leftPart + LDNHelper.VALUE_SEPARATOR + rightPart + "'"));
                throw new SoftwareErrorException();
            }
            this.leftPart = leftPart;
            this.rightPart = rightPart;
        }

        public String toString() {
            return this.leftPart + LDNHelper.VALUE_SEPARATOR + this.rightPart;
        }

        public boolean equals(Object u) {
            if (u == null) {
                return false;
            }
            if (u == this) {
                return true;
            }
            if (!(u instanceof Rdn)) {
                return false;
            }
            return this.leftPart.equals(((Rdn)u).leftPart) && this.rightPart.equals(((Rdn)u).rightPart);
        }
    }
}

