/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoDataConversionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.upfwk.common.Const;

public class MoDataHelper {
    private static final int BOAM_TX_TMO = 600;
    private static boolean debugOn = false;

    public static void registerBooleanAttr(MoData moData, BooleanAttribute attr, String attrName, boolean notify, boolean value) {
        if (moData == null) {
            return;
        }
        if (attr == null) {
            attr = new BooleanAttribute(attrName, notify, value);
        }
        moData.registerPersistentAttr((Attribute)attr);
    }

    public static void registerIntegerAttr(MoData moData, IntegerAttribute attr, String attrName, boolean notify, int value) {
        if (moData == null) {
            return;
        }
        if (attr == null) {
            attr = new IntegerAttribute(attrName, notify, value);
        }
        moData.registerPersistentAttr((Attribute)attr);
    }

    public static void registerStringAttr(MoData moData, StringAttribute attr, String attrName, boolean notify, String value) {
        if (moData == null) {
            return;
        }
        if (attr == null) {
            attr = new StringAttribute(attrName, notify, value);
        }
        moData.registerPersistentAttr((Attribute)attr);
    }

    public static void registerRefAttr(MoData moData, ReferenceAttribute attr, String attrName, boolean notify, String value) {
        ReferenceAttribute tempAttr;
        if (moData == null) {
            return;
        }
        if (attr == null) {
            attr = new ReferenceAttribute(attrName, value, notify);
        }
        if ((tempAttr = (ReferenceAttribute)moData.getAttribute(attrName)) != null) {
            MoDataHelper.deRegisterAttr(moData, attrName);
        }
        moData.registerPersistentAttr((Attribute)attr);
    }

    public static void registerStructAttr(MoData moData, StructAttribute attr, String attrName, boolean notify) {
        StructAttribute tempAttr;
        if (moData == null) {
            return;
        }
        if (attr == null) {
            attr = new StructAttribute(attrName, notify);
        }
        if ((tempAttr = (StructAttribute)moData.getAttribute(attrName)) != null) {
            MoDataHelper.deRegisterAttr(moData, attrName);
        }
        moData.registerPersistentAttr((Attribute)attr);
    }

    public static void deRegisterAttr(MoData moData, Attribute attr) {
        if (moData == null || attr == null) {
            return;
        }
        moData.deregisterAttribute(attr);
    }

    public static void deRegisterAttr(MoData moData, String attrName) {
        if (moData == null) {
            return;
        }
        Attribute attr = moData.getAttribute(attrName);
        if (attr != null) {
            MoDataHelper.deRegisterAttr(moData, attr);
        }
    }

    public static void registerSeqAttr(MoData moData, SequenceAttribute attr, String attrName, boolean notify, Attribute[] values) {
        if (moData == null) {
            MessageLog.trace((int)9, (Class)MoDataHelper.class, (String)"MoData  is null!!");
            return;
        }
        if (attr == null) {
            attr = new SequenceAttribute(attrName, notify);
            moData.registerPersistentAttr((Attribute)attr);
        } else if (moData.getAttribute(attrName) == null) {
            moData.registerPersistentAttr((Attribute)attr);
        }
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) {
                    attr.addElement(values[i]);
                    continue;
                }
                MessageLog.trace((int)9, (Class)(class$se$ericsson$wcdma$rbs$boam$upfwk$common$MoDataHelper == null ? MoDataHelper.class$("se.ericsson.wcdma.rbs.boam.upfwk.common.MoDataHelper") : class$se$ericsson$wcdma$rbs$boam$upfwk$common$MoDataHelper), (String)"null value will not be added to sequence attribute");
            }
        }
    }

    public static String getFroIdAttrName(String moType) throws MoAccessException {
        MessageLog.traceEnter((Class)MoDataHelper.class, (String)("getFroIdAttrName(), moType: " + moType));
        if (moType.equals("AlmDeviceSet")) {
            return "auxDevSetFroId";
        }
        if (moType.equals("AlmDevice")) {
            return "auxDeviceFroId";
        }
        if (moType.equals("DpclDevice")) {
            return "deviceFroId";
        }
        if (moType.equals("TpaDevice")) {
            return "auxDeviceFroId";
        }
        if (moType.equals("TrDevice")) {
            return "deviceFroId";
        }
        if (moType.equals("OutDevice")) {
            return "auxDeviceFroId";
        }
        if (moType.equals("DbccDevice")) {
            return "deviceFroId";
        }
        if (moType.equals("AuxPlugInUnit")) {
            return "auxPiuFroId";
        }
        if (moType.equals("TmaDevice")) {
            return "auxDeviceFroId";
        }
        if (moType.equals("AiDevice")) {
            return "deviceFroId";
        }
        throw new SoftwareErrorException((Throwable)new IllegalArgumentException("cannot handle MO type: " + moType));
    }

    public static void activateWriteAccess(Coordinator context, MoData moData) throws MoDataConversionException {
        try {
            moData.handleTransaction(context, MoData.WRITE_ACCESS);
        }
        catch (MoAccessException e) {
            MessageLog.trace((int)9, (Class)MoDataHelper.class, (String)"BoamDC- dirty write not accepted");
            throw new MoDataConversionException("BoamDC- dirty write not accepted");
        }
    }

    public static Control createTransaction() throws Exception {
        return TransactionServiceImpl.instance().getTransactionFactory().create(600);
    }

    public static void debug(String msg) {
        if (debugOn) {
            System.out.println("\nBoamDC Log:\t" + msg + "\n");
        }
    }

    public static void restartSystem(Class c) {
        MessageLog.traceEnter((Class)c, (String)"restartSystem() ");
        MoDataHelper.debug("\n\nBOAM: An irrecoverable failure during data conversion has occurred.Calling Assert!!");
        MessageLog.traceError((Class)c, (String)"\n\nBOAM: An irrecoverable failure during data conversion has occurred.Calling Assert!!");
        Const.callAssert(null, "An irrecoverable failure during data conversion has occurred.");
    }
}

