/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.common;

import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class TransactionWrapper {
    private static final int TRANSACTION_TIMEOUT = 900;
    private static final long RETRY_INTERVAL = 10L;
    private Control control = null;
    private Coordinator context = null;

    public TransactionWrapper(int timeOut) throws TransactionRolledBackException {
        try {
            this.control = this.createTransaction(timeOut);
        }
        catch (TransactionRolledBackException trbe) {
            MessageLog.traceError(this.getClass(), (String)" Instantiation failed on first attempt. Retrying in 10s.", (Throwable)trbe);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.control = this.createTransaction(timeOut);
            MessageLog.info(this.getClass(), (String)" Instantiation succeeded on second attempt.");
        }
        this.context = this.control.getCoordinator();
    }

    public TransactionWrapper() throws TransactionRolledBackException {
        try {
            this.control = this.createTransaction(900);
        }
        catch (TransactionRolledBackException trbe) {
            MessageLog.traceError(this.getClass(), (String)" Instantiation failed on first attempt. Retrying in 10s.", (Throwable)trbe);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.control = this.createTransaction(900);
            MessageLog.info(this.getClass(), (String)" Instantiation succeeded on second attempt.");
        }
        this.context = this.control.getCoordinator();
    }

    private Control createTransaction(int timeOut) throws TransactionRolledBackException {
        return TransactionServiceImpl.instance().getTransactionFactory().create(timeOut);
    }

    public void commit() throws InactiveTransactionException, TransactionRolledBackException {
        this.control.getTerminator().commit();
    }

    public void rollback() throws InactiveTransactionException {
        this.control.getTerminator().rollback();
    }

    public Coordinator getCoordinator() {
        return this.context;
    }

    public int getID() {
        return this.context.getTransactionID();
    }

    public boolean isActive() {
        return this.control.getCoordinator().getStatus() == Status.ACTIVE;
    }
}

