/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.upfwk.data;

import java.io.Serializable;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.upfwk.data.Attribute;

public class BooleanAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 0L;
    private transient boolean myBackup;
    private boolean myValue;
    private transient boolean myIsTransactionActive = false;

    public BooleanAttribute(String name, boolean isAttrValueChangeNotifier, boolean initialValue) {
        super(name, isAttrValueChangeNotifier);
        this.myValue = initialValue;
    }

    public BooleanAttribute(String name, String attrData) {
        super(name, attrData.charAt(1));
        this.myValue = Boolean.valueOf(attrData.substring(2));
    }

    public synchronized boolean getValue(Coordinator c) {
        if (c == null) {
            if (this.myIsTransactionActive) {
                return this.myBackup;
            }
            return this.myValue;
        }
        return this.myValue;
    }

    public synchronized void setValue(boolean aValue) {
        this.myValue = aValue;
    }

    public synchronized void setValue(Boolean aValue) {
        this.myValue = aValue;
    }

    synchronized void rollback() {
        this.myValue = this.myBackup;
        this.myIsTransactionActive = false;
    }

    synchronized void commit() {
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        this.myBackup = this.myValue;
        this.myIsTransactionActive = true;
    }

    Object getValueAsObject(Coordinator c) {
        return new Boolean(this.getValue(c));
    }

    boolean isModified() {
        return this.myValue != this.myBackup;
    }

    public String buildString() {
        String avc = "";
        avc = this.isAVCNotifier() ? "T" : "F";
        return this.getName() + "^b" + avc + String.valueOf(this.myValue);
    }
}

