/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.util.Properties;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.ProgressUpdaterInterface;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.utils.EmLogger;

class ApplicationWrapper
implements Runnable {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private boolean wait;
    private boolean exceptionalExit;
    private String className;
    ClassLoader classloader;
    private String NE;
    private Launchable parent;
    private Properties parameters;
    private VersionedLauncherInterface launcher;
    private Launchable instance;
    private String startedByThread = Thread.currentThread().toString();
    private ApplicationConfiguration configuration;
    private boolean is_application;

    public ApplicationWrapper(ClassLoader aClassloader, ApplicationConfiguration config, boolean is_appl, String aHostname, Properties theParameters, VersionedLauncherInterface theLauncher, Launchable parent_ref) {
        this.is_application = is_appl;
        this.wait = false;
        this.classloader = aClassloader;
        this.className = config.getApplicationClass();
        this.NE = aHostname;
        this.parameters = theParameters;
        this.launcher = theLauncher;
        this.parent = parent_ref;
        this.configuration = config;
        this.instance = null;
        this.exceptionalExit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceReader(boolean excExit) {
        ApplicationWrapper applicationWrapper = this;
        synchronized (applicationWrapper) {
            if (this.wait) {
                this.notify();
            } else {
                this.exceptionalExit = excExit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block16: {
            EProps ep = new EProps();
            ep.put(EKEY.PROBLEM_DESIGNER_LEVEL, "Failed to start new application!");
            ep.put(EKEY.JAVA_METHOD, "ApplicationWrapper.run");
            ep.append(EKEY.JAVA_METHOD, "classloader    = " + this.classloader);
            ep.append(EKEY.JAVA_METHOD, "className      = " + this.className);
            ep.append(EKEY.JAVA_METHOD, "NE             = " + this.NE);
            ep.append(EKEY.JAVA_METHOD, "parameters     = " + this.parameters);
            ep.append(EKEY.JAVA_METHOD, "launcher       = " + this.launcher);
            ep.append(EKEY.JAVA_METHOD, "parent         = " + this.parent);
            ep.append(EKEY.JAVA_METHOD, "thread         = " + Thread.currentThread());
            ep.append(EKEY.JAVA_METHOD, "startedByThread= " + this.startedByThread);
            ep.append(EKEY.JAVA_METHOD, "this           = " + this);
            ep.append(EKEY.JAVA_METHOD, "classloader    = " + this.getClass().getClassLoader());
            ep.append(EKEY.JAVA_METHOD, "cl.parent      = " + this.getClass().getClassLoader().getParent());
            try {
                try {
                    Object p;
                    Class<?> applClass = this.classloader.loadClass(this.className);
                    Object applObj = applClass.newInstance();
                    if (!(applObj instanceof Launchable)) {
                        LOG.warning("The application is not an instance of Launchable", new Object[0]);
                    }
                    ProgressListenerInterface pli = this.launcher.getProgressListener();
                    if (applObj instanceof ProgressUpdaterInterface) {
                        p = (ProgressUpdaterInterface)applObj;
                        p.setProgressListener(pli);
                        pli.setUpdater(applObj);
                    }
                    p = this;
                    synchronized (p) {
                        this.instance = (Launchable)applObj;
                        ApplicationConfiguration aci = this.configuration;
                        ((Launcher)this.launcher).putApplicationconfiguration(this.instance, aci, this.is_application);
                        if (this.wait) {
                            this.notify();
                        }
                    }
                    try {
                        LOG.info("before run instance, className : " + this.className, new Object[0]);
                        this.instance.run(this.NE, this.parameters, this.launcher, this.parent);
                        LOG.info("after run instance, className : " + this.className, new Object[0]);
                    }
                    catch (Exception e) {
                        LauncherException ne = Launcher.createLauncherException("Failed to start new application!", ep, e);
                        ErrorDialog edial = new ErrorDialog("An exception was thrown by the application's run method", ne);
                        edial.setVisible(!Boolean.getBoolean("launchertest.silent"));
                        ne.printStackTrace();
                    }
                    Object var10_23 = null;
                }
                catch (ClassNotFoundException e) {
                    LauncherException ne = Launcher.createLauncherException("Failed to start new application!", ep, e);
                    ErrorDialog edial = new ErrorDialog("The application's main class " + this.className + " was not found", ne);
                    edial.setVisible(!Boolean.getBoolean("launchertest.silent"));
                    ne.printStackTrace();
                    Object var10_24 = null;
                    this.notifyInstanceReader(false);
                    break block16;
                }
                catch (InstantiationException e1) {
                    LauncherException ne = Launcher.createLauncherException("Failed to start new application!", ep, e1);
                    ErrorDialog edial = new ErrorDialog("The application class " + this.className + " could not properly be instantiated", ne);
                    edial.setVisible(!Boolean.getBoolean("launchertest.silent"));
                    ne.printStackTrace();
                    Object var10_25 = null;
                    this.notifyInstanceReader(false);
                    break block16;
                }
                catch (IllegalAccessException e1) {
                    LauncherException ne = Launcher.createLauncherException("Failed to start new application!", ep, e1);
                    ErrorDialog edial = new ErrorDialog("There was an illegal access exception when trying to instantiate the class " + this.className, ne);
                    edial.setVisible(!Boolean.getBoolean("launchertest.silent"));
                    ne.printStackTrace();
                    Object var10_26 = null;
                    this.notifyInstanceReader(false);
                    break block16;
                }
                catch (RuntimeException e1) {
                    LauncherException ne = Launcher.createLauncherException(null, ep, e1);
                    ne.printStackTrace();
                    throw e1;
                }
                catch (Error err) {
                    LauncherException ne = Launcher.createLauncherException("Error was thrown while trying to start new application!", ep, err);
                    ne.printStackTrace();
                    throw err;
                }
                this.notifyInstanceReader(false);
                return;
            }
            catch (Throwable throwable) {
                Object var10_27 = null;
                this.notifyInstanceReader(false);
                throw throwable;
            }
        }
        LOG.severe("Could not start application", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Launchable getInstance() {
        ApplicationWrapper applicationWrapper = this;
        synchronized (applicationWrapper) {
            if (this.instance == null && !this.exceptionalExit) {
                try {
                    this.wait = true;
                    this.wait();
                    this.wait = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.instance;
    }
}

