/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public class ErrorDialog {
    private String mySpecificMessage = null;
    private String myMainMessage = null;
    private Exception myException = null;
    String closeButtonLabel = null;
    private static final String DEFAULT_CLOSE_BUTTON_LABEL = "Close";
    private String moreStr = "More >>";
    private String lessStr = "<< Less";
    final int ROWS_DEFAULT = 10;
    final int COLUMNS_DEFAULT = 60;
    private JDialog jDialog = null;
    private JScrollPane scrollPane = null;
    private JTextArea detailsTextArea = null;
    protected static final Border loweredBorder = BorderFactory.createLoweredBevelBorder();
    private JPanel northP = null;
    private JPanel iconP = null;
    private JLabel errorLabel = null;
    private JPanel messageP = null;
    private JPanel northMessagePane = null;
    private JPanel centerMessagePane = null;
    private JTextArea messageTextArea = null;
    private JPanel buttonP = null;
    private JButton detailsB = null;
    private JButton closeBtn = null;
    private JTextArea specMessageTextArea = null;
    private JFrame frame = null;

    public ErrorDialog(String message) {
        this(message, null, DEFAULT_CLOSE_BUTTON_LABEL);
    }

    public ErrorDialog(String message, Exception exception) {
        this(message, exception, DEFAULT_CLOSE_BUTTON_LABEL);
    }

    public ErrorDialog(String message, Exception exception, String closeButtonLabel) {
        this.mySpecificMessage = message;
        this.myException = exception;
        this.closeButtonLabel = closeButtonLabel;
        this.initialize();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.jDialog.pack();
            this.jDialog.setModal(true);
            this.jDialog.setVisible(true);
            this.jDialog.toFront();
        } else {
            this.jDialog.setVisible(false);
        }
    }

    private void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.frame = new JFrame();
        this.jDialog = new JDialog((Frame)this.frame, true);
        this.jDialog.setTitle("Error");
        this.jDialog.getContentPane().add((Component)this.getNorthP(), "North");
        this.jDialog.getContentPane().add((Component)this.getScrollPane(), "Center");
        this.jDialog.setResizable(true);
        this.jDialog.setLocation(this.frame.getLocation().x + 200, this.frame.getLocation().y + 200);
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getDetailsTextArea());
            this.scrollPane.setVisible(false);
        }
        return this.scrollPane;
    }

    private JTextArea getDetailsTextArea() {
        if (this.detailsTextArea == null) {
            this.detailsTextArea = new JTextArea();
            this.detailsTextArea.setName("detailsTextArea");
            this.detailsTextArea.setRows(10);
            this.detailsTextArea.setColumns(60);
            this.detailsTextArea.setLineWrap(false);
            this.detailsTextArea.setEditable(false);
            this.detailsTextArea.setBorder(loweredBorder);
            this.detailsTextArea.setBackground(this.messageP.getBackground());
            this.detailsTextArea.setMargin(new Insets(0, 2, 0, 5));
            if (this.myException != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(buffer, true);
                this.myException.printStackTrace(writer);
                String details = this.mySpecificMessage + "\n";
                details = details + buffer.toString();
                this.detailsTextArea.setText(details);
            }
        }
        return this.detailsTextArea;
    }

    private JPanel getNorthP() {
        if (this.northP == null) {
            this.northP = new JPanel();
            this.northP.setLayout(new BorderLayout());
            this.northP.add((Component)this.getIconP(), "West");
            this.northP.add((Component)this.getMessageP(), "Center");
            this.northP.add((Component)this.getButtonP(), "South");
        }
        return this.northP;
    }

    private JPanel getIconP() {
        if (this.iconP == null) {
            this.iconP = new JPanel();
            this.iconP.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            this.iconP.setLayout(new BorderLayout());
            this.iconP.add((Component)this.getErrorLabel(), "North");
        }
        return this.iconP;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        }
        return this.errorLabel;
    }

    private JPanel getMessageP() {
        if (this.messageP == null) {
            this.messageP = new JPanel();
            this.messageP.setLayout(new BorderLayout());
            this.messageP.add((Component)this.getNorthMessagePane(), "North");
        }
        return this.messageP;
    }

    private JPanel getNorthMessagePane() {
        if (this.northMessagePane == null) {
            this.northMessagePane = new JPanel();
            this.northMessagePane.setLayout(new BorderLayout());
            this.northMessagePane.add((Component)this.getCenterMessagePane(), "Center");
        }
        return this.northMessagePane;
    }

    private JPanel getCenterMessagePane() {
        if (this.centerMessagePane == null) {
            this.centerMessagePane = new JPanel();
            this.centerMessagePane.setLayout(new BorderLayout());
            this.centerMessagePane.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
            if (this.myMainMessage != null) {
                this.centerMessagePane.add((Component)this.getMessageTextArea(), "North");
            }
            this.centerMessagePane.add((Component)this.getSpecMessageTextArea(), "Center");
        }
        return this.centerMessagePane;
    }

    private JTextArea getMessageTextArea() {
        if (this.messageTextArea == null) {
            this.messageTextArea = new JTextArea(this.myMainMessage);
            this.messageTextArea.setName("messageTextArea");
            this.messageTextArea.setColumns(60);
            this.messageTextArea.setLineWrap(true);
            this.messageTextArea.setWrapStyleWord(true);
            this.messageTextArea.setEditable(false);
            this.messageTextArea.setOpaque(false);
            Font currentFont = this.messageTextArea.getFont();
            this.messageTextArea.setFont(new Font(currentFont.getName(), 1, currentFont.getSize()));
            this.messageTextArea.setForeground(Color.black);
            this.messageTextArea.setMargin(new Insets(0, 2, 0, 5));
            this.messageTextArea.setSize(this.messageTextArea.getPreferredSize());
            this.messageTextArea.validate();
        }
        return this.messageTextArea;
    }

    private JPanel getButtonP() {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP = new JPanel(new FlowLayout(2));
            if (this.myException != null) {
                this.buttonP.add((Component)this.getDetailsB(), null);
            }
            this.buttonP.add((Component)this.getCloseBtn(this.closeButtonLabel), null);
        }
        return this.buttonP;
    }

    private JButton getDetailsB() {
        if (this.detailsB == null) {
            this.detailsB = new JButton(this.moreStr);
            this.detailsB.setName("detailsB");
            this.detailsB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ErrorDialog.this.detailsB.getText().equals(ErrorDialog.this.moreStr)) {
                        ErrorDialog.this.scrollPane.setPreferredSize(null);
                        ErrorDialog.this.scrollPane.setVisible(true);
                        ErrorDialog.this.detailsB.setText(ErrorDialog.this.lessStr);
                        ErrorDialog.this.jDialog.pack();
                    } else {
                        ErrorDialog.this.scrollPane.setPreferredSize(new Dimension(0, 0));
                        ErrorDialog.this.scrollPane.setVisible(false);
                        ErrorDialog.this.detailsB.setText(ErrorDialog.this.moreStr);
                        ErrorDialog.this.jDialog.pack();
                    }
                }
            });
        }
        return this.detailsB;
    }

    private JButton getCloseBtn(String label) {
        if (this.closeBtn == null) {
            this.closeBtn = new JButton(label);
            this.closeBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.jDialog.dispose();
                }
            });
        }
        return this.closeBtn;
    }

    private JTextArea getSpecMessageTextArea() {
        if (this.specMessageTextArea == null) {
            this.specMessageTextArea = new JTextArea();
            this.specMessageTextArea.setName("specMessageTextArea");
            StringBuffer specific = new StringBuffer("");
            if (this.mySpecificMessage != null) {
                specific.append(this.mySpecificMessage);
                specific.append("\n");
            }
            this.specMessageTextArea.setText(specific.toString());
            this.specMessageTextArea.setColumns(60);
            this.specMessageTextArea.setLineWrap(true);
            this.specMessageTextArea.setWrapStyleWord(true);
            this.specMessageTextArea.setEditable(false);
            this.specMessageTextArea.setOpaque(false);
            this.specMessageTextArea.setMargin(new Insets(0, 2, 0, 5));
            this.specMessageTextArea.setSize(this.specMessageTextArea.getPreferredSize());
            this.specMessageTextArea.validate();
        }
        return this.specMessageTextArea;
    }
}

