/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.security.launcher.ApplicationCacheInterface;
import se.ericsson.security.launcher.ApplicationConfiguration;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

class SecurityConfiguration
implements ApplicationCacheInterface {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private URL NEAddress;
    private Collection files;
    private Collection commonFiles;
    private Collection referredFiles = null;

    public SecurityConfiguration(ApplicationCacheInterface configuration, PropertyManager pm) {
        int i;
        this.NEAddress = configuration.getNEAddress();
        this.files = new ArrayList();
        this.commonFiles = new ArrayList();
        Iterator<ApplicationFileInterface> it = configuration.getApplicationFiles().iterator();
        String ssuCxc = pm.getString("se.ericsson.security.launcher.ssu_cxc", false);
        if (ssuCxc == null) {
            ssuCxc = "CXC1721554";
        }
        String[] securityFiles = new String[]{ssuCxc};
        List<String> securityFileList = Arrays.asList(securityFiles);
        while (it.hasNext()) {
            ApplicationFileInterface af = it.next();
            if (!securityFileList.contains(af.getProductNumber())) continue;
            this.files.add(af);
        }
        if (this.files.size() == 0) {
            LOG.fine("No security files are specified in application configuration file", new Object[0]);
        }
        Collection<ApplicationFileInterface> tempCommonFiles = null;
        Class<?>[] interf = configuration.getClass().getInterfaces();
        for (i = 0; i < interf.length; ++i) {
            if (interf[i].getName().indexOf("ApplicationCacheInterface") == -1) continue;
            try {
                interf[i].getMethod("getCommonApplicationFiles", null);
                tempCommonFiles = configuration.getCommonApplicationFiles();
                break;
            }
            catch (NoSuchMethodException nsme) {
                if (!(configuration instanceof ApplicationConfiguration)) continue;
                try {
                    configuration.getClass().getMethod("getCommonApplicationFiles", null);
                    tempCommonFiles = ((ApplicationConfiguration)configuration).getCommonApplicationFiles();
                    break;
                }
                catch (NoSuchMethodException nsme1) {
                    System.out.println("This should not happen! The class should have conmtained the method!!!");
                }
            }
        }
        if (tempCommonFiles != null) {
            for (ApplicationFileInterface af : tempCommonFiles) {
                if (!securityFileList.contains(af.getProductNumber())) continue;
                this.commonFiles.add(af);
            }
            if (this.commonFiles.size() == 0) {
                LOG.fine("No files are specified in application configuration file as common files", new Object[0]);
            }
        }
        interf = configuration.getClass().getInterfaces();
        for (i = 0; i < interf.length; ++i) {
            if (interf[i].getName().indexOf("ApplicationCacheInterface") == -1) continue;
            try {
                interf[i].getMethod("getConfigurationFiles", null);
                this.referredFiles = configuration.getConfigurationFiles();
                break;
            }
            catch (NoSuchMethodException nsme) {
                if (!(configuration instanceof ApplicationConfiguration)) continue;
                try {
                    configuration.getClass().getMethod("getConfigurationFiles", null);
                    this.referredFiles = ((ApplicationConfiguration)configuration).getConfigurationFiles();
                    break;
                }
                catch (NoSuchMethodException nsme1) {
                    // empty catch block
                }
            }
        }
    }

    public URL getNEAddress() {
        return this.NEAddress;
    }

    public URL[] getSoftwareServers() {
        return null;
    }

    public Collection getApplicationFiles() {
        return this.files;
    }

    public Collection getCommonApplicationFiles() {
        return this.commonFiles;
    }

    public Collection getConfigurationFiles() {
        return this.referredFiles;
    }
}

