/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.cache.Cache;
import se.ericsson.security.launcher.util.LauncherTool;
import se.ericsson.security.launcher.util.SecurityLogTool;
import se.ericsson.security.utils.EmLogger;

class TrustedCertificateManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private X509Certificate[] trustedCerts;
    private char[] storepass = new char[]{'w', 'r', 'e', 'd', 'h', 's'};
    private static final String KEYSTORE_LABEL = "keystore";
    private static final String SSW_LABEL = "SSW";
    private static final String[] rootCertificateAlias = new String[]{"root", "sswa_root", "sswb_root", "sswc_root", "sswd_root"};

    TrustedCertificateManager() {
    }

    X509Certificate[] getTrustedcerts() throws LauncherException {
        LOG.finest("Trying to get the certificate from emas key store ", new Object[0]);
        Certificate[] keystoreRootCerts = this.getCertificateFromKeyStore();
        LOG.finest("Got trusted certificates: " + keystoreRootCerts.toString() + " from emas key store.\n", new Object[0]);
        CodeSource thisCodeSource = this.getClass().getProtectionDomain().getCodeSource();
        LOG.finest("Trying to get self-signed certificates", new Object[0]);
        Certificate[] certificatesByLauncher = thisCodeSource.getCertificates();
        if (certificatesByLauncher == null) {
            LOG.finest("No SSW certificates found.\n", new Object[0]);
            this.trustedCerts = new X509Certificate[rootCertificateAlias.length];
        } else {
            LOG.finest("Got trusted certificates: " + certificatesByLauncher.toString() + " from SSW.\n", new Object[0]);
            this.trustedCerts = new X509Certificate[certificatesByLauncher.length + rootCertificateAlias.length];
        }
        this.loadTrustedCertsFromKeyStore(keystoreRootCerts);
        if (certificatesByLauncher != null) {
            this.loadTrustedCertsByLauncher(certificatesByLauncher);
        }
        return this.trustedCerts;
    }

    private void loadTrustedCertsFromKeyStore(Certificate[] certificates) {
        for (int i = 0; i < certificates.length; ++i) {
            if (certificates[i] instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificates[i];
                try {
                    x509Cert.checkValidity();
                    LOG.fine("Added keystore trusted certificate with SubjectDN: " + x509Cert.getSubjectDN() + "\n", new Object[0]);
                }
                catch (CertificateException ce) {
                    LOG.warning("The certificate form emas.keystore file has expired, Certificate with SubjectDN = " + x509Cert.getSubjectDN(), new Object[0]);
                }
                this.trustedCerts[i] = x509Cert;
                continue;
            }
            LOG.severe("Trusted Certificate from keystore is not X509. Type= " + certificates[i].getType(), new Object[0]);
        }
    }

    private void loadTrustedCertsByLauncher(Certificate[] certificates) {
        ArrayList<X509Certificate> expiredCerts = new ArrayList<X509Certificate>();
        for (int i = 0; i < certificates.length; ++i) {
            if (certificates[i] instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificates[i];
                try {
                    x509Cert.checkValidity();
                    LOG.fine("Added SSW trusted certificate with SubjectDN: " + x509Cert.getSubjectDN() + "\n", new Object[0]);
                }
                catch (CertificateException ce) {
                    LOG.severe("The certificate of launcher.jar has expired, please update launcher.jar or reinstall EM.", new Object[0]);
                    LOG.severe("Certificate with SubjectDN = " + x509Cert.getSubjectDN() + " is not valid, " + ce, new Object[0]);
                    expiredCerts.add(x509Cert);
                }
                this.trustedCerts[i + TrustedCertificateManager.rootCertificateAlias.length] = x509Cert;
                continue;
            }
            LOG.severe("Trusted Certificate from launcher is not X509. Type= " + certificates[i].getType(), new Object[0]);
        }
        String jarFileWithPath = LauncherTool.getCurrentLauncherPath();
        LOG.fine("isUseClientLauncher : " + SecurityLogTool.isUseClientLauncher, new Object[0]);
        String launcherType = SecurityLogTool.getLauncherTypeInTrustedCertificate();
        LOG.fine("launchType : " + launcherType, new Object[0]);
        File launcherFile = new File(jarFileWithPath);
        if (expiredCerts.size() > 0) {
            SecurityLogTool.writeEMSecurityLog(jarFileWithPath, expiredCerts, "LOCAL", launcherType, launcherFile.getName());
        }
        SecurityLogTool.putDataIntoList(launcherFile.getName(), "LOCAL", launcherType);
    }

    private Certificate[] getCertificateFromKeyStore() {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("JKS");
            LOG.finest("Get keystore instance " + ks.toString(), new Object[0]);
            InputStream is = Cache.class.getResourceAsStream("emas.keystore");
            ks.load(is, this.storepass);
        }
        catch (KeyStoreException e) {
            LOG.severe("Get JKS keystore instance exception", new Object[0]);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.severe("Keystore load algorithm exception", new Object[0]);
        }
        catch (CertificateException e) {
            LOG.severe("Keystore load certificate exception", new Object[0]);
        }
        catch (IOException e) {
            LOG.severe("Keystore load IO exception", new Object[0]);
        }
        Certificate[] certificates = new Certificate[rootCertificateAlias.length];
        if (null != ks) {
            for (int i = 0; i < rootCertificateAlias.length; ++i) {
                try {
                    certificates[i] = ks.getCertificate(rootCertificateAlias[i]);
                    continue;
                }
                catch (KeyStoreException e) {
                    LOG.severe("Get root certificate exception", new Object[0]);
                }
            }
        }
        return certificates;
    }
}

