/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.download;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.net.ssl.SSLHandshakeException;
import se.ericsson.security.launcher.download.DownloadException;
import se.ericsson.security.launcher.download.DownloadFeedbackListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.download.FileNotFoundException;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.utils.EmLogger;

public class DownloadManager {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private int SOCKET_TIMEOUT;
    private int MAX_RETRY_COUNT = 3;

    public DownloadManager() {
        PropertyManager properties = PropertyManager.getInstance(this.getClass().getClassLoader());
        this.SOCKET_TIMEOUT = properties.getInt("se.ericsson.security.launcher.connecttimeout", true, 20000);
    }

    public void downloadToFile(URL remoteFile, File localFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        DownloadRelativeParam param = new DownloadRelativeParam(0, false);
        this.downloadToFileExtact(remoteFile, localFile, listener, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void downloadToFileExtact(URL remoteFile, File localFile, DownloadListener listener, DownloadRelativeParam param) throws DownloadException, SocketTimeoutException, IOException {
        DownloadManager.LOG.fine("downloadToFile retry param : " + param + ", localfile size : " + localFile.length(), new Object[0]);
        in = null;
        fos = null;
        willDoReadOperation = true;
        fileChannel = null;
        urlConnection = null;
        lastModified = -1L;
        port = -1;
        failed = false;
        remoteFileName = remoteFile.toExternalForm();
        path = remoteFile.getPath();
        inRbs = null;
        count = param.retryCount;
        try {
            block89: {
                block87: {
                    block86: {
                        block85: {
                            try {
                                ret = this.doConnect(remoteFile, listener);
                                urlConnection = ret.urlConnection;
                                lastModified = ret.lastModified;
                                in = urlConnection.getInputStream();
                                totalLength = urlConnection.getContentLength();
                                fos = new FileOutputStream(localFile);
                                inRbs = Channels.newChannel(in);
                                bb = ByteBuffer.allocate(32768);
                                fileChannel = fos.getChannel();
                                progress = 0;
                                read = 0;
                                while ((read = inRbs.read(bb)) >= 0) {
                                    bb.flip();
                                    willDoReadOperation = false;
                                    fileChannel.write(bb);
                                    bb.clear();
                                    willDoReadOperation = true;
                                    listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                                }
                                willDoReadOperation = false;
                            }
                            catch (IOException e) {
                                block94: {
                                    block101: {
                                        block93: {
                                            block92: {
                                                block91: {
                                                    failed = true;
                                                    param.isFailedFinal = true;
                                                    message = willDoReadOperation == false ? "Failed to write data to " + localFile.getAbsolutePath() + " during download from " + remoteFileName : "Failed reading data from " + remoteFileName + " during download to " + localFile.getAbsolutePath();
                                                    DownloadManager.LOG.severe(message + ", e : " + e, new Object[0]);
                                                    DownloadManager.LOG.severe(e.getStackTrace() + ",", e);
                                                    if (listener instanceof DownloadFeedbackListener) {
                                                        ((DownloadFeedbackListener)listener).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                                    } else {
                                                        listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                                                    }
                                                    if (e instanceof SocketTimeoutException == false) throw new DownloadException(message, (Throwable)e);
                                                    if (param.retryCount >= this.MAX_RETRY_COUNT) {
                                                        DownloadManager.LOG.severe("It already has retried the max times.", new Object[0]);
                                                        throw new DownloadException(message, (Throwable)e);
                                                    }
                                                    ++param.retryCount;
                                                    this.downloadToFileExtact(remoteFile, localFile, listener, param);
                                                    var24_25 = null;
                                                    DownloadManager.LOG.fine("in final code, current cnt : " + count + ", current failed : " + failed + ", fos : " + fos, new Object[0]);
                                                    if (!failed) {
                                                        if (listener instanceof DownloadFeedbackListener) {
                                                            ((DownloadFeedbackListener)listener).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                                        } else {
                                                            listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                                        }
                                                        param.isFailedFinal = false;
                                                    }
                                                    if (fileChannel != null) {
                                                        try {}
                                                        catch (Throwable var26_40) {
                                                            var27_32 = null;
                                                            in = null;
                                                            throw var26_40;
                                                        }
                                                        try {}
                                                        catch (IOException ioe) {
                                                            DownloadManager.LOG.warning("Failed to close fileChannel.", new Object[0]);
                                                            var27_31 = null;
                                                            in = null;
                                                            break block91;
                                                        }
                                                        fileChannel.close();
                                                        var27_30 = null;
                                                        in = null;
                                                    }
                                                }
                                                if (inRbs != null) {
                                                    try {}
                                                    catch (Throwable var28_52) {
                                                        var29_47 = null;
                                                        in = null;
                                                        throw var28_52;
                                                    }
                                                    try {}
                                                    catch (IOException ioe) {
                                                        DownloadManager.LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                                        var29_46 = null;
                                                        in = null;
                                                        break block92;
                                                    }
                                                    inRbs.close();
                                                    var29_45 = null;
                                                    in = null;
                                                }
                                            }
                                            if (in != null) {
                                                try {}
                                                catch (Throwable var30_64) {
                                                    var31_59 = null;
                                                    in = null;
                                                    throw var30_64;
                                                }
                                                try {}
                                                catch (IOException ioe) {
                                                    DownloadManager.LOG.warning("Failed to close inputstream.", new Object[0]);
                                                    var31_58 = null;
                                                    in = null;
                                                    break block93;
                                                }
                                                in.close();
                                                var31_57 = null;
                                                in = null;
                                            }
                                        }
                                        if (fos == null) break block94;
                                        try {}
                                        catch (Throwable var32_94) {
                                            block99: {
                                                var33_71 = null;
                                                ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl130:
                                                // 1 sources

                                                if (param.isFailedFinal && localFile.exists()) {
                                                    DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                                    deleteOk = localFile.delete();
                                                    if (!deleteOk) {
                                                        DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                    }
                                                }
                                                break block99;
lbl137:
                                                // 1 sources

                                                catch (SecurityException e) {
                                                    DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                }
                                            }
                                            fos = null;
                                            throw var32_94;
                                        }
                                        try {}
                                        catch (IOException ioe) {
                                            block100: {
                                                DownloadManager.LOG.warning("Failed to close outputstream.", new Object[0]);
                                                var33_70 = null;
                                                ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl148:
                                                // 1 sources

                                                if (param.isFailedFinal && localFile.exists()) {
                                                    DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                                    deleteOk = localFile.delete();
                                                    if (!deleteOk) {
                                                        DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                    }
                                                }
                                                break block100;
lbl155:
                                                // 1 sources

                                                catch (SecurityException e) {
                                                    DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                                }
                                            }
                                            fos = null;
                                            break block94;
                                        }
                                        fos.close();
                                        var33_69 = null;
                                        ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl164:
                                        // 1 sources

                                        if (param.isFailedFinal && localFile.exists()) {
                                            DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                            deleteOk = localFile.delete();
                                            if (!deleteOk) {
                                                DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                            }
                                        }
                                        break block101;
lbl171:
                                        // 1 sources

                                        catch (SecurityException e) {
                                            DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                        }
                                    }
                                    fos = null;
                                }
                                DownloadManager.LOG.fine("in final code, localfile size : " + localFile.length() + " when downloadToFile, isFailedFinal : " + param.isFailedFinal, new Object[0]);
                                return;
                            }
                            var24_24 = null;
                            DownloadManager.LOG.fine("in final code, current cnt : " + count + ", current failed : " + failed + ", fos : " + fos, new Object[0]);
                            if (!failed) {
                                if (listener instanceof DownloadFeedbackListener) {
                                    ((DownloadFeedbackListener)listener).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                } else {
                                    listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                }
                                param.isFailedFinal = false;
                            }
                            if (fileChannel != null) {
                                try {
                                    try {
                                        fileChannel.close();
                                    }
                                    catch (IOException ioe) {
                                        DownloadManager.LOG.warning("Failed to close fileChannel.", new Object[0]);
                                        var27_28 = null;
                                        in = null;
                                        break block85;
                                    }
                                    var27_27 = null;
                                    in = null;
                                }
                                catch (Throwable var26_39) {
                                    var27_29 = null;
                                    in = null;
                                    throw var26_39;
                                }
                            }
                        }
                        if (inRbs != null) {
                            try {
                                try {
                                    inRbs.close();
                                }
                                catch (IOException ioe) {
                                    DownloadManager.LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                    var29_43 = null;
                                    in = null;
                                    break block86;
                                }
                                var29_42 = null;
                                in = null;
                            }
                            catch (Throwable var28_51) {
                                var29_44 = null;
                                in = null;
                                throw var28_51;
                            }
                        }
                    }
                    if (in != null) {
                        try {
                            try {
                                in.close();
                            }
                            catch (IOException ioe) {
                                DownloadManager.LOG.warning("Failed to close inputstream.", new Object[0]);
                                var31_55 = null;
                                in = null;
                                break block87;
                            }
                            var31_54 = null;
                            in = null;
                        }
                        catch (Throwable var30_63) {
                            var31_56 = null;
                            in = null;
                            throw var30_63;
                        }
                    }
                }
                if (fos == null) break block89;
                try {
                    block88: {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            block102: {
                                DownloadManager.LOG.warning("Failed to close outputstream.", new Object[0]);
                                var33_67 = null;
                                ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl257:
                                // 1 sources

                                if (param.isFailedFinal && localFile.exists()) {
                                    DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                    deleteOk = localFile.delete();
                                    if (!deleteOk) {
                                        DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                    }
                                }
                                break block102;
lbl264:
                                // 1 sources

                                catch (SecurityException e) {
                                    DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            fos = null;
                            break block89;
                        }
                        var33_66 = null;
                        try {
                            if (!param.isFailedFinal || !localFile.exists()) break block88;
                            DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                            deleteOk = localFile.delete();
                            if (!deleteOk) {
                                DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        catch (SecurityException e) {
                            DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    fos = null;
                }
                catch (Throwable var32_93) {
                    block103: {
                        var33_68 = null;
                        ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl287:
                        // 1 sources

                        if (param.isFailedFinal && localFile.exists()) {
                            DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                            deleteOk = localFile.delete();
                            if (!deleteOk) {
                                DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        break block103;
lbl294:
                        // 1 sources

                        catch (SecurityException e) {
                            DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    fos = null;
                    throw var32_93;
                }
            }
            DownloadManager.LOG.fine("in final code, localfile size : " + localFile.length() + " when downloadToFile, isFailedFinal : " + param.isFailedFinal, new Object[0]);
        }
        catch (Throwable var23_96) {
            block98: {
                block106: {
                    block97: {
                        block96: {
                            block95: {
                                var24_26 = null;
                                DownloadManager.LOG.fine("in final code, current cnt : " + count + ", current failed : " + failed + ", fos : " + fos, new Object[0]);
                                if (!failed) {
                                    if (listener instanceof DownloadFeedbackListener) {
                                        ((DownloadFeedbackListener)listener).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                                    } else {
                                        listener.finished(path.substring(path.lastIndexOf("/") + 1));
                                    }
                                    param.isFailedFinal = false;
                                }
                                if (fileChannel != null) {
                                    try {}
                                    catch (Throwable var26_41) {
                                        var27_35 = null;
                                        in = null;
                                        throw var26_41;
                                    }
                                    try {}
                                    catch (IOException ioe) {
                                        DownloadManager.LOG.warning("Failed to close fileChannel.", new Object[0]);
                                        var27_34 = null;
                                        in = null;
                                        break block95;
                                    }
                                    fileChannel.close();
                                    var27_33 = null;
                                    in = null;
                                }
                            }
                            if (inRbs != null) {
                                try {}
                                catch (Throwable var28_53) {
                                    var29_50 = null;
                                    in = null;
                                    throw var28_53;
                                }
                                try {}
                                catch (IOException ioe) {
                                    DownloadManager.LOG.warning("Failed to close ReadableByteChannel.", new Object[0]);
                                    var29_49 = null;
                                    in = null;
                                    break block96;
                                }
                                inRbs.close();
                                var29_48 = null;
                                in = null;
                            }
                        }
                        if (in != null) {
                            try {}
                            catch (Throwable var30_65) {
                                var31_62 = null;
                                in = null;
                                throw var30_65;
                            }
                            try {}
                            catch (IOException ioe) {
                                DownloadManager.LOG.warning("Failed to close inputstream.", new Object[0]);
                                var31_61 = null;
                                in = null;
                                break block97;
                            }
                            in.close();
                            var31_60 = null;
                            in = null;
                        }
                    }
                    if (fos == null) break block98;
                    try {}
                    catch (Throwable var32_95) {
                        block104: {
                            var33_74 = null;
                            ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl378:
                            // 1 sources

                            if (param.isFailedFinal && localFile.exists()) {
                                DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                deleteOk = localFile.delete();
                                if (!deleteOk) {
                                    DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            break block104;
lbl385:
                            // 1 sources

                            catch (SecurityException e) {
                                DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        fos = null;
                        throw var32_95;
                    }
                    try {}
                    catch (IOException ioe) {
                        block105: {
                            DownloadManager.LOG.warning("Failed to close outputstream.", new Object[0]);
                            var33_73 = null;
                            ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl396:
                            // 1 sources

                            if (param.isFailedFinal && localFile.exists()) {
                                DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                                deleteOk = localFile.delete();
                                if (!deleteOk) {
                                    DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                                }
                            }
                            break block105;
lbl403:
                            // 1 sources

                            catch (SecurityException e) {
                                DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                            }
                        }
                        fos = null;
                        break block98;
                    }
                    fos.close();
                    var33_72 = null;
                    ** try [egrp 10[TRYBLOCK] [20 : 944->1042)] { 
lbl412:
                    // 1 sources

                    if (param.isFailedFinal && localFile.exists()) {
                        DownloadManager.LOG.info("Will remove the incomplete file " + localFile.getAbsolutePath(), new Object[0]);
                        deleteOk = localFile.delete();
                        if (!deleteOk) {
                            DownloadManager.LOG.warning("Could not remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                        }
                    }
                    break block106;
lbl419:
                    // 1 sources

                    catch (SecurityException e) {
                        DownloadManager.LOG.warning("Failed to remove the incomplete file " + localFile.getAbsolutePath() + ". You should try to remove it manually.", new Object[0]);
                    }
                }
                fos = null;
            }
            DownloadManager.LOG.fine("in final code, localfile size : " + localFile.length() + " when downloadToFile, isFailedFinal : " + param.isFailedFinal, new Object[0]);
            throw var23_96;
        }
        if (lastModified <= 0L) return;
        if (localFile.isFile() == false) return;
        if (localFile.setLastModified(lastModified) != false) return;
        DownloadManager.LOG.warning("Failed to set last modified of " + localFile, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadToString(URL remoteFile, DownloadListener listener) throws DownloadException, SocketTimeoutException, IOException {
        String string;
        InputStream in;
        block19: {
            in = null;
            URLConnection urlConnection = null;
            boolean failed = false;
            String remoteFileName = remoteFile.toExternalForm();
            String path = remoteFile.toExternalForm();
            ReadableByteChannel inRbs = null;
            StringBuffer strBuffCont = null;
            try {
                try {
                    ConnectReturn ret = this.doConnect(remoteFile, listener);
                    urlConnection = ret.urlConnection;
                    in = urlConnection.getInputStream();
                    int totalLength = urlConnection.getContentLength();
                    ByteBuffer bb = ByteBuffer.allocate(4096);
                    Charset charset = Charset.forName("UTF-8");
                    CharsetDecoder decoder = charset.newDecoder();
                    CharBuffer charBuffer = null;
                    inRbs = Channels.newChannel(in);
                    strBuffCont = new StringBuffer();
                    int progress = 0;
                    int read = 0;
                    while ((read = inRbs.read(bb)) >= 0) {
                        bb.flip();
                        charBuffer = decoder.decode(bb);
                        strBuffCont.append(charBuffer.toString());
                        bb.clear();
                        listener.downloading(remoteFile.getFile(), progress += read, totalLength);
                    }
                    string = strBuffCont.toString();
                    Object var20_22 = null;
                    if (failed) break block19;
                }
                catch (IOException e) {
                    failed = true;
                    if (e instanceof SSLHandshakeException) {
                        throw (SSLHandshakeException)e;
                    }
                    String message = "Failed reading data from " + remoteFileName;
                    LOG.severe(message, new Object[0]);
                    if (!(listener instanceof DownloadFeedbackListener)) {
                        listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                        throw new DownloadException(message, (Throwable)e);
                    }
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                    throw new DownloadException(message, (Throwable)e);
                }
                catch (Exception e) {
                    failed = true;
                    throw new DownloadException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (!failed) {
                    if (listener instanceof DownloadFeedbackListener) {
                        ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
                    } else {
                        listener.finished(path.substring(path.lastIndexOf("/") + 1));
                    }
                }
                if (in == null) throw throwable;
                try {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        LOG.warning("Failed to close inputstream.", new Object[0]);
                        Object var23_28 = null;
                        in = null;
                        throw throwable;
                    }
                    Object var23_27 = null;
                    in = null;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var23_29 = null;
                    in = null;
                    throw throwable2;
                }
            }
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).finished(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (remoteFile.getPort() != -1 ? ":" + String.valueOf(remoteFile.getPort()) : ""));
            } else {
                listener.finished(path.substring(path.lastIndexOf("/") + 1));
            }
        }
        if (in == null) return string;
        try {}
        catch (Throwable throwable) {
            Object var23_26 = null;
            in = null;
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            LOG.warning("Failed to close inputstream.", new Object[0]);
            return string;
        }
        in.close();
        return string;
    }

    private ConnectReturn doConnect(URL remoteFile, DownloadListener listener) throws SocketTimeoutException, SSLHandshakeException, IOException, FileNotFoundException, DownloadException {
        LOG.fine("Opening connection to url: " + remoteFile.toExternalForm(), new Object[0]);
        URLConnection urlConnection = remoteFile.openConnection();
        ConnectReturn ret = new ConnectReturn(urlConnection, -1L);
        EmasUtilities.getInstance().enableNECertificateValidation(urlConnection);
        urlConnection.setConnectTimeout(this.SOCKET_TIMEOUT);
        urlConnection.setUseCaches(false);
        urlConnection.setReadTimeout(this.SOCKET_TIMEOUT);
        String path = remoteFile.getFile();
        int port = remoteFile.getPort();
        try {
            if (listener instanceof DownloadFeedbackListener) {
                ((DownloadFeedbackListener)((Object)listener)).connecting(remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""), path.substring(path.lastIndexOf("/") + 1));
            }
            LOG.fine("Doing urlConnection.connect()...timeout : " + urlConnection.getReadTimeout() + "ms.", new Object[0]);
            urlConnection.connect();
            LOG.fine("Done urlConnection.connect()", new Object[0]);
        }
        catch (SocketTimeoutException e) {
            throw this.createWrappedSocketTimeoutException(remoteFile, e);
        }
        catch (SSLHandshakeException e) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), e);
            if (e.getCause() instanceof EOFException) {
                this.retryConnect(urlConnection, e);
            }
            throw e;
        }
        catch (SocketException e) {
            this.retryConnect(urlConnection, e);
        }
        catch (IOException e) {
            throw this.createWrappedIOException(urlConnection, e);
        }
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            ret.lastModified = httpURLConnection.getLastModified();
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                if (listener instanceof DownloadFeedbackListener) {
                    ((DownloadFeedbackListener)((Object)listener)).downloadFailed(path.substring(path.lastIndexOf("/") + 1), remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : ""));
                } else {
                    listener.downloadFailed(path.substring(path.lastIndexOf("/") + 1));
                }
                LOG.fine("HTTP Code: " + responseCode, new Object[0]);
                if (responseCode == 404) {
                    throw new FileNotFoundException("File " + remoteFile.toExternalForm() + " not found on server");
                }
                throw new DownloadException("Failed to download " + remoteFile.toExternalForm() + ". HTTP Code: " + responseCode);
            }
        }
        return ret;
    }

    public InputStream downloadToInputStream(URL remoteFile) throws DownloadException {
        try {
            URLConnection connection = remoteFile.openConnection();
            EmasUtilities.getInstance().enableNECertificateValidation(connection);
            InputStream is = connection.getInputStream();
            return is;
        }
        catch (IOException e) {
            throw new DownloadException("Could not download: " + remoteFile.toExternalForm(), (Throwable)e);
        }
    }

    private SocketTimeoutException createWrappedSocketTimeoutException(URL remoteFile, SocketTimeoutException e) {
        LOG.warning("Could not connect (timeout) to: " + remoteFile.getHost(), new Object[0]);
        int port = remoteFile.getPort();
        SocketTimeoutException resentExc = new SocketTimeoutException("Could not connect (timeout) to node " + remoteFile.getHost() + (port != -1 ? ":" + String.valueOf(port) : "") + " to download " + remoteFile.getPath());
        resentExc.setStackTrace(e.getStackTrace());
        resentExc.initCause(e);
        return resentExc;
    }

    private void retryConnect(URLConnection urlConnection, IOException originalException) throws SocketTimeoutException, SocketException, IOException {
        try {
            urlConnection.connect();
        }
        catch (SocketTimeoutException ex) {
            throw this.createWrappedSocketTimeoutException(urlConnection.getURL(), ex);
        }
        catch (SSLHandshakeException ex) {
            LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), ex);
            throw originalException;
        }
        catch (IOException ex) {
            throw this.createWrappedIOException(urlConnection, originalException);
        }
    }

    private IOException createWrappedIOException(URLConnection urlConnection, Exception originalException) {
        LOG.warning("Failed to connect to: " + urlConnection.getURL().toExternalForm(), originalException);
        IOException resentExc = new IOException("Could not download " + urlConnection.getURL().toExternalForm());
        resentExc.setStackTrace(originalException.getStackTrace());
        resentExc.initCause(originalException);
        return resentExc;
    }

    private class DownloadRelativeParam {
        int retryCount;
        boolean isFailedFinal;

        private DownloadRelativeParam(int retryCount, boolean isFailedFinal) {
            this.retryCount = retryCount;
            this.isFailedFinal = isFailedFinal;
        }

        public String toString() {
            return "[retryCount : " + this.retryCount + ", isFailedFinal : " + this.isFailedFinal + "]";
        }
    }

    private class ConnectReturn {
        long lastModified;
        URLConnection urlConnection;

        private ConnectReturn(URLConnection urlConnection, long lastModified) {
            this.urlConnection = urlConnection;
            this.lastModified = lastModified;
        }
    }
}

