/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.download;

import se.ericsson.security.launcher.download.DownloadFeedbackListener;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.ui.SplashWindow;
import se.ericsson.security.launcher.util.Localizer;
import se.ericsson.security.utils.EmLogger;

public class SplashDownloadListener
implements DownloadListener,
DownloadFeedbackListener {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private SplashWindow window;

    public SplashDownloadListener(SplashWindow window) {
        this.window = window;
    }

    public void downloadFailed(String filename, String host) {
        String text = Localizer.getString("download") + " OF " + filename + " FROM " + host + " " + Localizer.getString("failed") + "\n";
        LOG.severe(text, new Object[0]);
    }

    public void downloading(String filename, int readSoFar, int totalSize) {
        String status = Localizer.getString("downloading");
        status = status.concat(" ").concat(filename);
        this.window.setProgress(status, readSoFar, totalSize);
    }

    public void finished(String filename, String host) {
        String text = Localizer.getString("download") + " OF " + filename + " FROM " + host + " " + Localizer.getString("completed");
        LOG.info(text, new Object[0]);
    }

    public void connecting(String host, String filename) {
        String status = Localizer.getString("connecting");
        status = status.concat(" to ").concat(host).concat(" to ").concat("download").concat(" ").concat(filename);
        this.window.setProgress(status, 0, -1);
    }

    public void downloadFailed(String filename) {
        this.downloadFailed(filename, "<?>");
    }

    public void finished(String filename) {
        this.finished(filename, "<?>");
    }

    public void updating(String filename, int a, int b) {
    }
}

