/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.testmode;

import java.io.File;
import java.net.URL;
import se.ericsson.security.launcher.testmode.TmProperty;
import se.ericsson.security.launcher.testmode.TmUtilities;
import se.ericsson.security.utils.EmLogger;

public class TmOverrideLib {
    private static final EmLogger LOGGER = EmLogger.STARTER;

    public static URL getOverrideUrl(URL url) {
        String overrideLib = TmProperty.OVERRIDE_LIB.getValue();
        if (overrideLib == null) {
            return null;
        }
        URL overrideURL = null;
        String baseName = null;
        try {
            baseName = TmOverrideLib.getBaseName(url);
            LOGGER.finest(TmUtilities.getLogMessage("Trying to find override for \"" + url.toString() + "\"" + "\n      " + "using name \"" + baseName + "\"" + "\n      " + "in \"" + overrideLib + "\"."), new Object[0]);
            File overrideFile = new File(overrideLib, baseName);
            if (overrideFile.isFile() && overrideFile.canRead()) {
                overrideURL = overrideFile.toURL();
                LOGGER.finest(TmUtilities.getLogMessage("Override found for \"" + baseName + "\"."), new Object[0]);
            } else {
                LOGGER.finest(TmUtilities.getLogMessage("Override NOT found for \"" + baseName + "\"."), new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.finest(TmUtilities.getLogMessage("Exception when trying to find override for \"" + url.toString() + "\"."), e);
        }
        return overrideURL;
    }

    public static File getOverrideFile(String file) {
        String overrideLib = TmProperty.OVERRIDE_LIB.getValue();
        if (overrideLib == null) {
            return null;
        }
        String baseName = String.valueOf(file);
        try {
            baseName = new File(file).getName();
            File overrideFile = new File(overrideLib, file);
            if (overrideFile.isFile() && overrideFile.canRead()) {
                LOGGER.warning("OVERRIDE found for " + baseName + "!", new Object[0]);
                return overrideFile;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Unexpected Exception while polling for file " + baseName + "in OVERRIDE_LIB:\n" + e, new Object[0]);
        }
        return null;
    }

    private static String getBaseName(URL url) {
        try {
            String path = url.getFile();
            int index = path.lastIndexOf(47);
            if (index >= 0) {
                path = path.substring(index + 1);
            }
            if ((index = path.lastIndexOf(92)) >= 0) {
                path = path.substring(index + 1);
            }
            if ((index = path.lastIndexOf(33)) >= 0) {
                path = path.substring(index + 1);
            }
            return path;
        }
        catch (Exception e) {
            LOGGER.warning("Failed to extract base name from URL " + url + ":\n" + e, new Object[0]);
            return "";
        }
    }
}

