/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.utils.EmLogger;

public class UrlUtilities {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private static String originProtocol = null;
    private static String originPort = null;

    public static URL getURL(String defaultProtocol, String address, String defaultPort, String path) {
        address = UrlUtilities.getCommonURL(defaultProtocol, address, defaultPort, path);
        return UrlUtilities.getURL(address);
    }

    public static String getCommonURL(String defaultProtocol, String address, String defaultPort, String path) {
        Pattern uri;
        Matcher m;
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        if (defaultProtocol != null && defaultProtocol.length() > 0 && !address.contains(PROTOCOL_SEPARATOR)) {
            address = defaultProtocol + PROTOCOL_SEPARATOR + address;
        }
        if (defaultPort != null && defaultPort.trim().length() > 0 && (m = (uri = Pattern.compile("^(([a-zA-Z\\.\\+]*)://)?([a-zA-Z0-9\\.\\+\\-\\[\\]:]+?)(:(\\d{1,5}))?")).matcher(address)).matches() && m.group(5) == null) {
            address = address + ":" + defaultPort;
        }
        if (path != null) {
            address = address + path;
        }
        return address;
    }

    private static URL getCommonURL(String address) {
        String[] hostPath;
        LOG.info("Address is: " + address, new Object[0]);
        originProtocol = null;
        originPort = null;
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        String delProtocolAddress = address;
        if (address.contains(PROTOCOL_SEPARATOR)) {
            originProtocol = address.split(PROTOCOL_SEPARATOR)[0];
            delProtocolAddress = address.replace(originProtocol + PROTOCOL_SEPARATOR, "");
        }
        String threadAddress = delProtocolAddress;
        if (delProtocolAddress.contains(":") && (hostPath = delProtocolAddress.split(":")).length == 2) {
            originPort = hostPath[1];
            int firstSlash = hostPath[1].indexOf("/");
            if (firstSlash != -1) {
                originPort = hostPath[1].substring(0, firstSlash);
            }
        }
        if (null != originPort) {
            threadAddress = threadAddress.replace(":" + originPort, "");
        }
        LOG.info("threadAddress changed to: " + threadAddress + ", originPort: " + originPort, new Object[0]);
        URL url = UrlUtilities.getUrlWithHttpOrHttps(threadAddress);
        if (null == url) {
            LOG.fine("Returning URL null for address " + address, new Object[0]);
            return null;
        }
        return url;
    }

    public static URL checkAndGetURL(String address) {
        URL url = UrlUtilities.getCommonURL(address);
        if (null == url) {
            return null;
        }
        if (originProtocol != null && !originProtocol.equals(url.getProtocol())) {
            String msg = "The protocol supported by node is " + url.getProtocol() + ". The hostname used the wrong protocol. hostname is: " + address;
            ErrorDialog errorDialog = new ErrorDialog(msg);
            errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            return null;
        }
        if (originPort != null && !originPort.equals(String.valueOf(url.getDefaultPort()))) {
            String msg = "The protocol supported by node is " + url.getProtocol() + ". The hostname used the wrong port. hostname is: " + address;
            ErrorDialog errorDialog = new ErrorDialog(msg);
            errorDialog.setVisible(!Boolean.getBoolean("launchertest.silent"));
            return null;
        }
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getPath());
        }
        catch (MalformedURLException e) {
            LOG.warning("Failed creating new URL with default port for " + url, e);
            return null;
        }
        LOG.fine("Returning URL " + url + " for address " + address, new Object[0]);
        return url;
    }

    public static URL getURL(String address) {
        URL url = UrlUtilities.getCommonURL(address);
        if (null == url) {
            return null;
        }
        try {
            url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getPath());
        }
        catch (MalformedURLException e) {
            LOG.warning("Failed creating new URL with default port for " + url, e);
            return null;
        }
        LOG.fine("Returning URL " + url + " for address " + address, new Object[0]);
        return url;
    }

    public static URL getURLForTest(String address) {
        URL url = null;
        try {
            url = new URL(address);
            if (url != null && url.getPort() == -1) {
                url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getPath());
            }
        }
        catch (MalformedURLException e) {
            LOG.warning("Failed creating new URL with default port for " + url, e);
            return null;
        }
        return url;
    }

    public static URL getURLForTest(String defaultProtocol, String address, String defaultPort, String path) {
        address = UrlUtilities.getCommonURL(defaultProtocol, address, defaultPort, path);
        return UrlUtilities.getURLForTest(address);
    }

    private static URL getUrlWithHttpOrHttps(String address) {
        LinkedBlockingQueue<ConnectionResult> resultQueue = new LinkedBlockingQueue<ConnectionResult>();
        URL httpUrl = null;
        URL httpsUrl = null;
        ConnectionAttempt httpThread = null;
        ConnectionAttempt httpsThread = null;
        ExecutorService exec = null;
        try {
            exec = Executors.newCachedThreadPool();
            httpUrl = new URL("http://" + address);
            httpsUrl = new URL("https://" + address);
            httpThread = new ConnectionAttempt(httpUrl, resultQueue);
            httpsThread = new ConnectionAttempt(httpsUrl, resultQueue);
            exec.execute(httpThread);
            exec.execute(httpsThread);
        }
        catch (MalformedURLException e) {
            LOG.fine(address + " is not a valid URL", e);
            return null;
        }
        try {
            ConnectionResult connectionResult = (ConnectionResult)resultQueue.take();
            if (!connectionResult.success) {
                connectionResult = (ConnectionResult)resultQueue.take();
            }
            httpThread.suppressTimeoutResult();
            httpsThread.suppressTimeoutResult();
            exec.shutdown();
            if (connectionResult.success) {
                LOG.fine("Successful response from " + connectionResult.url, new Object[0]);
                return connectionResult.url;
            }
            LOG.fine("Invalid responses from " + httpUrl + " and " + httpsUrl, new Object[0]);
            return null;
        }
        catch (InterruptedException e) {
            LOG.severe("Interrupted while waiting for ConnectionResult", e);
            return null;
        }
    }

    private static class ConnectionResult {
        private final URL url;
        private final boolean success;

        public ConnectionResult(URL url, boolean success) {
            this.url = url;
            this.success = success;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionAttempt
    implements Runnable {
        private final URL url;
        private final BlockingQueue<ConnectionResult> queue;
        private boolean suppressTimeoutResult = false;

        public ConnectionAttempt(URL url, BlockingQueue<ConnectionResult> queue) {
            this.url = url;
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean success;
            block9: {
                String thread = "Thread " + Thread.currentThread().getName() + " - ";
                LOG.fine(thread + "Trying to connect to " + this.url, new Object[0]);
                success = false;
                URLConnection connection = null;
                try {
                    try {
                        connection = this.url.openConnection();
                        int responseCode = -1;
                        if (this.url.getProtocol().equals(UrlUtilities.HTTPS)) {
                            EmasUtilities.getInstance().enableNECertificateValidation(connection);
                            responseCode = ((HttpsURLConnection)connection).getResponseCode();
                        } else {
                            responseCode = ((HttpURLConnection)connection).getResponseCode();
                        }
                        success = responseCode != -1;
                        LOG.fine(thread + "Got response code " + responseCode + " from " + this.url, new Object[0]);
                    }
                    catch (SSLHandshakeException e) {
                        success = true;
                        LOG.fine(thread + "Got response on " + this.url + " but with SSLHandshakeException", e);
                        Object var6_9 = null;
                        EmasUtilities.disconnect(connection);
                        break block9;
                    }
                    catch (IOException e) {
                        if (this.suppressTimeoutResult) {
                            Object var6_10 = null;
                            EmasUtilities.disconnect(connection);
                            return;
                        }
                        LOG.fine(thread + "Connection to " + this.url + " failed because of IOException.", e);
                        Object var6_11 = null;
                        EmasUtilities.disconnect(connection);
                        break block9;
                    }
                    catch (RuntimeException e) {
                        LOG.fine(thread + "Connection to " + this.url + " failed because of RuntimeException", e);
                        Object var6_12 = null;
                        EmasUtilities.disconnect(connection);
                        break block9;
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_13 = null;
                    EmasUtilities.disconnect(connection);
                    throw throwable;
                }
                EmasUtilities.disconnect(connection);
            }
            this.queue.add(new ConnectionResult(this.url, success));
        }

        public void suppressTimeoutResult() {
            this.suppressTimeoutResult = true;
        }
    }
}

