/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter.investigator.resource;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.security.launcher.ErrorDialog;
import se.ericsson.security.starter.investigator.resource.Resource;
import se.ericsson.security.starter.investigator.resource.ResourceInfo;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInfoFactory {
    private static final EmLogger LOGGER = EmLogger.STARTER;
    private static final String RESOURCE_TYPE_START = "Resource resourceType";
    private static final String RESOURCE_NAME = "ResourceName";
    private static final String RESOURCE_PATH = "ResourcePath";
    private static final String RESOURCE_REF_SEE = "ResourceRefSee";
    private static final String RESOURCE_TYPE_END = "/Resource";
    private static final String RESOURCE_REF_START = "ResourceRef resourceFile";
    private static final String DIRECTORY_PATH = "DirectoryPath";
    private static final String PRODUCT_NUMBER = "ProductNumber";
    private static final String PRODUCT_REVISION = "ProductRevision";
    private static final String DIRECTORY_FILE = "DirectoryFile";
    private static final String RESOURCE_REF_END = "/ResourceRef";
    private static final String DOCTYPE = "!DOCTYPE";
    private static String ERROR_INFO = "Illegal DOCTYPE tag is detected. Can't parse configuration file emapplications.xml";

    public static ArrayList<ResourceInfo> constructResourceInfos(String fileContents) {
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        StringTokenizer tok = new StringTokenizer(fileContents, "<>");
        boolean pickResource = false;
        boolean pickDirectoryPath = false;
        boolean pickProductNumber = false;
        boolean pickProductRevision = false;
        boolean pickDirectoryFile = false;
        boolean hasError = false;
        ResourceInfo currentResourceInfo = null;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.startsWith(DOCTYPE)) {
                hasError = true;
                break;
            }
            if (str.startsWith(RESOURCE_REF_START)) {
                String filename = str.substring(RESOURCE_REF_START.length()).replace('\"', ' ');
                filename = filename.replace('=', ' ');
                filename = filename.trim();
                currentResourceInfo = new ResourceInfo(filename);
                pickResource = true;
                continue;
            }
            if (pickResource && str.equalsIgnoreCase(DIRECTORY_PATH)) {
                pickDirectoryPath = true;
                continue;
            }
            if (pickResource && str.equalsIgnoreCase(PRODUCT_NUMBER)) {
                pickProductNumber = true;
                continue;
            }
            if (pickResource && str.equalsIgnoreCase(PRODUCT_REVISION)) {
                pickProductRevision = true;
                continue;
            }
            if (pickResource && str.equalsIgnoreCase(DIRECTORY_FILE)) {
                pickDirectoryFile = true;
                continue;
            }
            if (pickDirectoryPath) {
                currentResourceInfo.setDirectoryPath(str);
                pickDirectoryPath = false;
                continue;
            }
            if (pickProductNumber) {
                currentResourceInfo.setProductNumber(str);
                pickProductNumber = false;
                continue;
            }
            if (pickProductRevision) {
                currentResourceInfo.setProductRevision(str);
                pickProductRevision = false;
                continue;
            }
            if (pickDirectoryFile) {
                currentResourceInfo.setDirectoryFile(str);
                pickDirectoryFile = false;
                continue;
            }
            if (!str.equalsIgnoreCase(RESOURCE_REF_END)) continue;
            pickResource = false;
            if (null == currentResourceInfo) continue;
            resourceInfos.add(currentResourceInfo);
            currentResourceInfo = null;
        }
        if (hasError) {
            resourceInfos = new ArrayList();
            ErrorDialog dialog = new ErrorDialog(ERROR_INFO);
            dialog.setVisible(true);
            System.exit(1);
        }
        LOGGER.info("No error info.", new Object[0]);
        for (ResourceInfo resource : resourceInfos) {
            LOGGER.finer("resource: " + resource, new Object[0]);
        }
        return resourceInfos;
    }

    private static ArrayList<Resource> constructResources(String fileContents) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        boolean setName = false;
        boolean setPath = false;
        boolean setRef = false;
        StringTokenizer tok = new StringTokenizer(fileContents, "<>");
        Resource currentResource = null;
        boolean setResourceInfo = false;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.startsWith(RESOURCE_TYPE_START)) {
                String type = str.substring(RESOURCE_TYPE_START.length()).replace('\"', ' ');
                type = type.replace('=', ' ').trim();
                currentResource = new Resource(type);
                setResourceInfo = true;
                continue;
            }
            if (setResourceInfo && str.equalsIgnoreCase(RESOURCE_NAME)) {
                setName = true;
                continue;
            }
            if (setResourceInfo && str.equalsIgnoreCase(RESOURCE_PATH)) {
                setPath = true;
                continue;
            }
            if (setResourceInfo && str.equalsIgnoreCase(RESOURCE_REF_SEE)) {
                setRef = true;
                continue;
            }
            if (setName) {
                currentResource.setResourceName(str);
                setName = false;
                continue;
            }
            if (setPath) {
                currentResource.setResourcePath(str);
                setPath = false;
                continue;
            }
            if (setRef) {
                currentResource.setResourceRef(new ResourceInfo(str));
                setRef = false;
                continue;
            }
            if (!str.equalsIgnoreCase(RESOURCE_TYPE_END)) continue;
            setResourceInfo = false;
            if (currentResource == null) continue;
            resources.add(currentResource);
            currentResource = null;
        }
        return resources;
    }

    public static ArrayList<Resource> parseResources(String fileContents) {
        ArrayList<Resource> resources = ResourceInfoFactory.constructResources(fileContents);
        ArrayList<ResourceInfo> resourceInfoList = ResourceInfoFactory.constructResourceInfos(fileContents);
        for (Resource resource : resources) {
            for (ResourceInfo resourceRef : resourceInfoList) {
                if (!resource.getResourceRef().getResourceFileName().equals(resourceRef.getResourceFileName())) continue;
                resource.getResourceRef().setDirectoryPath(resourceRef.getDirectoryPath());
                resource.getResourceRef().setDirectoryFile(resourceRef.getDirectoryFile());
                resource.getResourceRef().setProductNumber(resourceRef.getProductNumber());
                resource.getResourceRef().setProductRevision(resourceRef.getProductRevision());
            }
        }
        return resources;
    }
}

