/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing;

import enea.ose.system.UnlinkedSignal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorMgr;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.faultmanagement.Event;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.licensing.LicensingMo;
import se.ericsson.cello.licensing.fropxy.Notifiable;
import se.ericsson.cello.licensing.fropxy.OsaLic6FileListCfm;
import se.ericsson.cello.licensing.fropxy.OsaLic7EmergencyStateViewCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicEmergencyStateCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicEmergencyStateChdInd;
import se.ericsson.cello.licensing.fropxy.OsaLicFileUpdateCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicFingerPrintCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicIntegrationUnlockStateCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicIntegrationUnlockStateChdInd;
import se.ericsson.cello.licensing.fropxy.OsaLicIntegrationUnlockStateViewCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicLkfInstallationTimeCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicMgmntProxy;
import se.ericsson.cello.licensing.fropxy.OsaLicSequenceNumberCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicSetFingerPrintCfm;
import se.ericsson.cello.licensing.fropxy.OsaLicSwltCfm;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.SetNotAllowedException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.productinventory.LicenseCapacityData;
import se.ericsson.cello.productinventory.LicenseFeatureData;
import se.ericsson.cello.productinventory.LicenseProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.productinventory.SwltData;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class LicensingMoImpl
extends CelloMao
implements LicensingMo,
LicenseProductData,
LogContentInspector,
Notifiable {
    private static int DEFAULT_TIMEOUT = 3600;
    private static int LOCAL_TIMEOUT = 10000;
    private static int MAX_NO_OF_RETRIES = 5;
    private static int RETRY_INTERVAL = 2000;
    private MoData data;
    private static String myLicensingId = "1";
    private static String myUserLabel = "";
    private StringAttribute userLabel;
    private StringAttribute straLastLicensingPiChangeTimeStamp;
    private static final int MO_DATA_REVISION_42 = 4002;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    private static final int ONLY_POSSIBLE_FRO_ID = 1;
    private static final String EXPIRY_TIME = "expiryTime";
    private static final String REMAINING_TIME = "remainingTime";
    private static final String STATE = "state";
    private static final String TIME = "time";
    private static OsaLicMgmntProxy osaLicMgmntProxy = null;
    private static final int OSA_LIC_INTEGRATION_UNLOCK = 1;

    protected LicensingMoImpl(OsaLicMgmntProxy osaLicMgmntProxy) throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("SystemFunctions")).getMo(), "Licensing", myLicensingId, null);
        LicensingMoImpl.osaLicMgmntProxy = osaLicMgmntProxy;
        ProductRepository.instance().registerLicense((LicenseProductData)this);
        LicensingMoImpl.osaLicMgmntProxy.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        InspectorMgr.getInspectorRepository().register((LogContentInspector)this, "Licensing");
        this.registerData();
    }

    LicensingMoImpl(MoData moData, OsaLicMgmntProxy osaLicMgmntProxy) throws MoNameAlreadyTakenException {
        super(((SingletonMoFactory)MoFactoryMgr.instance().lookup("SystemFunctions")).getMo(), "Licensing", myLicensingId, null);
        this.data = moData;
        LicensingMoImpl.osaLicMgmntProxy = osaLicMgmntProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("lastLicensingPiChange");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.straLastLicensingPiChangeTimeStamp = (StringAttribute)moData.getAttribute("lastLicensingPiChange");
        this.notifyPiChange();
        ProductRepository.instance().registerLicense((LicenseProductData)this);
        LicensingMoImpl.osaLicMgmntProxy.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
        InspectorMgr.getInspectorRepository().register((LogContentInspector)this, "Licensing");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    private void registerData() {
        if (this.data == null) {
            try {
                Control control = LicensingMoImpl.createTransaction(DEFAULT_TIMEOUT);
                Coordinator coordinator = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec"));
                this.data = new MoData(this.getLocalDistinguishedName(), "Licensing", true, coordinator);
                this.userLabel = new StringAttribute("userLabel", true, myUserLabel);
                this.straLastLicensingPiChangeTimeStamp = new StringAttribute("lastLicensingPiChange", true, this.getCurrentTimeStamp());
                this.data.registerPersistentAttr((Attribute)this.userLabel);
                this.data.registerPersistentAttr((Attribute)this.straLastLicensingPiChangeTimeStamp);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.data.setRevision(8000);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                MessageLog.traceError(this.getClass(), (String)"start of Licensing failed", (Throwable)transactionRequiredException);
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"start of Licensing failed", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"start of Licensing failed", (Throwable)inactiveTransactionException);
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"start of Licensing failed", (Throwable)moAccessException);
            }
        }
    }

    public String getLicensingId(Coordinator coordinator) throws MoAccessException {
        return myLicensingId;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Licensing", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public Struct getEmergencyStateInfo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[3];
        String[] stringArray = new String[]{EXPIRY_TIME, STATE, TIME};
        OsaLic7EmergencyStateViewCfm osaLic7EmergencyStateViewCfm = osaLicMgmntProxy.sendOsaLic7EmergencyStateViewReq();
        if (osaLic7EmergencyStateViewCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLic7EmergencyStateViewCfm.getResult() != 6) {
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "GetAttrReq: " + osaLicMgmntProxy.getResultMsg(osaLic7EmergencyStateViewCfm.getResult()), osaLic7EmergencyStateViewCfm.getResult());
        }
        objectArray[0] = osaLic7EmergencyStateViewCfm.getExpiryTime();
        objectArray[1] = new Integer(osaLic7EmergencyStateViewCfm.getState());
        objectArray[2] = new Integer(osaLic7EmergencyStateViewCfm.getTime());
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    public Struct getIntegrationUnlockStateInfo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[3];
        String[] stringArray = new String[]{EXPIRY_TIME, REMAINING_TIME, STATE};
        OsaLicIntegrationUnlockStateViewCfm osaLicIntegrationUnlockStateViewCfm = osaLicMgmntProxy.sendOsaLicIntegrationUnlockStateViewReq();
        if (osaLicIntegrationUnlockStateViewCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicIntegrationUnlockStateViewCfm.getResult() != 16) {
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "GetAttrReq: " + osaLicMgmntProxy.getResultMsg(osaLicIntegrationUnlockStateViewCfm.getResult()), osaLicIntegrationUnlockStateViewCfm.getResult());
        }
        objectArray[0] = osaLicIntegrationUnlockStateViewCfm.getExpiryTime();
        objectArray[1] = new Integer(osaLicIntegrationUnlockStateViewCfm.getRemainingTime());
        objectArray[2] = new Integer(osaLicIntegrationUnlockStateViewCfm.getState());
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    public String getLicenseFileUrl(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLic6FileListCfm osaLic6FileListCfm = osaLicMgmntProxy.sendOsaLic6FileListReq();
        if (osaLic6FileListCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLic6FileListCfm.getResult() != 2) {
            String string = osaLic6FileListCfm.getLicenseFileUrl();
            if (string == null) {
                string = "null";
            }
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "GetAttrReq: " + osaLicMgmntProxy.getResultMsg(osaLic6FileListCfm.getResult()), osaLic6FileListCfm.getResult());
        }
        return osaLic6FileListCfm.getLicenseFileUrl();
    }

    private void notifyPiChange() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    LicensingMoImpl.this.actionLastLicensingPiChange(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, "CmaLicPiChangeNotifierThread");
        thread.start();
    }

    public String getLicenseFileUrlIpv6(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLic6FileListCfm osaLic6FileListCfm = osaLicMgmntProxy.sendOsaLic6FileListReq();
        if (osaLic6FileListCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLic6FileListCfm.getResult() != 2) {
            String string = osaLic6FileListCfm.getLicenseFileUrlIpv6();
            if (string == null) {
                string = "null";
            }
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "GetAttrReq: " + osaLicMgmntProxy.getResultMsg(osaLic6FileListCfm.getResult()), osaLic6FileListCfm.getResult());
        }
        return osaLic6FileListCfm.getLicenseFileUrlIpv6();
    }

    public void actionUpdateLicenseKeyFile(String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        if (string.length() > 99) {
            throw new ValueOutOfRangeException("userId", "Licensing");
        }
        MoAttributeValidator.validateForIllegalCharacters((String)string2, (String)string2, (String)"Licensing");
        if (string2.length() > 20) {
            throw new ValueOutOfRangeException("password", "Licensing");
        }
        if (string4.length() > 256) {
            throw new ValueOutOfRangeException("sFile", "Licensing");
        }
        IpAddressValidation.validateHostName((String)string3, (String)"Licensing", (String)"");
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)99);
        byte[] byArray2 = MaoFroTypeConverter.string2byteArray((String)string2, (int)20);
        byte[] byArray3 = MaoFroTypeConverter.string2byteArray((String)string3, (int)256);
        byte[] byArray4 = MaoFroTypeConverter.string2byteArray((String)string4, (int)256);
        OsaLicFileUpdateCfm osaLicFileUpdateCfm = osaLicMgmntProxy.sendOsaLicFileUpdateReq(byArray, byArray2, byArray3, byArray4);
        if (osaLicFileUpdateCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicFileUpdateCfm.getResult() != 1) {
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "ActionReq: " + osaLicMgmntProxy.getResultMsg(osaLicFileUpdateCfm.getResult()) + "; AdditionalInfo: " + osaLicFileUpdateCfm.getAdditionalInfo(), osaLicFileUpdateCfm.getResult());
        }
        this.actionLastLicensingPiChange(coordinator);
    }

    public void actionSetEmergencyState(Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        OsaLicEmergencyStateCfm osaLicEmergencyStateCfm = osaLicMgmntProxy.sendOsaLicEmergencyStateReq();
        if (osaLicEmergencyStateCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicEmergencyStateCfm.getResult() != 4) {
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "ActionReq: " + osaLicMgmntProxy.getResultMsg(osaLicEmergencyStateCfm.getResult()), osaLicEmergencyStateCfm.getResult());
        }
    }

    public String actionSetIntegrationUnlockState(Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        OsaLicIntegrationUnlockStateCfm osaLicIntegrationUnlockStateCfm = osaLicMgmntProxy.sendOsaLicIntegrationUnlockStateReq();
        if (osaLicIntegrationUnlockStateCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicIntegrationUnlockStateCfm.getResult() != 14) {
            throw new FroRequestFailedException("Licensing", "LicensingMoPortFro", "ActionReq: " + osaLicMgmntProxy.getResultMsg(osaLicIntegrationUnlockStateCfm.getResult()) + "; AdditionalInfo: " + osaLicIntegrationUnlockStateCfm.getAdditionalInfo(), osaLicIntegrationUnlockStateCfm.getResult());
        }
        return osaLicIntegrationUnlockStateCfm.getTimeStamp();
    }

    public void actionSetUln(String string, Coordinator coordinator) throws MoAccessException {
        this.setUln(string, coordinator);
    }

    public String getType() {
        return "Licensing";
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        try {
            Map map = maoFroGenericEventInd.getParameters(TagNameDictionaries.getDefault());
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            String string = "";
            if (stringParameter != null) {
                string = stringParameter.getValue();
            }
            int n = maoFroGenericEventInd.getSpecificEvent();
            int n2 = 0;
            if (n == 0) {
                n2 = 15;
            } else if (n == 1) {
                n2 = 20;
            } else if (n == 2) {
                n2 = 22;
            } else if (n == 3) {
                n2 = 17;
            } else if (n == 4) {
                n2 = 18;
            } else if (n == 5) {
                n2 = 19;
            } else if (n == 6) {
                n2 = 16;
            } else if (n == 7) {
                n2 = 21;
            }
            if (n2 != 0) {
                AlarmManager.getReporter().reportEvent(n2, (ManagedObject)this, "", string, null);
            } else {
                String string2;
                if (n == 8) {
                    string2 = "Licensing_ElsnMismatch";
                } else if (n == 9) {
                    string2 = "Licensing_SwltMismatch";
                } else {
                    MessageLog.traceError(this.getClass(), (String)("Unknown event sent to LicenseMo :" + n));
                    return;
                }
                new Event("Licensing", this.getFullDistinguishedName(), "0", "", string2, string, null);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public synchronized void parameterChanged(UnlinkedSignal unlinkedSignal, String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)("parameterChdInd: " + unlinkedSignal + "\n\tproxy: " + string));
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[3];
        if (unlinkedSignal instanceof OsaLicEmergencyStateChdInd) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"Licensing FRO have changed state for emergencyStateInfo attribute (OsaLicEmergencyStateChdInd)");
            String[] stringArray2 = new String[]{EXPIRY_TIME, STATE, TIME};
            stringArray[0] = "emergencyStateInfo";
            OsaLicEmergencyStateChdInd osaLicEmergencyStateChdInd = (OsaLicEmergencyStateChdInd)unlinkedSignal;
            String string2 = osaLicEmergencyStateChdInd.getExpiryTime();
            int n = osaLicEmergencyStateChdInd.getState();
            int n2 = osaLicEmergencyStateChdInd.getTime();
            objectArray[0] = string2;
            objectArray[1] = new Integer(n);
            objectArray[2] = new Integer(n2);
            Object[] objectArray2 = new Struct[]{new StructImpl(stringArray2, objectArray)};
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray2);
        } else if (unlinkedSignal instanceof OsaLicIntegrationUnlockStateChdInd) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"Licensing FRO have changed state for integrationUnlockStateInfo attribute (OsaLicIntegrationUnlockStateChdInd)");
            String[] stringArray3 = new String[]{EXPIRY_TIME, REMAINING_TIME, STATE};
            stringArray[0] = "integrationUnlockStateInfo";
            OsaLicIntegrationUnlockStateChdInd osaLicIntegrationUnlockStateChdInd = (OsaLicIntegrationUnlockStateChdInd)unlinkedSignal;
            String string3 = osaLicIntegrationUnlockStateChdInd.getExpiryTime();
            int n = osaLicIntegrationUnlockStateChdInd.getRemainingTime();
            int n3 = osaLicIntegrationUnlockStateChdInd.getState();
            objectArray[0] = string3;
            objectArray[1] = new Integer(n);
            objectArray[2] = new Integer(n3);
            Object[] objectArray3 = new Struct[]{new StructImpl(stringArray3, objectArray)};
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray3);
        }
    }

    public void setUln(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string.length() > 256) {
            throw new ValueOutOfRangeException("Uln", "Licensing");
        }
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)256);
        OsaLicSetFingerPrintCfm osaLicSetFingerPrintCfm = osaLicMgmntProxy.sendOsaLicSetFingerPrintReq(byArray);
        if (osaLicSetFingerPrintCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicSetFingerPrintCfm.getResult() == 11) {
            throw new FroRequestFailedException("Licensing", "Fingerprint", "ResultMsg: " + osaLicMgmntProxy.getResultMsg(osaLicSetFingerPrintCfm.getResult()), osaLicSetFingerPrintCfm.getResult());
        }
        if (osaLicSetFingerPrintCfm.getResult() != 10) {
            throw new SetNotAllowedException("Licensing", "Fingerprint", osaLicMgmntProxy.getResultMsg(osaLicSetFingerPrintCfm.getResult()));
        }
        String[] stringArray = new String[]{"fingerprint"};
        Object[] objectArray = new Object[]{string};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getFingerprint(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLicFingerPrintCfm osaLicFingerPrintCfm = osaLicMgmntProxy.sendOsaLicFingerPrintReq();
        if (osaLicFingerPrintCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        if (osaLicFingerPrintCfm.getResult() != 8) {
            throw new FroRequestFailedException("Licensing", "Licensing", "GetAttrReq: " + osaLicMgmntProxy.getResultMsg(osaLicFingerPrintCfm.getResult()), osaLicFingerPrintCfm.getResult());
        }
        return osaLicFingerPrintCfm.getFingerPrint();
    }

    public SwltData getSwlt(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLicSwltCfm osaLicSwltCfm = osaLicMgmntProxy.sendOsaLicSwltReq();
        if (osaLicSwltCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        return osaLicSwltCfm.getSwlt();
    }

    public String getInstallationTime(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLicLkfInstallationTimeCfm osaLicLkfInstallationTimeCfm = osaLicMgmntProxy.sendOsaLicLkfInstallationTimeReq();
        if (osaLicLkfInstallationTimeCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        return osaLicLkfInstallationTimeCfm.getLkfInstallationTime();
    }

    public String getInstallationSeqNumber(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaLicSequenceNumberCfm osaLicSequenceNumberCfm = osaLicMgmntProxy.sendOsaLicSequenceNumberReq();
        if (osaLicSequenceNumberCfm == null) {
            throw new FroNotAccessibleException("Licensing", "LicensingMoPortFro");
        }
        return osaLicSequenceNumberCfm.getSequenceNumber();
    }

    public LicenseCapacityData[] getLicenseCapacityList(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        LicenseCapacityData[] licenseCapacityDataArray = osaLicMgmntProxy.sendOsaLicCapacityKeyListReq();
        return licenseCapacityDataArray;
    }

    public LicenseFeatureData[] getLicenseFeatureList(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        LicenseFeatureData[] licenseFeatureDataArray = osaLicMgmntProxy.sendOsaLicFeatureKeyListReq();
        return licenseFeatureDataArray;
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd-HHmmss");
        return simpleDateFormat.format(new Date());
    }

    private static Control createTransaction(int n) throws TransactionRolledBackException {
        return TransactionServiceImpl.instance().getTransactionFactory().create(n);
    }

    private static Control createTransactionWithTraniWait(int n) {
        Control control = null;
        int n2 = 0;
        while (true) {
            try {
                control = LicensingMoImpl.createTransaction(n);
            }
            catch (Exception exception) {
                block7: {
                    block6: {
                        try {
                            if (n2 >= MAX_NO_OF_RETRIES) break block6;
                            if (n2 % 2 == 0) {
                                MessageLog.info((Class)(class$se$ericsson$cello$licensing$LicensingMoImpl == null ? LicensingMoImpl.class$("se.ericsson.cello.licensing.LicensingMoImpl") : class$se$ericsson$cello$licensing$LicensingMoImpl), (String)"Could not create transaction due to TransactionServer unavailable; retrying in 2 secs");
                            }
                            Thread.sleep(RETRY_INTERVAL);
                            break block7;
                        }
                        catch (InterruptedException interruptedException) {
                            MessageLog.traceError((Class)LicensingMoImpl.class, (String)"Thread Interrupted while retrying", (Throwable)interruptedException);
                        }
                    }
                    MessageLog.traceError((Class)LicensingMoImpl.class, (String)"Unable to create Transaction due to Exception", (Throwable)exception);
                    break;
                }
                ++n2;
                continue;
            }
            break;
        }
        return control;
    }

    private void actionLastLicensingPiChange(Coordinator coordinator) throws MoAccessException {
        Coordinator coordinator2 = null;
        Control control = null;
        try {
            if (coordinator == null) {
                control = LicensingMoImpl.createTransactionWithTraniWait(LOCAL_TIMEOUT);
                coordinator2 = control.getCoordinator();
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + coordinator2.getTransactionID() + ", timeout = " + LOCAL_TIMEOUT + " sec"));
            } else {
                coordinator2 = coordinator;
            }
            this.data.handleTransaction(coordinator2, MoData.WRITE_ACCESS);
            this.straLastLicensingPiChangeTimeStamp.setValue(this.getCurrentTimeStamp());
            if (control != null) {
                MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA Trying Commit for txId = " + coordinator2.getTransactionID()));
                control.getTerminator().commit();
            }
        }
        catch (Exception exception) {
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            MessageLog.traceError(this.getClass(), (String)"licensing change failed", (Throwable)exception);
        }
    }

    public String getLastLicensingPiChange(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.straLastLicensingPiChangeTimeStamp != null) {
            return this.straLastLicensingPiChangeTimeStamp.getValue(coordinator);
        }
        return "NOT DEFINED";
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (!string.equalsIgnoreCase("updateLicenseKeyFile")) {
                return null;
            }
            int n = 1;
            try {
                objectArray[n] = "*****";
            }
            catch (Exception exception) {
                MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + exception));
                return null;
            }
            return objectArray;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }
}

