/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.model;

import java.util.Iterator;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.licensing.model.TableEntry;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public class LicensingNameValue
implements TableEntry {
    private NameValue nameValue;
    private NodeServices nodeServices;
    private String value = null;

    public LicensingNameValue(NodeServices nodeServices, NameValue nameValue, String ldn) {
        this.nameValue = nameValue;
        this.nodeServices = nodeServices;
        this.value = nameValue.valueToString();
        this.resolveEnumValue(ldn);
    }

    private void resolveEnumValue(String ldn) {
        if (this.nodeServices != null) {
            Mo mo = this.nodeServices.getNode().getCmService().getMo(ldn);
            MomClass momclass = this.nodeServices.getMimModel().getClass(mo.getType());
            MomAttribute momAttr = momclass.getAttribute(this.nameValue.getName());
            MomEntity attributeType = momAttr.getType();
            if (attributeType instanceof MomEnumRef) {
                MomEnum momEnumRef = ((MomEnumRef)attributeType).getEnum();
                Iterator iter = momEnumRef.getMembers();
                while (iter.hasNext()) {
                    MomEnumMember momEnum = (MomEnumMember)iter.next();
                    if (!momEnum.getValue().equals(this.nameValue.getValue())) continue;
                    this.value = momEnum.getName();
                    break;
                }
            }
        }
    }

    public NameValue getNameValue() {
        return this.nameValue;
    }

    public String getName() {
        return this.nameValue.getName();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    public String getTooltipText() {
        return this.getName();
    }
}

