/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import CosNaming.NameComponent;
import java.util.StringTokenizer;

class EasyNaming {
    static final String RDN_DELIMITER = ",";
    static final String TYPE_DELIMITER = "=";
    static final String LOCAL_DN_FIRST_RDN = "ManagedElement=1";

    EasyNaming() {
    }

    static String extractMibPrefix(NameComponent[] nameComponentArray) {
        String string = EasyNaming.nameComponentArray2String(nameComponentArray);
        int n = string.indexOf(LOCAL_DN_FIRST_RDN);
        if (n == -1 || n == 0) {
            return "";
        }
        return string.substring(0, n - 1);
    }

    static String extractIdentity(NameComponent[] nameComponentArray) {
        return EasyNaming.extractIdentity(EasyNaming.nameComponentArray2String(nameComponentArray));
    }

    static String extractIdentity(String string) {
        int n = string.lastIndexOf(TYPE_DELIMITER) + 1;
        return string.substring(n);
    }

    static String extractLocalDn(String string) {
        if (string.startsWith(LOCAL_DN_FIRST_RDN)) {
            return string;
        }
        int n = string.indexOf(LOCAL_DN_FIRST_RDN);
        if (n == -1) {
            n = 0;
        }
        return string.substring(n);
    }

    static String extractType(String string) {
        int n = string.lastIndexOf(RDN_DELIMITER);
        int n2 = string.lastIndexOf(TYPE_DELIMITER);
        if (n2 == -1 || n > n2) {
            return string;
        }
        return string.substring(n + 1, n2);
    }

    static String makeFdn(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + RDN_DELIMITER + string2;
    }

    static String nameComponentArray2String(NameComponent[] nameComponentArray) {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(nameComponentArray[0].id);
        for (int i = 1; i < nameComponentArray.length; ++i) {
            stringBuffer.append(RDN_DELIMITER);
            stringBuffer.append(nameComponentArray[i].id);
        }
        return stringBuffer.toString();
    }

    static NameComponent[] string2NameComponentArray(String string) {
        if (string == null || string.equals("")) {
            return new NameComponent[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, RDN_DELIMITER);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("rdnSeq is null or empty");
        }
        NameComponent[] nameComponentArray = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            NameComponent nameComponent;
            String string2 = stringTokenizer.nextToken();
            nameComponentArray[i] = nameComponent = new NameComponent(string2, "");
        }
        return nameComponentArray;
    }
}

