/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.fm;

import java.util.Hashtable;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.fm.ExtendedEventType;

class AlarmIrpTranslator {
    private static AlarmIrpTranslator _instance;
    static Hashtable probableCauseMap;

    static synchronized AlarmIrpTranslator getInstance() {
        if (_instance == null) {
            _instance = new AlarmIrpTranslator();
        }
        return _instance;
    }

    private AlarmIrpTranslator() {
    }

    boolean includeFilterableField(String string) {
        if (string.equals("b")) {
            return false;
        }
        if (string.equals("j")) {
            return false;
        }
        if (string.equals("l")) {
            return false;
        }
        if (string.equals("m")) {
            return false;
        }
        if (string.equals("n")) {
            return false;
        }
        return !string.equals("o");
    }

    String translateFilterableHeader(String string) {
        if (string.equals("NEAL.fixed_header.domain_name")) {
            return "DomainName";
        }
        if (string.equals("NEAL.fixed_header.type_name")) {
            return "EventType";
        }
        if (string.equals("NEAL.fixed_header.event_name")) {
            return "ExtendedEventType";
        }
        if (string.equals("userLabel")) {
            return "userLabel ------- userLabel";
        }
        if (string.equals("a")) {
            return string + " ---------- NotificationId";
        }
        if (string.equals("b")) {
            return string + " - CorrelatedNotifications";
        }
        if (string.equals("c")) {
            return string + " --------------- EventTime";
        }
        if (string.equals("d")) {
            return string + " ---------------- SystemDN";
        }
        if (string.equals("e")) {
            return string + " ------ ManagedObjectClass";
        }
        if (string.equals("f")) {
            return string + " --- ManagedObjectInstance";
        }
        if (string.equals("g")) {
            return string + " ----------- ProbableCause";
        }
        if (string.equals("h")) {
            return string + " ------- PerceivedSeverity";
        }
        if (string.equals("i")) {
            return string + " --------- SpecificProblem";
        }
        if (string.equals("j")) {
            return string + " ---------- AdditionalText";
        }
        if (string.equals("k")) {
            return string + " ----------------- AlarmId";
        }
        if (string.equals("l")) {
            return string + " --------------- AckUserId";
        }
        if (string.equals("m")) {
            return string + " ----------------- AckTime";
        }
        if (string.equals("n")) {
            return string + " ------------- AckSystemId";
        }
        if (string.equals("o")) {
            return string + " ---------------- AckState";
        }
        return string + " -------------------------";
    }

    String translateAttributeData(NameValue nameValue) {
        String string = nameValue.getName();
        if (string.equals("NEAL.fixed_header.type_name")) {
            return this.translateEventType(nameValue.getStringValue());
        }
        if (string.equals("NEAL.fixed_header.event_name")) {
            return this.translateNotificationType(nameValue.getStringValue());
        }
        if (string.equals("h")) {
            return this.translatePerceivedSeverity(nameValue.getIntegerValue());
        }
        if (string.equals("g")) {
            return this.translateProbableCause(nameValue.getIntegerValue());
        }
        return nameValue.valueToString();
    }

    String translateEventType(String string) {
        if (string.equals("x1")) {
            return "COMMUNICATIONS_ALARM";
        }
        if (string.equals("x2")) {
            return "PROCESSING_ERROR_ALARM";
        }
        if (string.equals("x3")) {
            return "ENVIRONMENTAL_ALARM";
        }
        if (string.equals("x4")) {
            return "QUALITY_OF_SERVICE_ALARM";
        }
        if (string.equals("x5")) {
            return "EQUIPMENT_ALARM";
        }
        if (string.equals("0")) {
            return "UNKNOWN_EVENT_TYPE";
        }
        return string;
    }

    String translatePerceivedSeverity(Integer n) {
        if (n == 1) {
            return "INDETERMINATE";
        }
        if (n == 2) {
            return "CRITICAL";
        }
        if (n == 3) {
            return "MAJOR";
        }
        if (n == 4) {
            return "MINOR";
        }
        if (n == 5) {
            return "WARNING";
        }
        if (n == 6) {
            return "CLEARED";
        }
        return "UNKNOWN?!";
    }

    String translateProbableCause(Integer n) {
        String string = (String)probableCauseMap.get(n.toString());
        if (string == null) {
            return n.toString();
        }
        return string;
    }

    String translateNotificationType(String string) {
        return ExtendedEventType.fromTag(string).toString();
    }

    boolean isPercievedSeverity(String string) {
        return string.equals("h");
    }

    boolean isProbableCause(String string) {
        return string.equals("g");
    }

    boolean isEventTime(String string) {
        return string.equals("c");
    }

    static {
        probableCauseMap = new Hashtable();
        probableCauseMap.put("0", "INDETERMINATE");
        probableCauseMap.put("1", "ALARM_INDICATION_SIGNAL");
        probableCauseMap.put("2", "CALL_SETUP_FAILURE");
        probableCauseMap.put("3", "DEGRADED_SIGNAL_M3100");
        probableCauseMap.put("4", "FAR_END_RECEIVER_FAILURE");
        probableCauseMap.put("5", "FRAMING_ERROR_M3100");
        probableCauseMap.put("6", "LOSS_OF_FRAME");
        probableCauseMap.put("7", "LOSS_OF_POINTER");
        probableCauseMap.put("8", "LOSS_OF_SIGNAL");
        probableCauseMap.put("9", "PAYLOAD_TYPE_MISMATCH");
        probableCauseMap.put("10", "TRANSMISSION_ERROR");
        probableCauseMap.put("11", "REMOTE_ALARM_INTERFACE");
        probableCauseMap.put("12", "EXCESSIVE_BIT_ERROR_RATE");
        probableCauseMap.put("13", "PATH_TRACE_MISMATCH");
        probableCauseMap.put("14", "UNAVAILABLE");
        probableCauseMap.put("15", "SIGNAL_LABEL_MISMATCH");
        probableCauseMap.put("16", "LOSS_OF_MULTI_FRAME");
        probableCauseMap.put("51", "BACK_PLANE_FAILURE");
        probableCauseMap.put("52", "DATA_SET_PROBLEM");
        probableCauseMap.put("53", "EQUIPMENT_IDENTIFIER_DUPLICATION");
        probableCauseMap.put("54", "EXTERNAL_DEVICE_PROBLEM");
        probableCauseMap.put("55", "LINE_CARD_PROBLEM");
        probableCauseMap.put("56", "MULTIPLEXER_PROBLEM_M3100");
        probableCauseMap.put("57", "NE_IDENTIFIER_DUPLICATION");
        probableCauseMap.put("58", "POWER_PROBLEM_M3100");
        probableCauseMap.put("59", "PROCESSOR_PROBLEM_M3100");
        probableCauseMap.put("60", "PROTECTION_PATH_FAILURE");
        probableCauseMap.put("61", "RECEIVER_FAILURE_M3100");
        probableCauseMap.put("62", "REPLACEABLE_UNIT_MISSING");
        probableCauseMap.put("63", "REPLACEABLE_UNIT_TYPE_MISMATCH");
        probableCauseMap.put("64", "SYNCHRONISATION_SOURCE_MISMATCH");
        probableCauseMap.put("65", "TERMINAL_PROBLEM");
        probableCauseMap.put("66", "TIMING_PROBLEM_M3100");
        probableCauseMap.put("67", "TRANSMITTER_FAILURE_M3100");
        probableCauseMap.put("68", "TRUNK_CARD_PROBLEM");
        probableCauseMap.put("69", "REPLACEABLE_UNIT_PROBLEM");
        probableCauseMap.put("101", "AIR_COMPRESSOR_FAILURE");
        probableCauseMap.put("102", "AIR_CONDITIONING_FAILURE");
        probableCauseMap.put("103", "AIR_DRYER_FAILURE");
        probableCauseMap.put("104", "BATTERY_DISCHARGING");
        probableCauseMap.put("105", "BATTERY_FAILURE");
        probableCauseMap.put("106", "COMMERICAL_POWER_FAILURE");
        probableCauseMap.put("107", "COOLING_FAN_FAILURE");
        probableCauseMap.put("108", "ENGINE_FAILURE");
        probableCauseMap.put("109", "FIRE_DETECTOR_FAILURE");
        probableCauseMap.put("110", "FUSE_FAILURE");
        probableCauseMap.put("111", "GENERATOR_FAILURE");
        probableCauseMap.put("112", "LOW_BATTERY_THRESHOLD");
        probableCauseMap.put("113", "PUMP_FAILURE_M3100");
        probableCauseMap.put("114", "RECTIFIER_FAILURE");
        probableCauseMap.put("115", "RECTIFIER_HIGH_VOLTAGE");
        probableCauseMap.put("116", "RECTIFIER_LOW_F_VOLTAGE");
        probableCauseMap.put("117", "VENTILATION_SYSTEM_FAILURE");
        probableCauseMap.put("118", "ENCLOSURE_DOOR_OPEN_M3100");
        probableCauseMap.put("119", "EXPLOSIVE_GAS");
        probableCauseMap.put("120", "FIRE");
        probableCauseMap.put("121", "FLOOD");
        probableCauseMap.put("122", "HIGH_HUMIDITY");
        probableCauseMap.put("123", "HIGH_TEMPERATURE");
        probableCauseMap.put("124", "HIGH_WIND");
        probableCauseMap.put("125", "ICE_BUILD_UP");
        probableCauseMap.put("127", "LOW_FUEL");
        probableCauseMap.put("128", "LOW_HUMIDITY");
        probableCauseMap.put("129", "LOW_CABLE_PRESSURE");
        probableCauseMap.put("130", "LOW_TEMPERATURE");
        probableCauseMap.put("131", "LOW_WATER");
        probableCauseMap.put("132", "SMOKE");
        probableCauseMap.put("133", "TOXIC_GAS");
        probableCauseMap.put("151", "STORAGE_CAPACITY_PROBLEM_M3100");
        probableCauseMap.put("152", "MEMORY_MISMATCH");
        probableCauseMap.put("153", "CORRUPT_DATA_M3100");
        probableCauseMap.put("154", "OUT_OF_CPU_CYCLES");
        probableCauseMap.put("155", "SOFTWARE_ENVIRONMENT_PROBLEM");
        probableCauseMap.put("156", "SOFTWARE_DOWNLOAD_FAILURE");
        probableCauseMap.put("301", "ADAPTER_ERROR");
        probableCauseMap.put("302", "APPLICATION_SUBSYSTEM_FAILURE");
        probableCauseMap.put("303", "BANDWIDTH_REDUCTION");
        probableCauseMap.put("305", "COMMUNICATION_PROTOCOL_ERROR");
        probableCauseMap.put("306", "COMMUNICATION_SUBSYSTEM_FAILURE");
        probableCauseMap.put("307", "CONFIGURATION_OR_CUSTOMIZING_ERROR");
        probableCauseMap.put("308", "CONGESTION");
        probableCauseMap.put("310", "CPU_CYCLES_LIMIT_EXCEEDED");
        probableCauseMap.put("311", "DATA_SET_OR_MODEM_ERROR");
        probableCauseMap.put("313", "DTE_DCE_INETERFACE_ERROR");
        probableCauseMap.put("315", "EQUIPMENT_MALFUNCTION");
        probableCauseMap.put("316", "EXCESSIVE_VIBRATION");
        probableCauseMap.put("317", "FILE_ERROR");
        probableCauseMap.put("321", "HEATING_OR_VENTILATION_OR_COOLING_SYSTEM_PROBLEM");
        probableCauseMap.put("322", "HUMIDITY_UNACCEPTABLE");
        probableCauseMap.put("323", "INPUT_OUTPUT_DEVICE_ERROR");
        probableCauseMap.put("324", "INPUT_DEVICE_ERROR");
        probableCauseMap.put("325", "LAN_ERROR");
        probableCauseMap.put("326", "LEAK_DETECTION");
        probableCauseMap.put("327", "LOCAL_NODE_TRANSMISSION_ERROR");
        probableCauseMap.put("330", "MATERIAL_SUPPLY_EXHAUSTED");
        probableCauseMap.put("332", "OUT_OF_MEMORY");
        probableCauseMap.put("333", "OUTPUT_DEVICE_ERROR");
        probableCauseMap.put("334", "PERFORMANCE_DEGRADED");
        probableCauseMap.put("336", "PRESSURE_UNACCEPTABLE");
        probableCauseMap.put("339", "QUEUE_SIZE_EXCEEDED");
        probableCauseMap.put("340", "RECEIVE_FAILURE");
        probableCauseMap.put("342", "REMOTE_NODE_TRANSMISSION_ERROR");
        probableCauseMap.put("343", "RESOURCE_AT_OR_NEARING_CAPACITY");
        probableCauseMap.put("344", "RESPONSE_TIME_EXCESSIVE");
        probableCauseMap.put("345", "RETRANSMISSION_RATE_EXCESSIVE");
        probableCauseMap.put("346", "SOFTWARE_ERROR");
        probableCauseMap.put("347", "SOFTWARE_PROGRAM_ABNORMALLY_TERMINATED");
        probableCauseMap.put("348", "SOFTWARE_PROGRAM_ERROR");
        probableCauseMap.put("350", "TEMPERATURE_UNACCEPTABLE");
        probableCauseMap.put("351", "THRESHOLD_CROSSED");
        probableCauseMap.put("353", "TOXIC_LEAK_DETECTED");
        probableCauseMap.put("354", "TRANSMIT_FAILURE");
        probableCauseMap.put("356", "UNDERLYING_RESOURCE_UNAVAILABLE");
        probableCauseMap.put("357", "VERSION_MISMATCH");
        probableCauseMap.put("401", "AUTHENTICATION_FAILURE");
        probableCauseMap.put("402", "BREACH_OF_CONFIDENTIALITY");
        probableCauseMap.put("403", "CABLE_TAMPER");
        probableCauseMap.put("404", "DELAYED_INFORMATION");
        probableCauseMap.put("405", "DENIAL_OF_SERVICE");
        probableCauseMap.put("406", "DUPLICATE_INFORMATION");
        probableCauseMap.put("407", "INFORMATION_MISSING");
        probableCauseMap.put("408", "INFORMATION_MODIFICATION_DETECTED");
        probableCauseMap.put("409", "INFORMATION_OUT_OF_SEQUENCE");
        probableCauseMap.put("410", "INTRUSION_DETECTED");
        probableCauseMap.put("411", "KEY_EXPIRED");
        probableCauseMap.put("412", "NON_REPUDIATION_FAILURE");
        probableCauseMap.put("413", "OUT_OF_HOURS_ACTIVITY");
        probableCauseMap.put("414", "OUT_OF_SERVICE");
        probableCauseMap.put("415", "PROCEDURAL_ERROR");
        probableCauseMap.put("416", "UNAUTHORIZED_ACCESS_ATTEMPT");
        probableCauseMap.put("417", "UNEXPECTED_INFORMATION");
        probableCauseMap.put("418", "UNSPECIFIED_REASON");
        probableCauseMap.put("501", "A_BIS_TO_BTS_INTERFACE_FAILURE");
        probableCauseMap.put("502", "A_BIS_TO_TRX_INTERFACE_FAILURE");
        probableCauseMap.put("503", "ANTENNA_PROBLEM");
        probableCauseMap.put("504", "BATTERY_BREAKDOWN");
        probableCauseMap.put("505", "BATTERY_CHARGING_FAULT");
        probableCauseMap.put("506", "CLOCK_SYNCHRONISATION_PROBLEM");
        probableCauseMap.put("507", "COMBINER_PROBLEM");
        probableCauseMap.put("508", "DISK_PROBLEM");
        probableCauseMap.put("510", "EXCESSIVE_RECEIVER_TEMPERATURE");
        probableCauseMap.put("511", "EXCESSIVE_TRANSMITTER_OUTPUT_POWER");
        probableCauseMap.put("512", "EXCESSIVE_TRANSMITTER_TEMPERATURE");
        probableCauseMap.put("513", "FREQUENCY_HOPPING_DEGRADED");
        probableCauseMap.put("514", "FREQUENCY_HOPPING_FAILURE");
        probableCauseMap.put("515", "FREQUENCY_REDEFINITION_FAILED");
        probableCauseMap.put("516", "LINE_INTERFACE_FAILURE");
        probableCauseMap.put("517", "LINK_FAILURE");
        probableCauseMap.put("518", "LOSS_OF_SYNCHRONISATION");
        probableCauseMap.put("519", "LOST_REDUNDANCY");
        probableCauseMap.put("520", "MAINS_BREAKDOWN_WITH_BATTERY_BACKUP");
        probableCauseMap.put("521", "MAINS_BREAKDOWN_WITHOUT_BATTERY_BACKUP");
        probableCauseMap.put("522", "POWER_SUPPLY_FAILURE");
        probableCauseMap.put("523", "RECEIVER_ANTENNA_FAULT");
        probableCauseMap.put("525", "RECEIVER_MULTICOUPLER_FAILURE");
        probableCauseMap.put("526", "REDUCED_TRANSMITTER_OUTPUT_POWER");
        probableCauseMap.put("527", "SIGNAL_QUALITY_EVALUATION_FAULT");
        probableCauseMap.put("528", "TIMESLOT_HARDWARE_FAILURE");
        probableCauseMap.put("529", "TRANSCEIVER_PROBLEM");
        probableCauseMap.put("530", "TRANSCODER_PROBLEM");
        probableCauseMap.put("531", "TRANSCODER_OR_RATE_ADAPTER_PROBLEM");
        probableCauseMap.put("532", "TRANSMITTER_ANTENNA_FAILURE");
        probableCauseMap.put("533", "TRANSMITTER_ANTENNA_NOT_ADJUSTED");
        probableCauseMap.put("535", "TRANSMITTER_LOW_VOLTAGE_OR_CURRENT");
        probableCauseMap.put("536", "TRANSMITTER_OFF_FREQUENCY");
        probableCauseMap.put("537", "DATABASE_INCONSISTENCY");
        probableCauseMap.put("538", "FILE_SYSTEM_CALL_UNSUCCESSFUL");
        probableCauseMap.put("539", "INPUT_PARAMETER_OUT_OF_RANGE");
        probableCauseMap.put("540", "INVALID_PARAMETER");
        probableCauseMap.put("541", "INVALID_POINTER");
        probableCauseMap.put("542", "MESSAGE_NOT_EXPECTED");
        probableCauseMap.put("543", "MESSAGE_NOT_INITIALISED");
        probableCauseMap.put("544", "MESSAGE_OUT_OF_SEQUENCE");
        probableCauseMap.put("545", "SYSTEM_CALL_UNSUCCESSFUL");
        probableCauseMap.put("546", "TIMEOUT_EXPIRED");
        probableCauseMap.put("547", "VARIABLE_OUT_OF_RANGE");
        probableCauseMap.put("548", "WATCH_DOG_TIMER_EXPIRED");
        probableCauseMap.put("549", "COOLING_SYSTEM_FAILURE");
        probableCauseMap.put("550", "EXTERNAL_EQUIPMENT_FAILURE");
        probableCauseMap.put("551", "EXTERNAL_POWER_SUPPLY_FAILURE");
        probableCauseMap.put("552", "EXTERNAL_TRANSMISSION_DEVICE_FAILURE");
        probableCauseMap.put("561", "REDUCED_ALARM_REPORTING");
        probableCauseMap.put("562", "REDUCED_EVENT_REPORTING");
        probableCauseMap.put("563", "RECUCED_LOGGING_CAPABILITY");
        probableCauseMap.put("564", "SYSTEM_RESOURCES_OVERLOAD");
        probableCauseMap.put("565", "BROADCAST_CHANNEL_FAILURE");
        probableCauseMap.put("566", "CALL_ESTABLISHMENT_ERROR");
        probableCauseMap.put("567", "INVALID_MESSAGE_RECEIVED");
        probableCauseMap.put("568", "INVALID_MSU_RECEIVED");
        probableCauseMap.put("569", "LAPD_LINK_PROTOCOL_FAILURE");
        probableCauseMap.put("570", "LOCAL_ALARM_INDICATION");
        probableCauseMap.put("571", "REMOTE_ALARM_INDICATION");
        probableCauseMap.put("572", "ROUTING_FAILURE");
        probableCauseMap.put("573", "SS7_PROTOCOL_FAILURE");
        probableCauseMap.put("574", "TRANSMISSION_FAILURE");
    }
}

