/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import se.ericsson.cello.emt.helpservice.HelpServiceI;
import se.ericsson.cello.emt.logservices.LogServices;
import se.ericsson.cello.emt.logservices.LogStatusListener;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.neal.NodeConnectionEvent;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.StateMoParams;
import se.ericsson.cello.nex.UI;
import se.ericsson.cello.nex.gui.FrameKeyListener;
import se.ericsson.cello.nex.gui.NodeStateIcon;
import se.ericsson.cello.nex.gui.NodeStateUpdater;
import se.ericsson.cello.nex.gui.NodeTime;
import se.ericsson.cello.nex.gui.OwnerFrameI;
import se.ericsson.cello.nex.gui.TxtFileFilter;
import se.ericsson.cello.nex.gui.ViewSelectionDialog;
import se.ericsson.cello.nex.gui.XlsFileFilter;
import se.ericsson.cello.nex.gui.XmlFileFilter;
import se.ericsson.cello.nex.gui.view.GuiView;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewI;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gui
extends JFrame
implements UI,
OwnerFrameI,
LogStatusListener,
NodeConnectionListener {
    private static final String EMPTY_STRING = "";
    private static final String COPYRIGHT_YEAR = "2008-" + Calendar.getInstance().get(1);
    private static final String XERCES_ACK = "This product includes Apache Xerces Java.\nIt is licensed under the Apache License, Version 2.0.\nYou may obtain a copy of the License at\nhttp://www.apache.org/licenses/LICENSE-2.0";
    private Image ericssonImage = null;
    private Component comp = this;
    private ConfigurationI myConfig;
    private ToolServicesI myToolServices;
    private ViewServicesI myViewServices;
    private ViewI myView;
    private static final long serialVersionUID = 1L;
    private JPanel contentPanel = null;
    private JMenuBar nexMenuBar = null;
    private JMenu toolsMenu = null;
    private JMenuItem[] toolsMenuItem = null;
    private JMenuItem[] helpMenuItems = null;
    private JMenu jFileMenu = null;
    private JMenu jViewMenu = null;
    private JMenu moMenu = null;
    private JMenu alarmMenu = null;
    private JMenu jHelpMenu = null;
    private JPanel statusPanel = null;
    private JTextField statusTextField = new JTextField();
    private JLabel iconLabel = null;
    private ImageIcon ericssonIcon = null;
    private JPanel topPanel = null;
    private JPanel selectViewPanel = null;
    private JMenuItem viewOpenMenuItem = null;
    private JMenuItem importViewMenuItem = null;
    private JButton previousButton = null;
    private JButton nextButton = null;
    private JComboBox viewNamesComboBox = null;
    private JButton viewDescrButton = null;
    private JMenuItem exportViewMenuItem = null;
    private JMenuItem exportModelMenuItem = null;
    protected File lastOpenViewDir = null;
    private JCheckBoxMenuItem showRelMenuItem = null;
    private JCheckBoxMenuItem showLdnColumnMenuItem = null;
    private JMenuItem addColumnMenuItem = null;
    private JMenuItem removeColumnMenuItem = null;
    private JMenuItem expandMenuItem = null;
    private JMenuItem propertiesMenuItem = null;
    private JMenuItem searchMenuItem = null;
    private JMenu gotoMenu = null;
    private JMenuItem moHelpMenuItem = null;
    private JMenuItem deleteMenuItem = null;
    private JMenuItem jExitMenuItem = null;
    private boolean listenToCreateViewAction = true;
    private boolean showPrefix = false;
    private JPanel clockIconPanel = null;
    private JTextField clockField = null;
    private JTextField traceField = null;
    private Timer clockTimerGetTime;
    private ViewSelectionDialog viewDescriptionDia = null;
    private ViewSelectionDialog openViewDia = null;
    private JMenuItem addMenuItem = null;
    private JMenuItem cloneMenuItem = null;
    private FrameKeyListener frameKeyListener = null;
    private boolean connected = true;
    private volatile boolean initialized = false;
    private NodeTime myNodeTime = null;
    private NodeStateUpdater nodeStateUpdater = null;
    private StateMoParams[] stateMoParams = null;
    private static boolean initValue = true;

    public Gui(ConfigurationI configuration, ToolServicesI toolServices) {
        this.statusTextField.setName("statusTextField");
        this.myConfig = configuration;
        this.myToolServices = toolServices;
        this.myNodeTime = new NodeTime(this.myToolServices);
        this.nodeStateUpdater = new NodeStateUpdater(this.myToolServices);
    }

    public void setViewServices(ViewServicesI viewServices) {
        this.myViewServices = viewServices;
    }

    @Override
    public void initialize() {
        NexLog.logger().log(Level.INFO, " initialize the GUI");
        try {
            NexLog.logger().info("Will set System Look and Feel: " + UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            NexLog.logger().info("Was not able to set the correct look and feel of the system.\n" + NexLog.stackToString(e));
        }
        NexLog.logger().log(Level.INFO, " create title and icon");
        this.setTitle(this.myToolServices.getHostAddress() + " - " + this.myConfig.getTitle());
        this.setSize(new Dimension(900, 700));
        this.setPreferredSize(new Dimension(900, 700));
        try {
            this.setIconImage(this.myConfig.getIconImage());
        }
        catch (Exception ex) {
            NexLog.logger().info("Something went wrong when setting icon to main window.\n" + NexLog.stackToString(ex));
        }
        this.frameKeyListener = new FrameKeyListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.frameKeyListener);
        this.setJMenuBar(this.getNexMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setStatusMessage("Initializing...");
        this.importViewMenuItem.setEnabled(false);
        this.exportViewMenuItem.setEnabled(false);
        this.exportModelMenuItem.setEnabled(false);
        this.setFocusable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Gui.this.userClosing();
            }
        });
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void connectionLost(NodeConnectionEvent event) {
        this.connected = false;
        if (null != this.myView) {
            this.myView.offLine();
        }
        this.viewNamesComboBox.setEnabled(false);
        this.viewDescrButton.setEnabled(false);
        this.setStatusMessage("Node connection is lost. Please wait...");
    }

    public void connectionRestored(NodeConnectionEvent event) {
        if (event.getConnectionStatus() == 2) {
            this.connected = true;
            if (null != this.myView) {
                this.myView.onLine();
            }
            this.viewNamesComboBox.setEnabled(true);
            this.viewDescrButton.setEnabled(true);
            try {
                Mo cvMo = this.myToolServices.getNodeServices().getNode().getCmService().getMo("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
                String executingCv = cvMo.getAttribute("executingCv", null).valueToString();
                if (executingCv != null) {
                    EProps.getRevisionProperties().set(EKEY.REV_CV_CURRENT, (Object)executingCv);
                }
            }
            catch (StartFailureException e) {
                NexLog.logger().log(Level.SEVERE, "Can not retrieve Cv MO attribute executingCv.");
            }
            this.setStatusMessage("Node connection is restored");
        }
    }

    public void connectionEstablished() {
        this.connected = true;
    }

    public void updateGuiAfterConnection() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.updateGuiAfterConnection();
                }
            };
            SwingUtilities.invokeLater(runner);
        } else {
            this.viewDescrButton.setEnabled(true);
            this.importViewMenuItem.setEnabled(true);
            try {
                Collection<String> list = this.myViewServices.getAvailableViewNames();
                this.listenToCreateViewAction = false;
                for (String item : list) {
                    this.viewNamesComboBox.addItem(item);
                }
            }
            catch (IOException e) {
                MessageDialogFactory.createMessageDialog((String)"It was not possible to update gui after connection: ", (Exception)e, (boolean)true, (JFrame)this.getFrame()).setVisible(true);
            }
            if (null != this.myView) {
                this.viewNamesComboBox.setSelectedItem(this.myView.getName());
            }
            this.listenToCreateViewAction = true;
        }
    }

    @Override
    public void showUI(boolean visible) {
        NexLog.logger().log(Level.INFO, " showUI()");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(visible);
    }

    @Override
    public Mo askForTopMo(Collection<Mo> mos) {
        Mo returnMo = null;
        HashMap<String, Mo> possibleMOs = new HashMap<String, Mo>(mos.size());
        for (Mo mo : mos) {
            possibleMOs.put(mo.getLdn(), mo);
        }
        String selectedLdn = null;
        Object[] possibleValues = possibleMOs.keySet().toArray();
        Object[] options = new Object[]{"Set", "Cancel"};
        JOptionPane pane = new JOptionPane("Select MO to be used as top in the view:", 1, 0, null, options, options[0]);
        pane.setSelectionValues(possibleValues);
        JDialog jDialog = pane.createDialog(this.getFrame(), "Select Top MO");
        jDialog.setVisible(true);
        Object selectedButtonText = pane.getValue();
        if (null == selectedButtonText || selectedButtonText.equals("Cancel")) {
            returnMo = null;
        } else {
            Object inputValue = pane.getInputValue();
            selectedLdn = (String)inputValue;
            if (null != selectedLdn) {
                returnMo = (Mo)possibleMOs.get(selectedLdn);
            }
        }
        if (null == returnMo) {
            this.listenToCreateViewAction = false;
            this.viewNamesComboBox.setSelectedItem(this.myView.getName());
            this.listenToCreateViewAction = true;
        }
        return returnMo;
    }

    public JFrame getMainWindow() {
        return this;
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public String getToolTitle() {
        return this.myConfig.getTitle();
    }

    @Override
    public String getHostName() {
        return this.myToolServices.getHostName();
    }

    @Override
    public void viewIsListening(boolean available) {
        this.expandMenuItem.setEnabled(available);
        this.addColumnMenuItem.setEnabled(available);
        this.removeColumnMenuItem.setEnabled(available);
    }

    @Override
    public void setMessage(String mainMessage, String specificMessage, boolean severe) {
        this.setAnyMessage(mainMessage, specificMessage, null, severe, 1);
    }

    @Override
    public void setMessage(String mainMessage, Exception exception, boolean severe) {
        this.setAnyMessage(mainMessage, null, exception, severe, 2);
    }

    @Override
    public void setMessage(String mainMessage, String specific, Exception exception, boolean severe) {
        this.setAnyMessage(mainMessage, specific, exception, severe, 3);
    }

    @Override
    public void setStatusMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.setStatusMessage(message);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        if (this.statusTextField == null) {
            return;
        }
        NexLog.logger().log(Level.INFO, " setStatusMessage: " + message);
        this.statusTextField.setText(message);
        this.statusTextField.setToolTipText(message);
        this.statusTextField.setCaretPosition(0);
    }

    @Override
    public void setView(final ViewI view) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.setView(view);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        NexLog.logger().log(Level.INFO, " setView(): " + view.getName());
        if (null != this.myView) {
            this.myView.setToAccessible(false);
            if (this.myView instanceof GuiView) {
                this.getContentPane().remove(((GuiView)this.myView).getViewPanel());
            }
        }
        this.myView = view;
        if (this.myView instanceof GuiView) {
            ((GuiView)this.myView).setOwnerFrameI(this);
            this.getContentPane().add((Component)((GuiView)this.myView).getViewPanel(), "Center");
            ((GuiView)this.myView).getViewPanel().setVisible(true);
        }
        ((GuiView)this.myView).updatePrefix();
        this.myView.setToAccessible(true);
        this.exportViewMenuItem.setEnabled(true);
        this.exportModelMenuItem.setEnabled(true);
        this.showRelMenuItem.setEnabled(true);
        this.showLdnColumnMenuItem.setEnabled(true);
        this.addColumnMenuItem.setEnabled(true);
        this.removeColumnMenuItem.setEnabled(true);
        this.expandMenuItem.setEnabled(true);
        this.searchMenuItem.setEnabled(true);
        int length = this.viewNamesComboBox.getItemCount();
        boolean found = false;
        for (int i = 0; i < length; ++i) {
            if (!this.viewNamesComboBox.getItemAt(i).equals(this.myView.getName())) continue;
            found = true;
            break;
        }
        if (!found && null != this.myViewServices) {
            try {
                this.updateViewNames(this.myViewServices.getAvailableViewNames());
            }
            catch (IOException e) {
                MessageDialogFactory.createMessageDialog((String)("It was not possible to remove the view with the name: " + view.getName()), (Exception)e, (boolean)true, (JFrame)this.getFrame()).setVisible(true);
                NexLog.logger().log(Level.WARNING, "Failed to create model.It was not possible to read the view with the name.\n" + view.getName() + "\n" + NexLog.stackToString(e));
                return;
            }
        }
        this.listenToCreateViewAction = false;
        this.viewNamesComboBox.setSelectedItem(this.myView.getName());
        this.showLdnColumnMenuItem.setSelected(this.myView.getShowLDN());
        this.validate();
        this.repaint();
        this.listenToCreateViewAction = true;
        this.setStatusMessage("View: " + view.getName());
        if (!this.connected) {
            view.offLine();
        }
    }

    @Override
    public void updateViewNames(final Collection<String> newNames) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.updateViewNames(newNames);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        this.listenToCreateViewAction = false;
        String currentlySelected = (String)this.viewNamesComboBox.getSelectedItem();
        this.viewNamesComboBox.removeAllItems();
        for (String item : newNames) {
            this.viewNamesComboBox.addItem(item);
        }
        if (newNames.contains(currentlySelected)) {
            this.viewNamesComboBox.setSelectedItem(currentlySelected);
        }
        this.listenToCreateViewAction = true;
    }

    public void destroy() {
        this.myNodeTime.destroy();
        this.clockTimerGetTime.stop();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.frameKeyListener);
        this.setVisible(false);
        this.removeAll();
        this.comp = null;
        this.myConfig = null;
        this.myToolServices = null;
        this.myViewServices = null;
        this.myView = null;
        this.contentPanel = null;
        this.nexMenuBar = null;
        this.toolsMenu = null;
        this.toolsMenuItem = null;
        this.jFileMenu = null;
        this.jViewMenu = null;
        this.moMenu = null;
        this.alarmMenu = null;
        this.jHelpMenu = null;
        this.statusPanel = null;
        this.statusTextField = null;
        this.clockIconPanel = null;
        this.clockField = null;
        this.traceField = null;
        this.iconLabel = null;
        this.ericssonImage = null;
        this.ericssonIcon = null;
        this.topPanel = null;
        this.selectViewPanel = null;
        this.importViewMenuItem = null;
        this.viewOpenMenuItem = null;
        this.previousButton = null;
        this.nextButton = null;
        this.viewNamesComboBox = null;
        this.viewDescrButton = null;
        this.exportViewMenuItem = null;
        this.exportModelMenuItem = null;
        this.lastOpenViewDir = null;
        this.frameKeyListener = null;
        this.connected = false;
        this.initialized = false;
        this.dispose();
    }

    @Override
    public void enableForwardView(final boolean b) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.enableForwardView(b);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        if (null == this.nextButton) {
            return;
        }
        this.nextButton.setEnabled(b);
    }

    @Override
    public void enableBackwardView(final boolean b) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.enableBackwardView(b);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        if (null == this.previousButton) {
            return;
        }
        this.previousButton.setEnabled(b);
    }

    @Override
    public boolean showTreeNodePrefix() {
        return this.showPrefix;
    }

    private void setAnyMessage(final String mainMessage, final String specific, final Exception exception, final boolean severe, final int type) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    Gui.this.setAnyMessage(mainMessage, specific, exception, severe, type);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        MessageDialog messageDialog = null;
        switch (type) {
            case 1: {
                messageDialog = MessageDialogFactory.createMessageDialog((String)mainMessage, (String)specific, (boolean)severe, (JFrame)this.getFrame());
                break;
            }
            case 2: {
                messageDialog = MessageDialogFactory.createMessageDialog((String)mainMessage, (Exception)exception, (boolean)severe, (JFrame)this.getFrame());
                break;
            }
            case 3: {
                messageDialog = MessageDialogFactory.createMessageDialog((String)mainMessage, (String)specific, (Exception)exception, (boolean)severe, (JFrame)this.getFrame());
                break;
            }
            default: {
                NexLog.logger().log(Level.FINE, " setMessage: " + mainMessage + " !!!!!!!!!!!!!!! Unknown type: " + type);
            }
        }
        NexLog.logger().log(Level.FINE, " setMessage: " + mainMessage + " type: " + type);
        if (null != messageDialog) {
            messageDialog.setVisible(true);
        }
    }

    private JPanel getJContentPane() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)this.getStatusPanel(), "South");
            this.contentPanel.add((Component)this.getTopPanel(), "North");
        }
        return this.contentPanel;
    }

    private JMenuBar getNexMenuBar() {
        if (this.nexMenuBar == null) {
            this.nexMenuBar = new JMenuBar();
            this.nexMenuBar.setName("nexMenuBar");
            this.nexMenuBar.add(this.getFileMenu());
            this.nexMenuBar.add(this.getViewMenu());
            this.nexMenuBar.add(this.getMoMenu());
            this.nexMenuBar.add(this.getAlarmMenu());
            this.nexMenuBar.add(this.getToolsMenu());
            this.nexMenuBar.add(this.getHelpMenu());
        }
        return this.nexMenuBar;
    }

    private JMenu getToolsMenu() {
        if (this.toolsMenu == null) {
            this.toolsMenu = new JMenu();
            this.toolsMenu.setName("toolsMenu");
            this.toolsMenu.setText("Tools");
            this.toolsMenu.setMnemonic('T');
            this.getToolsMenuItems();
            for (int i = 0; i < this.toolsMenuItem.length; ++i) {
                this.toolsMenu.add(this.toolsMenuItem[i]);
            }
        }
        return this.toolsMenu;
    }

    private void getToolsMenuItems() {
        NexLog.logger().log(Level.INFO, " getToolsMenuItems()");
        if (this.toolsMenuItem == null) {
            List<String> toolsCollection = this.myToolServices.getAvailableTools();
            this.toolsMenuItem = new JMenuItem[toolsCollection.size()];
            for (int i = 0; i < toolsCollection.size(); ++i) {
                this.toolsMenuItem[i] = new JMenuItem();
                this.toolsMenuItem[i].setText(toolsCollection.get(i));
                final int this_i = i;
                final String toolName = toolsCollection.get(i);
                this.toolsMenuItem[i].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        NexLog.logger().log(Level.INFO, " Starts tool " + toolName);
                        try {
                            Properties props = Gui.this.myToolServices.getConfiguration().getSupersedingProperties();
                            Gui.this.myToolServices.startTool(Gui.this.myToolServices.getAvailableTools().get(this_i), props);
                        }
                        catch (StartFailureException e1) {
                            NexLog.logger().log(Level.WARNING, "Can not start Tool " + toolName + " " + NexLog.stackToString(e1));
                            Gui.this.setMessage("Can not start Tool " + toolName, e1, true);
                        }
                    }
                });
            }
        }
    }

    private JMenu getFileMenu() {
        if (this.jFileMenu == null) {
            this.jFileMenu = new JMenu();
            this.jFileMenu.setText("File");
            this.jFileMenu.setName("fileMenu");
            this.jFileMenu.setMnemonic(70);
            this.jFileMenu.add(this.getImportViewMenuItem());
            this.jFileMenu.add(this.getExportModelMenuItem());
            this.jFileMenu.add(this.getExportViewMenuItem());
            this.jFileMenu.addSeparator();
            this.jFileMenu.add(this.getExitMenuItem());
        }
        return this.jFileMenu;
    }

    private JMenu getViewMenu() {
        if (this.jViewMenu == null) {
            this.jViewMenu = new JMenu();
            this.jViewMenu.setText("View");
            this.jViewMenu.setName("viewMenu");
            this.jViewMenu.setMnemonic(86);
            this.jViewMenu.add(this.getViewOpenMenuItem());
            this.jViewMenu.addSeparator();
            this.jViewMenu.add(this.getExpandMenuItem());
            this.jViewMenu.add(this.getShowRelMenuItem());
            this.jViewMenu.addSeparator();
            this.jViewMenu.add(this.getShowLdnColumnMenuItem());
            this.jViewMenu.add(this.getAddColumnMenuItem());
            this.jViewMenu.add(this.getRemoveColumnMenuItem());
            this.jViewMenu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent event) {
                    Gui.this.addColumnMenuItem.setEnabled(Gui.this.connected);
                    Gui.this.viewOpenMenuItem.setEnabled(Gui.this.connected);
                    Gui.this.expandMenuItem.setEnabled(Gui.this.connected);
                    Gui.this.showRelMenuItem.setEnabled(Gui.this.connected);
                    Gui.this.addColumnMenuItem.setEnabled(Gui.this.connected);
                    if (Gui.this.myView.getColumnNamesAddedByUser().size() == 0) {
                        Gui.this.removeColumnMenuItem.setEnabled(false);
                    } else {
                        Gui.this.removeColumnMenuItem.setEnabled(Gui.this.connected);
                    }
                }

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }
            });
        }
        return this.jViewMenu;
    }

    private JMenu getMoMenu() {
        if (this.moMenu == null) {
            this.moMenu = new JMenu();
            this.moMenu.setText("MO");
            this.moMenu.setMnemonic('o');
            this.moMenu.add(this.getPropertiesMenuItem());
            this.moMenu.add(this.getSearchMenuItem());
            this.getGotoMenu();
            if (!this.gotoMenu.getText().equalsIgnoreCase(EMPTY_STRING)) {
                this.moMenu.add(this.gotoMenu);
            }
            this.moMenu.add(this.getMoHelpMenuItem());
            this.moMenu.addSeparator();
            this.moMenu.add(this.getAddMenuItem());
            this.moMenu.add(this.getCloneMenuItem());
            this.moMenu.add(this.getDeleteMenuItem());
            this.moMenu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent event) {
                    if (null != Gui.this.myView && Gui.this.connected) {
                        String selectedLdn = Gui.this.myView.getSelectedLDN();
                        if (null == selectedLdn || selectedLdn.equals(Gui.EMPTY_STRING)) {
                            Gui.this.propertiesMenuItem.setEnabled(false);
                            Gui.this.gotoMenu.setEnabled(false);
                            Gui.this.moHelpMenuItem.setEnabled(false);
                            Gui.this.addMenuItem.setEnabled(false);
                            Gui.this.cloneMenuItem.setEnabled(false);
                            Gui.this.deleteMenuItem.setEnabled(false);
                        } else {
                            Gui.this.propertiesMenuItem.setEnabled(true);
                            Gui.this.gotoMenu.setEnabled(true);
                            Gui.this.moHelpMenuItem.setEnabled(true);
                            if (Gui.this.myView.getName().equals("Containment (MOM based)")) {
                                Gui.this.addMenuItem.setEnabled(true);
                                Gui.this.cloneMenuItem.setEnabled(true);
                                Gui.this.deleteMenuItem.setEnabled(true);
                            } else {
                                Gui.this.addMenuItem.setEnabled(false);
                                Gui.this.cloneMenuItem.setEnabled(false);
                                Gui.this.deleteMenuItem.setEnabled(true);
                            }
                        }
                    } else {
                        Gui.this.propertiesMenuItem.setEnabled(false);
                        Gui.this.gotoMenu.setEnabled(false);
                        Gui.this.moHelpMenuItem.setEnabled(false);
                        Gui.this.addMenuItem.setEnabled(false);
                        Gui.this.cloneMenuItem.setEnabled(false);
                        Gui.this.deleteMenuItem.setEnabled(false);
                        Gui.this.searchMenuItem.setEnabled(false);
                    }
                }

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }
            });
        }
        return this.moMenu;
    }

    private JMenu getAlarmMenu() {
        if (this.alarmMenu == null) {
            this.alarmMenu = new JMenu();
            this.alarmMenu.setText("Alarm");
            this.alarmMenu.setMnemonic('l');
            JMenuItem[] alarmsMenuItems = this.getAlarmMenuItems();
            for (int i = 0; i < alarmsMenuItems.length; ++i) {
                this.alarmMenu.add(alarmsMenuItems[i]);
            }
        }
        return this.alarmMenu;
    }

    private JMenuItem[] getAlarmMenuItems() {
        NexLog.logger().log(Level.INFO, " getAlarmMenuItems()");
        Collection<String> alarmToolsCollection = this.myToolServices.getAvailableAlarmTools();
        JMenuItem[] alarmMenuItems = new JMenuItem[alarmToolsCollection.size()];
        int index = 0;
        for (String name : alarmToolsCollection) {
            alarmMenuItems[index] = new JMenuItem(name);
            final String toolName = name;
            alarmMenuItems[index].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts  alarm tool " + toolName);
                    try {
                        Properties props = Gui.this.myToolServices.getConfiguration().getSupersedingProperties();
                        Gui.this.myToolServices.startAlarmTool(toolName, props);
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start Tool " + toolName + " " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start Tool " + toolName, e1, true);
                    }
                }
            });
            ++index;
        }
        return alarmMenuItems;
    }

    private JMenu getHelpMenu() {
        if (this.jHelpMenu == null) {
            this.jHelpMenu = new JMenu();
            this.jHelpMenu.setText("Help");
            this.jHelpMenu.setMnemonic('H');
            this.getHelpMenuItems();
            for (int i = 0; i < this.helpMenuItems.length; ++i) {
                this.jHelpMenu.add(this.helpMenuItems[i]);
                if (i != 2) continue;
                this.jHelpMenu.addSeparator();
            }
        }
        return this.jHelpMenu;
    }

    private void getHelpMenuItems() {
        NexLog.logger().log(Level.INFO, " getHelpsMenuItems()");
        if (this.helpMenuItems == null) {
            String aboutName = "About " + this.myConfig.getManagerName();
            final ArrayList<HelpRecord> helpsCollection = new ArrayList<HelpRecord>();
            helpsCollection.add(new HelpRecord("On Window", "Element Manager", "MainWindowHelp", "O", "Element Manager User Guide"));
            helpsCollection.add(new HelpRecord("System Library", "System Library", EMPTY_STRING, "L", "Display ALEX library for this node"));
            helpsCollection.add(new HelpRecord("Using Help", EMPTY_STRING, EMPTY_STRING, "U", "Explanation of the help configuration"));
            helpsCollection.add(new HelpRecord(aboutName, EMPTY_STRING, EMPTY_STRING, "A", "Display product numbers and versions"));
            this.helpMenuItems = new JMenuItem[helpsCollection.size()];
            block5: for (int i = 0; i < helpsCollection.size(); ++i) {
                this.helpMenuItems[i] = new JMenuItem();
                this.helpMenuItems[i].setText(((HelpRecord)helpsCollection.get(i)).getName());
                if (((HelpRecord)helpsCollection.get(i)).hasMnemonic()) {
                    this.helpMenuItems[i].setMnemonic(((HelpRecord)helpsCollection.get(i)).getMnemonic().charAt(0));
                }
                if (((HelpRecord)helpsCollection.get(i)).hasToolTip()) {
                    this.helpMenuItems[i].setToolTipText(((HelpRecord)helpsCollection.get(i)).getToolTip());
                }
                final int this_i = i;
                final String helpName = ((HelpRecord)helpsCollection.get(i)).getName();
                switch (i) {
                    case 2: {
                        this.helpMenuItems[i].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Gui.this.displayUsingHelp();
                            }
                        });
                        continue block5;
                    }
                    case 3: {
                        this.helpMenuItems[i].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                NexLog.logger().log(Level.INFO, " Starts help " + helpName);
                                HelpServiceI helpServ = Gui.this.myToolServices.getHelpService();
                                if (null != helpServ) {
                                    helpServ.displayAbout(Gui.this.myConfig.getManagerName(), Gui.this.myToolServices.getConfigurationFiles(), Gui.this.getFrame(), null, "XSD Schema: " + Gui.this.myConfig.getXsdFileName(), COPYRIGHT_YEAR, Gui.XERCES_ACK);
                                }
                            }
                        });
                        continue block5;
                    }
                    case 0: {
                        this.helpMenuItems[i].setAccelerator(KeyStroke.getKeyStroke(112, 0));
                    }
                    default: {
                        this.helpMenuItems[i].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                NexLog.logger().log(Level.INFO, " Starts help " + helpName);
                                try {
                                    Properties props = new Properties();
                                    props.setProperty("DOC_TITLE", ((HelpRecord)helpsCollection.get(this_i)).getDoc());
                                    props.setProperty("SECTION_TAG", ((HelpRecord)helpsCollection.get(this_i)).getSec());
                                    Gui.this.myToolServices.startHelpTool(props);
                                }
                                catch (StartFailureException e1) {
                                    NexLog.logger().log(Level.WARNING, "Can not start Tool " + helpName + " " + NexLog.stackToString(e1));
                                    Gui.this.setMessage("Can not start Tool " + helpName, e1, true);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private void displayUsingHelp() {
        HelpServiceI help = this.myToolServices.getHelpService();
        if (null != help) {
            help.displayUsingHelp(this.getFrame());
        }
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.add((Component)this.getStatusTextField(), "Center");
            this.clockIconPanel = new JPanel(new BorderLayout());
            this.clockIconPanel.add((Component)this.getTraceField(), "West");
            this.clockIconPanel.add((Component)this.getClockField(), "Center");
            this.clockIconPanel.add((Component)this.getIconLabel(), "East");
            this.statusPanel.add((Component)this.clockIconPanel, "East");
        }
        return this.statusPanel;
    }

    public JTextField getTraceField() {
        if (this.traceField == null) {
            this.traceField = new JTextField(EMPTY_STRING, 6);
            this.traceField.setEditable(false);
            this.traceField.setOpaque(false);
            this.traceField.setText(EMPTY_STRING);
        }
        if (this.isLoggingEnabled()) {
            this.notifyTraceEnabled();
        }
        return this.traceField;
    }

    public JTextField getClockField() {
        if (this.clockField == null) {
            this.clockField = new JTextField(EMPTY_STRING, 12);
            this.clockField.setEditable(false);
            this.clockField.setOpaque(false);
            this.clockField.setText(this.myNodeTime.getTime());
            this.clockField.setToolTipText("Node UTC time");
        }
        this.clockTimerGetTime = new Timer(2000, new ActionListener(){
            String tooltipLead = "Node UTC time: ";
            String time;

            public void actionPerformed(ActionEvent actionEvent) {
                this.time = Gui.this.myNodeTime.getTime();
                Gui.this.clockField.setText(this.time);
                Gui.this.clockField.setToolTipText(this.tooltipLead + this.time);
                Gui.this.updateStateInfoPanel();
            }
        });
        this.clockTimerGetTime.start();
        return this.clockField;
    }

    private void updateStateInfoPanel() {
        if (this.myView != null) {
            this.stateMoParams = this.myConfig.getStateMoParams();
            NodeStateIcon[] iconLabelArray = null;
            if (null != this.stateMoParams && this.stateMoParams.length > 0) {
                iconLabelArray = this.nodeStateUpdater.getNodeStateIcons();
            }
            this.myView.setNodeStateIcons(iconLabelArray);
        }
    }

    private JLabel getIconLabel() {
        if (this.iconLabel == null) {
            this.ericssonImage = Toolkit.getDefaultToolkit().getImage(Gui.class.getResource("ericsson_logo.gif"));
            this.ericssonIcon = new ImageIcon(this.ericssonImage);
            this.iconLabel = new JLabel(EMPTY_STRING, this.ericssonIcon, 4);
        }
        return this.iconLabel;
    }

    private JTextField getStatusTextField() {
        this.statusTextField.setEditable(false);
        this.statusTextField.setOpaque(false);
        return this.statusTextField;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.getTopPanel(), 1));
            this.topPanel.add((Component)this.getSelectViewPanel(), null);
        }
        return this.topPanel;
    }

    private JPanel getSelectViewPanel() {
        if (this.selectViewPanel == null) {
            this.selectViewPanel = new JPanel();
            this.selectViewPanel.setName("selectViewPanel");
            this.selectViewPanel.setLayout(new FlowLayout(3));
            this.selectViewPanel.add((Component)this.getPreviousButton(), null);
            this.selectViewPanel.add((Component)this.getNextButton(), null);
            this.selectViewPanel.add((Component)this.getViewNamesComboBox(), null);
            this.selectViewPanel.add((Component)this.getViewDescrButton(), null);
        }
        return this.selectViewPanel;
    }

    private JMenuItem getImportViewMenuItem() {
        if (this.importViewMenuItem == null) {
            this.importViewMenuItem = new JMenuItem();
            this.importViewMenuItem.setText("Import View File...");
            this.importViewMenuItem.setMnemonic(73);
            this.importViewMenuItem.setName("importViewMenuItem");
            this.importViewMenuItem.setToolTipText("Add a View XML file to available views");
            this.importViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Import action");
                    JFileChooser fileChooser = null != Gui.this.lastOpenViewDir ? new JFileChooser(Gui.this.lastOpenViewDir) : new JFileChooser();
                    XmlFileFilter filter = new XmlFileFilter();
                    fileChooser.setFileFilter(filter);
                    fileChooser.setMultiSelectionEnabled(true);
                    int returnVal = fileChooser.showOpenDialog(Gui.this.comp);
                    if (returnVal == 0) {
                        NexLog.logger().log(Level.INFO, " Import file " + fileChooser.getSelectedFile().getName());
                        Gui.this.lastOpenViewDir = fileChooser.getSelectedFile().getParentFile();
                        File[] fileArr = fileChooser.getSelectedFiles();
                        for (int i = 0; i < fileArr.length; ++i) {
                            Gui.this.myViewServices.importView(fileArr[i]);
                        }
                    }
                }
            });
        }
        return this.importViewMenuItem;
    }

    private JMenuItem getExportModelMenuItem() {
        if (this.exportModelMenuItem == null) {
            this.exportModelMenuItem = new JMenuItem();
            this.exportModelMenuItem.setText("Export View File...");
            this.exportModelMenuItem.setMnemonic('t');
            this.exportModelMenuItem.setName("exportModelMenuItem");
            this.exportModelMenuItem.setToolTipText("Export the View model to an XML (.xml) file");
            this.exportModelMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Export model action");
                    if (Gui.this.myView.getName().equals("Containment (MOM based)")) {
                        Gui.this.setMessage("No XML model is defined for the Containment View.", Gui.EMPTY_STRING, false);
                        return;
                    }
                    String defaultPath = System.getProperty("user.home");
                    if (null == defaultPath) {
                        NexLog.logger().log(Level.SEVERE, " Error retrieving user home directory");
                        Gui.this.setMessage("Error retrieving user home directory", Gui.EMPTY_STRING, true);
                        defaultPath = Gui.EMPTY_STRING;
                    }
                    JFileChooser fileChooser = new JFileChooser(defaultPath);
                    fileChooser.setDialogTitle("Export View to XML File");
                    fileChooser.addChoosableFileFilter(new XmlFileFilter());
                    int returnVal = fileChooser.showSaveDialog(Gui.this.comp);
                    if (0 == returnVal) {
                        File file = fileChooser.getSelectedFile();
                        NexLog.logger().log(Level.INFO, " Export model file " + file.getName());
                        if (file.getName().indexOf(46) == -1) {
                            file = new File(file.getAbsolutePath() + ".xml");
                        }
                        if (file.exists()) {
                            NexLog.logger().log(Level.INFO, " file already exists");
                            Object[] options = new Object[]{"Overwrite", "Cancel"};
                            JOptionPane pane = new JOptionPane(file.toString() + " already exists.\nDo you want to replace it?", 3, 2, null, options);
                            JDialog jDialog = pane.createDialog(Gui.this.getFrame(), "Confirm Overwrite");
                            jDialog.setVisible(true);
                            Object response = pane.getValue();
                            if (null == response) {
                                return;
                            }
                            if (!response.equals("Overwrite")) {
                                return;
                            }
                        }
                        try {
                            FileWriter fileW = new FileWriter(file);
                            fileW.write(Gui.this.myView.getViewModel().getXmlModelString());
                            fileW.close();
                        }
                        catch (Exception ex) {
                            NexLog.logger().log(Level.SEVERE, " Exception while writing to file" + NexLog.stackToString(ex));
                            Gui.this.setMessage("Exception while writing to file", ex, true);
                        }
                    }
                }
            });
        }
        return this.exportModelMenuItem;
    }

    private JButton getPreviousButton() {
        if (this.previousButton == null) {
            Image backImage = Toolkit.getDefaultToolkit().getImage(Gui.class.getResource("arrow_back.png"));
            ImageIcon backImIcon = new ImageIcon(backImage);
            this.previousButton = new JButton(backImIcon);
            this.previousButton.setName("previousViewButton");
            this.previousButton.setToolTipText("Go back to previous view");
            this.previousButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.setStatusMessage(Gui.EMPTY_STRING);
                    if (initValue) {
                        ButtonHandler previousButtonHandler = ButtonHandler.getInstance();
                        previousButtonHandler.putViewServicesData(Gui.this.myViewServices);
                        initValue = false;
                    } else {
                        Gui.this.myViewServices.setPreviousView();
                    }
                }
            });
            this.previousButton.setEnabled(false);
        }
        return this.previousButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            Image forwardImage = Toolkit.getDefaultToolkit().getImage(Gui.class.getResource("arrow_forward.png"));
            ImageIcon forwardImIcon = new ImageIcon(forwardImage);
            this.nextButton = new JButton(forwardImIcon);
            this.nextButton.setName("nextViewButton");
            this.nextButton.setToolTipText("Go forward in the view history");
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.setStatusMessage(Gui.EMPTY_STRING);
                    Gui.this.myViewServices.setNextView();
                }
            });
            this.nextButton.setEnabled(false);
        }
        return this.nextButton;
    }

    private JComboBox getViewNamesComboBox() {
        if (this.viewNamesComboBox == null) {
            this.viewNamesComboBox = new JComboBox();
            this.viewNamesComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Gui.this.listenToCreateViewAction) {
                        return;
                    }
                    final String selectedView = (String)Gui.this.viewNamesComboBox.getItemAt(Gui.this.viewNamesComboBox.getSelectedIndex());
                    if (null != selectedView && selectedView.length() > 0 && (selectedView.equals("-------IMPORTED VIEWS----------") || selectedView.equals("-------PREDEFINED VIEWS------") || selectedView.equals("-------USER-DEFINED VIEWS-----"))) {
                        Gui.this.listenToCreateViewAction = false;
                        Gui.this.viewNamesComboBox.setSelectedItem(Gui.this.myView.getName());
                        Gui.this.listenToCreateViewAction = true;
                        return;
                    }
                    String ldn = Gui.EMPTY_STRING;
                    if (null != Gui.this.myView) {
                        ldn = Gui.this.myView.getSelectedLDN();
                    }
                    final String myLdn = ldn;
                    Runnable runner = new Runnable(){

                        public void run() {
                            if (!Gui.this.myViewServices.startView(selectedView, myLdn) && null != Gui.this.myView) {
                                Gui.this.listenToCreateViewAction = false;
                                Gui.this.viewNamesComboBox.setSelectedItem(Gui.this.myView.getName());
                                Gui.this.listenToCreateViewAction = true;
                            }
                        }
                    };
                    new Thread(runner).start();
                }
            });
        }
        return this.viewNamesComboBox;
    }

    private JButton getViewDescrButton() {
        if (this.viewDescrButton == null) {
            this.viewDescrButton = new JButton();
            this.viewDescrButton.setText("View Descriptions");
            this.viewDescrButton.setMnemonic('D');
            this.viewDescrButton.setEnabled(false);
            this.viewDescrButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().info("open View Descriptions");
                    String viewName = Gui.EMPTY_STRING;
                    if (null != Gui.this.myView) {
                        viewName = Gui.this.myView.getName();
                    }
                    if (null == Gui.this.viewDescriptionDia || !Gui.this.viewDescriptionDia.isVisible()) {
                        Gui.this.viewDescriptionDia = new ViewSelectionDialog(Gui.this, "View Descriptions", Gui.this.myViewServices, viewName, Gui.this.myToolServices, Gui.this.myConfig, false);
                        Gui.this.viewDescriptionDia.setVisible(true);
                    } else {
                        Gui.this.viewDescriptionDia.selectView(viewName);
                        Gui.this.viewDescriptionDia.toFront();
                    }
                }
            });
        }
        return this.viewDescrButton;
    }

    private JMenuItem getViewOpenMenuItem() {
        if (this.viewOpenMenuItem == null) {
            this.viewOpenMenuItem = new JMenuItem();
            this.viewOpenMenuItem.setText("Open View...");
            this.viewOpenMenuItem.setMnemonic('o');
            this.viewOpenMenuItem.setName("viewOpenMenuItem");
            this.viewOpenMenuItem.setToolTipText("Display names and descriptions of View files to open");
            this.viewOpenMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Open view dialog from menu action");
                    if (null == Gui.this.openViewDia || !Gui.this.openViewDia.isVisible()) {
                        Gui.this.openViewDia = new ViewSelectionDialog(Gui.this, "Open View", Gui.this.myViewServices, Gui.EMPTY_STRING, Gui.this.myToolServices, Gui.this.myConfig, true);
                        Gui.this.openViewDia.setVisible(true);
                    } else {
                        Gui.this.openViewDia.toFront();
                    }
                }
            });
        }
        return this.viewOpenMenuItem;
    }

    private JMenuItem getExportViewMenuItem() {
        if (this.exportViewMenuItem == null) {
            this.exportViewMenuItem = new JMenuItem();
            this.exportViewMenuItem.setText("Export View Contents...");
            this.exportViewMenuItem.setMnemonic('s');
            this.exportViewMenuItem.setName("exportViewMenuItem");
            this.exportViewMenuItem.setToolTipText("Export the View table contents to a text file or an Excel (.xls) file");
            this.exportViewMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Export action");
                    String defaultPath = System.getProperty("user.home");
                    if (null == defaultPath) {
                        NexLog.logger().log(Level.SEVERE, " Error retrieving user home directory");
                        Gui.this.setMessage("Error retrieving user home directory", Gui.EMPTY_STRING, true);
                        defaultPath = Gui.EMPTY_STRING;
                    }
                    JFileChooser fileChooser = new JFileChooser(defaultPath);
                    fileChooser.setDialogTitle("Export View Contents to a Text or Excel File");
                    fileChooser.addChoosableFileFilter(new TxtFileFilter());
                    fileChooser.addChoosableFileFilter(new XlsFileFilter());
                    int returnVal = fileChooser.showSaveDialog(Gui.this.comp);
                    if (0 == returnVal) {
                        File file = fileChooser.getSelectedFile();
                        NexLog.logger().log(Level.INFO, " Export file " + file.getName());
                        if (fileChooser.getFileFilter().getDescription().indexOf(".xls") > -1) {
                            if (file.getName().indexOf(46) == -1) {
                                file = new File(file.getAbsolutePath() + ".xls");
                            }
                        } else if (fileChooser.getFileFilter().getDescription().indexOf(".txt") > -1 && file.getName().indexOf(46) == -1) {
                            file = new File(file.getAbsolutePath() + ".txt");
                        }
                        if (file.exists()) {
                            NexLog.logger().log(Level.INFO, " file already exists");
                            Object[] options = new Object[]{"Overwrite", "Cancel"};
                            JOptionPane pane = new JOptionPane(file.toString() + " already exists.\nDo you want to replace it?", 3, 2, null, options);
                            JDialog jDialog = pane.createDialog(Gui.this.getFrame(), "Confirm Overwrite");
                            jDialog.setVisible(true);
                            Object response = pane.getValue();
                            if (null == response) {
                                return;
                            }
                            if (!response.equals("Overwrite")) {
                                return;
                            }
                        }
                        try {
                            FileWriter fileW = new FileWriter(file);
                            fileW.write(Gui.this.myView.getExportString());
                            fileW.close();
                        }
                        catch (Exception ex) {
                            NexLog.logger().log(Level.SEVERE, " Exception while writing to file" + NexLog.stackToString(ex));
                            Gui.this.setMessage("Exception while writing to file", ex, true);
                        }
                    }
                }
            });
        }
        return this.exportViewMenuItem;
    }

    private void userClosing() {
        NexLog.logger().log(Level.INFO, "User closing NEX");
        Collection<String> appNames = this.myToolServices.getStartedTools();
        if (1 == appNames.size()) {
            String qu = "You are about to exit " + this.myConfig.getTitle() + " connected to " + this.myToolServices.getHostAddress() + ".";
            String dialogTitle = this.myConfig.getTitle() + " - Confirm Exit";
            Object[] opt = new Object[]{"Exit", "Cancel"};
            int answ = JOptionPane.showOptionDialog(this.getFrame(), qu, dialogTitle, 2, 3, null, opt, opt[0]);
            if (0 == answ) {
                NexLog.logger().log(Level.INFO, "User closing NEX");
                this.myNodeTime.destroy();
                this.clockTimerGetTime.stop();
                this.myToolServices.exitNex();
            }
        } else if (appNames.size() > 1) {
            StringBuilder appStrings = new StringBuilder();
            for (String name : appNames) {
                appStrings.append(name);
                appStrings.append("\n");
            }
            String question = "Do you want to exit " + this.myConfig.getTitle() + " Main Window,\nor exit all following tools towards " + this.myToolServices.getHostAddress() + "?\n\n" + appStrings.toString();
            Object[] options = new Object[]{"Exit Main Window", "Exit All", "Cancel"};
            int n = JOptionPane.showOptionDialog(this.getFrame(), question, this.myConfig.getTitle() + " - Confirm Exit", 1, 3, null, options, options[0]);
            if (0 == n) {
                NexLog.logger().log(Level.INFO, "User closing only NEX");
                this.myNodeTime.destroy();
                this.clockTimerGetTime.stop();
                this.myToolServices.exitNex();
            } else if (1 == n) {
                NexLog.logger().log(Level.INFO, "User closing all tools");
                this.myNodeTime.destroy();
                this.clockTimerGetTime.stop();
                this.myToolServices.exitAllTools();
            }
        }
    }

    private JCheckBoxMenuItem getShowRelMenuItem() {
        if (this.showRelMenuItem == null) {
            this.showRelMenuItem = new JCheckBoxMenuItem();
            this.showRelMenuItem.setText("Show Relations");
            this.showRelMenuItem.setToolTipText("In the tree, display relation type prefix to the names");
            this.showRelMenuItem.setMnemonic('R');
            this.showRelMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.showPrefix = Gui.this.showRelMenuItem.isSelected();
                    ((GuiView)Gui.this.myView).updatePrefix();
                }
            });
        }
        return this.showRelMenuItem;
    }

    private JCheckBoxMenuItem getShowLdnColumnMenuItem() {
        if (this.showLdnColumnMenuItem == null) {
            this.showLdnColumnMenuItem = new JCheckBoxMenuItem();
            this.showLdnColumnMenuItem.setText("Show LDN Column");
            this.showLdnColumnMenuItem.setToolTipText("Display an LDN column in the attribute table");
            this.showLdnColumnMenuItem.setMnemonic('L');
            this.showLdnColumnMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.myView.setShowLdnColumn(Gui.this.showLdnColumnMenuItem.isSelected());
                }
            });
        }
        return this.showLdnColumnMenuItem;
    }

    private JMenuItem getAddColumnMenuItem() {
        if (this.addColumnMenuItem == null) {
            this.addColumnMenuItem = new JMenuItem();
            this.addColumnMenuItem.setText("Add Attribute Column...");
            this.addColumnMenuItem.setToolTipText("Add a column the attribute table, for a specific attribute.");
            this.addColumnMenuItem.setMnemonic('A');
            this.addColumnMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object inputObj;
                    if (null == Gui.this.myView) {
                        return;
                    }
                    Object[] options = new Object[]{"Add", "Cancel"};
                    JOptionPane pane = new JOptionPane("Select attribute:", 1, 0, null, options, options[0]);
                    Object[] attributeNames = Gui.this.myViewServices.getMomAttributes().toArray();
                    pane.setSelectionValues(attributeNames);
                    JDialog jDialog = pane.createDialog(Gui.this.getFrame(), "Add Attribute Column");
                    jDialog.setVisible(true);
                    Object answer = pane.getValue();
                    if (null != answer && answer.equals("Add") && null != (inputObj = pane.getInputValue()) && inputObj instanceof String && ((String)inputObj).length() > 0) {
                        Gui.this.myView.addColumnByClient((String)inputObj);
                    }
                }
            });
        }
        return this.addColumnMenuItem;
    }

    private JMenuItem getRemoveColumnMenuItem() {
        if (this.removeColumnMenuItem == null) {
            this.removeColumnMenuItem = new JMenuItem();
            this.removeColumnMenuItem.setText("Remove Attribute Column...");
            this.removeColumnMenuItem.setToolTipText("Remove one of the added attribute columns from the attribute table");
            this.removeColumnMenuItem.setMnemonic('v');
            this.removeColumnMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (null == Gui.this.myView) {
                        return;
                    }
                    String input = null;
                    Object[] possibleValues = Gui.this.myView.getColumnNamesAddedByUser().toArray(new String[0]);
                    Object[] options = new Object[]{"Remove", "Cancel"};
                    JOptionPane pane = new JOptionPane("Select column to be removed:", 1, 0, null, options, options[0]);
                    pane.setSelectionValues(possibleValues);
                    JDialog jDialog = pane.createDialog(Gui.this.getFrame(), "Remove Attribute Column");
                    jDialog.setVisible(true);
                    Object selectedButtonText = pane.getValue();
                    if (null != selectedButtonText && !selectedButtonText.equals("Cancel")) {
                        Object inputValue = pane.getInputValue();
                        input = (String)inputValue;
                    }
                    if (null != input && input.length() > 0) {
                        Gui.this.myView.removeColumnByClient(input);
                    }
                }
            });
        }
        return this.removeColumnMenuItem;
    }

    private JMenuItem getExpandMenuItem() {
        if (this.expandMenuItem == null) {
            this.expandMenuItem = new JMenuItem();
            this.expandMenuItem.setText("Expand Below");
            this.expandMenuItem.setToolTipText("Expand the selected tree node, and all subnodes below it.");
            this.expandMenuItem.setMnemonic('d');
            this.expandMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.myView.expandAll();
                }
            });
        }
        return this.expandMenuItem;
    }

    private JMenuItem getPropertiesMenuItem() {
        if (this.propertiesMenuItem == null) {
            this.propertiesMenuItem = new JMenuItem();
            this.propertiesMenuItem.setText("Properties");
            this.propertiesMenuItem.setToolTipText("Open a separate window displaying the properties of the selected MO");
            this.propertiesMenuItem.setMnemonic('P');
            this.propertiesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts Properties Tool");
                    try {
                        Properties props = Gui.this.myConfig.getSupersedingProperties();
                        String selectedLdns = Gui.this.myView.getSelectedLDNs();
                        if (selectedLdns != null) {
                            props.put("LDNs", selectedLdns);
                        }
                        Gui.this.myToolServices.startMoPropsTool(props);
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start Properties Tool " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start Properties Tool", e1, true);
                    }
                }
            });
        }
        return this.propertiesMenuItem;
    }

    private JMenuItem getSearchMenuItem() {
        if (this.searchMenuItem == null) {
            this.searchMenuItem = new JMenuItem();
            this.searchMenuItem.setText("Search...");
            this.searchMenuItem.setToolTipText("Open a separate search window, starting search from the selected MO");
            this.searchMenuItem.setMnemonic('S');
            this.searchMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
            this.searchMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts Search MO");
                    try {
                        Properties props = Gui.this.myConfig.getSupersedingProperties();
                        String selectedLdn = Gui.this.myView.getSelectedLDN();
                        if (null != selectedLdn) {
                            props.put("LDNs", selectedLdn);
                            Gui.this.myToolServices.startSearchTool(props);
                        }
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start Search MO " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start Search MO", e1, true);
                    }
                }
            });
        }
        return this.searchMenuItem;
    }

    private JMenu getGotoMenu() {
        Collection<String> hyperNames = this.myToolServices.getAvailableHyperTools();
        if (hyperNames.isEmpty()) {
            this.gotoMenu = new JMenu(EMPTY_STRING);
            return this.gotoMenu;
        }
        this.gotoMenu = new JMenu("Open In");
        this.gotoMenu.setToolTipText("Open a tool in a separate window, in the context of the selected MO");
        this.gotoMenu.setMnemonic('O');
        ActionListener menuItemListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem menuItem = (JMenuItem)actionEvent.getSource();
                String ldn = Gui.this.myView.getSelectedLDN();
                if (Gui.EMPTY_STRING == ldn) {
                    NexLog.logger().info("No selected row.");
                } else {
                    Properties props = Gui.this.myConfig.getSupersedingProperties();
                    props.put("LDNs", ldn);
                    try {
                        Gui.this.myToolServices.startHyperTool(menuItem.getText(), props);
                    }
                    catch (Exception ex) {
                        NexLog.logger().warning("Was not able to launch the tool ." + menuItem.getText() + "\n" + ex.getMessage());
                        Gui.this.setMessage("Failed to start the tool " + menuItem.getText(), ex, false);
                    }
                }
            }
        };
        for (String hypertoolName : hyperNames) {
            JMenuItem tmpMenuItem = new JMenuItem(hypertoolName);
            tmpMenuItem.addActionListener(menuItemListener);
            this.gotoMenu.add(tmpMenuItem);
        }
        return this.gotoMenu;
    }

    private JMenuItem getMoHelpMenuItem() {
        if (this.moHelpMenuItem == null) {
            this.moHelpMenuItem = new JMenuItem();
            this.moHelpMenuItem.setText("Help");
            this.moHelpMenuItem.setToolTipText("Display help on selected MO");
            this.moHelpMenuItem.setMnemonic('H');
            this.moHelpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts MO Help");
                    try {
                        String selectedLdn = Gui.this.myView.getSelectedLDN();
                        if (null != selectedLdn) {
                            Properties props = new Properties();
                            int start = selectedLdn.lastIndexOf(44) + 1;
                            int end = selectedLdn.lastIndexOf(61);
                            String moType = selectedLdn.substring(start, end);
                            props.setProperty("DOC_TITLE", "class " + moType);
                            props.setProperty("SECTION_TAG", Gui.EMPTY_STRING);
                            Gui.this.myToolServices.startHelpTool(props);
                        }
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start MO Help " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start MO Help", e1, true);
                    }
                }
            });
        }
        return this.moHelpMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem();
            this.deleteMenuItem.setText("Delete");
            this.deleteMenuItem.setToolTipText("Delete the selected MO instance in the Network Element");
            this.deleteMenuItem.setMnemonic('D');
            this.deleteMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.myView.deleteSelectedMOs();
                }
            });
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.jExitMenuItem == null) {
            this.jExitMenuItem = new JMenuItem();
            this.jExitMenuItem.setText("Exit");
            this.jExitMenuItem.setToolTipText("Exit Element Manager");
            this.jExitMenuItem.setMnemonic('x');
            this.jExitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.userClosing();
                }
            });
        }
        return this.jExitMenuItem;
    }

    public void getEmTraceLog() {
        String toolName = this.myToolServices.getEmTraceLog().getName();
        NexLog.logger().log(Level.INFO, " Starts " + toolName + " Tool");
        try {
            Properties props = this.myToolServices.getConfiguration().getSupersedingProperties();
            props.setProperty("LOG_NAME", "se.ericsson.cello.nex");
            LogServices emLogServices = this.myToolServices.startEmTraceLogTool(props);
            emLogServices.registerListener((LogStatusListener)this.comp);
        }
        catch (StartFailureException e1) {
            NexLog.logger().log(Level.WARNING, "Can not start " + toolName + " Tool " + NexLog.stackToString(e1));
            this.setMessage("Can not start " + toolName + " Tool", e1, true);
        }
    }

    public void restoreFrame() {
        this.setState(0);
    }

    private JMenuItem getAddMenuItem() {
        if (this.addMenuItem == null) {
            this.addMenuItem = new JMenuItem();
            this.addMenuItem.setMnemonic(65);
            this.addMenuItem.setText("Add...");
            this.addMenuItem.setToolTipText("Open a window for adding MO instances below the selected MO");
            this.addMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts Add MO");
                    try {
                        Properties props = Gui.this.myConfig.getSupersedingProperties();
                        String selectedLdns = Gui.this.myView.getSelectedLDNs();
                        props.put("LDNs", selectedLdns);
                        Gui.this.myToolServices.startAddMoTool(props);
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start Add MO " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start Add MO", e1, true);
                    }
                }
            });
        }
        return this.addMenuItem;
    }

    private JMenuItem getCloneMenuItem() {
        if (this.cloneMenuItem == null) {
            this.cloneMenuItem = new JMenuItem();
            this.cloneMenuItem.setMnemonic(67);
            this.cloneMenuItem.setText("Clone...");
            this.cloneMenuItem.setToolTipText("Open a window for cloning a selected MO instance");
            this.cloneMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NexLog.logger().log(Level.INFO, " Starts Add MO with clone funtionality");
                    try {
                        Properties props = Gui.this.myConfig.getSupersedingProperties();
                        String cloneMOLdn = Gui.this.myView.getSelectedLDNs();
                        String parentLdnOfCloneMO = Gui.this.getParentFromCloneMo(cloneMOLdn);
                        props.put("SOURCE_MO", cloneMOLdn);
                        props.put("LDNs", parentLdnOfCloneMO);
                        Gui.this.myToolServices.startAddMoTool(props);
                    }
                    catch (StartFailureException e1) {
                        NexLog.logger().log(Level.WARNING, "Can not start Add MO with clone functionality " + NexLog.stackToString(e1));
                        Gui.this.setMessage("Can not start Add MO with clone functionality", e1, true);
                    }
                }
            });
        }
        return this.cloneMenuItem;
    }

    @Override
    public boolean getConfirmationToProceed(String title, String message, String yesOption, String noOption) {
        boolean confirmationValue = false;
        JPanel confPanel = new JPanel();
        confPanel.setLayout(new BoxLayout(confPanel, 1));
        Object[] options = new Object[]{yesOption, noOption};
        int response = JOptionPane.showOptionDialog(this.getFrame(), message, title, 0, 3, null, options, noOption);
        if (response == 1) {
            confirmationValue = false;
        } else if (response == 0) {
            confirmationValue = true;
        } else if (response == -1) {
            confirmationValue = false;
        }
        return confirmationValue;
    }

    public boolean getConfirmationToProceed(String title, String infoText, String message, String yesOption, String noOption) {
        boolean confirmationValue = false;
        int width = 500;
        JTextArea textArea = new JTextArea(message);
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        scrollPane.setPreferredSize(new Dimension(width, 130));
        JPanel contents = new JPanel();
        JLabel infoLabel = new JLabel(infoText);
        contents.setLayout(new BoxLayout(contents, 1));
        infoLabel.setAlignmentX(0.0f);
        scrollPane.setAlignmentX(0.0f);
        contents.add(infoLabel);
        contents.add(Box.createRigidArea(new Dimension(0, 7)));
        contents.add(scrollPane);
        contents.add(Box.createRigidArea(new Dimension(0, 7)));
        Object[] options = new Object[]{yesOption, noOption};
        int response = JOptionPane.showOptionDialog(null, contents, title, 0, 3, null, options, noOption);
        if (response == 1) {
            confirmationValue = false;
        } else if (response == 0) {
            confirmationValue = true;
        } else if (response == -1) {
            confirmationValue = false;
        }
        return confirmationValue;
    }

    @Override
    public void updateTitleForInitialTool() {
        Runnable myUppdateRunner = new Runnable(){

            public void run() {
                Gui.this.setTitle(Gui.this.myToolServices.getHostAddress() + " - " + Gui.this.myConfig.getTitle());
                NexLog.logger().log(Level.INFO, " updateTitleForInitialTool is successful.");
            }
        };
        SwingUtilities.invokeLater(myUppdateRunner);
    }

    public void notifyTraceDisabled() {
        this.traceField.setText(EMPTY_STRING);
    }

    public void notifyTraceEnabled() {
        this.traceField.setText("Trace On");
    }

    public boolean isLoggingEnabled() {
        Logger logger = Logger.getLogger("java.util.logging.FileHandler");
        return logger.isLoggable(Level.ALL) || logger.isLoggable(Level.CONFIG) || logger.isLoggable(Level.FINE) || logger.isLoggable(Level.FINER) || logger.isLoggable(Level.FINEST);
    }

    public String getParentFromCloneMo(String ldns) {
        StringBuilder parentLdn = new StringBuilder(EMPTY_STRING);
        String[] fullLdn = ldns.trim().split(";");
        String firstLdn = fullLdn[0];
        String[] ldnParts = firstLdn.trim().split(",");
        for (int i = 0; i < ldnParts.length - 1; ++i) {
            if (i > 0) {
                parentLdn.append(",");
            }
            parentLdn.append(ldnParts[i]);
        }
        return parentLdn.toString();
    }

    protected void gotoLDN(String ldn) {
        this.myViewServices.startView("Containment (MOM based)", ldn);
    }

    protected String getSelectedLdn() {
        String ldn = EMPTY_STRING;
        if (null != this.myView) {
            ldn = this.myView.getSelectedLDN();
        }
        return ldn;
    }

    protected void refreshRequested() {
        if (null != this.myView) {
            this.myView.refreshRequested();
        }
    }

    private static class ButtonHandler
    extends Thread {
        private static ButtonHandler instance = null;
        private static List<ViewServicesI> viewServicesList = new ArrayList<ViewServicesI>();

        private ButtonHandler() {
        }

        public static ButtonHandler getInstance() {
            if (instance == null) {
                instance = new ButtonHandler();
                instance.start();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putViewServicesData(ViewServicesI data) {
            List<ViewServicesI> list = viewServicesList;
            synchronized (list) {
                viewServicesList.add(data);
                viewServicesList.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<ViewServicesI> list = viewServicesList;
            synchronized (list) {
                if (viewServicesList.isEmpty()) {
                    try {
                        viewServicesList.wait();
                    }
                    catch (InterruptedException e) {
                        NexLog.logger().info("encounter InterruptedException : " + e);
                    }
                }
                Iterator<ViewServicesI> iterator = viewServicesList.iterator();
                while (iterator.hasNext()) {
                    ViewServicesI viewServicesI = iterator.next();
                    viewServicesI.setPreviousView();
                    iterator.remove();
                }
            }
        }
    }

    private static class HelpRecord {
        private String myHelpName = "";
        private String myDocument = "";
        private String mySection = "";
        private String myMnemonic = "";
        private String myToolTip = "";

        public HelpRecord(String helpName, String doc, String sec, String memo, String tip) {
            this.myHelpName = helpName;
            this.myDocument = doc;
            this.mySection = sec;
            this.myMnemonic = memo;
            this.myToolTip = tip;
        }

        public String getName() {
            return this.myHelpName;
        }

        public String getDoc() {
            return this.myDocument;
        }

        public String getSec() {
            return this.mySection;
        }

        public String getMnemonic() {
            return this.myMnemonic;
        }

        public String getToolTip() {
            return this.myToolTip;
        }

        public boolean hasMnemonic() {
            return this.myMnemonic.length() > 0;
        }

        public boolean hasToolTip() {
            return this.myToolTip.length() > 0;
        }
    }
}

