/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.InsertionJob;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyExpandToLDNWorker
extends ModelWorker<Collection<NexTreeNode>, InsertionJob> {
    private Collection<String> LDNs;
    private NexTreeNode parent;
    private ModelCallback<Collection<NexTreeNode>> callback;

    public PartiallyExpandToLDNWorker(MoTreeTableModel model, Collection<String> ldns, NexTreeNode p, ModelCallback<Collection<NexTreeNode>> cb) {
        super(model);
        this.LDNs = ldns;
        this.parent = p;
        this.callback = cb;
    }

    @Override
    protected Collection<NexTreeNode> doWork() throws Exception {
        ArrayList<NexTreeNode> nodes = new ArrayList<NexTreeNode>(this.LDNs.size());
        for (String ldn : this.LDNs) {
            NexTreeNode node = this.expandTo(ldn, this.parent);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    protected void process(List<InsertionJob> insertions) {
        for (InsertionJob insertion : insertions) {
            this.insertOrReplace(insertion.child, insertion.parent);
        }
    }

    private void insertOrReplace(NexTreeNode newChild, NexTreeNode parent) {
        int index = 0;
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            NexTreeNode aChild = (NexTreeNode)e.nextElement();
            int comp = newChild.getLongName().compareTo(aChild.getLongName());
            if (comp == 0) {
                this.getModel().removeNodeFromParent(aChild);
                break;
            }
            if (comp < 0) break;
            ++index;
        }
        this.getModel().insertNodeInto(newChild, parent, index);
    }

    private NexTreeNode expandTo(String ldn, NexTreeNode parent) throws Exception {
        if (parent.getLongName().equals(ldn)) {
            NexLog.logger().log(Level.INFO, "expandTo has FOUND the Node! ldn=" + ldn);
            return parent;
        }
        NexTreeNode result = this.partiallyExpand(parent, ldn);
        if (result == null) {
            return null;
        }
        if (ldn.equals(result.getLongName())) {
            return result;
        }
        return this.expandTo(ldn, result);
    }

    private NexTreeNode partiallyExpand(NexTreeNode parent, String ldn) throws Exception {
        if (!parent.getAllowsChildren()) {
            return null;
        }
        Enumeration<TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            NexTreeNode child = (NexTreeNode)children.nextElement();
            if (!ldn.equals(child.getLongName()) && (!ldn.startsWith(child.getLongName()) || !ldn.substring(child.getLongName().length()).startsWith(","))) continue;
            return child;
        }
        Collection<ViewElementI> childrenViewElements = parent.getViewElement().getChildren(this.getModel().getColumnNames());
        for (ViewElementI viewElem : childrenViewElements) {
            if (!ldn.equals(viewElem.getLdn()) && (!ldn.startsWith(viewElem.getLdn()) || !ldn.substring(viewElem.getLdn().length()).startsWith(","))) continue;
            NexTreeNode node = this.getModel().getNodeFactory().createNode(viewElem);
            this.publish(new InsertionJob[]{new InsertionJob(parent, node)});
            parent.setPartiallyExpanded(true);
            return node;
        }
        return null;
    }

    protected void done() {
        Collection result;
        block4: {
            result = new ArrayList();
            try {
                result = (Collection)this.get();
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in PartiallyExpandToLDNWorker.done(), ldn: " + this.LDNs + "\n" + NexLog.stackToString(e));
                if (this.callback == null) break block4;
                this.callback.setException(e);
            }
        }
        if (this.callback != null) {
            this.callback.run(result, this.isCancelled());
        }
    }

    public String toString() {
        return "Partially expanding LDNs: " + this.LDNs + ".";
    }
}

