/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view.workers;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.gui.view.workers.ModelWorker;
import se.ericsson.cello.nex.viewservices.model.ViewElementI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshNodeWorker
extends ModelWorker<Collection<ViewElementI>, Void> {
    private NexTreeNode node;
    private ModelCallback<NexTreeNode> callBack;

    public RefreshNodeWorker(MoTreeTableModel model, NexTreeNode node, ModelCallback<NexTreeNode> cb) {
        super(model);
        this.node = node;
        this.callBack = cb;
    }

    @Override
    protected Collection<ViewElementI> doWork() throws Exception {
        this.node.refreshAttributes(this.getModel().getColumnNames());
        this.node.refreshHasChildren();
        if (this.node.hasFetchedChildren() || this.node.isPartiallyExpanded()) {
            return this.node.getViewElement().getChildren(this.getModel().getColumnNames());
        }
        return null;
    }

    protected void done() {
        boolean cancelled;
        block5: {
            cancelled = false;
            try {
                Collection newChildren = (Collection)this.get();
                if (null != newChildren) {
                    this.removeOldChildren(newChildren, this.node.children());
                    this.fillInNewChildren(this.node, newChildren.iterator());
                }
                this.node.allChildrenFetched();
            }
            catch (CancellationException e) {
                NexLog.logger().warning("RefreshNodeWorker cancelled, this shouldn't be possible.");
                cancelled = true;
            }
            catch (Exception e) {
                NexLog.logger().warning("Exception caught in RefreshNodeWorker.done() \n" + NexLog.stackToString(e));
                if (this.callBack == null) break block5;
                this.callBack.setException(e);
            }
        }
        if (null != this.callBack) {
            this.callBack.run(this.node, cancelled);
        }
    }

    private void removeOldChildren(Collection<ViewElementI> newChildren, Enumeration<?> oldChildren) {
        while (oldChildren.hasMoreElements()) {
            NexTreeNode anOldNode = (NexTreeNode)oldChildren.nextElement();
            ViewElementI anOldViewElement = anOldNode.getViewElement();
            boolean foundInNew = false;
            for (ViewElementI newViewElement : newChildren) {
                if (!newViewElement.getLdn().equals(anOldViewElement.getLdn())) continue;
                foundInNew = true;
                break;
            }
            if (foundInNew) continue;
            this.getModel().removeNodeFromParent(anOldNode);
        }
    }

    private void fillInNewChildren(NexTreeNode node, Iterator<ViewElementI> newChildrenIterator) {
        while (newChildrenIterator.hasNext()) {
            NexTreeNode aChild;
            NexTreeNode newNode;
            ViewElementI aNewViewElement = newChildrenIterator.next();
            NexTreeNode old = null;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                NexTreeNode anOldChildNode = (NexTreeNode)children.nextElement();
                ViewElementI anOldViewElem = anOldChildNode.getViewElement();
                if (!anOldViewElem.getLdn().equals(aNewViewElement.getLdn())) continue;
                old = anOldChildNode;
                break;
            }
            if (old != null) continue;
            try {
                newNode = this.getModel().getNodeFactory().createNode(aNewViewElement);
            }
            catch (Exception e1) {
                NexLog.logger().warning("Error creating NexTreeNode for MO " + aNewViewElement.getLdn());
                continue;
            }
            NexLog.logger().log(Level.INFO, "updateChildren of " + node.getName() + "adding newNode:" + newNode.getName());
            int place = 0;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements() && newNode.compareTo(aChild = (NexTreeNode)e.nextElement()) >= 0) {
                ++place;
            }
            this.getModel().insertNodeInto(newNode, node, place);
        }
    }

    public String toString() {
        return "Refreshing node " + this.node.getLongName() + ".";
    }
}

