/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.toolservices;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.swing.JComponent;
import se.ericsson.cello.emt.helpservice.HelpServiceI;
import se.ericsson.cello.emt.helpservice.ProductFinder;
import se.ericsson.cello.emt.logservices.LogServices;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.DestroyableEmbeddable;
import se.ericsson.cello.nex.Embeddable;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.UI;
import se.ericsson.cello.nex.toolservices.NexEvent;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.Tool;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.VersionedLauncherInterface;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolServices
implements ToolServicesI {
    private static final String LAUNCHER_CXC = "CXC1721561";
    private static final String LAUNCHER_NAME = "Launcher";
    private LauncherInterface myLauncher;
    private Launchable myLaunchableNex;
    private ConfigurationI myParameterHandler;
    private String myHostName;
    private NodeServices myNodeServices = null;
    private UI myUI = null;
    private HelpServiceI myHelpService = null;
    private UserPreferencesI myUserPreferences = null;
    private TreeSet<String> executingAppsProductData = new TreeSet();
    private static final String PROPERTY_ADDRESS = "address";
    private static final String NEW_LINE = "\n";

    public ToolServices(Launchable nex, String hostName, LauncherInterface launcher, ConfigurationI parameterHandler) {
        this.myLaunchableNex = nex;
        this.myLauncher = launcher;
        this.myParameterHandler = parameterHandler;
        this.myHostName = hostName;
    }

    @Override
    public DestroyableEmbeddable getEmbeddedApplication(String embeddedClassName) {
        NexLog.logger().info("Will create " + embeddedClassName);
        DestroyableEmbeddable anApp = null;
        try {
            Class<?> aClass = Class.forName(embeddedClassName);
            Object obj = aClass.newInstance();
            if (obj instanceof DestroyableEmbeddable) {
                anApp = (DestroyableEmbeddable)obj;
                NexLog.logger().info("Application " + embeddedClassName + " is DestroyableEmbeddable");
            } else {
                Embeddable embeddable = (Embeddable)obj;
                anApp = new DestroyableEmbeddableAdapter(embeddable);
                NexLog.logger().info("Application " + embeddedClassName + " is not DestroyableEmbeddable");
            }
            Properties props = this.myParameterHandler.getProperties();
            anApp.init(props, this.myLaunchableNex, this.myLauncher);
        }
        catch (Exception e) {
            NexLog.logger().info("An embedded application could not be instantiated: " + embeddedClassName + NEW_LINE + NexLog.stackToString(e));
            this.myUI.setMessage("Failed adding a special tab.", "An application was specified for this view to be inside a special tab. It was not possible to start the application.", e, false);
        }
        return anApp;
    }

    @Override
    public Collection<String> getAvailableAlarmTools() {
        return this.getTools(ToolType.ALARM_TOOL);
    }

    @Override
    public Collection<String> getAvailableHyperTools() {
        return this.getTools(ToolType.HYPER_TOOL);
    }

    @Override
    public List<String> getAvailableTools() {
        return this.getTools(ToolType.TOOL);
    }

    @Override
    public Tool getEmTraceLog() {
        return this.myParameterHandler.getEmTraceLogTool();
    }

    @Override
    public void startAlarmTool(String toolName, Properties props) throws StartFailureException {
        NexLog.logger().log(Level.INFO, " startAlarmTool()");
        Tool tool = this.myParameterHandler.getAlarmTool(toolName);
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The tool " + toolName + " is not defined in the configuration file.");
            throw new StartFailureException("The tool " + toolName + " is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startHyperTool(String toolName, Properties props) throws StartFailureException {
        Tool tool = this.myParameterHandler.getHyperTool(toolName);
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The tool " + toolName + " is not defined in the configuration file.");
            throw new StartFailureException("The tool " + toolName + " is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startTool(String toolName, Properties props) throws StartFailureException {
        Tool tool = this.myParameterHandler.getTool(toolName);
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The tool " + toolName + " is not defined in the configuration file.");
            throw new StartFailureException("The tool " + toolName + " is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startSearchTool(Properties props) throws StartFailureException {
        Tool tool = this.myParameterHandler.getSearchTool();
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The Search MO Tool is not defined in the configuration file.");
            throw new StartFailureException("The Search MO Tool is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startAnyTool(String toolName, Properties props, boolean isResource) throws StartFailureException {
        Tool tool = null;
        if (toolName.trim().endsWith(".xml")) {
            this.startAnyConfig(toolName, props, isResource);
            return;
        }
        tool = this.myParameterHandler.getTool(toolName);
        if (tool == null) {
            tool = this.myParameterHandler.getAlarmTool(toolName);
        }
        if (tool == null) {
            tool = this.myParameterHandler.getHyperTool(toolName);
        }
        if (tool == null) {
            if (toolName.equalsIgnoreCase("MO Properties")) {
                tool = this.myParameterHandler.getMoPropTool();
            } else if (toolName.equalsIgnoreCase("Search MO")) {
                tool = this.myParameterHandler.getSearchTool();
            } else if (toolName.equalsIgnoreCase("Add MO")) {
                tool = this.myParameterHandler.getAddTool();
            }
        }
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The tool " + toolName + " is not defined in the configuration file.");
            throw new StartFailureException("The tool " + toolName + " is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startHelpTool(Properties props) throws StartFailureException {
        Tool tool = this.myParameterHandler.getHelpTool();
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The Help Service Tool is not defined in the configuration file.");
            throw new StartFailureException("The EM Help Service Tool is not defined in the configuration file.");
        }
        this.startAnyConfig(tool.getConfigFile(), props, true);
    }

    @Override
    public HelpServiceI getHelpService() {
        if (null != this.myHelpService) {
            return this.myHelpService;
        }
        final Properties props = this.myParameterHandler.getSupersedingProperties();
        props.setProperty("HELPSERVICE_INIT", "TRUE");
        PrivilegedExceptionAction<Launchable> launchHelpServiceAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return ToolServices.this.myLauncher.runResource(ToolServices.this.myParameterHandler.getHelpTool().getConfigFile(), ToolServices.this.myHostName, props, ToolServices.this.myLaunchableNex);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchHelpServiceAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> hsFuture = exec.submit(launchResourceCallable);
        try {
            Object obj = hsFuture.get();
            exec.shutdown();
            this.myHelpService = (HelpServiceI)obj;
        }
        catch (Exception ex) {
            this.myUI.setMessage("Help Service problem.", "\nIt is not possible to open any help information", ex, true);
        }
        return this.myHelpService;
    }

    @Override
    public void startMoPropsTool(Properties props) throws StartFailureException {
        Tool tool = this.myParameterHandler.getMoPropTool();
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The MO Properties Tool is not defined in the configuration file.");
            throw new StartFailureException("The MO Properties is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startAddMoTool(Properties props) throws StartFailureException {
        NexLog.logger().log(Level.INFO, " startAddMoTool()");
        Tool tool = this.myParameterHandler.getAddTool();
        if (tool == null) {
            NexLog.logger().log(Level.SEVERE, " The Add MO Tool is not defined in the configuration file.");
            throw new StartFailureException("The Add MO Tool is not defined in the configuration file.");
        }
        this.startAnyTool(tool, props);
    }

    @Override
    public void startMoTableTool(Properties props) throws StartFailureException {
        throw new StartFailureException("The MO Table tool is not yet implemented.");
    }

    @Override
    public NodeServices getNodeServices() throws StartFailureException {
        NexLog.logger().log(Level.INFO, " getNodeServices()");
        if (this.myNodeServices == null) {
            NexLog.logger().log(Level.WARNING, " throw new StartFailureException");
            throw new StartFailureException("Failed to contact the node. Node Services was not started. Please exit, and try to start again.");
        }
        return this.myNodeServices;
    }

    @Override
    public String getHostName() {
        return this.myHostName;
    }

    @Override
    public String getHostAddress() {
        Properties props = this.myParameterHandler.getProperties();
        return props.getProperty(PROPERTY_ADDRESS, "");
    }

    @Override
    public Collection<String> getStartedTools() {
        Collection apps = this.myLauncher.getRunningApplications();
        LinkedList<String> appNames = new LinkedList<String>();
        for (Object obj : apps) {
            appNames.add(obj.toString());
        }
        return appNames;
    }

    @Override
    public void exitNex() {
        this.myLaunchableNex.exit();
    }

    @Override
    public void exitAllTools() {
        if (this.myLauncher != null) {
            Collection apps = this.myLauncher.getRunningApplications();
            Vector vec = new Vector(apps);
            try {
                for (Object obj : vec) {
                    if (obj == this.myLaunchableNex) continue;
                    NexLog.logger().log(Level.INFO, "NEX calling exit of " + obj.toString());
                    ((Launchable)obj).exit();
                }
            }
            catch (Exception e) {
                NexLog.logger().log(Level.INFO, "Exception when calling exit of all tools.\n" + NexLog.stackToString(e));
            }
        }
        if (this.myLaunchableNex != null) {
            this.myLaunchableNex.exit();
        }
    }

    @Override
    public void destroy() {
        this.myLauncher = null;
        this.myLaunchableNex = null;
        this.myParameterHandler = null;
        this.myHostName = null;
        this.myNodeServices = null;
        this.myUI = null;
    }

    @Override
    public void setNodeServices(NodeServices nodeServices) {
        this.myNodeServices = nodeServices;
    }

    @Override
    public void setUI(UI anUI) {
        this.myUI = anUI;
    }

    @Override
    public UI getUI() {
        return this.myUI;
    }

    @Override
    public String getLauncherNameAndVersion() {
        String returnString = "";
        if (this.myLauncher instanceof VersionedLauncherInterface) {
            String version = ((VersionedLauncherInterface)this.myLauncher).getVersion();
            returnString = "Launcher CXC1721561 " + version;
        }
        return returnString;
    }

    @Override
    public Collection<ApplicationFileInterface> getConfigurationFiles() {
        Vector<ApplicationFileInterface> appConfigFiles = new Vector<ApplicationFileInterface>();
        Collection apps = this.myLauncher.getRunningApplications();
        Collection resources = this.myLauncher.getRunningResources();
        try {
            ApplicationFileInterface anAppFile;
            Collection col;
            for (Object obj : apps) {
                col = this.myLauncher.getConfigurationFiles((Launchable)obj);
                for (Object appFile : col) {
                    anAppFile = (ApplicationFileInterface)appFile;
                    if (appConfigFiles.contains(anAppFile)) continue;
                    appConfigFiles.add(anAppFile);
                }
            }
            for (Object obj : resources) {
                col = this.myLauncher.getConfigurationFiles((Launchable)obj);
                for (Object appFile : col) {
                    anAppFile = (ApplicationFileInterface)appFile;
                    if (appConfigFiles.contains(anAppFile)) continue;
                    appConfigFiles.add(anAppFile);
                }
            }
        }
        catch (Exception e) {
            NexLog.logger().log(Level.INFO, "Exception when getting configFiles of all tools from Launcher .\n" + NexLog.stackToString(e));
        }
        return appConfigFiles;
    }

    @Override
    public UserPreferencesI getUserPreferences() {
        if (null != this.myUserPreferences) {
            return this.myUserPreferences;
        }
        if (this.myParameterHandler.shouldStorePreferences()) {
            final Tool userPrefTool = this.myParameterHandler.getUserPreferencesTool();
            if (null == userPrefTool) {
                NexLog.logger().warning("Missing information about the user preferences configuration file. User preferences will not be stored when this session ends.");
            } else {
                final Properties props = this.myParameterHandler.getSupersedingProperties();
                PrivilegedExceptionAction<Launchable> launchHelpServiceAction = new PrivilegedExceptionAction<Launchable>(){

                    @Override
                    public Launchable run() throws LauncherException {
                        return ToolServices.this.myLauncher.runResource(userPrefTool.getConfigFile(), ToolServices.this.myHostName, props, ToolServices.this.myLaunchableNex);
                    }
                };
                Callable<Object> launchResourceCallable = Executors.callable(launchHelpServiceAction);
                ExecutorService exec = Executors.newSingleThreadExecutor();
                Future<Object> hsFuture = exec.submit(launchResourceCallable);
                try {
                    Object obj = hsFuture.get();
                    exec.shutdown();
                    this.myUserPreferences = (UserPreferencesI)obj;
                }
                catch (Exception ex) {
                    NexLog.logger().log(Level.WARNING, "Could not get User Preference Service from Launcher. Using temporary preferences.\n");
                }
            }
        }
        if (null == this.myUserPreferences) {
            this.myUserPreferences = new TempUserProps();
        }
        return this.myUserPreferences;
    }

    private void startAnyTool(final Tool tool, final Properties props) throws StartFailureException {
        NexLog.logger().log(Level.INFO, " startAnyTool() with LDNs: " + props.getProperty("LDNs"));
        props.putAll((Map<?, ?>)this.myParameterHandler.getSupersedingProperties());
        Runnable runnable = new Runnable(){

            public void run() {
                block2: {
                    try {
                        ToolServices.this.myLauncher.runApplication(tool.getConfigFile(), ToolServices.this.myHostName, props, ToolServices.this.myLaunchableNex);
                    }
                    catch (LauncherException exep) {
                        NexLog.logger().log(Level.SEVERE, "Could not launch " + tool.getName() + ToolServices.NEW_LINE + NexLog.stackToString((Exception)((Object)exep)));
                        if (null == ToolServices.this.myUI) break block2;
                        ToolServices.this.myUI.setMessage("Could not start " + tool.getName(), (Exception)((Object)exep), false);
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    private void startAnyConfig(final String configFileName, final Properties props, final boolean isResource) throws StartFailureException {
        NexLog.logger().log(Level.INFO, " startAnyConfig() with LDNs: " + props.getProperty("LDNs"));
        props.putAll((Map<?, ?>)this.myParameterHandler.getSupersedingProperties());
        Runnable runnable = new Runnable(){

            public void run() {
                block4: {
                    try {
                        if (isResource) {
                            ToolServices.this.myLauncher.runResource(configFileName, ToolServices.this.myHostName, props, ToolServices.this.myLaunchableNex);
                        } else {
                            ToolServices.this.myLauncher.runApplication(configFileName, ToolServices.this.myHostName, props, ToolServices.this.myLaunchableNex);
                        }
                    }
                    catch (LauncherException exep) {
                        NexLog.logger().log(Level.SEVERE, "Could not launch " + configFileName + ToolServices.NEW_LINE + NexLog.stackToString((Exception)((Object)exep)));
                        if (null == ToolServices.this.myUI) break block4;
                        ToolServices.this.myUI.setMessage("Could not start " + configFileName, (Exception)((Object)exep), false);
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    private List<String> getTools(ToolType toolType) {
        Collection<Tool> tools;
        NexLog.logger().log(Level.INFO, " getTools()");
        ArrayList<String> toolNames = new ArrayList<String>();
        switch (toolType) {
            case TOOL: {
                tools = this.myParameterHandler.getTools();
                break;
            }
            case ALARM_TOOL: {
                tools = this.myParameterHandler.getAlarmTools();
                break;
            }
            case HYPER_TOOL: {
                tools = this.myParameterHandler.getHyperTools();
                break;
            }
            default: {
                return toolNames;
            }
        }
        for (Tool tool : tools) {
            toolNames.add(tool.getName());
        }
        return toolNames;
    }

    @Override
    public ConfigurationI getConfiguration() {
        return this.myParameterHandler;
    }

    @Override
    public boolean isNodeServicesStarted() {
        return this.myNodeServices != null;
    }

    @Override
    public LauncherInterface getLauncher() {
        return this.myLauncher;
    }

    @Override
    public LogServices startEmTraceLogTool(Properties props) throws StartFailureException {
        LogServices emTraceLogLaunchable;
        NexLog.logger().log(Level.INFO, "");
        Tool emTraceTool = this.myParameterHandler.getEmTraceLogTool();
        if (emTraceTool == null) {
            NexLog.logger().log(Level.INFO, "The EM Trace Log Tool, was not found in the configuration.");
            throw new StartFailureException("The EM Trace Log Tool is not properly defined.");
        }
        try {
            Launchable launchedTool = LaunchHandler.getTool((LauncherInterface)this.myLauncher, (String)emTraceTool.getConfigFile(), (String)this.myHostName, (Properties)props, (Launchable)this.myLaunchableNex);
            NexLog.logger().log(Level.INFO, " after LaunchHandler.getTool(...).");
            emTraceLogLaunchable = (LogServices)launchedTool;
        }
        catch (Exception e) {
            NexLog.logger().warning("Launch Em Trace Log Error. " + e.getMessage());
            throw new StartFailureException(e);
        }
        return emTraceLogLaunchable;
    }

    @Override
    public void sendEmNotification(NexEvent aNexEvent) {
        EmNotificationServiceInterface myEmNotificationService = null;
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            myEmNotificationService = (EmNotificationServiceInterface)this.myLauncher;
            myEmNotificationService.sendNotification((EmEventInterface)aNexEvent);
            NexLog.logger().log(Level.INFO, "Notificationsent: " + aNexEvent.getType());
        } else {
            NexLog.logger().log(Level.INFO, "Notification service not available. ");
        }
    }

    @Override
    public void addEmNotificationListener(EmNotificationListenerInterface aListener) {
        EmNotificationServiceInterface myEmNotificationService = null;
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            myEmNotificationService = (EmNotificationServiceInterface)this.myLauncher;
            myEmNotificationService.addEmNotificationListener(aListener);
            NexLog.logger().log(Level.INFO, "Notification listener added: ");
        } else {
            NexLog.logger().log(Level.INFO, "Can not add notification listner. Notification service not available.");
        }
    }

    @Override
    public void removeEmNotificationListener(EmNotificationListenerInterface aListener) {
        EmNotificationServiceInterface myEmNotificationService = null;
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            myEmNotificationService = (EmNotificationServiceInterface)this.myLauncher;
            myEmNotificationService.removeEmNotificationListener(aListener);
            NexLog.logger().log(Level.INFO, "Notification listener removed: ");
        } else {
            NexLog.logger().log(Level.INFO, "Can not remove notification listner. Notification service not available.");
        }
    }

    @Override
    public byte[] getFileInJarAsByteArray(String filePathInJar, String jarFilePathOnNode) {
        NexLog.logger().info("filePathInJar " + filePathInJar + " jarFilePathOnNode: " + jarFilePathOnNode);
        byte[] fileContents = new byte[]{};
        URL url = this.getConfiguration().generateUrlToPathOnNode(jarFilePathOnNode);
        String cachedFilePath = "";
        try {
            cachedFilePath = this.getLauncher().getFile(url, new DownloadListener(){

                public void downloadFailed(String filename) {
                    NexLog.logger().info("Failed downloading " + filename);
                }

                public void downloading(String filename, int readSoFar, int totalSize) {
                }

                public void finished(String filename) {
                    NexLog.logger().info("Finished downloading " + filename);
                }

                public void updating(String filename, int readSoFar, int totalSize) {
                }

                public void connecting(String host, String file) {
                }

                public void finished(String filename, String host) {
                    NexLog.logger().info("Finished downloading " + filename + " from host " + host);
                }
            });
            NexLog.logger().info("cachedFilePath:" + cachedFilePath);
            JarFile jarF = new JarFile(cachedFilePath);
            JarEntry jarentry = jarF.getJarEntry(filePathInJar);
            if (null == jarentry) {
                jarentry = filePathInJar.startsWith("/") ? jarF.getJarEntry(filePathInJar.substring(1)) : jarF.getJarEntry("/" + filePathInJar);
            }
            InputStream instr = jarF.getInputStream(jarentry);
            long size = jarentry.getSize();
            byte[] byteBuffer = new byte[(int)size];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (instr.read(byteBuffer) != -1) {
                out.write(byteBuffer);
            }
            fileContents = out.toByteArray();
        }
        catch (Exception exep) {
            NexLog.logger().info("A file inside a jar file on the node could not be read. \nJar file: " + jarFilePathOnNode + "\nFile inside the jar file: " + filePathInJar);
            NexLog.logger().fine(NexLog.stackToString(exep));
        }
        return fileContents;
    }

    @Override
    public void update(Observable o, Object applicationConfiguration) {
        TreeSet executingApps = null;
        executingApps = ProductFinder.constructExecutingApplicationRows(this.getConfigurationFiles(), (LauncherInterface)this.myLauncher, (String)this.myHostName);
        this.executingAppsProductData.addAll(executingApps);
        String jarRevisions = this.generateString(this.executingAppsProductData);
        EProps.getRevisionProperties().set(EKEY.REV_JAR_FILES, (Object)jarRevisions);
    }

    private String generateString(Collection<String> entries) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = entries.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    private static class DestroyableEmbeddableAdapter
    implements DestroyableEmbeddable {
        private Embeddable embeddable;

        public DestroyableEmbeddableAdapter(Embeddable embeddable) {
            this.embeddable = embeddable;
        }

        public void destroy() {
        }

        public JComponent getComponent() {
            JComponent j = this.embeddable.getComponent();
            return j;
        }

        public void init(Properties nexProps, Launchable nex, LauncherInterface theLauncher) {
            this.embeddable.init(nexProps, nex, theLauncher);
        }

        public String getName() {
            String s = this.embeddable.getName();
            return s;
        }

        public void setLDNs(String[] LDNs) {
            this.embeddable.setLDNs(LDNs);
        }
    }

    private static class TempUserProps
    implements UserPreferencesI {
        Properties myProps = new Properties();

        private TempUserProps() {
        }

        public String getPreference(String key, String defaultValue) {
            return this.myProps.getProperty(key, defaultValue);
        }

        public void setPreference(String key, String value) {
            this.myProps.setProperty(key, value);
        }

        public void removePreference(String preferenceKey) {
            this.myProps.remove(preferenceKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ToolType {
        TOOL,
        ALARM_TOOL,
        HYPER_TOOL;

    }
}

