/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.AlreadyDefined;
import BasicConfig.AttrIterRef;
import BasicConfig.AttrMORefHolder;
import BasicConfig.AttrMORefSeqHolder;
import BasicConfig.Filter;
import BasicConfig.IterRef;
import BasicConfig.MGRef;
import BasicConfig.MIBInfo;
import BasicConfig.MIBRef;
import BasicConfig.MOAssociation;
import BasicConfig.MOAttrValue;
import BasicConfig.MOInfo;
import BasicConfig.MORef;
import BasicConfig.MORefHelper;
import BasicConfig.MORefHolder;
import BasicConfig.MORefSeqHolder;
import BasicConfig.MOidpair;
import BasicConfig.MOidpairHelper;
import BasicConfig.NameValue;
import BasicConfig.NameValueSeqHolder;
import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import BasicConfig.PlanningStateType;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.Session;
import BasicConfig.SessionHelper;
import CosNaming.NameComponent;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TypeCode;
import se.ericsson.cello.commandlog.AuditLogWriter;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorMgr;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.configirpimpl.AnyMapping;
import se.ericsson.cello.configirpimpl.AttrIterator;
import se.ericsson.cello.configirpimpl.AttrIteratorMgr;
import se.ericsson.cello.configirpimpl.AttrListImpl;
import se.ericsson.cello.configirpimpl.BasicConfigAdapter;
import se.ericsson.cello.configirpimpl.DynMoAccess;
import se.ericsson.cello.configirpimpl.EasyNaming;
import se.ericsson.cello.configirpimpl.MoIteratorMgr;
import se.ericsson.cello.configirpimpl.MoRefMgr;
import se.ericsson.cello.configirpimpl.SessionImpl;
import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.IllegalIdentityException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.corba.MibAccessControl;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.debug.Util;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.util.ExceptionHelper;
import se.ericsson.cello.support.util.TypeDnExtractor;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.security.corba.Current;

public abstract class BasicConfigImpl
extends BasicConfigAdapter {
    private static final int MINOR_CODE = 20000;
    private static final int TRACE_GROUP = 5;
    private static DynMoAccess theMoAccess = null;
    private InspectorMgr inspectorMgr = null;
    protected static Current current = null;
    private AuditLogWriter auditLogWriter = null;
    private static ExceptionHelper exceptionHelper = null;
    private MibAccessControl mibAccessControl = null;

    public Session create_session(String string, int n) throws ProcessingFailure {
        try {
            SessionImpl sessionImpl = new SessionImpl(string, n);
            return SessionHelper.narrow(CelloOrb.instance().addressDependentServantToReference(sessionImpl));
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"create_session: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"create_session: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MIBRef get_MIB(String string, Session session) throws NotDefined, ProcessingFailure {
        try {
            Mib mib = MibMgr.instance().getMib();
            if (mib == null || !mib.getMibName().trim().equalsIgnoreCase(string)) {
                throw new NotDefined("");
            }
            int n = MibMgr.instance().getMibId();
            return new MIBRef(n);
        }
        catch (NotDefined notDefined) {
            MessageLog.trace((int)5, this.getClass(), (String)("get_MIB: " + Util.stack2string((Throwable)((Object)notDefined))));
            throw notDefined;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIB: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIB: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MIBRef[] get_MIBs(Session session) throws ProcessingFailure {
        try {
            MIBRef[] mIBRefArray = new MIBRef[]{new MIBRef(MibMgr.instance().getMibId())};
            return mIBRefArray;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIBs :", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIBs :", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MORef basic_get_root_MO(MIBRef mIBRef, Session session) throws ProcessingFailure, NotDefined {
        try {
            Mib mib = MibMgr.instance().getMib();
            if (mib == null || MibMgr.instance().getMibId() != (int)mIBRef.oid) {
                throw new NotDefined("");
            }
            return MoRefMgr.createMoRef(mib.getRootMo());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_root_MO :", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_root_MO :", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MIBInfo get_MIB_info(MIBRef mIBRef, Session session) throws NotDefined, ProcessingFailure {
        try {
            Mib mib = MibMgr.instance().getMib();
            if (mib == null || MibMgr.instance().getMibId() != (int)mIBRef.oid) {
                throw new NotDefined("");
            }
            NameComponent[] nameComponentArray = EasyNaming.str2name(mib.getMibPrefix());
            return new MIBInfo((int)mIBRef.oid, mib.getMibName(), mib.getModelType(), 0L, mib.getModelVersion(), nameComponentArray);
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIB_info :", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"get_MIB_info :", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public void set_prefix_MIB(MIBRef mIBRef, NameComponent[] nameComponentArray, Session session) throws NotDefined, ProcessingFailure, NotAccepted {
        try {
            Coordinator coordinator;
            Mib mib = MibMgr.instance().getMib();
            if (mib == null || MibMgr.instance().getMibId() != (int)mIBRef.oid) {
                throw new NotDefined("");
            }
            String string = EasyNaming.name2str(nameComponentArray).trim();
            Assert.cppAssert((Object)string, (String)"prefixAsStr");
            if (session == null) {
                coordinator = null;
            } else {
                SessionImpl sessionImpl = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (sessionImpl == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = sessionImpl.getCoordinator();
            }
            mib.setMibPrefix(string, coordinator);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.trace((int)5, this.getClass(), (String)("set_prefix_MIB: " + Util.stack2string((Throwable)moAccessException)));
            throw new ProcessingFailure(moAccessException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"set_prefix_MIB: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"set_prefix_MIB :", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MORef basic_create_MO(String string, String string2, MOidpair mOidpair, MOidpair mOidpair2, NameValue[] nameValueArray, MOAssociation[] mOAssociationArray, Session session) throws AlreadyDefined, NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)("basic_create_MO: name = " + string + ", type = " + string2));
        Coordinator coordinator = null;
        AttrListImpl attrListImpl = null;
        String string3 = null;
        String string4 = null;
        try {
            NameValue[] nameValueArray2;
            try {
                NameValue[] nameValueArray3;
                if (session == null) {
                    string4 = "session == null";
                    throw new ProcessingFailure(string4);
                }
                SessionImpl sessionImpl = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (sessionImpl == null) {
                    string4 = "Invalid session object!";
                    throw new ProcessingFailure(string4);
                }
                coordinator = sessionImpl.getCoordinator();
                this.auditLogWriter.addResource(coordinator);
                MoFactory moFactory = MoFactoryMgr.instance().lookup(string2);
                if (moFactory == null) {
                    MoCanNotBeCreatedException moCanNotBeCreatedException = new MoCanNotBeCreatedException(string2);
                    string4 = moCanNotBeCreatedException.toString() + ExceptionHelper.stackToString(moCanNotBeCreatedException.getStackTrace());
                    throw new ProcessingFailure(string4);
                }
                ManagedObject managedObject = MoRefMgr.lookup(mOidpair, coordinator, session);
                if (managedObject == null) {
                    string4 = "Mo not found";
                    throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
                }
                this.validateMoRefAttributes(nameValueArray, coordinator, session);
                String string5 = TypeDnExtractor.extractTypeDnFromLDN(managedObject.getLocalDistinguishedName());
                if (!this.mibAccessControl.isAuthorizedInMib(string5 + "," + string2, 0, null)) {
                    throw new NO_PERMISSION("Not allowed to create MO of type " + string2, 20000, CompletionStatus.COMPLETED_NO);
                }
                string3 = managedObject.getLocalDistinguishedName();
                ManagedObject managedObject2 = MoRefMgr.lookup(mOidpair2);
                Object[] objectArray = null;
                attrListImpl = new AttrListImpl(nameValueArray);
                LogContentInspector logContentInspector = this.inspectorMgr.lookup(string2);
                if (logContentInspector != null && (objectArray = logContentInspector.hideHazardousAttributeValues(attrListImpl)) != null) {
                    if (objectArray.length == attrListImpl.size()) {
                        nameValueArray3 = new NameValue[objectArray.length];
                        for (int i = 0; i < nameValueArray3.length; ++i) {
                            nameValueArray3[i] = new NameValue();
                            nameValueArray3[i].name = nameValueArray[i].name;
                            nameValueArray3[i].value = AnyMapping.object2any(objectArray[i]);
                        }
                        attrListImpl = new AttrListImpl(nameValueArray3);
                    } else {
                        MessageLog.traceError((Class)BasicConfigImpl.class, (String)("basic_create_MO: The log content inspector for MO type " + string2 + " has not returned correct values. As a result the original attribute values are logged."));
                    }
                }
                ManagedObject managedObject3 = moFactory.createMo(managedObject, new AttrListImpl(nameValueArray), string, managedObject2, coordinator);
                nameValueArray3 = MoRefMgr.createMoRef(managedObject3);
                MessageLog.traceReturn(this.getClass(), (String)"basic_create_MO");
                nameValueArray2 = nameValueArray3;
                Object var23_31 = null;
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                string4 = nO_PERMISSION.toString() + ExceptionHelper.stackToString(nO_PERMISSION.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("basic_create_MO: " + Util.stack2string((Throwable)nO_PERMISSION)));
                throw nO_PERMISSION;
            }
            catch (NoPermissionException noPermissionException) {
                string4 = noPermissionException.toString() + ExceptionHelper.stackToString(noPermissionException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_create_MO: " + Util.stack2string((Throwable)noPermissionException)));
                throw new NO_PERMISSION(noPermissionException.toString(), 20000, CompletionStatus.COMPLETED_NO);
            }
            catch (IllegalIdentityException illegalIdentityException) {
                string4 = illegalIdentityException.toString() + ExceptionHelper.stackToString(illegalIdentityException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_create_MO: " + Util.stack2string((Throwable)illegalIdentityException)));
                throw new ProcessingFailure(illegalIdentityException.getMessage());
            }
            catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
                string4 = moNameAlreadyTakenException.toString() + ExceptionHelper.stackToString(moNameAlreadyTakenException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_create_MO: " + Util.stack2string((Throwable)moNameAlreadyTakenException)));
                throw new AlreadyDefined(moNameAlreadyTakenException.toString());
            }
            catch (MoAccessException moAccessException) {
                string4 = moAccessException.toString() + ExceptionHelper.stackToString(moAccessException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_create_MO: " + Util.stack2string((Throwable)moAccessException)));
                throw new ProcessingFailure(moAccessException.toString());
            }
            catch (RuntimeException runtimeException) {
                string4 = runtimeException.toString() + ExceptionHelper.stackToString(runtimeException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_create_MO: ", (Throwable)runtimeException);
                throw new ProcessingFailure("InternalError: " + runtimeException);
            }
            catch (Error error) {
                string4 = error.toString() + ExceptionHelper.stackToString(error.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_create_MO: ", (Throwable)error);
                throw new ProcessingFailure("InternalError: " + error);
            }
            this.auditLogWriter.addCreateCmd(string3, string, attrListImpl, string2, this.getUserName(), coordinator, string4);
            return nameValueArray2;
        }
        catch (Throwable throwable) {
            Object var23_32 = null;
            this.auditLogWriter.addCreateCmd(string3, string, attrListImpl, string2, this.getUserName(), coordinator, string4);
            throw throwable;
        }
    }

    private void validateMoRefAttributes(NameValue[] nameValueArray, Coordinator coordinator, Session session) throws MoNotFoundException {
        for (int i = 0; i < nameValueArray.length; ++i) {
            Object object;
            TypeCode typeCode = nameValueArray[i].value.type();
            if (typeCode.equals(MOidpairHelper.type())) {
                object = MOidpairHelper.extract(nameValueArray[i].value);
                MoRefMgr.lookup(object, coordinator, session);
                continue;
            }
            if (!typeCode.equals(MORefHelper.type())) continue;
            object = MORefHelper.extract(nameValueArray[i].value);
            MoRefMgr.lookup((MORef)object, coordinator, session);
        }
    }

    public void basic_delete_MO(MOidpair mOidpair, MGRef mGRef, int n, Filter filter, Session session) throws ProcessingFailure, NotDefined {
        MessageLog.traceEnter(this.getClass(), (String)"basic_delete_MO");
        Coordinator coordinator = null;
        String string = null;
        String string2 = null;
        try {
            try {
                Object object;
                if (session == null) {
                    coordinator = null;
                } else {
                    object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                    if (object == null) {
                        string2 = "Invalid session object";
                        throw new ProcessingFailure(string2);
                    }
                    coordinator = ((SessionImpl)object).getCoordinator();
                }
                this.auditLogWriter.addResource(coordinator);
                ManagedObject managedObject = MoRefMgr.lookup(mOidpair);
                if (managedObject == null) {
                    object = new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
                    string2 = ((MoAccessException)object).toString() + ExceptionHelper.stackToString(((Throwable)object).getStackTrace());
                    throw new ProcessingFailure(string2);
                }
                object = TypeDnExtractor.extractTypeDnFromLDN(managedObject.getLocalDistinguishedName());
                if (!this.mibAccessControl.isAuthorizedInMib((String)object, 1, null)) {
                    throw new NO_PERMISSION("Not allowed to delete MO of type " + managedObject.getType(), 20000, CompletionStatus.COMPLETED_NO);
                }
                string = managedObject.getLocalDistinguishedName();
                MoIterator moIterator = MoRepository.instance().select(managedObject, n, coordinator, filter.type, filter.constraint);
                this.deleteRecursive(string, moIterator, coordinator);
                MessageLog.traceReturn(this.getClass(), (String)"basic_delete_MO");
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                string2 = nO_PERMISSION.toString() + ExceptionHelper.stackToString(nO_PERMISSION.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("basic_delete_MO: " + Util.stack2string((Throwable)nO_PERMISSION)));
                throw nO_PERMISSION;
            }
            catch (NoPermissionException noPermissionException) {
                string2 = noPermissionException.toString() + ExceptionHelper.stackToString(noPermissionException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_delete_MO: " + Util.stack2string((Throwable)noPermissionException)));
                throw new NO_PERMISSION(noPermissionException.toString(), 20000, CompletionStatus.COMPLETED_NO);
            }
            catch (FilterSyntaxException filterSyntaxException) {
                string2 = filterSyntaxException.toString() + ExceptionHelper.stackToString(filterSyntaxException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_delete_MO: " + Util.stack2string((Throwable)filterSyntaxException)));
                throw new ProcessingFailure(filterSyntaxException.toString());
            }
            catch (MoAccessException moAccessException) {
                string2 = moAccessException.toString() + ExceptionHelper.stackToString(moAccessException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_delete_MO: " + Util.stack2string((Throwable)moAccessException)));
                throw new ProcessingFailure(moAccessException.toString());
            }
            catch (ProcessingFailure processingFailure) {
                string2 = processingFailure.toString() + ExceptionHelper.stackToString(processingFailure.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_delete_MO: " + Util.stack2string((Throwable)((Object)processingFailure))));
                throw processingFailure;
            }
            catch (RuntimeException runtimeException) {
                string2 = runtimeException.toString() + ExceptionHelper.stackToString(runtimeException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_delete_MO: ", (Throwable)runtimeException);
                throw new ProcessingFailure("InternalError: " + runtimeException);
            }
            catch (Error error) {
                string2 = error.toString() + ExceptionHelper.stackToString(error.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_delete_MO: ", (Throwable)error);
                throw new ProcessingFailure("InternalError: " + error);
            }
            Object var13_19 = null;
            this.auditLogWriter.addDeleteCmd(string, this.getUserName(), coordinator, string2);
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            this.auditLogWriter.addDeleteCmd(string, this.getUserName(), coordinator, string2);
            throw throwable;
        }
    }

    private void deleteRecursive(String string, MoIterator moIterator, Coordinator coordinator) throws MoAccessException {
        Assert.cppAssert((boolean)moIterator.hasMoreElements(), (String)"deleteRecursive hasMoreElements");
        ManagedObject managedObject = moIterator.nextMo();
        if (moIterator.hasMoreElements()) {
            this.deleteRecursive(string, moIterator, coordinator);
        }
        if (string.equals(managedObject.getLocalDistinguishedName())) {
            managedObject.delete(coordinator);
        } else {
            try {
                managedObject.delete(coordinator);
            }
            catch (UndeletableMoException undeletableMoException) {
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"deleteRecursive: ", (Throwable)undeletableMoException);
            }
        }
    }

    public IterRef basic_set_MO(MOidpair mOidpair, MGRef mGRef, int n, Filter filter, NameValue[] nameValueArray, Session session) throws NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"basic_set_MO");
        throw new ProcessingFailure("The operation basic_set_mo is not supported. Please use basic_set_MO_attributes instead.");
    }

    public IterRef basic_get_MO_containment_short(MOidpair mOidpair, MGRef mGRef, int n, Filter filter, IntHolder intHolder, MORefSeqHolder mORefSeqHolder, Session session) throws NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"basic_get_MO_containment_short");
        try {
            Object object;
            Coordinator coordinator;
            ManagedObject managedObject = MoRefMgr.lookup(mOidpair);
            if (managedObject == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRepository.instance().select(managedObject, n, coordinator, filter.type, filter.constraint);
            intHolder.value = 0;
            mORefSeqHolder.value = new MORef[0];
            int n2 = MoIteratorMgr.instance().register((MoIterator)object);
            IterRef iterRef = new IterRef(n2);
            MessageLog.traceReturn(this.getClass(), (String)"basic_get_MO_containment_short");
            return iterRef;
        }
        catch (FilterSyntaxException filterSyntaxException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_MO_containment_short: " + Util.stack2string((Throwable)filterSyntaxException)));
            throw new ProcessingFailure(filterSyntaxException.toString());
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_MO_containment_short: " + Util.stack2string((Throwable)moNotFoundException)));
            throw new NotDefined(moNotFoundException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_containment_short: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_containment_short: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public AttrIterRef basic_get_attr_MO_containment(MOidpair mOidpair, int n, Filter filter, String[] stringArray, Session session) throws NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"basic_get_attr_MO_containment");
        try {
            Object object;
            Coordinator coordinator;
            ManagedObject managedObject = MoRefMgr.lookup(mOidpair);
            if (managedObject == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRepository.instance().select(managedObject, n, coordinator, filter.type, filter.constraint);
            MOAttrValue[] mOAttrValueArray = theMoAccess.getAttributes((MoIterator)object, stringArray, coordinator);
            AttrIterRef attrIterRef = AttrIteratorMgr.createIter(mOAttrValueArray, stringArray);
            MessageLog.traceReturn(this.getClass(), (String)"basic_get_attr_MO_containment");
            return attrIterRef;
        }
        catch (FilterSyntaxException filterSyntaxException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_attr_MO_containment: " + Util.stack2string((Throwable)filterSyntaxException)));
            throw new ProcessingFailure(filterSyntaxException.toString());
        }
        catch (MoAccessException moAccessException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_attr_MO_containment: " + Util.stack2string((Throwable)moAccessException)));
            throw new ProcessingFailure(moAccessException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_attr_MO_containment: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_attr_MO_containment: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean attr_next_MO(AttrIterRef attrIterRef, AttrMORefHolder attrMORefHolder, Session session) throws ProcessingFailure, NotDefined {
        try {
            AttrIterator attrIterator = AttrIteratorMgr.lookup(attrIterRef);
            attrMORefHolder.value = attrIterator.nextMo();
            boolean bl = attrIterator.hasMoreElements();
            if (!bl) {
                AttrIteratorMgr.remove(attrIterRef);
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_next_MO: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_next_MO: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean attr_next_MOs(AttrIterRef attrIterRef, int n, AttrMORefSeqHolder attrMORefSeqHolder, Session session) throws NotDefined, ProcessingFailure {
        try {
            AttrIterator attrIterator = AttrIteratorMgr.lookup(attrIterRef);
            attrMORefSeqHolder.value = attrIterator.nextMos(n);
            boolean bl = attrIterator.hasMoreElements();
            if (!bl) {
                AttrIteratorMgr.remove(attrIterRef);
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_next_MOs: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_next_MOs: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean attr_all_MOs(AttrIterRef attrIterRef, AttrMORefSeqHolder attrMORefSeqHolder, Session session) throws ProcessingFailure, NotDefined {
        try {
            AttrIterator attrIterator = AttrIteratorMgr.lookup(attrIterRef);
            attrMORefSeqHolder.value = attrIterator.allMos();
            boolean bl = attrIterator.hasMoreElements();
            if (!bl) {
                AttrIteratorMgr.remove(attrIterRef);
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_all_MOs: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"attr_all_MOs: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public void attr_delete_Iter(AttrIterRef attrIterRef, Session session) {
        AttrIteratorMgr.remove(attrIterRef);
    }

    public void basic_get_MO_attributes(MOidpair mOidpair, String[] stringArray, NameValueSeqHolder nameValueSeqHolder, Session session) throws NotDefined, SecurityViolation, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"basic_get_MO_attributes");
        try {
            Object object;
            Coordinator coordinator;
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRefMgr.lookup(mOidpair, coordinator, session);
            if (object == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            MoIterator moIterator = MoRepository.instance().select((ManagedObject)object, 0, null);
            MOAttrValue[] mOAttrValueArray = theMoAccess.getAttributes(moIterator, stringArray, coordinator);
            Assert.cppAssert((mOAttrValueArray.length == 1 ? 1 : 0) != 0);
            nameValueSeqHolder.value = new NameValue[mOAttrValueArray[0].attrValues.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nameValueSeqHolder.value[i] = new NameValue();
                nameValueSeqHolder.value[i].name = stringArray[i];
                nameValueSeqHolder.value[i].value = mOAttrValueArray[0].attrValues[i];
            }
            MessageLog.traceReturn(this.getClass(), (String)"basic_get_MO_attributes");
        }
        catch (MoAccessException moAccessException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_MO_attributes: " + Util.stack2string((Throwable)moAccessException)));
            throw new ProcessingFailure(moAccessException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_attributes: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_attributes: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean basic_is_existing(MOidpair mOidpair, Session session) throws ProcessingFailure {
        try {
            Object object;
            Coordinator coordinator;
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRefMgr.lookup(mOidpair, coordinator, session);
            if (object == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            return true;
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_is_existing: " + Util.stack2string((Throwable)moNotFoundException)));
            return false;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_is_existing: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_is_existing: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MOInfo basic_get_MO_info(MOidpair mOidpair, Session session) throws NotDefined, ProcessingFailure {
        try {
            Object object;
            Coordinator coordinator;
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRefMgr.lookup(mOidpair, coordinator, session);
            if (object == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            Mib mib = MibMgr.instance().getMib();
            MOInfo mOInfo = new MOInfo(MoRefMgr.createMoRef((ManagedObject)object), object.getType(), EasyNaming.str2name(object.getLocalDistinguishedName()), EasyNaming.str2name(object.getFullDistinguishedName()), PlanningStateType.PlanningStateType_UNPLANNED, mib.getMibName(), 0L);
            return mOInfo;
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_MO_info: " + Util.stack2string((Throwable)moNotFoundException)));
            throw new NotDefined(moNotFoundException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_info: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_info: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public MORef basic_get_MO_parent(MOidpair mOidpair, Session session) throws NotDefined, ProcessingFailure {
        try {
            Object object;
            Coordinator coordinator;
            if (session == null) {
                coordinator = null;
            } else {
                object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                if (object == null) {
                    throw new ProcessingFailure("Invalid session object");
                }
                coordinator = ((SessionImpl)object).getCoordinator();
            }
            object = MoRefMgr.lookup(mOidpair, coordinator, session);
            if (object == null) {
                throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
            }
            ManagedObject managedObject = object.getParent();
            if (managedObject == null) {
                throw new NotDefined("");
            }
            return MoRefMgr.createMoRef(managedObject);
        }
        catch (MoNotFoundException moNotFoundException) {
            MessageLog.trace((int)5, this.getClass(), (String)("basic_get_MO_parent: " + Util.stack2string((Throwable)moNotFoundException)));
            throw new NotDefined(moNotFoundException.toString());
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_parent: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError: " + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_get_MO_parent: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public void basic_set_MO_attributes(MOidpair mOidpair, NameValue[] nameValueArray, Session session) throws NotDefined, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)"basic_set_MO_attributes");
        Coordinator coordinator = null;
        AttrListImpl attrListImpl = null;
        String string = null;
        String string2 = null;
        try {
            try {
                Object object;
                if (session == null) {
                    coordinator = null;
                } else {
                    object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                    if (object == null) {
                        string2 = "Invalid session object";
                        throw new ProcessingFailure("Invalid session object");
                    }
                    coordinator = ((SessionImpl)object).getCoordinator();
                }
                this.auditLogWriter.addResource(coordinator);
                ManagedObject managedObject = MoRefMgr.lookup(mOidpair, coordinator, session);
                this.validateMoRefAttributes(nameValueArray, coordinator, session);
                if (managedObject == null) {
                    string2 = "Mo not found: " + mOidpair;
                    throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
                }
                string = managedObject.getLocalDistinguishedName();
                object = TypeDnExtractor.extractTypeDnFromLDN(managedObject.getLocalDistinguishedName());
                for (int i = 0; i < nameValueArray.length; ++i) {
                    if (this.mibAccessControl.isAuthorizedInMib((String)object, 2, nameValueArray[i].name)) continue;
                    throw new NO_PERMISSION("Not allowed to set attribute " + nameValueArray[i].name + " on MO of type " + managedObject.getType(), 20000, CompletionStatus.COMPLETED_NO);
                }
                Object[] objectArray = null;
                attrListImpl = new AttrListImpl(nameValueArray);
                LogContentInspector logContentInspector = this.inspectorMgr.lookup(managedObject.getType());
                if (logContentInspector != null && (objectArray = logContentInspector.hideHazardousAttributeValues(attrListImpl)) != null) {
                    if (objectArray.length == attrListImpl.size()) {
                        NameValue[] nameValueArray2 = new NameValue[objectArray.length];
                        for (int i = 0; i < nameValueArray2.length; ++i) {
                            nameValueArray2[i] = new NameValue();
                            nameValueArray2[i].name = nameValueArray[i].name;
                            nameValueArray2[i].value = AnyMapping.object2any(objectArray[i]);
                        }
                        attrListImpl = new AttrListImpl(nameValueArray2);
                    } else {
                        MessageLog.traceError((Class)DynMoAccess.class, (String)("setAttributes: The log content inspector for MO type " + managedObject.getType() + " has not returned correct values. As a result the original attribute values are logged."));
                    }
                }
                theMoAccess.setAttributes(managedObject, nameValueArray, coordinator);
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                string2 = nO_PERMISSION.toString() + ExceptionHelper.stackToString(nO_PERMISSION.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("basic_set_MO_attributes: " + Util.stack2string((Throwable)nO_PERMISSION)));
                throw nO_PERMISSION;
            }
            catch (MoAccessException moAccessException) {
                string2 = moAccessException.toString() + ExceptionHelper.stackToString(moAccessException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.trace((int)5, this.getClass(), (String)("basic_set_MO_attributes: " + Util.stack2string((Throwable)moAccessException)));
                throw new ProcessingFailure(moAccessException.toString());
            }
            catch (RuntimeException runtimeException) {
                string2 = runtimeException.toString() + ExceptionHelper.stackToString(runtimeException.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_set_MO_attributes: ", (Throwable)runtimeException);
                throw new ProcessingFailure("InternalError: " + runtimeException);
            }
            catch (Error error) {
                string2 = error.toString() + ExceptionHelper.stackToString(error.getStackTrace());
                this.rollbackTransaction(coordinator);
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"basic_set_MO_attributes: ", (Throwable)error);
                throw new ProcessingFailure("InternalError: " + error);
            }
            Object var15_19 = null;
            this.auditLogWriter.addSetCmd(string, attrListImpl, this.getUserName(), coordinator, string2);
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            this.auditLogWriter.addSetCmd(string, attrListImpl, this.getUserName(), coordinator, string2);
            throw throwable;
        }
        MessageLog.traceReturn(this.getClass(), (String)"basic_set_MO_attributes");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Any action(MOidpair mOidpair, String string, NameValueSeqHolder nameValueSeqHolder, Session session) throws NotDefined, NotAccepted, ProcessingFailure {
        MessageLog.traceEnter(this.getClass(), (String)("action: name = " + string));
        Coordinator coordinator = null;
        Object[] objectArray = null;
        Any any = null;
        String string2 = null;
        String string3 = null;
        try {
            Any any2;
            try {
                Object object;
                if (session == null) {
                    coordinator = null;
                } else {
                    object = (SessionImpl)CelloOrb.instance().reference_to_servant(session);
                    if (object == null) {
                        string3 = "Invalid session object";
                        throw new ProcessingFailure(string3);
                    }
                    coordinator = ((SessionImpl)object).getCoordinator();
                }
                this.auditLogWriter.addResource(coordinator);
                ManagedObject managedObject = MoRefMgr.lookup(mOidpair, coordinator, session);
                if (managedObject == null) {
                    throw new MoNotFoundException(MoRefMgr.moidpairToString(mOidpair));
                }
                string2 = managedObject.getLocalDistinguishedName();
                object = TypeDnExtractor.extractTypeDnFromLDN(managedObject.getLocalDistinguishedName());
                if (!this.mibAccessControl.isAuthorizedInMib((String)object, 3, string)) {
                    throw new NO_PERMISSION("Not allowed to perform action " + string + " on MO of type " + managedObject.getType(), 20000, CompletionStatus.COMPLETED_NO);
                }
                NameValue[] nameValueArray = nameValueSeqHolder.value;
                Object[] objectArray2 = new Object[nameValueArray.length];
                for (int i = 0; i < nameValueArray.length; ++i) {
                    objectArray2[i] = AnyMapping.any2object(nameValueArray[i].value);
                }
                objectArray = objectArray2;
                LogContentInspector logContentInspector = this.inspectorMgr.lookup(managedObject.getType());
                if (logContentInspector != null) {
                    any2 = new Object[objectArray2.length];
                    System.arraycopy(objectArray2, 0, any2, 0, objectArray2.length);
                    Object[] objectArray3 = null;
                    objectArray3 = logContentInspector.hideHazardousActionParameters(string, (Object[])any2);
                    if (objectArray3 != null) {
                        if (objectArray3.length == objectArray2.length) {
                            objectArray = objectArray3;
                        } else {
                            MessageLog.traceError((Class)DynMoAccess.class, (String)("invokeAction: The log content inspector for MO type " + managedObject.getType() + " has not returned correct parameters. As a result the original attribute values are logged."));
                        }
                    }
                }
                any = theMoAccess.invokeAction(managedObject, string, nameValueArray, coordinator);
                MessageLog.traceReturn(this.getClass(), (String)"action");
                any2 = any;
                Object var18_24 = null;
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                string3 = nO_PERMISSION.toString() + ExceptionHelper.stackToString(nO_PERMISSION.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("action: " + Util.stack2string((Throwable)nO_PERMISSION)));
                throw nO_PERMISSION;
            }
            catch (NoPermissionException noPermissionException) {
                string3 = noPermissionException.toString() + ExceptionHelper.stackToString(noPermissionException.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("action: " + Util.stack2string((Throwable)noPermissionException)));
                throw new NO_PERMISSION(noPermissionException.toString(), 20000, CompletionStatus.COMPLETED_NO);
            }
            catch (MoNotFoundException moNotFoundException) {
                string3 = moNotFoundException.toString() + ExceptionHelper.stackToString(moNotFoundException.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("action: " + Util.stack2string((Throwable)moNotFoundException)));
                throw new NotDefined(moNotFoundException.toString());
            }
            catch (MoAccessException moAccessException) {
                string3 = moAccessException.toString() + ExceptionHelper.stackToString(moAccessException.getStackTrace());
                MessageLog.trace((int)5, this.getClass(), (String)("action: " + Util.stack2string((Throwable)moAccessException)));
                throw new ProcessingFailure(moAccessException.toString());
            }
            catch (RuntimeException runtimeException) {
                string3 = runtimeException.toString() + ExceptionHelper.stackToString(runtimeException.getStackTrace());
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"action: ", (Throwable)runtimeException);
                throw new ProcessingFailure("InternalError: " + runtimeException);
            }
            catch (Error error) {
                string3 = error.toString() + ExceptionHelper.stackToString(error.getStackTrace());
                MessageLog.traceError((Class)BasicConfigImpl.class, (String)"action: ", (Throwable)error);
                throw new ProcessingFailure("InternalError: " + error);
            }
            this.auditLogWriter.addActionCmd(string, objectArray, string2, this.getUserName(), any, coordinator, string3);
            return any2;
        }
        catch (Throwable throwable) {
            Object var18_25 = null;
            this.auditLogWriter.addActionCmd(string, objectArray, string2, this.getUserName(), any, coordinator, string3);
            throw throwable;
        }
    }

    public boolean next_MO(IterRef iterRef, MORefHolder mORefHolder, Session session) throws NotDefined, ProcessingFailure {
        try {
            MoIterator moIterator = MoIteratorMgr.instance().lookup(iterRef.id);
            if (moIterator == null) {
                throw new NotDefined("");
            }
            ManagedObject managedObject = moIterator.nextMo();
            if (managedObject == null) {
                throw new NotDefined("");
            }
            if (!moIterator.hasMoreElements()) {
                MoIteratorMgr.instance().deregister(iterRef.id);
            }
            mORefHolder.value = MoRefMgr.createMoRef(managedObject);
            return moIterator.hasMoreElements();
        }
        catch (NotDefined notDefined) {
            MessageLog.trace((int)5, this.getClass(), (String)("next_MO: " + Util.stack2string((Throwable)((Object)notDefined))));
            throw notDefined;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"next_MO: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError" + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"next_MO: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean next_MOs(IterRef iterRef, int n, MORefSeqHolder mORefSeqHolder, Session session) throws NotDefined, ProcessingFailure {
        try {
            Object object;
            int n2;
            MoIterator moIterator = MoIteratorMgr.instance().lookup(iterRef.id);
            if (moIterator == null) {
                throw new NotDefined("");
            }
            LinkedList<MORef> linkedList = new LinkedList<MORef>();
            for (n2 = 0; n2 < n && moIterator.hasMoreElements(); ++n2) {
                object = moIterator.nextMo();
                linkedList.add(MoRefMgr.createMoRef((ManagedObject)object));
            }
            object = linkedList.toArray();
            mORefSeqHolder.value = new MORef[((Object[])object).length];
            for (n2 = 0; n2 < ((Object[])object).length; ++n2) {
                mORefSeqHolder.value[n2] = (MORef)object[n2];
            }
            if (!moIterator.hasMoreElements()) {
                MoIteratorMgr.instance().deregister(iterRef.id);
            }
            return moIterator.hasMoreElements();
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"next_MOs: ", (Throwable)runtimeException);
            throw new ProcessingFailure("InternalError" + runtimeException);
        }
        catch (Error error) {
            MessageLog.traceError((Class)BasicConfigImpl.class, (String)"next_MOs: ", (Throwable)error);
            throw new ProcessingFailure("InternalError: " + error);
        }
    }

    public boolean all_MOs(IterRef iterRef, MORefSeqHolder mORefSeqHolder, Session session) throws NotDefined, ProcessingFailure {
        return this.next_MOs(iterRef, 1000, mORefSeqHolder, session);
    }

    public void delete_Iter(IterRef iterRef, Session session) throws ProcessingFailure {
        MoIteratorMgr.instance().deregister(iterRef.id);
    }

    public short[] get_QoS(Session session) {
        return this.supported_QoS(session);
    }

    public short[] supported_QoS(Session session) {
        short[] sArray = new short[]{0};
        return sArray;
    }

    private String getUserName() {
        String string = "Unknown";
        String string2 = null;
        if (current != null) {
            string2 = current.getAIC();
            string = string2 == null ? current.getUniqueID(current.getActingPrincipal()) : current.getUniqueID(current.getActingPrincipal()) + " Delegated by " + string2;
        }
        return string;
    }

    protected BasicConfigImpl() {
        theMoAccess = DynMoAccess.instance();
        this.auditLogWriter = AuditLogWriter.instance();
        exceptionHelper = new ExceptionHelper();
        this.inspectorMgr = InspectorMgr.instance();
        this.mibAccessControl = (MibAccessControl)ServiceLocatorFacade.getRepository().getService(MibAccessControl.class);
        if (this.mibAccessControl == null) {
            MessageLog.info((Class)BasicConfigImpl.class, (String)"Could not get reference to MibAccessControl");
        }
    }

    private void rollbackTransaction(Coordinator coordinator) {
        if (coordinator != null) {
            try {
                coordinator.rollbackOnly();
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
        }
    }
}

