/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import java.util.Hashtable;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.support.debug.MessageLog;

public class MoIteratorMgr {
    private static MoIteratorMgr theOneAndOnly;
    private static final int DEFAULT_ITERATOR_SIZE = 10000;
    private static final int MAX_ITERATOR_SIZE = 100000;
    private int nextId = 0;
    private Hashtable allIterators = new Hashtable();

    public static synchronized MoIteratorMgr instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new MoIteratorMgr();
        }
        return theOneAndOnly;
    }

    private MoIteratorMgr() {
    }

    public synchronized int register(MoIterator moIterator) {
        if (this.allIterators.size() >= this.getIteratorSize()) {
            MessageLog.info(this.getClass(), (String)"Clearing the old iterator ids as iterator count has reached the Maximum/Configured Iterator size limit");
            this.allIterators.clear();
        }
        ++this.nextId;
        Integer n = new Integer(this.nextId);
        this.allIterators.put(n, moIterator);
        return this.nextId;
    }

    private int getIteratorSize() {
        String string = System.getProperty("se.ericsson.cello.CsMoIteratorListSize");
        int n = 10000;
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 10000) {
                    n = n2;
                    if (n > 100000) {
                        MessageLog.info(this.getClass(), (String)"The property se.ericsson.cello.CsMoIteratorListSize has value greater than Maximum Iterator size limit. Hence, the value will be set to 100000");
                        n = 100000;
                    }
                } else {
                    MessageLog.info(this.getClass(), (String)"The property se.ericsson.cello.CsMoIteratorListSize has value less than Default Iterator limit. Hence, the value will be set to 10000");
                }
            }
            catch (NumberFormatException numberFormatException) {
                MessageLog.info(this.getClass(), (String)("The property se.ericsson.cello.CsMoIteratorListSize is invalid. Must be a number, now set to " + string + ". Using default value."));
            }
        }
        return n;
    }

    public synchronized void deregister(int n) {
        this.allIterators.remove(new Integer(n));
    }

    public synchronized MoIterator lookup(int n) {
        return (MoIterator)this.allIterators.get(new Integer(n));
    }
}

