/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.csnotification;

import ConfigExtended.AVCNotification;
import ConfigExtended.AttributeNotificationInfo;
import ConfigExtended.ConfigNotification;
import ConfigExtended.DeltaNotificationInfo;
import ConfigExtended.MOInfo;
import ConfigExtended.NotificationConsumer;
import ConfigExtended.NotificationProducerPackage.MOTypeAndAttributes;
import ConfigExtended.NotificationProducerPackage.NoTransactionException;
import ConfigExtended.NotificationProducerPackage.NotificationFilterExt;
import ConfigExtended.SequenceChangeInfo;
import ConfigExtended.SequenceDeltaNotification;
import ConfigExtended.SequenceElementChangeType;
import ConfigExtended.TopologyNotification;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.SystemException;
import se.ericsson.cello.configirpimpl.AnyMapping;
import se.ericsson.cello.csnotification.ConfigNotificationWrapper;
import se.ericsson.cello.csnotification.Consumer;
import se.ericsson.cello.csnotification.NotificationSizeCalculator;
import se.ericsson.cello.csnotification.SubscriptionMgr;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.util.BlockingQueue;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

class Subscription {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_QUEUE_SIZE = 1000;
    private static final int TRACE_GROUP = 5;
    private int subscriptionId;
    private NotificationConsumer subscriber;
    private int timeout;
    private Watchdog myWatchdog;
    private Thread watchdogThread = null;
    private BlockingQueue notificationQueue;
    private SubscriptionFilter subFilter;
    private Vector excludedTxList;
    private boolean supportSDN;

    Subscription(NotificationConsumer notificationConsumer, NotificationFilterExt notificationFilterExt, int n, int n2, boolean bl) {
        int n3 = 1000;
        String string = System.getProperty("se.ericsson.cello.CsNotificationQueueSize");
        if (string != null) {
            try {
                int n4 = Integer.parseInt(string);
                if (n4 > 1000) {
                    n3 = n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                MessageLog.info(this.getClass(), (String)("The property se.ericsson.cello.CsNotificationQueueSize is invalid. Must be a number, now set to " + string + ". Using default value."));
            }
        }
        this.subscriber = notificationConsumer;
        this.notificationQueue = new BlockingQueue(n3);
        this.subFilter = new SubscriptionFilter(notificationFilterExt);
        this.subscriptionId = n;
        this.excludedTxList = new Vector();
        this.supportSDN = bl;
        this.timeout = n2 > 0 ? n2 * 1000 : 10000;
        this.myWatchdog = new Watchdog(this, this.timeout);
        this.watchdogThread = new Thread((Runnable)this.myWatchdog, "CM_NotWatch_" + this.subscriptionId);
        this.watchdogThread.start();
        Consumer consumer = new Consumer(this, notificationConsumer);
        consumer.start();
    }

    synchronized NotificationConsumer getNotConsumer() {
        return this.subscriber;
    }

    synchronized void restartTimer() {
        this.myWatchdog.restartTimer();
    }

    int getId() {
        return this.subscriptionId;
    }

    void excludeTx(Coordinator coordinator) throws NoTransactionException {
        boolean bl = false;
        if (coordinator == null) {
            throw new NoTransactionException();
        }
        Enumeration enumeration = this.excludedTxList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            if (!((Coordinator)enumeration.nextElement()).isSameTransaction(coordinator)) continue;
            bl = true;
        }
        if (!bl) {
            this.excludedTxList.addElement(coordinator);
            new TxResource(this, coordinator);
        }
    }

    void removeTx(Coordinator coordinator) {
        this.excludedTxList.removeElement(coordinator);
    }

    void pushAVC(String string, String string2, String string3, int n, String[] stringArray, Object[] objectArray, int n2, Coordinator coordinator) {
        int[] nArray = this.wantedAttributes(string, string3, stringArray, coordinator);
        if (nArray.length == 0) {
            return;
        }
        MOInfo mOInfo = new MOInfo(n, string3, string, string2);
        AttributeNotificationInfo[] attributeNotificationInfoArray = new AttributeNotificationInfo[nArray.length];
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                attributeNotificationInfoArray[i] = new AttributeNotificationInfo(stringArray[nArray[i]], AnyMapping.object2any(objectArray[nArray[i]]));
            }
            catch (SystemException systemException) {
                MessageLog.info(this.getClass(), (String)(" pushAVC: Notification could not be sent " + (Object)((Object)systemException)));
                return;
            }
            l += NotificationSizeCalculator.calculateSize(objectArray[nArray[i]]);
        }
        AVCNotification aVCNotification = new AVCNotification(mOInfo, attributeNotificationInfoArray, n2);
        ConfigNotification configNotification = new ConfigNotification();
        configNotification.updatedMO(aVCNotification);
        ConfigNotificationWrapper configNotificationWrapper = new ConfigNotificationWrapper(l, configNotification);
        try {
            if (!this.notificationQueue.enqueue(configNotificationWrapper)) {
                this.handleQueFull();
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            SubscriptionMgr.terminateSubscription(this);
        }
    }

    private int[] wantedAttributes(String string, String string2, String[] stringArray, Coordinator coordinator) {
        if (!this.isSubscriberInterested(coordinator)) {
            return new int[0];
        }
        if (!(this.subFilter.sendAVC() && this.subFilter.inScope(string) && this.subFilter.wantedType(string2))) {
            return new int[0];
        }
        int[] nArray = this.subFilter.getAttrOfInterest(string2, stringArray);
        if (nArray.length == 0) {
            return new int[0];
        }
        return nArray;
    }

    void pushSequenceDeltaNotification(String string, String string2, String string3, int n, String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray, int n2, Coordinator coordinator) {
        SequenceChangeInfo[] sequenceChangeInfoArray;
        Object object;
        DeltaNotificationInfo[] deltaNotificationInfoArray = new DeltaNotificationInfo[sequenceDiffInfoArray.length];
        int[] nArray = this.wantedAttributes(string, string3, stringArray, coordinator);
        if (nArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[nArray.length];
        SequenceDiffInfo[] sequenceDiffInfoArray2 = new SequenceDiffInfo[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray2[i] = stringArray[nArray[i]];
            sequenceDiffInfoArray2[i] = sequenceDiffInfoArray[nArray[i]];
        }
        long l = 0L;
        for (int i = 0; i < stringArray2.length; ++i) {
            Object object2;
            List list = sequenceDiffInfoArray2[i].getRemoved();
            List list2 = sequenceDiffInfoArray2[i].getAdded();
            String string4 = stringArray2[i];
            object = list.iterator();
            sequenceChangeInfoArray = new SequenceChangeInfo[list.size() + list2.size()];
            int n3 = 0;
            while (object.hasNext()) {
                object2 = object.next();
                l += NotificationSizeCalculator.calculateSize(object2);
                try {
                    sequenceChangeInfoArray[n3++] = new SequenceChangeInfo(AnyMapping.object2any(object2), SequenceElementChangeType.DELETE);
                }
                catch (SystemException systemException) {
                    MessageLog.info(this.getClass(), (String)(" pushSequenceDeltaNotification: Notification could not be sent " + (Object)((Object)systemException)));
                    return;
                }
            }
            object2 = list2.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                l += NotificationSizeCalculator.calculateSize(e);
                try {
                    sequenceChangeInfoArray[n3++] = new SequenceChangeInfo(AnyMapping.object2any(e), SequenceElementChangeType.ADD);
                }
                catch (SystemException systemException) {
                    MessageLog.info(this.getClass(), (String)(" pushSequenceDeltaNotification: Notification could not be sent " + (Object)((Object)systemException)));
                    return;
                }
            }
            deltaNotificationInfoArray[i] = new DeltaNotificationInfo(string4, sequenceChangeInfoArray);
        }
        MOInfo mOInfo = new MOInfo(n, string3, string, string2);
        object = new SequenceDeltaNotification(mOInfo, deltaNotificationInfoArray, n2);
        sequenceChangeInfoArray = new ConfigNotification();
        sequenceChangeInfoArray.sequenceAttributeChanged((SequenceDeltaNotification)object);
        ConfigNotificationWrapper configNotificationWrapper = new ConfigNotificationWrapper(l, (ConfigNotification)sequenceChangeInfoArray);
        try {
            if (!this.notificationQueue.enqueue(configNotificationWrapper)) {
                this.handleQueFull();
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            SubscriptionMgr.terminateSubscription(this);
        }
    }

    void pushMoCreated(String string, String string2, String string3, int n, int n2, Coordinator coordinator) {
        if (!this.isSubscriberInterested(coordinator)) {
            return;
        }
        if (!(this.subFilter.sendTopology() && this.subFilter.inScope(string) && this.subFilter.wantedType(string3))) {
            return;
        }
        TopologyNotification topologyNotification = new TopologyNotification(new MOInfo(n, string3, string, string2), n2);
        ConfigNotification configNotification = new ConfigNotification();
        configNotification.createdMO(topologyNotification);
        ConfigNotificationWrapper configNotificationWrapper = new ConfigNotificationWrapper(0L, configNotification);
        try {
            if (!this.notificationQueue.enqueue(configNotificationWrapper)) {
                this.handleQueFull();
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            SubscriptionMgr.terminateSubscription(this);
        }
    }

    void pushMoDeleted(String string, String string2, String string3, int n, int n2, Coordinator coordinator) {
        if (!this.isSubscriberInterested(coordinator)) {
            return;
        }
        if (!(this.subFilter.sendTopology() && this.subFilter.inScope(string) && this.subFilter.wantedType(string3))) {
            return;
        }
        TopologyNotification topologyNotification = new TopologyNotification(new MOInfo(n, string3, string, string2), n2);
        ConfigNotification configNotification = new ConfigNotification();
        configNotification.deletedMO(topologyNotification);
        ConfigNotificationWrapper configNotificationWrapper = new ConfigNotificationWrapper(0L, configNotification);
        try {
            if (!this.notificationQueue.enqueue(configNotificationWrapper)) {
                this.handleQueFull();
            }
        }
        catch (BlockingQueue.ClosedException closedException) {
            SubscriptionMgr.terminateSubscription(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigNotificationWrapper[] dequeue() throws BlockingQueue.ClosedException {
        BlockingQueue blockingQueue = this.notificationQueue;
        synchronized (blockingQueue) {
            if (this.notificationQueue.isEmpty()) {
                ConfigNotificationWrapper[] configNotificationWrapperArray = new ConfigNotificationWrapper[]{(ConfigNotificationWrapper)this.notificationQueue.dequeue()};
                return configNotificationWrapperArray;
            }
            Object[] objectArray = this.notificationQueue.dequeueAll();
            ConfigNotificationWrapper[] configNotificationWrapperArray = new ConfigNotificationWrapper[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                configNotificationWrapperArray[i] = (ConfigNotificationWrapper)objectArray[i];
            }
            return configNotificationWrapperArray;
        }
    }

    void close() {
        this.notificationQueue.close();
        try {
            if (this.watchdogThread != null) {
                this.watchdogThread.interrupt();
            }
        }
        catch (SecurityException securityException) {
            MessageLog.traceError(this.getClass(), (String)"close(): ", (Throwable)securityException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueFull() throws BlockingQueue.ClosedException {
        BlockingQueue blockingQueue = this.notificationQueue;
        synchronized (blockingQueue) {
            this.notificationQueue.clear();
            ConfigNotification configNotification = new ConfigNotification();
            configNotification.overflow(SubscriptionMgr.createOverflowNotification("QUEUE_LIMIT_REACHED"));
            ConfigNotificationWrapper configNotificationWrapper = new ConfigNotificationWrapper(0L, configNotification);
            this.notificationQueue.enqueue(configNotificationWrapper);
        }
    }

    private boolean isSubscriberInterested(Coordinator coordinator) {
        boolean bl = true;
        if (coordinator != null) {
            Enumeration enumeration = this.excludedTxList.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Coordinator)enumeration.nextElement()).isSameTransaction(coordinator)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void setSupportSDN() {
        this.supportSDN = false;
    }

    public boolean getSupportSDN() {
        return this.supportSDN;
    }

    private static class Watchdog
    implements Runnable {
        private Subscription mySubscription;
        private int timeout;
        private boolean clearedByActor;

        Watchdog(Subscription subscription, int n) {
            this.mySubscription = subscription;
            this.timeout = n;
            this.clearedByActor = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                try {
                    do {
                        Watchdog watchdog = this;
                        synchronized (watchdog) {
                            this.clearedByActor = false;
                            try {
                                this.wait(this.timeout);
                            }
                            catch (InterruptedException interruptedException) {
                                break block9;
                            }
                        }
                    } while (this.clearedByActor);
                    SubscriptionMgr.terminateSubscription(this.mySubscription);
                    this.mySubscription = null;
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
                }
            }
        }

        public synchronized void restartTimer() {
            this.clearedByActor = true;
            this.notify();
        }
    }

    private static class TxResource
    implements Resource {
        private Subscription mySubscription;
        private Coordinator c;

        public TxResource(Subscription subscription, Coordinator coordinator) {
            Assert.cppAssert((Object)subscription);
            Assert.cppAssert((Object)coordinator);
            this.mySubscription = subscription;
            this.c = coordinator;
            try {
                coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                this.rollback();
            }
        }

        public void commit() {
            Fixer fixer = new Fixer(this.mySubscription, this.c);
            Thread thread = new Thread((Runnable)fixer, "CM_TxRemover_" + this.mySubscription.getId());
            thread.start();
            this.mySubscription = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            this.mySubscription.removeTx(this.c);
            this.mySubscription = null;
        }

        private static class Fixer
        implements Runnable {
            private Subscription s;
            private Coordinator c;

            Fixer(Subscription subscription, Coordinator coordinator) {
                this.s = subscription;
                this.c = coordinator;
            }

            public void run() {
                try {
                    Thread.sleep(60000L);
                    this.s.removeTx(this.c);
                    this.s = null;
                }
                catch (InterruptedException interruptedException) {
                    Assert.cppAssert(null, (String)("InterruptedException" + interruptedException.toString()));
                }
                catch (RuntimeException runtimeException) {
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)runtimeException);
                }
                catch (Error error) {
                    MessageLog.traceError(this.getClass(), (String)"run: ", (Throwable)error);
                }
            }
        }
    }

    private static class SubscriptionFilter {
        private MOTypeAndAttributes[] typesAndAttributes;
        private boolean sendTopology;
        private boolean sendAVC;
        private String baseMO;
        private int scope;

        public SubscriptionFilter(NotificationFilterExt notificationFilterExt) {
            this.typesAndAttributes = notificationFilterExt.typesAndAttributes;
            this.sendTopology = notificationFilterExt.topologyEvents;
            this.sendAVC = notificationFilterExt.avcEvents;
            this.baseMO = notificationFilterExt.baseMO;
            this.scope = notificationFilterExt.scope;
        }

        public boolean sendAVC() {
            return this.sendAVC;
        }

        public boolean sendTopology() {
            return this.sendTopology;
        }

        public boolean inScope(String string) {
            if (!string.startsWith(this.baseMO)) {
                return false;
            }
            if (string.length() == this.baseMO.length()) {
                return true;
            }
            if (string.charAt(this.baseMO.length()) != ',') {
                return false;
            }
            if (this.scope < 0) {
                return true;
            }
            if (this.scope == 0) {
                return false;
            }
            char[] cArray = string.substring(this.baseMO.length() + 1).toCharArray();
            int n = 1;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != ',') continue;
                ++n;
            }
            return n <= this.scope;
        }

        public boolean wantedType(String string) {
            if (this.typesAndAttributes.length == 0) {
                return true;
            }
            for (int i = 0; i < this.typesAndAttributes.length; ++i) {
                if (!string.equalsIgnoreCase(this.typesAndAttributes[i].typeOfMO)) continue;
                return true;
            }
            return false;
        }

        public int[] getAttrOfInterest(String string, String[] stringArray) {
            int[] nArray = new int[]{};
            if (this.typesAndAttributes.length == 0) {
                nArray = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = i;
                }
                return nArray;
            }
            for (int i = 0; i < this.typesAndAttributes.length; ++i) {
                int n;
                if (!this.typesAndAttributes[i].typeOfMO.equalsIgnoreCase(string)) continue;
                if (this.typesAndAttributes[i].attributes.length == 0) {
                    nArray = new int[stringArray.length];
                    for (int j = 0; j < stringArray.length; ++j) {
                        nArray[j] = j;
                    }
                    return nArray;
                }
                int[] nArray2 = new int[stringArray.length];
                int n2 = 0;
                block3: for (n = 0; n < stringArray.length; ++n) {
                    for (int j = 0; j < this.typesAndAttributes[i].attributes.length; ++j) {
                        if (!stringArray[n].equalsIgnoreCase(this.typesAndAttributes[i].attributes[j])) continue;
                        nArray2[n2] = n;
                        ++n2;
                        continue block3;
                    }
                }
                nArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    nArray[n] = nArray2[n];
                }
                return nArray;
            }
            return nArray;
        }
    }
}

