/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.faultmanagement;

import se.ericsson.cello.genericlog.InvalidParameterException;
import se.ericsson.cello.genericlog.Log;
import se.ericsson.cello.genericlog.LogAlreadyExistsException;
import se.ericsson.cello.genericlog.LogInternalErrorException;
import se.ericsson.cello.genericlog.LogMgr;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.BlockingQueue;

class AlarmEventLogHelper
implements Runnable {
    private BlockingQueue logEntriesQueue = new BlockingQueue(AlarmEventLogHelper.getMaxQueueSize());
    private final String LOG_NAME;
    private final int LOG_SIZE;
    private final String LOG_PATH;
    private Thread logWriterThread;
    private Log log;
    private static final int RETRY_INTERVAL = 2000;
    private static final int MAX_NUMBER_RETRIES = 20;
    private static final int ENQUEUE_MAX_NUMBER_RETRIES = 60;
    private static final int JAVA_HEAP_BREAKPOINT = 10000000;
    private static final int MAX_QUEUE_SIZE = 6000;
    private static final int MIN_QUEUE_SIZE = 1000;
    static /* synthetic */ Class class$se$ericsson$cello$faultmanagement$Alarm;

    AlarmEventLogHelper(String string, int n, String string2) {
        this.LOG_NAME = string;
        this.LOG_SIZE = n;
        this.LOG_PATH = string2;
        this.logWriterThread = new Thread((Runnable)this, this.LOG_NAME + "_Writer");
        this.logWriterThread.start();
    }

    public void run() {
        Object object = null;
        while (true) {
            try {
                while (true) {
                    if ((object = this.logEntriesQueue.dequeue()) instanceof String) {
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int i = 0; i < 20; ++i) {
                            try {
                                if (this.log == null) {
                                    this.lookupLogRef();
                                }
                                this.log.writeRecord(Log.ADD_TIME_STAMP, (String)object);
                                bl = true;
                                break;
                            }
                            catch (LogInternalErrorException logInternalErrorException) {
                                if (logInternalErrorException.resultCode == 10002) {
                                    MessageLog.info(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to " + logInternalErrorException.getMessage() + ". Log entry should be buffered in log server and written later. Data to be logged: " + object));
                                    bl2 = true;
                                    break;
                                }
                                this.log = null;
                                if (i == 0) {
                                    MessageLog.info(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to: " + logInternalErrorException.getMessage() + ", trying again..."));
                                }
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    MessageLog.traceError(this.getClass(), (String)"Thread interupted", (Throwable)interruptedException);
                                }
                                continue;
                            }
                        }
                        if (bl || bl2) continue;
                        MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " despite " + 20 + " retries. The following data will not be logged: " + object));
                        continue;
                    }
                    if (object != null) {
                        MessageLog.traceError(this.getClass(), (String)("Dequeued invalid object of type: " + object.getClass()));
                        continue;
                    }
                    MessageLog.traceError(this.getClass(), (String)"Dequeued null object");
                }
            }
            catch (InterruptedException interruptedException) {
                MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to unexpected InterruptedException "), (Throwable)interruptedException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to unexpected RuntimeException "), (Throwable)runtimeException);
                continue;
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to unexpected exception "), (Throwable)exception);
                continue;
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " due to unexpected error "), (Throwable)error);
                continue;
            }
            break;
        }
    }

    synchronized void lookupLogRef() throws LogInternalErrorException, InvalidParameterException, Exception {
        try {
            this.log = LogMgr.instance().createLog(this.LOG_NAME, this.LOG_SIZE, LogMgr.GLOBAL_STORAGE, LogMgr.XML_FORMAT, this.LOG_PATH, LogMgr.WRAPPED);
        }
        catch (LogAlreadyExistsException logAlreadyExistsException) {
            this.log = LogMgr.instance().findLog(this.LOG_NAME);
        }
    }

    void enqueue(String string) {
        boolean bl = this.logEntriesQueue.enqueue((Object)string);
        if (!bl) {
            MessageLog.info(this.getClass(), (String)("Failed to write to the log " + this.LOG_NAME + " due to full log data queue, trying again..."));
            for (int i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.traceError((Class)(class$se$ericsson$cello$faultmanagement$Alarm == null ? AlarmEventLogHelper.class$("se.ericsson.cello.faultmanagement.Alarm") : class$se$ericsson$cello$faultmanagement$Alarm), (String)"Thread interupted", (Throwable)interruptedException);
                }
                if (!this.logEntriesQueue.enqueue((Object)string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                MessageLog.traceError(this.getClass(), (String)("Failed to write to log " + this.LOG_NAME + " despite " + 60 + " retries. Log data queue was constantly full. " + "The following data will not be logged: " + string));
            }
        }
    }

    private static int getMaxQueueSize() {
        long l = Runtime.getRuntime().totalMemory();
        if (l < 10000000L) {
            return 1000;
        }
        return 6000;
    }
}

