/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.IllegalIdentityException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MaoContext;
import se.ericsson.cello.moframework.MaoContextImpl;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoIteratorImpl;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;

public abstract class ManagedObjectBase
implements ManagedObject {
    private ManagedObject parent;
    private List children = null;
    private String ldName = null;
    private Integer id;
    private boolean isRemoved = false;
    private String type;
    private InitialMaoContext initialMaoContext;
    private static final String[] ILLEGAL_CHARS = new String[]{"\u00a4", "|", "^", "'", "=", ","};
    private boolean isCreated = false;

    protected ManagedObjectBase(ManagedObject managedObject, String string, String string2, Coordinator coordinator) throws MoNameAlreadyTakenException {
        this(managedObject, string, string2, coordinator, MaoContextImpl.instance());
    }

    protected ManagedObjectBase(ManagedObject managedObject, String string, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        this.parent = managedObject;
        this.type = string;
        this.initialMaoContext = initialMaoContext;
        this.checkForIllegalCharacters(string2, coordinator);
        String string3 = string + "=" + string2;
        this.ldName = this.parent != null ? this.parent.getLocalDistinguishedName() + "," + string3 : string3;
        initialMaoContext.getWritableMoAccessor().registerMo(this, coordinator);
    }

    protected ManagedObjectBase(String string) throws MoNameAlreadyTakenException {
        this(string, MaoContextImpl.instance());
    }

    protected ManagedObjectBase(String string, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        this.ldName = string;
        this.type = this.extractTypeFromLDN(string);
        this.initialMaoContext = initialMaoContext;
        this.isCreated = true;
        initialMaoContext.getWritableMoAccessor().registerMo(this, null);
    }

    public String getType() {
        return this.type;
    }

    public void delete(Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        if (!this.isCreated && MoRepository.instance().lookup(this.ldName) == null) {
            throw new UndeletableMoException(this, "MO already deleted");
        }
        this.initialMaoContext.getWritableMoAccessor().deregisterMo(this, coordinator);
    }

    public void addChild(ManagedObject managedObject) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(managedObject);
    }

    public void removeChild(ManagedObject managedObject) {
        if (this.children != null) {
            this.children.remove(managedObject);
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }

    public boolean isRoot() {
        return this.getLocalDistinguishedName().lastIndexOf(",") == -1;
    }

    public boolean isResolved() {
        return this.parent != null || this.isRoot();
    }

    public String getLocalDistinguishedName() {
        return this.ldName;
    }

    public String getRelativeDistinguishedName() {
        if (this.isRoot()) {
            return this.ldName;
        }
        int n = this.ldName.lastIndexOf(",");
        if (n != -1) {
            String string = this.ldName.substring(n + 1);
            return string;
        }
        return null;
    }

    public String getNamingAttributeValue() {
        int n = this.ldName.lastIndexOf("=");
        if (n != -1) {
            String string = this.ldName.substring(n + 1);
            return string;
        }
        return null;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        try {
            Class<?> clazz;
            Method method = this.findMethod("get" + string);
            if (method == null) {
                if (string.equalsIgnoreCase(this.getType() + "Id")) {
                    return this.getNamingAttributeValue();
                }
                throw new NoSuchAttributeException(string, this.getType());
            }
            Object[] objectArray = new Object[]{coordinator};
            Object object = method.invoke((Object)this, objectArray);
            if (object == null && !ManagedObject.class.isAssignableFrom(clazz = method.getReturnType())) {
                Assert.cppAssert((boolean)false, (String)("Only MO get access methods that returns an MO are allowed to return null, returntype :" + clazz + " method :" + method));
                return null;
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof MoAccessException) {
                throw (MoAccessException)invocationTargetException.getTargetException();
            }
            MessageLog.traceError(this.getClass(), (String)"get attribute exception:", (Throwable)invocationTargetException.getTargetException());
            throw new SoftwareErrorException(invocationTargetException.getTargetException());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WrongAttributeTypeException(string, this.getType());
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.cppAssert((boolean)false, (String)("DynMoAccess.getOneAttribute exception :" + illegalAccessException + " attr :" + string));
            Assert.cppAssert((boolean)false);
            return null;
        }
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray = null;
        Object[] objectArray2 = new Object[stringArray.length];
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Class<?> clazz2;
                int n;
                boolean bl = false;
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equalsIgnoreCase("get" + stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                        objectArray2[i] = this.getNamingAttributeValue();
                        continue;
                    }
                    throw new NoSuchAttributeException(stringArray[i], this.getType());
                }
                objectArray = new Object[]{coordinator};
                objectArray2[i] = methodArray[n].invoke((Object)this, objectArray);
                if (objectArray2[i] != null || (class$se$ericsson$cello$moframework$ManagedObject == null ? ManagedObjectBase.class$("se.ericsson.cello.moframework.ManagedObject") : class$se$ericsson$cello$moframework$ManagedObject).isAssignableFrom(clazz2 = methodArray[n].getReturnType())) continue;
                Assert.cppAssert((boolean)false, (String)("Only MO get access methods that returns an MO are allowed to return null, returntype :" + clazz2 + " method :" + methodArray[n]));
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof MoAccessException) {
                    throw (MoAccessException)invocationTargetException.getTargetException();
                }
                MessageLog.traceError(this.getClass(), (String)"get attribute exception:", (Throwable)invocationTargetException.getTargetException());
                throw new SoftwareErrorException(invocationTargetException.getTargetException());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WrongAttributeTypeException(stringArray[i], this.getType());
            }
            catch (IllegalAccessException illegalAccessException) {
                Assert.cppAssert((boolean)false, (String)("DynMoAccess.getOneAttribute exception :" + illegalAccessException + " attr :" + stringArray[i]));
            }
        }
        return objectArray2;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        try {
            Method method = this.findMethod("set" + string);
            if (method == null) {
                throw new NoSuchAttributeException(string, this.getType());
            }
            Object[] objectArray = new Object[]{object, coordinator};
            method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof MoAccessException) {
                throw (MoAccessException)invocationTargetException.getTargetException();
            }
            MessageLog.traceError(this.getClass(), (String)"set attribute exception:", (Throwable)invocationTargetException.getTargetException());
            throw new SoftwareErrorException(invocationTargetException.getTargetException());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WrongAttributeTypeException(string, this.getType());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AttrNotSettableException(this, string);
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        Object[] objectArray2 = null;
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n;
                boolean bl = false;
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equalsIgnoreCase("set" + stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new NoSuchAttributeException(stringArray[i], this.getType());
                }
                objectArray2 = new Object[]{objectArray[i], coordinator};
                methodArray[n].invoke((Object)this, objectArray2);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof MoAccessException) {
                    throw (MoAccessException)invocationTargetException.getTargetException();
                }
                MessageLog.traceError(this.getClass(), (String)"set attribute exception:", (Throwable)invocationTargetException.getTargetException());
                throw new SoftwareErrorException(invocationTargetException.getTargetException());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WrongAttributeTypeException(stringArray[i], this.getType());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AttrNotSettableException(this, stringArray[i]);
            }
        }
    }

    private Method findMethod(String string) {
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        Object var4_4 = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase(string)) continue;
            return methodArray[i];
        }
        return null;
    }

    public String getFullDistinguishedName() {
        String string = this.getNamePrefix();
        if (string.length() == 0) {
            return this.ldName;
        }
        return string + "," + this.ldName;
    }

    public String getNamePrefix() {
        Mib mib = this.getMaoContext().getMib();
        Assert.cppAssert((Object)mib, (String)("No MIB found :" + this.ldName));
        return mib.getMibPrefix();
    }

    public ManagedObject getParent() {
        return this.parent;
    }

    public MoIterator getChildren() {
        ArrayList<ManagedObject> arrayList = null;
        if (this.children == null) {
            arrayList = new ArrayList<ManagedObject>(0);
        } else {
            ManagedObject managedObject = null;
            arrayList = new ArrayList(this.children.size());
            for (int i = 0; i < this.children.size(); ++i) {
                managedObject = (ManagedObject)this.children.get(i);
                if (managedObject == null || managedObject.isRemoved()) continue;
                arrayList.add(managedObject);
            }
        }
        return new MoIteratorImpl(arrayList);
    }

    public void setParent(ManagedObject managedObject) {
        this.parent = managedObject;
    }

    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Integer getId() {
        return this.id;
    }

    public String toString() {
        return this.getFullDistinguishedName();
    }

    protected MaoContext getMaoContext() {
        return this.initialMaoContext;
    }

    private String extractTypeFromLDN(String string) {
        int n = string.lastIndexOf(",");
        n = n == -1 ? 0 : ++n;
        int n2 = string.lastIndexOf("=");
        return string.substring(n, n2);
    }

    private void checkForIllegalCharacters(String string, Coordinator coordinator) throws IllegalIdentityException {
        for (int i = 0; i < ILLEGAL_CHARS.length; ++i) {
            if (string.indexOf(ILLEGAL_CHARS[i]) == -1) continue;
            try {
                coordinator.rollbackOnly();
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                // empty catch block
            }
            throw new IllegalIdentityException("Identity (" + string + ") contains illegal characters");
        }
    }

    public void setCreated(boolean bl) {
        this.isCreated = bl;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public final boolean equals(Object object) {
        if (object instanceof ManagedObject) {
            ManagedObject managedObject = (ManagedObject)object;
            return this.getId().intValue() == managedObject.getId().intValue();
        }
        return false;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }
}

