/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.recovery.MoTypeLookup;
import se.ericsson.cello.transaction.Coordinator;

public class ReferenceAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 259823827781573047L;
    private transient ManagedObject myReferredMo = null;
    private transient ManagedObject myReferredMoBackup = null;
    private String myReferredDName = null;
    private transient boolean myIsTransactionActive = false;

    public ReferenceAttribute(String string, boolean bl) {
        super(string, bl);
    }

    public ReferenceAttribute(String string, boolean bl, ManagedObject managedObject) {
        super(string, bl);
        this.myReferredMo = managedObject;
    }

    public ReferenceAttribute(String string, String string2, boolean bl) {
        super(string, bl);
        this.myReferredDName = string2;
    }

    public ReferenceAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        String string3 = string2.substring(2);
        this.myReferredDName = string3.equals("null") ? null : MoTypeLookup.instance().convertToLDN(string3);
    }

    public synchronized ManagedObject getValue(Coordinator coordinator) throws MoRemovedException {
        if (this.myReferredMo == null && this.myReferredDName != null) {
            this.resolve();
        }
        if (this.myReferredMo != null && this.myReferredMo.isRemoved()) {
            throw new MoRemovedException(this.myReferredMo.getLocalDistinguishedName());
        }
        if ((coordinator == null || coordinator.getTransactionID() == 0) && this.myIsTransactionActive) {
            return this.myReferredMoBackup;
        }
        return this.myReferredMo;
    }

    public synchronized String getReferenceAsLDN() {
        if (this.myReferredDName != null) {
            return this.myReferredDName;
        }
        if (this.myReferredMo != null) {
            return this.myReferredMo.getLocalDistinguishedName();
        }
        return null;
    }

    public synchronized void setValue(ManagedObject managedObject) {
        this.myReferredDName = null;
        this.myReferredMo = managedObject;
    }

    synchronized void rollback() {
        this.myReferredMo = this.myReferredMoBackup;
        this.myIsTransactionActive = false;
        this.myReferredDName = null;
    }

    synchronized void commit() {
        this.myReferredMoBackup = null;
        this.myIsTransactionActive = false;
    }

    synchronized void startTransaction() {
        try {
            this.resolve();
        }
        catch (MoRemovedException moRemovedException) {
            // empty catch block
        }
        this.myReferredMoBackup = this.myReferredMo;
        this.myIsTransactionActive = true;
    }

    private void resolve() throws MoRemovedException {
        if (this.myReferredMo == null && this.myReferredDName != null) {
            ManagedObject managedObject = MoRepository.instance().lookup(this.myReferredDName);
            if (managedObject == null) {
                throw new MoRemovedException(this.myReferredDName);
            }
            this.myReferredMo = managedObject;
            this.myReferredMoBackup = managedObject;
            this.myReferredDName = null;
        }
    }

    Object getValueAsObject(Coordinator coordinator) {
        try {
            return this.getValue(coordinator);
        }
        catch (MoRemovedException moRemovedException) {
            return null;
        }
    }

    Object getBackUpValueAsObject(Coordinator coordinator) {
        return this.myReferredMoBackup;
    }

    boolean isModified() {
        return this.myReferredMo != this.myReferredMoBackup;
    }

    public String buildValueString() {
        String string = null;
        String string2 = null;
        if ((this.myReferredMo != null || this.myReferredDName == null) && this.myReferredMo != null) {
            this.myReferredDName = this.myReferredMo.getLocalDistinguishedName();
        }
        string2 = this.getNotificationType() != 0 ? "T" : "F";
        string = this.myReferredDName != null ? MoTypeLookup.instance().convertToShortLDNFormat(this.myReferredDName) : null;
        return "^r" + string2 + string;
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    boolean equal(Attribute attribute, Coordinator coordinator) {
        boolean bl = false;
        ManagedObject managedObject = (ManagedObject)this.getValueAsObject(coordinator);
        ManagedObject managedObject2 = (ManagedObject)attribute.getValueAsObject(coordinator);
        if (managedObject == null && managedObject2 == null) {
            return true;
        }
        if (managedObject == null || managedObject2 == null) {
            return false;
        }
        Integer n = managedObject.getId();
        Integer n2 = managedObject2.getId();
        if (n.intValue() == n2.intValue()) {
            bl = true;
        }
        return bl;
    }
}

