/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.notification;

import java.util.Vector;

class BlockingQueue {
    private Vector queue = new Vector();
    private int maxSize;
    private boolean isClosed = false;

    public BlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public BlockingQueue(int n) {
        this.maxSize = n;
    }

    public final synchronized boolean enqueue(Object object) throws ClosedException {
        if (this.isClosed) {
            throw new ClosedException();
        }
        if (this.isFull()) {
            return false;
        }
        this.queue.addElement(object);
        this.notify();
        return true;
    }

    public synchronized void clear() {
        this.queue.removeAllElements();
    }

    public synchronized Object[] dequeueAll() throws ClosedException {
        if (this.isClosed) {
            throw new ClosedException();
        }
        Object[] objectArray = new Object[this.queue.size()];
        for (int i = 0; i < this.queue.size(); ++i) {
            objectArray[i] = this.queue.elementAt(i);
        }
        this.clear();
        return objectArray;
    }

    public synchronized Object dequeue() throws ClosedException {
        if (this.isClosed) {
            throw new ClosedException();
        }
        try {
            if (this.isEmpty()) {
                while (this.isEmpty() && !this.isClosed) {
                    this.wait(5000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.isClosed = true;
        }
        if (this.isClosed) {
            throw new ClosedException();
        }
        Object e = this.queue.firstElement();
        this.queue.removeElementAt(this.queue.indexOf(e));
        return e;
    }

    public final boolean isEmpty() {
        return this.queue.size() <= 0;
    }

    public final boolean isFull() {
        return this.queue.size() >= this.maxSize;
    }

    public int size() {
        return this.queue.size();
    }

    public synchronized void close() {
        this.clear();
        this.isClosed = true;
        this.notifyAll();
    }

    public class ClosedException
    extends Exception {
    }
}

