/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.Serializable;
import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.pms.generic.CounterBasedScanner;
import se.ericsson.cello.pms.generic.Measurable;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.MeasuredDataUpdatable;
import se.ericsson.cello.pms.generic.MeasurementStatus;
import se.ericsson.cello.pms.generic.NoValueException;
import se.ericsson.cello.pms.generic.ValueNotYetAvailableException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

abstract class ObservedEntity
implements Measurable,
Serializable {
    private transient Object[] valueObjectArray;
    private transient MeasuredDataUpdatable measuredData;
    protected boolean isMeasured = false;
    static final long serialVersionUID = -1607544300511323943L;

    ObservedEntity() {
    }

    protected abstract String[] getAttributes();

    protected abstract void setAttributes(String[] var1);

    public MeasuredData result() {
        return this.measuredData;
    }

    public boolean isMeasured() {
        return this.isMeasured;
    }

    protected MeasurementStatus fetch(ManagedObject managedObject, ArrayList arrayList, Coordinator coordinator, CounterBasedScanner counterBasedScanner) {
        MeasurementStatus measurementStatus = MeasurementStatus.OK;
        String[] stringArray = this.getAttributes();
        Object object = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                object = managedObject.getAttribute(stringArray[i], coordinator);
                arrayList.add(object);
                continue;
            }
            catch (ValueNotYetAvailableException valueNotYetAvailableException) {
                measurementStatus = MeasurementStatus.UNAVAILABLE;
                MessageLog.trace((int)8, this.getClass(), (String)("mo.getAttributes(" + managedObject.getLocalDistinguishedName() + ") - ValueNotYetAvailableException"));
                continue;
            }
            catch (NoValueException noValueException) {
                measurementStatus = MeasurementStatus.SUSPECT;
                MessageLog.trace((int)8, this.getClass(), (String)("mo.getAttributes(" + managedObject.getLocalDistinguishedName() + ") - NoValueException"));
                continue;
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                MessageLog.info(this.getClass(), (String)("Received a NoSuchAttributeException on MO " + managedObject.getLocalDistinguishedName() + ", trying to repair scanner reconfiguration."));
                measurementStatus = MeasurementStatus.ATTRIBUTE_MISMATCH;
                object = new Integer(-1);
                arrayList.add(object);
                MessageLog.info((String)"Unable to get attribute values from resource. Suspect flag has been set.");
                continue;
            }
            catch (Exception exception) {
                measurementStatus = MeasurementStatus.SUSPECT;
                object = new Integer(-1);
                arrayList.add(object);
                MessageLog.info((String)"Unable to get attribute values from resource. Suspect flag has been set.");
                MessageLog.trace((int)8, this.getClass(), (String)("mo.getAttributes(" + managedObject.getLocalDistinguishedName() + ") - " + exception.getMessage()));
            }
        }
        this.isMeasured = true;
        return measurementStatus;
    }

    protected Object[] createValueArray() {
        if (this.valueObjectArray == null) {
            this.valueObjectArray = new Object[this.getAttributes().length];
        }
        this.clearValueArray();
        return this.valueObjectArray;
    }

    protected void createMeasuredData() {
        MessageLog.trace((int)8, this.getClass(), (String)"createMeasuredData()");
        this.measuredData = new MeasuredDataUpdatable(this.getAttributes());
        this.clearValueArray();
        this.isMeasured = false;
    }

    protected MeasuredDataUpdatable getMeasuredData() {
        if (this.measuredData == null) {
            this.createMeasuredData();
        }
        return this.measuredData;
    }

    protected void clearValueArray() {
        if (this.valueObjectArray != null) {
            for (int i = 0; i < this.valueObjectArray.length; ++i) {
                this.valueObjectArray[i] = null;
            }
        }
    }
}

