/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.productinventory;

import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import se.ericsson.cello.ProductInventory.InventoryServicePOATie;
import se.ericsson.cello.productinventory.InventoryServiceImpl;
import se.ericsson.cello.productinventory.RequestScheduler;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateManager;
import se.ericsson.cello.support.thread.BlockingQueue;

public class ProductInventory {
    private static InventoryServiceImpl invent = null;
    private static int serviceProviderState = 2;
    private static ServiceProvider serviceProvider;

    public static void init() {
        try {
            BlockingQueue blockingQueue = new BlockingQueue();
            RequestScheduler[] requestSchedulerArray = new RequestScheduler[3];
            for (int i = 0; i < requestSchedulerArray.length; ++i) {
                requestSchedulerArray[i] = new RequestScheduler(blockingQueue);
                requestSchedulerArray[i].start();
            }
            invent = new InventoryServiceImpl(blockingQueue);
            InventoryServicePOATie inventoryServicePOATie = new InventoryServicePOATie(invent);
            CelloOrb.instance().connect("CelloInventoryService", inventoryServicePOATie);
            NameComponent nameComponent = new NameComponent("CelloInventoryService", "");
            NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
            CelloOrb.instance().rebind(nameComponentArray, CelloOrb.instance().servant_to_reference(inventoryServicePOATie));
            serviceProvider = new ServiceProviderImpl();
            ServiceStateManager.getInstance().registerService(serviceProvider);
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
        }
        catch (UserException userException) {
            MessageLog.traceError((Class)ProductInventory.class, (String)"CORBA user exception: ", (Throwable)userException);
        }
    }

    public static void reinit() {
        try {
            InventoryServicePOATie inventoryServicePOATie = new InventoryServicePOATie(invent);
            CelloOrb.instance().connect("CelloInventoryService", inventoryServicePOATie);
            NameComponent nameComponent = new NameComponent("CelloInventoryService", "");
            NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
            CelloOrb.instance().rebind(nameComponentArray, CelloOrb.instance().servant_to_reference(inventoryServicePOATie));
            serviceProviderState = 1;
            ServiceStateManager.getInstance().updateServiceProviderState(serviceProvider);
        }
        catch (UserException userException) {
            MessageLog.traceError((Class)ProductInventory.class, (String)"CORBA user exception: ", (Throwable)userException);
        }
    }

    private static class ServiceProviderImpl
    implements ServiceProvider {
        public String getServiceName() {
            return "CPP.OAM.PRODUCTINVENTORYSERVICE";
        }

        public int getState() {
            return serviceProviderState;
        }
    }
}

