/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.corba;

import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.ETF.Profile;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import se.ericsson.cello.support.corba.RequestItem;
import se.ericsson.cello.support.corba.RequestItemHandler;
import se.ericsson.cello.support.debug.MessageLog;

public class RemoteAddressInterceptor
extends LocalObject
implements ServerRequestInterceptor,
ORBInitializer {
    public RemoteAddressInterceptor() {
        RequestItemHandler.instance().clear();
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        RequestItem requestItem = this.getRequestItemFromRequestInfo(serverRequestInfo);
        if (requestItem != null) {
            RequestItemHandler.instance().storeItem(requestItem);
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeStoredRequest(serverRequestInfo);
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.removeStoredRequest(serverRequestInfo);
    }

    public void destroy() {
        RequestItemHandler.instance().clear();
    }

    public String name() {
        return "RemoteAddressInterceptor";
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
        try {
            oRBInitInfo.add_server_request_interceptor((ServerRequestInterceptor)this);
        }
        catch (DuplicateName duplicateName) {
            // empty catch block
        }
    }

    private RequestItem getRequestItemFromRequestInfo(ServerRequestInfo serverRequestInfo) {
        RequestItem requestItem = null;
        if (serverRequestInfo instanceof ServerRequestInfoImpl) {
            ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)serverRequestInfo;
            if (serverRequestInfoImpl.request != null) {
                Profile profile = serverRequestInfoImpl.request.getConnection().getTransport().get_server_profile();
                if (profile != null) {
                    requestItem = new RequestItem(Thread.currentThread().getName(), profile.toString(), serverRequestInfo.operation());
                } else {
                    MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"Local call. Ignoring request");
                }
            }
        } else {
            MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"Can not determine peer connection type");
        }
        return requestItem;
    }

    private void removeStoredRequest(ServerRequestInfo serverRequestInfo) {
        RequestItem requestItem = this.getRequestItemFromRequestInfo(serverRequestInfo);
        if (requestItem != null) {
            RequestItemHandler.instance().removeItem(requestItem);
        }
    }
}

