/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.support.services.ServiceProvider;
import se.ericsson.cello.support.services.ServiceStateListener;
import se.ericsson.cello.support.services.ServiceStateManagement;

public class ServiceStateManager
implements ServiceStateManagement {
    private static ServiceStateManagement myInstance;
    private HashMap myServices = new HashMap();
    private HashMap myServicesListeners = new HashMap();

    private ServiceStateManager() {
    }

    public static void setInstance(ServiceStateManagement serviceStateManagement) {
        if (myInstance == null) {
            myInstance = serviceStateManagement;
        }
    }

    public static ServiceStateManagement getInstance() {
        if (myInstance == null) {
            myInstance = new ServiceStateManager();
        }
        return myInstance;
    }

    public void registerService(ServiceProvider serviceProvider) {
        if (serviceProvider != null) {
            this.myServices.put(serviceProvider.getServiceName(), serviceProvider);
        }
    }

    public Collection getRegisteredServices() {
        return this.myServices.values();
    }

    public int getState(String string) {
        int n = this.myServices.get(string) != null ? ((ServiceProvider)this.myServices.get(string)).getState() : 0;
        return n;
    }

    public void registerServiceStateListener(ServiceStateListener serviceStateListener, String[] stringArray) {
        if (stringArray != null && serviceStateListener != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                List<ServiceStateListener> list;
                if (this.getListenersForService(stringArray[i]) == null) {
                    list = new ArrayList<ServiceStateListener>();
                    list.add(serviceStateListener);
                    this.myServicesListeners.put(stringArray[i], list);
                    continue;
                }
                list = this.getListenersForService(stringArray[i]);
                if (list.contains(serviceStateListener)) continue;
                list.add(serviceStateListener);
            }
        }
    }

    public void deRegisterServiceStateListener(ServiceStateListener serviceStateListener) {
        Collection collection = this.myServicesListeners.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            if (!arrayList.contains(serviceStateListener)) continue;
            arrayList.remove(serviceStateListener);
        }
    }

    public void updateServiceProviderState(ServiceProvider serviceProvider) {
        ArrayList arrayList = (ArrayList)this.myServicesListeners.get(serviceProvider.getServiceName());
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ServiceStateListener serviceStateListener = (ServiceStateListener)arrayList.get(i);
                if (serviceProvider.getState() == 1) {
                    serviceStateListener.serviceAvailable(serviceProvider);
                    continue;
                }
                if (serviceProvider.getState() != 2) continue;
                serviceStateListener.serviceNotAvailable(serviceProvider);
            }
        }
    }

    private List getListenersForService(String string) {
        return (ArrayList)this.myServicesListeners.get(string);
    }
}

