/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.model.ExportDeleteModel;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.postcontrol.ExportConfigDataPostController;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.postcontrol.ExportDeleteRollBackCvPostController;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.view.ExportDeleteView;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.view.ExportDeleteViewer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConfigurationVersion;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.support.gui.EmasProgressMonitor;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class ExportDeleteController
extends AbstractApplicationController
implements ProgressReporter,
Observer {
    private static RbsEmPropertiesFileHandler rbsEmProp = RbsEmPropertiesFileHandler.getInstance();
    private static final String TITLE_STRING_EXP_DEL_PROGRESS = "Export/Delete Progress";
    private static final String VALUE_STRING_PROGRESS_FOR_OFFLINE = "Checking that all Cells are Offline      ";
    private static final String TITLE_STRING_COMMIT_MO_PROGRESS = "Commit Deleted MO     ";
    private static final String VALUE_STRING_PROGRESS_FOR_COMMIT = "Commit Deleted MO                                      ";
    private static final String VALUE_STRING_USE_ROLLBACK_CV_FAILED_EXC = "Trying to use Rollback CV failed";
    private static final String VALUE_STRING_GET_EXP_PROG_REPORT_EXC = "Get Total No of ExportProgressReports Failed!";
    private static final String VALUE_STRING_GET_RBS_LOCAL_CELLS_EXC = "Unable to check Rbs Local Cells off Line";
    private static final String VALUE_STRING_EXPORT_FAILED_EXC = "Export Function Failed";
    private static final String VALUE_STRING_ROLLBACK_CREATE_FAIL_EXC = "Rollback CV creation failed";
    private static final String VALUE_STRING_PREPARE_DELETE_FAIL_EXC = "Prepare Delete failed!";
    private static final String VALUE_STRING_PREPARE_DELETE_FAIL = "Delete failed! Error during preparation phase.";
    private static final String VALUE_STRING_COMMIT_AND_ROLLBACK_FAIL = "Delete: Commit and Rollback failed. Reverting to Cancel CV.";
    private static final String VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC = "Delete failed! Rollback to previous configuration.";
    private static final String TITLE_STRING_FILECHOOSER = "Save Configuration File";
    private static final String VALUE_STRING_IS_DIRECTORY = "{0} is a directory, specify a valid filename.";
    private static final String TITLE_STRING_IS_DIRECTORY = "Directory";
    private static final String VALUE_STRING_CONFIRM_OVERWRITE = "Are you sure you want to overwrite the existing file {0}?";
    private static final String TITLE_STRING_CONFIRM_OVERWRITE = "Confirm Overwrite";
    private static final String VALUE_STRING_INVALID_FILENAME = "File can not be created. Check permissions and/or that file name is valid {0}";
    private static final String TITLE_STRING_INVALID_FILENAME = "Specify Filename";
    private static final String TITLE_STRING_EXPORT_CONFIGURATION_DATA = "Exporting configuration data";
    private static final String VALUE_STRING_EXPORT_CONFIGURATION_DATA = "Exporting configuration data";
    private static final String VALUE_STRING_PRINT_STACK = "Stack: ";
    private static final String VALUE_STRING_INFORMATION = "Information";
    private static final String VALUE_STRING_WARNING = "Warning";
    private static final String VALUE_STRING_CONFIRM = "Confirm";
    private static final String VALUE_STRING_ERROR = "Error";
    private static final String VALUE_STRING_BROWSE_BUTTON_EXC = "ExportDelete Browse button failed";
    private static final String VALUE_STRING_EXPORT_CHKBOX_EXC = "ExportDelete Checkbox failed";
    private static final String VALUE_STRING_EXPORT_CONFIG_DATA_FAIL_EXC = "Export of configuration data for cabinet and site failed";
    private static final String RESTART_INFORMATION = "ExportDelete configuration failed rollback to previous configuration";
    private static final String VALUE_STRING_INVALID_CHARS_IN_FILENAME = "Filename {0} contains an invalid character. The invalid character is: ";
    private static final String TITLE_STRING_INVALID_CHARS_IN_FILENAME = "Choose another filename";
    private static final CharSequence[] INCORRECT_CHARS = new CharSequence[]{"%", "\u00c5", "\u00c4", "\u00d6", "\u00e5", "\u00e4", "\u00f6", ",", "?", "[", "]", "\u00a3", "{", "}"};
    private ExportDeleteViewer myView = null;
    private int totalExpectedProgressReports = 0;
    private int progressReportsReceived = 0;
    private EmasProgressMonitor progressBar;
    private ExportDeleteModel exportDeleteModel = null;
    private ExportDeleteRollBackCvPostController theRollbackCvController = null;
    private boolean isExportAndDeleteThreadRunning = false;

    protected void init() {
        this.myView = (ExportDeleteViewer)((Object)this.getView());
        this.exportDeleteModel = ExportDeleteModel.getTheInstance();
        this.exportDeleteModel.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        NalNameValue nalNameValue = (NalNameValue)object;
        Integer n = (Integer)nalNameValue.getValue();
        this.progressReportsReceived += n.intValue();
        this.reportProgress(TITLE_STRING_EXP_DEL_PROGRESS, nalNameValue.getName());
        BemLog.log(7, "Progress: " + this.progressReportsReceived + " (" + this.totalExpectedProgressReports + ")");
    }

    protected boolean canStop() {
        return true;
    }

    protected void afterVisible() {
        try {
            this.arrangeGui();
            this.myView.getOkButton().addActionListener(new OkButtonListener());
            this.myView.getCancelButton().addActionListener(new CancelButtonListener());
            this.myView.setListernerOnExportMibBrowseButton(new ExportMibBrowseButtonListener());
            this.myView.setListernerOnExportMibCheckBox(new ExportMibCheckBoxListener());
            this.myView.setListernerOnExportConfigurationDataCheckBox(new ExportConfigDataCheckBoxListener());
            this.myView.setListernerOnExportXmlCabinetBrowseButton(new ExportCabinetXmlBrowseButtonListener());
            this.myView.setListernerOnExportXmlSiteBrowseButton(new ExportSiteXmlBrowseButtonListener());
            this.myView.setListenerOnDeleteCheckBox(new DeleteCheckBoxListener());
        }
        catch (Exception exception) {
            this.displayError(exception.toString());
        }
    }

    protected void displayInformation(String string) {
        this.progressBar.close();
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_INFORMATION, 1);
        this.endTheApplication();
    }

    protected void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_WARNING, 2);
    }

    protected boolean displayConfirmDialog(String string) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, VALUE_STRING_CONFIRM, 0);
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    protected boolean displayConfirmOkCancelDialog(String string, String string2) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, string2, 2, 3);
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    protected void displayError(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_ERROR, 0);
    }

    protected void displayErrorMsg(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_ERROR, 0);
    }

    protected void displayErrorMsg(String string, String string2) {
        JOptionPane.showMessageDialog(null, string, string2, 0);
    }

    public void reportComplete(StringBuffer stringBuffer) {
    }

    public void reportError(BemException bemException) {
        this.getEasyPopUp().displayError(bemException);
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        if (this.progressBar != null) {
            this.progressBar.setNote(string2);
            this.progressBar.setProgress(this.progressReportsReceived);
        }
    }

    public String getReportedProgress() {
        return this.progressBar.getNote();
    }

    private void cleanUpProgress() {
        if (this.progressReportsReceived != this.totalExpectedProgressReports) {
            BemLog.log(7, "Prog: " + this.progressReportsReceived + " Total: " + this.totalExpectedProgressReports);
            this.progressBar.close();
        }
    }

    private void endTheApplication() {
        this.cleanUpProgress();
        this.totalExpectedProgressReports = 0;
        this.progressReportsReceived = 0;
        this.exportDeleteModel.deleteObserver(this);
        AbstractApplication abstractApplication = this.getApplication();
        if (abstractApplication != null) {
            abstractApplication.stopApplication();
        }
    }

    private void arrangeGui() {
        this.arrangeExportConfigDataInGui();
        this.arrangeExportMibInGui();
        this.arrangeDeleteInGui();
    }

    private void arrangeExportMibInGui() {
        boolean bl = this.myView.shallExportMib();
        String string = "XML_PATH";
        String string2 = rbsEmProp.getProperty(string);
        if (string2 != null) {
            File file = new File(string2);
            boolean bl2 = file.isDirectory();
            String string3 = System.getProperty("file.separator");
            if (bl2) {
                String string4 = string2 + string3 + "mib.xml";
                this.myView.setExportMibFileName(string4);
            } else {
                this.myView.setExportMibFileName(string2);
            }
        } else {
            this.myView.setExportMibFileName("");
        }
        this.myView.enableExportMib(bl);
    }

    private void arrangeDeleteInGui() {
        boolean bl = this.myView.shallDelete();
        this.myView.enableDelete(bl);
    }

    private void arrangeExportConfigDataInGui() {
        boolean bl = this.myView.shallExportConfigurationData();
        String string = "XML_PATH";
        String string2 = rbsEmProp.getProperty(string);
        if (string2 != null) {
            File file = new File(string2);
            boolean bl2 = file.isDirectory();
            String string3 = System.getProperty("file.separator");
            if (bl2) {
                String string4 = string2 + string3 + "cabinet.xml";
                String string5 = string2 + string3 + "site.xml";
                this.myView.setExportXmlCabinetFileName(string4);
                this.myView.setExportXmlSiteFileName(string5);
            } else {
                this.myView.setExportXmlCabinetFileName(string2);
                this.myView.setExportXmlSiteFileName(string2);
            }
        } else {
            this.myView.setExportXmlCabinetFileName("");
            this.myView.setExportXmlSiteFileName("");
        }
        this.myView.enableExportConfigurationData(bl);
    }

    private void rollbackToCancelCv(boolean bl) {
        MoHandlerCache moHandlerCache = ExportDeleteModel.getMoHandler();
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimSwManagement.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimConfigurationVersion.MOTYPENAME, "1");
        boolean bl2 = true;
        try {
            String string = singleChildMoi2.getLdn();
            BemMo bemMo = moHandlerCache.getMo(string);
            String string2 = this.theRollbackCvController.getRollBackCvName();
            if (string2 != null) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string2)};
                moHandlerCache.action(bemMo, "setStartable", nalNameValueArray);
                String string3 = "\n The node is in an un-defined state. It is needed to perform a rollback.\n The rollback requires that the node is restarted. ";
                if (bl) {
                    bl2 = this.displayConfirmDialog(string3 + "\n\n Do you want to perform the rollback?");
                } else {
                    this.displayWarningMessage(string3);
                }
                if (bl2) {
                    NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", 1), Nal.getFactory().getNameValue("restartReason", 3), Nal.getFactory().getNameValue("restartInfo", RESTART_INFORMATION)};
                    moHandlerCache.action(moHandlerCache.getRoot(), "manualRestart", nalNameValueArray2);
                }
            }
        }
        catch (Exception exception) {
            BemLog.exceptionRaised(VALUE_STRING_USE_ROLLBACK_CV_FAILED_EXC, exception);
            this.displayError(VALUE_STRING_USE_ROLLBACK_CV_FAILED_EXC);
            BemLog.log(7, "Exception: " + exception.toString());
        }
    }

    private void exportAndDeleteAction() {
        block44: {
            BemLogAndScriptUtil bemLogAndScriptUtil = BemLogAndScriptUtil.getInstance();
            try {
                boolean bl;
                boolean bl2;
                String string = null;
                String string2 = null;
                String string3 = "XML_PATH";
                String string4 = null;
                String string5 = null;
                Rbs rbs = null;
                String[] stringArray = null;
                boolean bl3 = this.myView.shallDelete();
                boolean bl4 = this.myView.shallremoveSecondaryDUW();
                boolean bl5 = this.myView.shallExportMib();
                boolean bl6 = this.myView.shallExportConfigurationData();
                this.theRollbackCvController = null;
                ExportInstaller exportInstaller = new ExportInstaller();
                this.theRollbackCvController = new ExportDeleteRollBackCvPostController(exportInstaller);
                if (bl6) {
                    string4 = this.myView.getExportXmlCabinetFileName();
                    string5 = this.myView.getExportXmlSiteFileName();
                    bl2 = this.prepareFile(string4);
                    if (!bl2) {
                        return;
                    }
                    bl2 = this.prepareFile(string5);
                    if (!bl2) {
                        return;
                    }
                    this.totalExpectedProgressReports += 2;
                }
                if (bl5) {
                    Object object;
                    string = this.myView.getExportMibFileName();
                    if (string.length() == 0) {
                        String[] stringArray2 = new String[]{""};
                        String string6 = MessageFormat.format(VALUE_STRING_INVALID_FILENAME, stringArray2);
                        this.displayErrorMsg(string6, TITLE_STRING_INVALID_FILENAME);
                        return;
                    }
                    bl2 = this.prepareFile(string);
                    if (!bl2) {
                        return;
                    }
                    boolean bl7 = this.myView.shallCompressMibInZipFormat();
                    if (bl7 && !(bl2 = this.prepareFile((File)(object = new File(string2 = string + ".zip"))))) {
                        return;
                    }
                    object = new File(string).getParent();
                    if (object != null) {
                        rbsEmProp.setProperty(string3, (String)object);
                        rbsEmProp.storeBemPropInFile();
                    }
                    try {
                        this.totalExpectedProgressReports += this.exportDeleteModel.getTotalNoOfExportProgressReports();
                    }
                    catch (MoHandlerException moHandlerException) {
                        this.displayError(VALUE_STRING_GET_EXP_PROG_REPORT_EXC);
                        BemLog.exceptionRaised(VALUE_STRING_GET_EXP_PROG_REPORT_EXC, moHandlerException);
                        BemLog.log(7, VALUE_STRING_PRINT_STACK + moHandlerException.toString());
                    }
                }
                if (bl3) {
                    this.totalExpectedProgressReports += this.theRollbackCvController.getTotalNoOfProgressReports();
                    this.totalExpectedProgressReports += this.exportDeleteModel.getTotalNoOfDeleteProgressReports();
                    ++this.totalExpectedProgressReports;
                }
                this.progressBar = new EmasProgressMonitor((ExportDeleteView)this.myView, TITLE_STRING_EXP_DEL_PROGRESS, "", "                                                                ", 0, 0);
                this.progressBar.setMillisToDecideToPopup(0);
                this.progressBar.setMillisToPopup(0);
                this.progressBar.setMaximum(this.totalExpectedProgressReports);
                if (bl6) {
                    ++this.progressReportsReceived;
                    this.reportProgress("Exporting configuration data", "Exporting configuration data");
                    MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
                    rbs = RbsFactory.getRbs((MoHandler)moHandlerImpl, "STEP_SITE", DuwUtil.isPantherHybridRbs());
                    OpenCIs.openExportXmlCIs(rbs);
                    stringArray = rbs.getConfigurationCheckReport();
                    if (!this.displayMsgIfExisting(stringArray)) {
                        this.progressBar.close();
                        return;
                    }
                }
                if (bl3) {
                    ++this.progressReportsReceived;
                    this.reportProgress(TITLE_STRING_EXP_DEL_PROGRESS, VALUE_STRING_PROGRESS_FOR_OFFLINE);
                    Object[] objectArray = null;
                    try {
                        objectArray = this.exportDeleteModel.getRbsLocalCellsNotOffLine();
                    }
                    catch (MoHandlerException moHandlerException) {
                        this.displayError(VALUE_STRING_GET_RBS_LOCAL_CELLS_EXC);
                        BemLog.exceptionRaised(VALUE_STRING_GET_RBS_LOCAL_CELLS_EXC, moHandlerException);
                        BemLog.log(7, VALUE_STRING_PRINT_STACK + moHandlerException.toString());
                        this.progressBar.close();
                        return;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    if (objectArray.length != 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringBuffer.append(objectArray[i].toString());
                            if (i >= objectArray.length - 1) continue;
                            stringBuffer.append(", ");
                        }
                        this.displayErrorMsg("All cells needs to be off line before the configuration can be deleted. (" + stringBuffer.toString() + " not Off Line.)", "Cells On Line.\n Please lock all cells for this RBS in the RNC");
                        this.progressBar.close();
                        return;
                    }
                    if (bl4) {
                        if (!DuwUtil.hasDualDuws()) {
                            this.displayError("There are not dual Duws,so you can't remove secondary duw.");
                            this.progressBar.close();
                            return;
                        }
                        boolean bl8 = this.exportDeleteModel.isSecondaryDuwOffLine();
                        if (!bl8) {
                            this.displayError("Secondary DUW is not off line,please check it.");
                            this.progressBar.close();
                            return;
                        }
                    }
                }
                boolean bl9 = bl = bl3 || bl6 || bl5;
                if (bl) {
                    this.myView.disableAllComponents();
                }
                boolean bl10 = false;
                if (bl5) {
                    try {
                        this.exportDeleteModel.exportMOToXML(string, string2);
                    }
                    catch (Exception exception) {
                        BemLog.exceptionRaised(VALUE_STRING_EXPORT_FAILED_EXC, exception);
                        this.displayError(VALUE_STRING_EXPORT_FAILED_EXC);
                        bl10 = true;
                    }
                }
                if (bl6) {
                    try {
                        ++this.progressReportsReceived;
                        this.reportProgress("Exporting configuration data", "Exporting configuration data");
                        this.doExportConfigData(exportInstaller, string4, string5, rbs, stringArray);
                    }
                    catch (Exception exception) {
                        this.displayError("Export of configuration data for cabinet and site failed\n Details:\n" + exception.toString());
                        BemLog.exceptionRaised(VALUE_STRING_EXPORT_CONFIG_DATA_FAIL_EXC, exception);
                        BemLog.log(7, VALUE_STRING_PRINT_STACK + exception.toString());
                        bl10 = true;
                    }
                }
                if (bl3) {
                    bemLogAndScriptUtil.logStartConfigurationProcedure("DeleteCabinetAndSite_main");
                    bemLogAndScriptUtil.logStartConfigurationStep("RollbackCvController");
                    try {
                        this.theRollbackCvController.install();
                    }
                    catch (BemException bemException) {
                        BemLog.exceptionRaised(VALUE_STRING_ROLLBACK_CREATE_FAIL_EXC, bemException);
                        this.displayError(VALUE_STRING_ROLLBACK_CREATE_FAIL_EXC);
                        bemLogAndScriptUtil.logEndConfigurationStep();
                        bl10 = true;
                    }
                    bemLogAndScriptUtil.logEndConfigurationStep();
                    boolean bl11 = false;
                    try {
                        bl11 = this.exportDeleteModel.prepareDeleteMO();
                        if (bl4) {
                            bl11 = this.exportDeleteModel.prepareRemoveSecondaryDUW();
                        }
                    }
                    catch (BemException bemException) {
                        this.displayError(VALUE_STRING_PREPARE_DELETE_FAIL_EXC);
                        BemLog.exceptionRaised(VALUE_STRING_PREPARE_DELETE_FAIL_EXC, bemException);
                        BemLog.log(7, VALUE_STRING_PRINT_STACK + bemException.toString());
                        bl10 = true;
                    }
                    if (!bl11) {
                        this.displayError(VALUE_STRING_PREPARE_DELETE_FAIL);
                        BemLog.log(4, VALUE_STRING_PREPARE_DELETE_FAIL);
                        bl10 = true;
                    } else {
                        try {
                            this.cleanUpProgress();
                            this.totalExpectedProgressReports = 1 + ExportDeleteModel.getMoHandler().getTotalNoOfOrerredMoOperations();
                            this.progressReportsReceived = 0;
                            this.progressBar = new EmasProgressMonitor((ExportDeleteView)this.myView, TITLE_STRING_COMMIT_MO_PROGRESS, "                               ", VALUE_STRING_PROGRESS_FOR_COMMIT, this.progressReportsReceived, this.totalExpectedProgressReports);
                            ++this.progressReportsReceived;
                            this.reportProgress(TITLE_STRING_COMMIT_MO_PROGRESS, VALUE_STRING_PROGRESS_FOR_COMMIT);
                            this.exportDeleteModel.commitDeleteMO();
                            if (bl4) {
                                this.exportDeleteModel.prepareDeleteInterPiuLink();
                            }
                            this.clearProductName();
                            this.setDefaultVauleForNumHsCodeResourcesPerBBP();
                        }
                        catch (MoHandlerException moHandlerException) {
                            bl10 = true;
                            if (moHandlerException.getAction().equals("ROLLBACK_TRANSACTION")) {
                                BemLog.log(4, VALUE_STRING_COMMIT_AND_ROLLBACK_FAIL);
                                BemLog.log(7, VALUE_STRING_PRINT_STACK + moHandlerException.toString());
                                this.rollbackToCancelCv(true);
                            }
                            this.displayError(VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC);
                            BemLog.exceptionRaised(VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC, moHandlerException);
                            BemLog.log(4, VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC);
                            BemLog.log(7, VALUE_STRING_PRINT_STACK + moHandlerException.toString());
                        }
                    }
                }
                bemLogAndScriptUtil.logEndConfigurationProcedure();
                if (bl && !bl10) {
                    String string7 = this.buildOkMessage();
                    this.displayInformation(string7);
                } else {
                    this.endTheApplication();
                }
            }
            catch (Exception exception) {
                String string = "Unexpected exception " + exception.toString();
                this.displayErrorMsg(string);
                exception.printStackTrace();
                bemLogAndScriptUtil.logEndConfigurationProcedure();
                if (this.progressBar == null) break block44;
                this.progressBar.close();
            }
        }
    }

    private void doExportConfigData(ExportInstaller exportInstaller, String string, String string2, Rbs rbs, String[] stringArray) throws BemException {
        ExportConfigDataPostController exportConfigDataPostController = new ExportConfigDataPostController(exportInstaller, rbs, string, string2, stringArray);
        this.totalExpectedProgressReports += exportConfigDataPostController.getTotalNoOfProgressReports();
        exportConfigDataPostController.install();
    }

    private boolean prepareFile(String string) {
        File file = new File(string);
        return this.prepareFile(file);
    }

    private boolean prepareFile(File file) {
        String string;
        String string2 = file.getName();
        String[] stringArray = new String[]{string2};
        Character c = this.charsCorrect(string2);
        if (c != null) {
            String string3 = MessageFormat.format(VALUE_STRING_INVALID_CHARS_IN_FILENAME, stringArray);
            this.displayErrorMsg(string3.concat(c + ""), TITLE_STRING_INVALID_CHARS_IN_FILENAME);
            return false;
        }
        if (file.exists() && !file.isDirectory()) {
            string = MessageFormat.format(VALUE_STRING_CONFIRM_OVERWRITE, stringArray);
            boolean bl = this.displayConfirmOkCancelDialog(string, TITLE_STRING_CONFIRM_OVERWRITE);
            if (!bl) {
                return false;
            }
            file.delete();
        }
        if (file.isDirectory()) {
            string = MessageFormat.format(VALUE_STRING_IS_DIRECTORY, stringArray);
            this.displayErrorMsg(string, TITLE_STRING_IS_DIRECTORY);
            return false;
        }
        try {
            string = MessageFormat.format(VALUE_STRING_INVALID_FILENAME, stringArray);
            if (string2 == null || string2.length() == 0 || string2.trim().equals("")) {
                string = "File can not be created. Check permissions and/or that file name is valid {0} .No fileName given.";
            }
            if (!file.createNewFile()) {
                this.displayErrorMsg(string, TITLE_STRING_INVALID_FILENAME);
                return false;
            }
            if (!file.canWrite()) {
                this.displayErrorMsg(string, TITLE_STRING_INVALID_FILENAME);
                return false;
            }
            file.delete();
        }
        catch (IOException iOException) {
            String string4 = MessageFormat.format(VALUE_STRING_INVALID_FILENAME, stringArray);
            this.displayErrorMsg(string4, TITLE_STRING_INVALID_FILENAME);
            return false;
        }
        return true;
    }

    private void clearProductName() throws BemException {
        try {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            BemMo bemMo = moHandlerImpl.getRoot();
            moHandlerImpl.setAttribute(bemMo, "productName", "");
        }
        catch (Exception exception) {
            throw new BemException("Trying to clear productName in ManagedElement. Message=" + exception.toString());
        }
    }

    private void setDefaultVauleForNumHsCodeResourcesPerBBP() throws MoHandlerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BemMo bemMo = null;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        arrayList.add(DuwUtil.getPrimaryDuw1stBBPLdn());
        arrayList.add(DuwUtil.getPrimaryDuw2ndBBPLdn());
        arrayList.add(DuwUtil.getSecondaryDuw1stBBPLdn());
        arrayList.add(DuwUtil.getSecondaryDuw2ndBBPLdn());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            bemMo = moHandlerImpl.getMo(iterator.next().toString());
            if (!moHandlerImpl.isExisting(bemMo)) continue;
            moHandlerImpl.setAttribute(bemMo, "numHsCodeResources", MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES);
        }
    }

    private boolean displayMsgIfExisting(String[] stringArray) {
        boolean bl = true;
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Following configuration characteristics is discovered in your RBS.\nDo you want to continue?\n==============================================\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i] + "\n");
            }
            JTextArea jTextArea = new JTextArea(stringBuffer.toString());
            jTextArea.setRows(15);
            jTextArea.setColumns(40);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            int n = JOptionPane.showConfirmDialog(null, jScrollPane, "Configuration characteristics discovered", 0);
            if (n == 1) {
                bl = false;
            }
        }
        return bl;
    }

    private String buildOkMessage() {
        String string = "";
        boolean bl = this.myView.shallDelete();
        boolean bl2 = this.myView.shallExportMib();
        boolean bl3 = this.myView.shallExportConfigurationData();
        if (bl) {
            string = "Delete operation successfully completed ";
        }
        if (bl2 || bl3) {
            string = "Export operation successfully completed ";
        }
        if (bl && (bl2 || bl3)) {
            string = "Export and delete operation successfully completed ";
        }
        return string;
    }

    private Character charsCorrect(String string) {
        int n;
        Character c = null;
        boolean bl = true;
        for (n = 0; n < INCORRECT_CHARS.length && !(bl = string.contains(INCORRECT_CHARS[n])); ++n) {
        }
        if (bl) {
            c = new Character(INCORRECT_CHARS[n].charAt(0));
            return c;
        }
        return c;
    }

    class ExportInstaller
    implements Installer {
        ExportInstaller() {
        }

        public boolean isInterrupted() {
            return false;
        }

        public void reportProgress(String string, String string2) {
            this.reportProgress(string, string2, 1);
        }

        public void reportProgress(String string, String string2, int n) {
            ExportDeleteController.this.reportProgress(string, string2);
            ExportDeleteController.this.progressReportsReceived += n;
        }

        public void extendInstallReport(StringBuffer stringBuffer) {
        }

        public void reportComplete() {
        }

        public String getReportedProgress() {
            return ExportDeleteController.this.progressBar.getNote();
        }

        public void stopExecution() {
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportDeleteController.this.endTheApplication();
        }
    }

    class ExportSiteXmlBrowseButtonListener
    extends AbstractBrowseButtonListener {
        ExportSiteXmlBrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = super.getFileName();
            ExportDeleteController.this.myView.setExportXmlSiteFileName(string);
        }
    }

    class ExportCabinetXmlBrowseButtonListener
    extends AbstractBrowseButtonListener {
        ExportCabinetXmlBrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = super.getFileName();
            File file = new File(string);
            boolean bl = file.isDirectory();
            if (bl) {
                String string2 = System.getProperty("file.separator");
                string = string + string2 + "cabinet.xml";
            }
            ExportDeleteController.this.myView.setExportXmlCabinetFileName(string);
        }
    }

    class ExportMibBrowseButtonListener
    extends AbstractBrowseButtonListener {
        ExportMibBrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            String string = super.getFileName();
            ExportDeleteController.this.myView.setExportMibFileName(string);
        }
    }

    abstract class AbstractBrowseButtonListener
    implements ActionListener {
        String theFileName = null;

        AbstractBrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object;
                String string = "XML_PATH";
                String string2 = rbsEmProp.getProperty(string);
                JFileChooser jFileChooser = new JFileChooser(string2);
                BemFileFilter bemFileFilter = new BemFileFilter("xml", "XML files");
                jFileChooser.setFileFilter(bemFileFilter);
                jFileChooser.setDialogTitle(ExportDeleteController.TITLE_STRING_FILECHOOSER);
                int n = -1;
                while (n != 0) {
                    n = jFileChooser.showOpenDialog(null);
                    if (n == 1) {
                        return;
                    }
                    File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
                    if (file.exists()) {
                        object = file.getName();
                        String[] stringArray = new String[]{object};
                        String string3 = MessageFormat.format(ExportDeleteController.VALUE_STRING_CONFIRM_OVERWRITE, stringArray);
                        boolean bl = ExportDeleteController.this.displayConfirmOkCancelDialog(string3, ExportDeleteController.TITLE_STRING_CONFIRM_OVERWRITE);
                        if (bl) {
                            file.delete();
                        } else {
                            n = -1;
                        }
                    }
                    try {
                        if (!file.createNewFile()) continue;
                        file.delete();
                    }
                    catch (IOException iOException) {
                        ExportDeleteController.this.displayErrorMsg(ExportDeleteController.VALUE_STRING_INVALID_FILENAME, ExportDeleteController.TITLE_STRING_INVALID_FILENAME);
                        n = -1;
                    }
                }
                this.theFileName = jFileChooser.getSelectedFile().getAbsolutePath();
                object = jFileChooser.getCurrentDirectory();
                rbsEmProp.setProperty(string, ((File)object).getPath());
                rbsEmProp.storeBemPropInFile();
            }
            catch (Exception exception) {
                BemLog.exceptionRaised(ExportDeleteController.VALUE_STRING_BROWSE_BUTTON_EXC, exception);
                ExportDeleteController.this.displayError(ExportDeleteController.VALUE_STRING_BROWSE_BUTTON_EXC);
            }
        }

        protected String getFileName() {
            return this.theFileName;
        }
    }

    class ExportConfigDataCheckBoxListener
    implements ActionListener {
        ExportConfigDataCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                boolean bl = ExportDeleteController.this.myView.shallExportConfigurationData();
                String string = "XML_PATH";
                String string2 = rbsEmProp.getProperty(string);
                if (string2 != null) {
                    File file = new File(string2);
                    boolean bl2 = file.isDirectory();
                    String string3 = System.getProperty("file.separator");
                    if (bl2) {
                        String string4 = string2 + string3 + "cabinet.xml";
                        String string5 = string2 + string3 + "site.xml";
                        ExportDeleteController.this.myView.setExportXmlCabinetFileName(string4);
                        ExportDeleteController.this.myView.setExportXmlSiteFileName(string5);
                    } else {
                        ExportDeleteController.this.myView.setExportXmlCabinetFileName(string2);
                        ExportDeleteController.this.myView.setExportXmlSiteFileName(string2);
                    }
                } else {
                    ExportDeleteController.this.myView.setExportXmlCabinetFileName("");
                    ExportDeleteController.this.myView.setExportXmlSiteFileName("");
                }
                ExportDeleteController.this.myView.enableExportConfigurationData(bl);
            }
            catch (Exception exception) {
                BemLog.exceptionRaised(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC, exception);
                ExportDeleteController.this.displayError(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC);
            }
        }
    }

    class DeleteCheckBoxListener
    implements ActionListener {
        DeleteCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                boolean bl = ExportDeleteController.this.myView.shallDelete();
                ExportDeleteController.this.myView.enableDelete(bl);
            }
            catch (Exception exception) {
                BemLog.exceptionRaised(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC, exception);
                ExportDeleteController.this.displayError(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC);
            }
        }
    }

    class ExportMibCheckBoxListener
    implements ActionListener {
        ExportMibCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                boolean bl = ExportDeleteController.this.myView.shallExportMib();
                String string = "XML_PATH";
                String string2 = rbsEmProp.getProperty(string);
                if (string2 != null) {
                    File file = new File(string2);
                    boolean bl2 = file.isDirectory();
                    String string3 = System.getProperty("file.separator");
                    if (bl2) {
                        String string4 = string2 + string3 + "mib.xml";
                        ExportDeleteController.this.myView.setExportMibFileName(string4);
                    } else {
                        ExportDeleteController.this.myView.setExportMibFileName(string2);
                    }
                } else {
                    ExportDeleteController.this.myView.setExportMibFileName("");
                }
                ExportDeleteController.this.myView.enableExportMib(bl);
            }
            catch (Exception exception) {
                BemLog.exceptionRaised(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC, exception);
                ExportDeleteController.this.displayError(ExportDeleteController.VALUE_STRING_EXPORT_CHKBOX_EXC);
            }
        }
    }

    class OkButtonListener
    implements ActionListener {
        OkButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ExportDeleteController.this.isExportAndDeleteThreadRunning) {
                Thread thread = new Thread("BEM ExportAndDelete Wizard"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ExportDeleteController.this.isExportAndDeleteThreadRunning = true;
                            ExportDeleteController.this.exportAndDeleteAction();
                        }
                        catch (Exception exception) {
                            ExportDeleteController.this.displayError(exception.toString());
                        }
                        finally {
                            ExportDeleteController.this.isExportAndDeleteThreadRunning = false;
                        }
                    }
                };
                thread.start();
            }
        }
    }
}

