/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.AbstractDtdInfo;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.AbstractXmlElement;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.xmlelement.NormalElement;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.util.RadioDotSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.AlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.CommonAlarmCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.RbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.GenericAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.SauDeviceGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.XalmCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.XalmDeviceGroupRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementFactory {
    private static final String[] ignoredAttributes = new String[]{"sectorNumber"};
    private static boolean subElementToEthernetSwitchPort = false;
    private static String ethernetSwitchPortPrefix = "";
    private static final String CONFIGURATION_MODE_DHCP = "DHCP";

    public static AbstractXmlElement createRootElement(String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        return new NormalElement(string, abstractDtdInfo, rbs);
    }

    public static List createContainedElements(AbstractXmlElement abstractXmlElement, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        String string = abstractXmlElement.getElementName();
        ArrayList<NormalElement> arrayList = new ArrayList<NormalElement>();
        String[] stringArray = abstractDtdInfo.getContainedElements(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                XmlElementFactory.createXmlElements(string2, abstractXmlElement, abstractDtdInfo, rbs, arrayList);
            }
        }
        return arrayList;
    }

    private static void createXmlElements(String string, AbstractXmlElement abstractXmlElement, AbstractDtdInfo abstractDtdInfo, Rbs rbs, List<NormalElement> list) throws BemException {
        if (abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getSectorNumberAttributeName()) && abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getCreateSectorAttributeName()) && !string.equals("Alarm") && !abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getSequenceNumberAttributeName()) && !string.equals("PositionConfiguration")) {
            int n;
            int[] nArray;
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray2 = radioEquipmentProvider.getExistingSectors();
            for (int i = 0; i < nArray2.length; ++i) {
                arrayList.add(nArray2[i]);
            }
            if (rbs.isPantherHybridRbs()) {
                RadioEquipmentProvider radioEquipmentProvider2 = rbs.getRadioEquipmentProvider(1);
                nArray = radioEquipmentProvider2.getExistingSectors();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(nArray[n]);
                }
            }
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
            for (n = 0; n < nArray.length; ++n) {
                String string2 = String.valueOf(nArray[n]);
                String string3 = MessageFormat.format("S{0}_", string2);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string3, string2));
            }
        } else if (!(!abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getSectorNumberAttributeName()) || string.equals("Alarm") || abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getSequenceNumberAttributeName()) || string.equals("PositionConfiguration") || string.equals("InciConnector"))) {
            int n;
            int[] nArray;
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray3 = radioEquipmentProvider.getEquippedSectors();
            for (int i = 0; i < nArray3.length; ++i) {
                arrayList.add(nArray3[i]);
            }
            if (rbs.isPantherHybridRbs()) {
                RadioEquipmentProvider radioEquipmentProvider3 = rbs.getRadioEquipmentProvider(1);
                nArray = radioEquipmentProvider3.getEquippedSectors();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(nArray[n]);
                }
            }
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
            for (n = 0; n < nArray.length; ++n) {
                String string4 = String.valueOf(nArray[n]);
                String string5 = MessageFormat.format("S{0}_", string4);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string5, string4));
            }
        } else if (abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getCellNumberAttributeName())) {
            int n = rbs.getMaxNumberOfCells();
            String string6 = abstractXmlElement.getCountedValue();
            String string7 = MessageFormat.format("S{0}_", string6);
            for (int i = 1; i <= n; ++i) {
                String string8 = String.valueOf(i);
                String string9 = MessageFormat.format("C{0}_", string8);
                String string10 = string7 + string9;
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string10, string8));
            }
        } else if (abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getSequenceNumberAttributeName())) {
            int n;
            int[] nArray;
            int n2 = 6;
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray4 = radioEquipmentProvider.getEquippedSectors();
            for (int i = 0; i < nArray4.length; ++i) {
                arrayList.add(nArray4[i]);
            }
            if (rbs.isPantherHybridRbs()) {
                RadioEquipmentProvider radioEquipmentProvider4 = rbs.getRadioEquipmentProvider(1);
                nArray = radioEquipmentProvider4.getEquippedSectors();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(nArray[n]);
                }
            }
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
            for (n = 0; n < nArray.length; ++n) {
                String string11 = String.valueOf(nArray[n]);
                String string12 = MessageFormat.format("S{0}_", string11);
                for (int i = 1; i <= n2; ++i) {
                    String string13 = MessageFormat.format("SEQ{0}_", i);
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, string12 + string13, string11, String.valueOf(i)));
                }
            }
        } else if (abstractDtdInfo.getRadioDotNumberAttributeName() != null && abstractDtdInfo.doesElementContainAttribute(string, abstractDtdInfo.getRadioDotNumberAttributeName())) {
            int n = Integer.valueOf(abstractXmlElement.getCountedValue());
            for (int i = 1; i <= RadioDotSystemUtil.getMaxNoOfRadioDotPerIRU(); ++i) {
                String string14 = PrefixUtil.getRadioDotPrefix(n, i);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string14));
            }
        } else if (string.equals("PositionCoordinates")) {
            list.add(new NormalElement(string, abstractDtdInfo, rbs, abstractXmlElement.getPrefix()));
        } else if (string.equals("RadioDot")) {
            list.add(new NormalElement(string, abstractDtdInfo, rbs, abstractXmlElement.getPrefix()));
        } else if (string.equals("AddRadioDot") || string.equals("DeleteRadioDot")) {
            list.add(new NormalElement(string, abstractDtdInfo, rbs, abstractXmlElement.getPrefix()));
        } else if (string.equals("ExternalAlarmConfiguration")) {
            if (abstractDtdInfo.getDTDFileName().equals("SiteEquipment.dtd")) {
                if (!rbs.isParameterSupported("supportSystemControl") || DuwUtil.isDualBoxConfiguration(rbs.getRbsType())) {
                    list.add(new NormalElement(string, abstractDtdInfo, rbs));
                } else if (rbs.getCustomerParameterObject("supportSystemControl").getValue().equalsIgnoreCase("TRUE")) {
                    List list2 = rbs.getCabinetNumberList();
                    list2.add(0, 0);
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        int n = Integer.parseInt(iterator.next().toString());
                        if (!XmlElementFactory.isAlarmElementExist(list, string, abstractDtdInfo, rbs, n)) continue;
                        String string15 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
                        list.add(new NormalElement(string, abstractDtdInfo, rbs, string15, String.valueOf(n)));
                    }
                }
            } else {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (string.equals("Alarm")) {
            if (null != abstractXmlElement.getCountedValue() && !abstractXmlElement.getCountedValue().equals("")) {
                String string16 = abstractXmlElement.getCountedValue();
                XmlElementFactory.handleAlarmElement(list, string, abstractDtdInfo, rbs, Integer.valueOf(string16));
            } else {
                XmlElementFactory.handleAlarmElement(list, string, abstractDtdInfo, rbs);
            }
        } else if (string.equals("ExternalControlConfiguration")) {
            if (abstractDtdInfo.getDTDFileName().equals("SiteEquipment.dtd")) {
                if (!rbs.isParameterSupported("supportSystemControl") || DuwUtil.isDualBoxConfiguration(rbs.getRbsType())) {
                    list.add(new NormalElement(string, abstractDtdInfo, rbs));
                } else if (rbs.getCustomerParameterObject("supportSystemControl").getValue().equalsIgnoreCase("TRUE")) {
                    Iterator iterator = rbs.getCabinetNumberList().iterator();
                    while (iterator.hasNext()) {
                        try {
                            String string17 = iterator.next().toString();
                            if (!XmlElementFactory.isControlElementExist(list, string, abstractDtdInfo, rbs, Integer.parseInt(string17))) continue;
                            String string18 = PrefixUtil.getCabinetPrefix(string17);
                            list.add(new NormalElement(string, abstractDtdInfo, rbs, string18, string17));
                        }
                        catch (MoHandlerException moHandlerException) {
                            Nal.getLog().nalTraceEnter(XmlElementFactory.class, moHandlerException.toString());
                        }
                    }
                }
            } else {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (string.equals("Control")) {
            if (null != abstractXmlElement.getCountedValue() && !abstractXmlElement.getCountedValue().equals("")) {
                String string19 = abstractXmlElement.getCountedValue();
                XmlElementFactory.handleControlElement(list, string, abstractDtdInfo, rbs, Integer.valueOf(string19));
            } else {
                XmlElementFactory.handleControlElement(list, string, abstractDtdInfo, rbs);
            }
        } else if (string.equals("HsdpaSlot")) {
            int n = rbs.getHubSubrackNoOfSlots();
            for (int i = 1; i <= n; ++i) {
                String string20 = String.valueOf(i);
                String string21 = MessageFormat.format("hsSlot{0}_", string20);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string21, string20));
            }
        } else if (string.equals("EulSlot")) {
            int n = rbs.getHubSubrackNoOfSlots();
            for (int i = 1; i <= n; ++i) {
                String string22 = String.valueOf(i);
                String string23 = MessageFormat.format("eulSlot{0}_", string22);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string23, string22));
            }
        } else if (string.equals("BaseBandPoolSettings")) {
            int n = 2;
            for (int i = 1; i <= n; ++i) {
                String string24;
                String string25 = string24 = String.valueOf(i);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string25, string24));
            }
        } else if (string.equalsIgnoreCase("hubPosition") || string.equalsIgnoreCase("EcPort")) {
            int n = 18;
            int n3 = 0;
            while (n3 < n) {
                String string26 = MessageFormat.format("EcPort{0}_", String.valueOf(n3++));
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string26));
            }
        } else if (string.equals("RetProfile")) {
            List list3 = XmlElementFactory.getElementPseudoNames("RET_PROFILE_", rbs, "_");
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("Cabinet")) {
            Iterator iterator = rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                String string27 = iterator.next().toString();
                String string28 = PrefixUtil.getCabinetPrefix(string27);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string28, string27));
            }
        } else if (string.equals("ClimateSystem") || string.equals("ClimateRegulationSystem")) {
            String string29 = null;
            if (abstractDtdInfo.getDTDFileName().equals("SiteEquipment.dtd")) {
                String string30 = abstractXmlElement.getCountedValue();
                string29 = PrefixUtil.getCabinetPrefix(string30);
            } else {
                string29 = PrefixUtil.getFirstCabinetPrefix();
            }
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string29));
        } else if (string.equals("EcBus")) {
            for (int i = 1; i < 7; ++i) {
                String string31 = MessageFormat.format("EcBus{0}_", String.valueOf(i + 1));
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string31, String.valueOf(i + 1)));
            }
        } else if (string.equals("InciConnector")) {
            for (int i = 0; i < 7; ++i) {
                String string32 = MessageFormat.format("InciConnector{0}_", String.valueOf(i + 1));
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string32));
            }
        } else if (string.equals("PowerSupply")) {
            String string33 = PrefixUtil.getFirstCabinetPrefix();
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string33));
        } else if (string.equals("OptionalEquipmentConfiguration")) {
            list.add(new NormalElement(string, abstractDtdInfo, rbs, PrefixUtil.getFirstCabinetPrefix(), String.valueOf(1)));
            if (rbs.isParameterSupported("supportSystemControl") && rbs.getCustomerParameterObject("supportSystemControl").getValue().equalsIgnoreCase("TRUE")) {
                Iterator iterator = rbs.getCabinetNumberList().iterator();
                while (iterator.hasNext()) {
                    String string34 = iterator.next().toString();
                    if (Integer.parseInt(string34) <= 1) continue;
                    String string35 = PrefixUtil.getCabinetPrefix(string34);
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, string35, string34));
                }
            }
        } else if (string.equals("BatteryChargingConfiguration")) {
            String string36 = abstractXmlElement.getCountedValue();
            String string37 = PrefixUtil.getCabinetPrefix(string36);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string37));
        } else if (string.equals("AtmPort")) {
            String string38 = rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption");
            if (string38.equals("atm")) {
                List list4 = XmlElementFactory.getElementPseudoNames("AtmPort_", rbs, "_");
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
                }
            }
        } else if (string.equals("Route")) {
            List list5 = XmlElementFactory.getElementPseudoNames("R_", rbs, "_");
            Iterator iterator = list5.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("NetworkSynch")) {
            List list6 = XmlElementFactory.getElementPseudoNames("Y_", rbs, "_");
            Iterator iterator = list6.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("GigaBitEthernet")) {
            String string39 = rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption");
            if (abstractXmlElement.getElementName().equals("IPoverATM") && string39.equals("atm") || abstractXmlElement.getElementName().equals("IPoverGigabitEthernet") && string39.equals("ipV4")) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (string.equals("IPoverGigabitEthernet")) {
            String string40 = "IPoverGigabitEthernet_";
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string40));
        } else if (string.equals("OamIpHost")) {
            String string41 = "OamIpHost_";
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string41));
        } else if (string.equals("DhcpClientIdentifier")) {
            String string42;
            String string43 = abstractXmlElement.getPrefix() + "DhcpClientIdentifier_";
            String string44 = "OamIpHost_configurationMode";
            if (rbs.isParameterSupported(string44) && CONFIGURATION_MODE_DHCP.equals(string42 = rbs.getCustomerParameter(string44))) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string43));
            }
        } else if (string.equals("IpSyncRef")) {
            List list7 = XmlElementFactory.getElementPseudoNames("IPoverGigabitEthernet_", rbs, "_");
            Iterator iterator = list7.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("PacketFrequencySyncRef")) {
            List list8 = XmlElementFactory.getElementPseudoNames("IPoverGigabitEthernet_", rbs, "_");
            Iterator iterator = list8.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("EthernetSwitch")) {
            String string45 = "EthernetSwitch";
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string45));
        } else if (string.equals("LinkAggregationGroup")) {
            List list9 = XmlElementFactory.getElementPseudoNames("linkAggregationGroup_", rbs, "_");
            Iterator iterator = list9.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("EthernetSwitchPort")) {
            List list10 = XmlElementFactory.getElementPseudoNames("EthernetSwitchPort_", rbs, "_");
            Iterator iterator = list10.iterator();
            subElementToEthernetSwitchPort = true;
            while (iterator.hasNext()) {
                ethernetSwitchPortPrefix = (String)iterator.next();
                list.add(new NormalElement(string, abstractDtdInfo, rbs, ethernetSwitchPortPrefix));
            }
            subElementToEthernetSwitchPort = false;
            ethernetSwitchPortPrefix = "";
        } else if (string.equals("VlanMembership")) {
            if (subElementToEthernetSwitchPort) {
                List list11 = XmlElementFactory.getElementPseudoNames(ethernetSwitchPortPrefix + "VlanMembership" + "_", rbs, "_");
                Iterator iterator = list11.iterator();
                while (iterator.hasNext()) {
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
                }
            } else {
                List list12 = XmlElementFactory.getElementPseudoNames("EthernetSwitchVlanMembership_", rbs, "_");
                Iterator iterator = list12.iterator();
                while (iterator.hasNext()) {
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
                }
            }
        } else if (string.equals("Connection")) {
            String string46 = "firstOAMatm_";
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string46));
            String string47 = "secondOAMatm_";
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string47));
        } else if (string.equals("IPoverATM")) {
            String string48 = rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption");
            if (string48.equals("atm")) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (string.equals("IpSec") || string.equals("IubIpAccessHostEt") || string.equals("IkePeer") || string.equals("IpSecTunnel") || string.equals("DnsResolver")) {
            String string49 = rbs.getCustomerParameter("IpSec_configType");
            if (string49 != null && !string49.equals("NON_IPSEC")) {
                String string50 = string.equals("IpSec") ? "IpSec_" : (string.equals("IubIpAccessHostEt") ? "Iub_" : (string.equals("IkePeer") ? abstractXmlElement.getPrefix() + "IkePeer_" : (string.equals("IpSecTunnel") ? abstractXmlElement.getPrefix() + "IpSecTunnel_" : (string.equals("DnsResolver") ? abstractXmlElement.getPrefix() + "DnsResolver_" : ""))));
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string50));
            }
        } else if (string.equals("IkeSaTf")) {
            String string51 = abstractXmlElement.getPrefix() + "IkeSaTf_";
            List list13 = XmlElementFactory.getElementPseudoNames(string51, rbs, "_");
            Iterator iterator = list13.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("ChildSaTf")) {
            String string52 = abstractXmlElement.getPrefix() + "ChildSaTf_";
            List list14 = XmlElementFactory.getElementPseudoNames(string52, rbs, "_");
            Iterator iterator = list14.iterator();
            while (iterator.hasNext()) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs, (String)iterator.next()));
            }
        } else if (string.equals("CpriBasedSyncConfig")) {
            String string53 = rbs.getCustomerParameter("syncNodePriority");
            String string54 = rbs.getCustomerParameter("syncRiPortCandidate");
            if (!string53.equals("##UNDEFINED") && !string54.equals("##UNDEFINED")) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (string.equals("NodeId")) {
            String string55 = rbs.getCustomerParameter("nodeIdType");
            String string56 = rbs.getCustomerParameter("nodeIdValue");
            if (!string55.equals("##UNDEFINED") && !string56.equals("##UNDEFINED")) {
                list.add(new NormalElement(string, abstractDtdInfo, rbs));
            }
        } else if (RbsUtil.isApcLightSupported(rbs) && string.equals("HwGroupConfig")) {
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)rbs.getProvider(PowerSupplyProvider.class);
            if (null == powerSupplyProvider) {
                return;
            }
            int n = powerSupplyProvider.getNumberOfHwGroup();
            for (int i = 0; i < n; ++i) {
                String string57 = PrefixUtil.getHwGroupPrefix(i);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string57));
            }
        } else if (RbsUtil.isApcLightSupported(rbs) && string.equals("PositionConfiguration")) {
            XmlElementFactory.createPositionElement(list, string, abstractDtdInfo, rbs);
        } else if (string.equals("RadioUnit")) {
            AbstractRuRI[] abstractRuRIArray;
            String string58 = abstractXmlElement.getCountedValue();
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            if (radioEquipmentProvider instanceof RbbManager && (abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(Integer.parseInt(string58))) != null) {
                for (int i = 0; i < abstractRuRIArray.length; ++i) {
                    int n = abstractRuRIArray[i].getSequenceNumber();
                    String string59 = abstractRuRIArray[i].getSectorAuxPrefix();
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, string59, String.valueOf(n)));
                }
            }
        } else {
            list.add(new NormalElement(string, abstractDtdInfo, rbs));
        }
    }

    private static void createPositionElement(List<NormalElement> list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        int n;
        int n2;
        String string2 = "";
        int[] nArray = rbs.getRadioEquipmentProvider().getEquippedSectors();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            for (int i = 0; i < rbs.getAntennaSystemProvider().getNumOfSectorAntennas(n); ++i) {
                string2 = PrefixUtil.getPosPrefix(n, "Antenna", i + 1);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string2));
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (!SectorUtil.isPositionConfigurationSupported(rbs, n)) continue;
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(n);
            int n3 = null == abstractRuRIArray ? 0 : abstractRuRIArray.length;
            for (int i = 0; i < n3; ++i) {
                string2 = PrefixUtil.getPosPrefix(n, "RadioUnit", i + 1);
                list.add(new NormalElement(string, abstractDtdInfo, rbs, string2));
            }
        }
    }

    private static void handleAlarmElement(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        block22: {
            CommonAlarmCI commonAlarmCI;
            ConfigurationItem configurationItem;
            block21: {
                Object object;
                Object object2;
                Object object3;
                configurationItem = rbs.getConfigItem("AlarmCI");
                if (!(configurationItem instanceof XalmCI)) break block21;
                XalmCI xalmCI = (XalmCI)configurationItem;
                if (xalmCI == null || !xalmCI.isOpen()) break block22;
                GenericAlarmManager genericAlarmManager = xalmCI.getAlarmManager("Xalm");
                GenericAlarmManager genericAlarmManager2 = xalmCI.getAlarmManager("Sau");
                GenericAlarmManager genericAlarmManager3 = xalmCI.getAlarmManager("Scu");
                GenericAlarmManager genericAlarmManager4 = xalmCI.getAlarmManager("Sup");
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                try {
                    Object object4;
                    object3 = genericAlarmManager3.getDeviceGroupMoi();
                    if (object3 != null && (object2 = ((MoInstance)object3).getMoHandler()).isExisting((BemMo)(object4 = object2.getMo(genericAlarmManager3.getDeviceGroupLdn())))) {
                        bl3 = true;
                    }
                    if ((object2 = genericAlarmManager4.getDeviceGroupMoi()) != null && (object4 = ((MoInstance)object2).getMoHandler()).isExisting((BemMo)(object = object4.getMo(genericAlarmManager4.getDeviceGroupLdn())))) {
                        bl4 = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object3 = xalmCI.getXalmDeviceGroupRI();
                object2 = xalmCI.getSauDeviceGroupRI();
                if (object3 != null) {
                    bl = object3.isInstalled();
                }
                if (object2 != null) {
                    bl2 = object2.isInstalled();
                }
                if (genericAlarmManager != null && bl) {
                    XmlElementFactory.createAlarmElements(genericAlarmManager, list, string, abstractDtdInfo, rbs);
                }
                if (genericAlarmManager2 != null && bl2) {
                    XmlElementFactory.createAlarmElements(genericAlarmManager2, list, string, abstractDtdInfo, rbs);
                }
                if (genericAlarmManager3 != null && bl3) {
                    XmlElementFactory.createAlarmElements(genericAlarmManager3, list, string, abstractDtdInfo, rbs);
                }
                if (genericAlarmManager4 != null && bl4) {
                    XmlElementFactory.createAlarmElements(genericAlarmManager4, list, string, abstractDtdInfo, rbs);
                }
                for (int i = 0; i <= 1; ++i) {
                    object = rbs.getRadioEquipmentProvider(i);
                    if (object == null) continue;
                    boolean bl5 = object.mainRemoteRbs();
                    if ((i <= 0 || !rbs.isPantherHybridRbs()) && !bl5 || abstractDtdInfo.getRoot().equals("Cabinet")) continue;
                    XmlElementFactory.createRruwAlarmElements((RadioEquipmentProvider)object, list, string, abstractDtdInfo, rbs);
                }
                break block22;
            }
            if (configurationItem instanceof CommonAlarmCI && (commonAlarmCI = (CommonAlarmCI)configurationItem) != null && commonAlarmCI.isOpen()) {
                Object object;
                Object object5;
                AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", 1);
                AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", 1);
                AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", 1);
                boolean bl = false;
                boolean bl6 = false;
                boolean bl7 = false;
                try {
                    MoHandler moHandler;
                    if (alarmManager2 != null && (object5 = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object5).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager2.getHwUnitLdn())))) {
                        bl6 = true;
                    }
                    if (alarmManager3 != null && (object5 = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object5).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager3.getHwUnitLdn())))) {
                        bl7 = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object5 = commonAlarmCI.getSauRI(1);
                if (object5 != null) {
                    bl = object5.isInstalled();
                    if (alarmManager != null && bl) {
                        XmlElementFactory.createCommonAlarmElements(alarmManager, list, string, abstractDtdInfo, rbs);
                    }
                }
                if (alarmManager2 != null && bl6) {
                    XmlElementFactory.createCommonAlarmElements(alarmManager2, list, string, abstractDtdInfo, rbs);
                }
                if (alarmManager3 != null && bl7) {
                    XmlElementFactory.createCommonAlarmElements(alarmManager3, list, string, abstractDtdInfo, rbs);
                }
                for (int i = 0; i <= 1; ++i) {
                    object = rbs.getRadioEquipmentProvider(i);
                    if (object == null) continue;
                    boolean bl8 = object.mainRemoteRbs();
                    if ((i <= 0 || !rbs.isPantherHybridRbs()) && !bl8 || abstractDtdInfo.getRoot().equals("Cabinet")) continue;
                    XmlElementFactory.createRruwAlarmElements((RadioEquipmentProvider)object, list, string, abstractDtdInfo, rbs);
                }
            }
        }
    }

    private static boolean isAlarmElementExist(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException {
        CommonAlarmCI commonAlarmCI;
        ConfigurationItem configurationItem = rbs.getConfigItem("AlarmCI");
        if (configurationItem instanceof CommonAlarmCI && (commonAlarmCI = (CommonAlarmCI)configurationItem) != null && commonAlarmCI.isOpen()) {
            int n2;
            Object object;
            Object object2;
            AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", n);
            AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", n);
            AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", n);
            try {
                MoHandler moHandler;
                if (alarmManager2 != null && (object2 = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object2).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager2.getHwUnitLdn()))) && alarmManager2.getMaxNoOfAlarmPorts() > 0) {
                    return true;
                }
                if (alarmManager3 != null && (object2 = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object2).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager3.getHwUnitLdn()))) && alarmManager3.getMaxNoOfAlarmPorts() > 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = commonAlarmCI.getSauRI(n);
            if (object2 != null && alarmManager != null && object2.isInstalled() && alarmManager.getMaxNoOfAlarmPorts() > 0) {
                return true;
            }
            if (n == 1) {
                for (int i = 0; i <= 1; ++i) {
                    object = rbs.getRadioEquipmentProvider(i);
                    if (object == null) continue;
                    n2 = object.mainRemoteRbs();
                    if ((i <= 0 || !rbs.isPantherHybridRbs()) && n2 == 0 || abstractDtdInfo.getRoot().equals("Cabinet") || rbs.getMaxNumberOfXalmsForRruw() <= 0 || object.getEquippedSectors().length <= 0) continue;
                    return true;
                }
            }
            if (0 == n) {
                RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
                object = radioEquipmentProvider.getExistingSectors();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (!SectorUtil.isIRUInEnclosure(rbs, (int)object[n2])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void handleAlarmElement(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException {
        CommonAlarmCI commonAlarmCI;
        ConfigurationItem configurationItem = rbs.getConfigItem("AlarmCI");
        if (configurationItem instanceof CommonAlarmCI && (commonAlarmCI = (CommonAlarmCI)configurationItem) != null && commonAlarmCI.isOpen()) {
            int n2;
            Object object;
            Object object2;
            AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", n);
            AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", n);
            AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", n);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                MoHandler moHandler;
                if (alarmManager2 != null && (object2 = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object2).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager2.getHwUnitLdn())))) {
                    bl2 = true;
                }
                if (alarmManager3 != null && (object2 = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object2).getMoHandler()).isExisting((BemMo)(object = moHandler.getMo(alarmManager3.getHwUnitLdn())))) {
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = commonAlarmCI.getSauRI(n);
            if (object2 != null) {
                bl = object2.isInstalled();
                if (alarmManager != null && bl) {
                    XmlElementFactory.createCommonAlarmElements(alarmManager, list, string, abstractDtdInfo, rbs, n);
                }
            }
            if (alarmManager2 != null && bl2) {
                XmlElementFactory.createCommonAlarmElements(alarmManager2, list, string, abstractDtdInfo, rbs, n);
            }
            if (alarmManager3 != null && bl3) {
                XmlElementFactory.createCommonAlarmElements(alarmManager3, list, string, abstractDtdInfo, rbs, n);
            }
            for (int i = 0; i <= 1; ++i) {
                object = rbs.getRadioEquipmentProvider(i);
                if (object == null) continue;
                n2 = object.mainRemoteRbs();
                if ((i <= 0 || !rbs.isPantherHybridRbs()) && n2 == 0 || abstractDtdInfo.getRoot().equals("Cabinet") || 0 == n) continue;
                XmlElementFactory.createRruwAlarmElements((RadioEquipmentProvider)object, list, string, abstractDtdInfo, rbs);
            }
            if (0 == n) {
                RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
                object = radioEquipmentProvider.getExistingSectors();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (!SectorUtil.isIRUInEnclosure(rbs, (int)object[n2])) continue;
                    XmlElementFactory.createIruAlarmElements(radioEquipmentProvider, list, string, abstractDtdInfo, rbs);
                }
            }
        }
    }

    private static void handleControlElement(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        CommonAlarmCI commonAlarmCI;
        ConfigurationItem configurationItem = rbs.getConfigItem("AlarmCI");
        if (configurationItem instanceof XalmCI) {
            XalmCI xalmCI = (XalmCI)configurationItem;
            if (xalmCI != null && xalmCI.isOpen()) {
                GenericAlarmManager genericAlarmManager = xalmCI.getAlarmManager("Xalm");
                GenericAlarmManager genericAlarmManager2 = xalmCI.getAlarmManager("Sau");
                GenericAlarmManager genericAlarmManager3 = xalmCI.getAlarmManager("Scu");
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                XalmDeviceGroupRI xalmDeviceGroupRI = xalmCI.getXalmDeviceGroupRI();
                SauDeviceGroupRI sauDeviceGroupRI = xalmCI.getSauDeviceGroupRI();
                try {
                    MoHandler moHandler = genericAlarmManager3.getDeviceGroupMoi().getMoHandler();
                    BemMo bemMo = moHandler.getMo(genericAlarmManager3.getDeviceGroupLdn());
                    if (moHandler.isExisting(bemMo)) {
                        bl3 = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (xalmDeviceGroupRI != null) {
                    bl = xalmDeviceGroupRI.isInstalled();
                }
                if (sauDeviceGroupRI != null) {
                    bl2 = sauDeviceGroupRI.isInstalled();
                }
                if (genericAlarmManager != null && bl) {
                    XmlElementFactory.createControlElements(genericAlarmManager, list, string, abstractDtdInfo, rbs);
                }
                if (genericAlarmManager2 != null && bl2) {
                    XmlElementFactory.createControlElements(genericAlarmManager2, list, string, abstractDtdInfo, rbs);
                }
                if (genericAlarmManager3 != null && bl3) {
                    XmlElementFactory.createControlElements(genericAlarmManager3, list, string, abstractDtdInfo, rbs);
                }
            }
        } else if (configurationItem instanceof CommonAlarmCI && (commonAlarmCI = (CommonAlarmCI)configurationItem) != null && commonAlarmCI.isOpen()) {
            Object object;
            AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", 1);
            AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", 1);
            AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", 1);
            boolean bl = false;
            boolean bl4 = false;
            boolean bl5 = false;
            try {
                BemMo bemMo;
                MoHandler moHandler;
                if (alarmManager2 != null && (object = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager2.getHwUnitLdn()))) {
                    bl4 = true;
                }
                if (alarmManager3 != null && (object = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager3.getHwUnitLdn()))) {
                    bl5 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = commonAlarmCI.getSauRI(1);
            if (object != null) {
                bl = object.isInstalled();
                if (alarmManager != null && bl) {
                    XmlElementFactory.createCommonControlElements(alarmManager, list, string, abstractDtdInfo, rbs);
                }
            }
            if (alarmManager2 != null && bl4) {
                XmlElementFactory.createCommonControlElements(alarmManager2, list, string, abstractDtdInfo, rbs);
            }
            if (alarmManager3 != null && bl5) {
                XmlElementFactory.createCommonControlElements(alarmManager3, list, string, abstractDtdInfo, rbs);
            }
        }
    }

    private static boolean isControlElementExist(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException, MoHandlerException {
        ConfigurationItem configurationItem = rbs.getConfigItem("AlarmCI");
        if (!(configurationItem instanceof CommonAlarmCI)) {
            return false;
        }
        CommonAlarmCI commonAlarmCI = (CommonAlarmCI)configurationItem;
        if (commonAlarmCI != null && commonAlarmCI.isOpen()) {
            BemMo bemMo;
            MoHandler moHandler;
            Object object;
            AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", n);
            AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", n);
            AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", n);
            if (alarmManager2 != null && (object = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager2.getHwUnitLdn())) && alarmManager2.getMaxNoOfControlPorts() > 0) {
                return true;
            }
            if (alarmManager3 != null && (object = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager3.getHwUnitLdn())) && alarmManager3.getMaxNoOfControlPorts() > 0) {
                return true;
            }
            object = commonAlarmCI.getSauRI(n);
            if (object != null && alarmManager != null && object.isInstalled() && alarmManager.getMaxNoOfControlPorts() > 0) {
                return true;
            }
        }
        return false;
    }

    private static void handleControlElement(List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException {
        CommonAlarmCI commonAlarmCI;
        ConfigurationItem configurationItem = rbs.getConfigItem("AlarmCI");
        if (configurationItem instanceof CommonAlarmCI && (commonAlarmCI = (CommonAlarmCI)configurationItem) != null && commonAlarmCI.isOpen()) {
            Object object;
            AlarmManager alarmManager = commonAlarmCI.getAlarmManager("Sau", n);
            AlarmManager alarmManager2 = commonAlarmCI.getAlarmManager("Scu", n);
            AlarmManager alarmManager3 = commonAlarmCI.getAlarmManager("Sup", n);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                BemMo bemMo;
                MoHandler moHandler;
                if (alarmManager2 != null && (object = alarmManager2.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager2.getHwUnitLdn()))) {
                    bl2 = true;
                }
                if (alarmManager3 != null && (object = alarmManager3.getHwUnitMoi()) != null && (moHandler = ((MoInstance)object).getMoHandler()).isExisting(bemMo = moHandler.getMo(alarmManager3.getHwUnitLdn()))) {
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = commonAlarmCI.getSauRI(n);
            if (object != null) {
                bl = object.isInstalled();
                if (alarmManager != null && bl) {
                    XmlElementFactory.createCommonControlElements(alarmManager, list, string, abstractDtdInfo, rbs, n);
                }
            }
            if (alarmManager2 != null && bl2) {
                XmlElementFactory.createCommonControlElements(alarmManager2, list, string, abstractDtdInfo, rbs, n);
            }
            if (alarmManager3 != null && bl3) {
                XmlElementFactory.createCommonControlElements(alarmManager3, list, string, abstractDtdInfo, rbs, n);
            }
        }
    }

    private static void createAlarmElements(GenericAlarmManager genericAlarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        for (int i = 1; i <= genericAlarmManager.getMAX_NO_ALMDEVICES(); ++i) {
            String string2 = String.valueOf(i);
            String string3 = genericAlarmManager.getAutype();
            String string4 = PrefixUtil.getFirstCabinetPrefix() + string3 + MessageFormat.format("ExternalAlarm{0}_", string2);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string4, string2, ignoredAttributes));
        }
    }

    private static void createCommonAlarmElements(AlarmManager alarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        for (int i = 1; i <= alarmManager.getMaxNoOfAlarmPorts(); ++i) {
            String string2 = String.valueOf(i);
            String string3 = alarmManager.getHW_UNIT_TYPE();
            String string4 = PrefixUtil.getFirstCabinetPrefix() + string3 + MessageFormat.format("ExternalAlarm{0}_", string2);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string4, string2, ignoredAttributes));
        }
    }

    private static void createCommonAlarmElements(AlarmManager alarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException {
        String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        for (int i = 1; i <= alarmManager.getMaxNoOfAlarmPorts(); ++i) {
            String string3 = String.valueOf(i);
            String string4 = alarmManager.getHW_UNIT_TYPE();
            String string5 = string2 + string4 + MessageFormat.format("ExternalAlarm{0}_", string3);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string5, String.valueOf(n), string3, ignoredAttributes));
        }
    }

    private static void createRruwAlarmElements(RadioEquipmentProvider radioEquipmentProvider, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        int n = rbs.getMaxNumberOfXalmsForRruw();
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = String.valueOf(nArray[i]);
            if (!radioEquipmentProvider.isSectorRemote(Integer.parseInt(string2))) continue;
            for (int j = 1; j <= n; ++j) {
                String string3 = String.valueOf(j);
                for (int k = 0; k < n; ++k) {
                    String string4 = String.valueOf(k + 1);
                    String string5 = MessageFormat.format("ExternalAlarm{0}_", string4);
                    String string6 = "Rruw";
                    string5 = PrefixUtil.getFirstCabinetPrefix() + string6 + string5 + string2 + "_" + string3 + "_";
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, string5, string2, string4));
                }
            }
        }
    }

    private static void createIruAlarmElements(RadioEquipmentProvider radioEquipmentProvider, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        int n = rbs.getMaxNumberOfXalmsForIru();
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = String.valueOf(nArray[i]);
            if (!radioEquipmentProvider.isSectorRemote(Integer.parseInt(string2))) continue;
            for (int j = 1; j <= n; ++j) {
                String string3 = String.valueOf(j);
                for (int k = 0; k < n; ++k) {
                    String string4 = String.valueOf(k + 1);
                    String string5 = MessageFormat.format("ExternalAlarm{0}_", string4);
                    string5 = PrefixUtil.getCabinetPrefix(String.valueOf(0)) + "Iru" + string5 + string2 + "_" + string3 + "_";
                    list.add(new NormalElement(string, abstractDtdInfo, rbs, string5, string2, string4));
                }
            }
        }
    }

    private static void createControlElements(GenericAlarmManager genericAlarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        for (int i = 1; i <= genericAlarmManager.getMAX_NO_OUTDEVICES(); ++i) {
            String string2 = String.valueOf(i);
            String string3 = genericAlarmManager.getAutype();
            String string4 = PrefixUtil.getFirstCabinetPrefix() + string3 + MessageFormat.format("ControlPort{0}_", string2);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string4, string2));
        }
    }

    private static void createCommonControlElements(AlarmManager alarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs) throws BemException {
        for (int i = 1; i <= alarmManager.getMaxNoOfControlPorts(); ++i) {
            String string2 = String.valueOf(i);
            String string3 = alarmManager.getHW_UNIT_TYPE();
            String string4 = PrefixUtil.getFirstCabinetPrefix() + string3 + MessageFormat.format("ControlPort{0}_", string2);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string4, string2));
        }
    }

    private static void createCommonControlElements(AlarmManager alarmManager, List list, String string, AbstractDtdInfo abstractDtdInfo, Rbs rbs, int n) throws BemException {
        String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        for (int i = 1; i <= alarmManager.getMaxNoOfControlPorts(); ++i) {
            String string3 = String.valueOf(i);
            String string4 = alarmManager.getHW_UNIT_TYPE();
            String string5 = string2 + string4 + MessageFormat.format("ControlPort{0}_", string3);
            list.add(new NormalElement(string, abstractDtdInfo, rbs, string5, String.valueOf(n), string3));
        }
    }

    private static List getElementPseudoNames(String string, Rbs rbs, String string2) throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        CustomerParameter[] customerParameterArray = rbs.getCustomerParameterObjects();
        String string3 = "";
        boolean bl = false;
        for (int i = 0; i < customerParameterArray.length; ++i) {
            int n;
            String string4;
            int n2;
            string3 = customerParameterArray[i].getName();
            if (!string3.startsWith(string) || (n2 = (string4 = string3.substring(n = string.length())).indexOf(string2)) == -1) continue;
            String string5 = string4.substring(0, n2);
            Integer n3 = new Integer(Integer.valueOf(string5));
            bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(n3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(n3);
        }
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string6 = iterator.next().toString();
            arrayList2.add(string + string6 + string2);
        }
        return arrayList2;
    }
}

