/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control.ConfigReportController;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.util.IntegrateRbsUtil;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.view.IntegrateRbsView;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterExtended;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressMonitor;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class IntegrateRbsController
extends AbstractApplicationController
implements ProgressReporterExtended {
    private AbstractApplication application;
    private IntegrateRbsView view;
    private IntegrateRbsUtil integrateRbsUtil = null;
    private Rbs rbs = null;
    private CustomerParameter autoIntegrate;
    private ProgressMonitor pm = null;
    private boolean cancelledDuringWaitForOss = false;
    private static RbsEmPropertiesFileHandler rbsEmProp = RbsEmPropertiesFileHandler.getInstance();
    private static final String ROLLBACK_MESSAGE = "\n The node is in an undefined state. It is necessary to perform a rollback to last created CV.\n The rollback requires that the node is restarted.\n\n Do you want to perform the rollback?";
    private static final String CANCELLED_MESSAGE = "\n Integrate RBS was cancelled.\n\n The node is in an undefined state. It is necessary to perform a rollback to last created CV.\n The rollback requires that the node is restarted.\n\n Do you want to perform the rollback?";
    private static final String TMF_FILE_NAME_ERROR = "TMF data files have to use the naming convention \nTmfData_S<sectorNumber>_V<versionNumber>.bin";
    private Thread myIntegrationPerformerThread = null;
    private boolean faileDuringWaitForOss = false;
    private static final String VALUE_STRING_WARNING = "Warning";
    private static final String VALUE_STRING_CONFIRM = "Confirm";
    private static final String VALUE_STRING_ERROR = "Error";
    private static final String VALUE_STRING_INFORMATION = "Information";

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    public void init() {
        this.application = this.getApplication();
        this.view = (IntegrateRbsView)this.getView();
        try {
            this.integrateRbsUtil = new IntegrateRbsUtil(this);
            this.integrateRbsUtil.openBasicIntegrateRbsCIs();
            this.rbs = this.integrateRbsUtil.getRbs();
            this.autoIntegrate = this.rbs.getCustomerParameterObject("AI_autoIntegrate");
            this.view.setMainPanelCustomerParameter(this.autoIntegrate);
            this.autoIntegrate.addCustomerParameterListener(new AutoIntegrateRbsListener());
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("AI_logicalName");
            CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject("AI_user_name");
            CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject("AI_password");
            CustomerParameter customerParameter4 = null;
            if (DuwUtil.hasDuw()) {
                customerParameter4 = this.rbs.getCustomerParameterObject("AI_gigabitEthernetPort");
            }
            CustomerParameter customerParameter5 = this.rbs.getCustomerParameterObject("AI_vlan");
            CustomerParameter customerParameter6 = this.rbs.getCustomerParameterObject("AI_vid");
            customerParameter5.addCustomerParameterListener(new EnableVlanCheckBoxListener((IntegerParameter)customerParameter6));
            this.view.setAutomaticConfigurationPanel(customerParameter, customerParameter2, customerParameter3, customerParameter5, customerParameter4, customerParameter6);
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("AI_oamFilePath");
            customerParameterServer.setLoadedValue(rbsEmProp.getProperty("XML_PATH"));
            CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject("AI_siteFilePath");
            customerParameterServer2.setLoadedValue(rbsEmProp.getProperty("XML_PATH"));
            this.view.setConfigurationFilePanel((CustomerParameter)((Object)customerParameterServer), (CustomerParameter)((Object)customerParameterServer2));
            JButton jButton = this.view.getSiteBasicBrowsebutton();
            jButton.addActionListener(new oamBrowseButtonListener((CustomerParameter)((Object)customerParameterServer)));
            JButton jButton2 = this.view.getSiteExtrenalBrowsebutton();
            jButton2.addActionListener(new siteBrowseButtonListener((CustomerParameter)((Object)customerParameterServer2)));
            this.view.getButtonAddTmfFile().addActionListener(new AddTmfFilesButtonListener());
            this.view.getButtonRemoveTmfFile().addActionListener(new RemoveTmfFilesButtonListener());
            if (this.autoIntegrate.getValue().equals("Obtain configuration data from configuration files on client")) {
                this.view.enableTmfConfiguration(true);
                this.displayWarningMessage("No IP capable ETM board found, automatic configuration option will be disabled");
            } else {
                this.view.enableTmfConfiguration(false);
            }
            CustomerParameter customerParameter7 = this.rbs.getCustomerParameterObject("AI_waitForOss");
            this.view.setSiteSpecificPanel(customerParameter7);
            this.view.setOkButtonText("Start Integration");
            this.view.setFocusOnCustomerParameterComponent("AI_logicalName");
            new AbstractApplicationController.WhatNextButtonListener(this.view.getWhatNextButtonPanel()){

                protected void onCancelButton() {
                    IntegrateRbsController.this.onCancel();
                }

                protected void onHelpButton() {
                }

                protected void onNextButton() {
                    IntegrateRbsController.this.onOk();
                }
            };
        }
        catch (Exception exception) {
            this.reportException(exception, "");
            this.application.stopApplicationNoCheck();
        }
    }

    public void checkIfCanceled() throws InterruptedException {
        if (this.isCancelled && !this.isCancelledDuringWaitForOss()) {
            Nal.getLog().nalTrace(4, this.getClass(), "Integrate RBS was canceled. About to interrupt thread " + Thread.currentThread().getName() + "!");
            throw new InterruptedException("Integrate RBS was canceled.");
        }
    }

    public void onOk() {
        if (this.integrateRbsUtil.isSiteWizardRun()) {
            String string = "Integrate RBS can only be run once.\n\nUse the add, export and delete applications to change the configuration.";
            this.displayInformation(string);
            return;
        }
        this.setCancelledDuringWaitForOss(false);
        try {
            this.rbs.checkConsistency();
            this.findAndQuitAllOtherApplications();
            this.view.enableGuiSelections(false);
            IntegrateRbsView integrateRbsView = (IntegrateRbsView)this.getView();
            CustomerParameterList customerParameterList = integrateRbsView.getTmfFilesList();
            String[] stringArray = new String[customerParameterList.getNumberOfValues()];
            for (int i = 0; i < customerParameterList.getNumberOfValues(); ++i) {
                stringArray[i] = customerParameterList.getELementAt(i).toString();
            }
            if (customerParameterList.getNumberOfValues() > 0) {
                this.integrateRbsUtil.setTmfFileList(stringArray);
            }
            RbsIntegrationPerformer rbsIntegrationPerformer = new RbsIntegrationPerformer(this);
            this.myIntegrationPerformerThread = new Thread((Runnable)rbsIntegrationPerformer, "myIntegrationPerformerThread");
            this.myIntegrationPerformerThread.start();
        }
        catch (CustomerParameterException customerParameterException) {
            this.displayCustomerParameterWarning(customerParameterException);
        }
        catch (BemException bemException) {
            this.reportException(bemException, "Could not start RBS integration");
        }
    }

    public void reportProgress(int n, String string) {
        if (this.pm != null) {
            this.pm.reportProgress(n, string);
        }
    }

    public void reportTotalProgress(int n, String string) {
        if (this.pm != null) {
            this.pm.reportTotalProgress(n, string);
        }
    }

    public IntegrateRbsUtil getIntegrateRbsUtil() {
        return this.integrateRbsUtil;
    }

    public void onCancel() {
        this.isCancelled = true;
        WizardLaunchChecker.wizardStopped();
        Nal.getFactory().getLog().nalTrace(3, this.getClass(), "Integrate RBS was canceled by user");
        if (this.myIntegrationPerformerThread != null && this.myIntegrationPerformerThread.isAlive()) {
            try {
                if (this.rbs != null) {
                    this.rbs.stopInstallation();
                }
                if (this.myIntegrationPerformerThread != null) {
                    Nal.getFactory().getLog().nalTrace(4, this.getClass(), "About to interrupt the Thread " + this.myIntegrationPerformerThread.getName() + " because integrate RBS was canceled by user");
                    this.myIntegrationPerformerThread.interrupt();
                }
            }
            catch (Exception exception) {
                Nal.getFactory().getLog().nalTrace(1, this.getClass(), "Unexpected exception occured when cancelling IntegrateRbs!", exception);
                this.application.stopApplicationNoCheck();
            }
        } else {
            this.application.stopApplicationNoCheck();
        }
    }

    public void displayInformation(String string) {
        JOptionPane.showMessageDialog(this.application.getJFrame(), string, VALUE_STRING_INFORMATION, 1);
    }

    public void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_WARNING, 2);
    }

    public boolean displayConfirmDialog(String string) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, VALUE_STRING_CONFIRM, 0);
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    protected boolean displayConfirmOkCancelDialog(String string, String string2) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, string2, 2, 3);
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    public void displayError(String string) {
        JOptionPane.showMessageDialog(this.application.getJFrame(), string, VALUE_STRING_ERROR, 0);
    }

    public boolean displayContinueDialog(String string, String string2) {
        boolean bl = true;
        int n = JOptionPane.showOptionDialog(null, string, string2, 2, 3, null, new String[]{"Continue", "Cancel"}, "Continue");
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    public void reportException(Exception exception, String string) {
        ExceptionProperties exceptionProperties = ExceptionProperties.getProperties(exception);
        exceptionProperties.prependProperty("Problem", string, " - ");
        this.getEasyPopUp().displayError(exception);
    }

    public boolean isCancelledDuringWaitForOss() {
        return this.cancelledDuringWaitForOss;
    }

    public void setCancelledDuringWaitForOss(boolean bl) {
        this.cancelledDuringWaitForOss = bl;
    }

    protected String getHelpId() {
        return "INTEGRATE_RBS_BUTTON_HELP";
    }

    public boolean isFailedDuringWaitForOss() {
        return this.faileDuringWaitForOss;
    }

    public void setFailedDuringWaitForOss(boolean bl) {
        this.faileDuringWaitForOss = bl;
    }

    private void findAndQuitAllOtherApplications() {
        BemLaunchable bemLaunchable = this.application.getBemLaunchable();
        if (bemLaunchable.isLaunchedStandAlone()) {
            return;
        }
        LauncherInterface launcherInterface = bemLaunchable.getLauncher();
        Collection collection = launcherInterface.getRunningApplications();
        Iterator iterator = collection.iterator();
        Launchable launchable = null;
        LinkedList<Launchable> linkedList = new LinkedList<Launchable>();
        while (iterator.hasNext()) {
            launchable = (Launchable)iterator.next();
            if (launchable instanceof BemLaunchable) {
                BemLaunchable bemLaunchable2 = (BemLaunchable)launchable;
                if (bemLaunchable2.getApplName().equals(bemLaunchable.getApplName())) continue;
                linkedList.add(bemLaunchable2);
                continue;
            }
            linkedList.add(launchable);
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            launchable = (Launchable)linkedList.get(i);
            try {
                launchable.exit();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean checkTmfInputConsistency(String string) {
        boolean bl = true;
        String string2 = System.getProperty("file.separator");
        String string3 = string.substring(string.lastIndexOf(string2) + 1);
        String[] stringArray = string3.split("_");
        if (stringArray.length != 3) {
            bl = false;
            this.displayError(TMF_FILE_NAME_ERROR);
            return bl;
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        if (!(string4.equals("TmfData") && string5.startsWith("S") && string6.startsWith("V"))) {
            this.displayError(TMF_FILE_NAME_ERROR);
            bl = false;
        }
        return bl;
    }

    class AutoIntegrateRbsListener
    implements CustomerParameterListener {
        AutoIntegrateRbsListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (customerParameter.getValue().equals("Obtain configuration data from configuration files on client")) {
                IntegrateRbsController.this.view.enableTmfConfiguration(true);
            } else if (customerParameter.getValue().equals("Obtain configuration data automatically")) {
                IntegrateRbsController.this.view.enableTmfConfiguration(false);
            }
        }
    }

    class RemoveTmfFilesButtonListener
    implements ActionListener {
        RemoveTmfFilesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IntegrateRbsView integrateRbsView = (IntegrateRbsView)IntegrateRbsController.this.getView();
            CustomerParameterList customerParameterList = integrateRbsView.getTmfFilesList();
            customerParameterList.removeElement(customerParameterList.getSelectedValue());
            if (customerParameterList.getNumberOfValues() == 0) {
                integrateRbsView.getButtonRemoveTmfFile().setEnabled(false);
            }
            integrateRbsView.getButtonAddTmfFile().setEnabled(true);
        }
    }

    class AddTmfFilesButtonListener
    implements ActionListener {
        AddTmfFilesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = System.getProperties();
            String string = (String)properties.get(BemLanguageHelp.getTranslation("USER_HOME"));
            JFileChooser jFileChooser = new JFileChooser(string);
            BemFileFilter bemFileFilter = new BemFileFilter("bin", "BIN files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration File");
            int n = jFileChooser.showOpenDialog((JButton)actionEvent.getSource());
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                IntegrateRbsView integrateRbsView = (IntegrateRbsView)IntegrateRbsController.this.getView();
                CustomerParameterList customerParameterList = integrateRbsView.getTmfFilesList();
                if (!customerParameterList.checkObjectContains(string2)) {
                    if (IntegrateRbsController.this.checkTmfInputConsistency(string2) && customerParameterList.getNumberOfValues() < 3) {
                        customerParameterList.addElement(string2);
                        integrateRbsView.getButtonRemoveTmfFile().setEnabled(true);
                        if (customerParameterList.getNumberOfValues() == 3) {
                            integrateRbsView.getButtonAddTmfFile().setEnabled(false);
                        }
                    }
                } else {
                    IntegrateRbsController.this.displayWarningMessage("This TMF file is already in TMF file list!");
                }
            }
        }
    }

    class siteBrowseButtonListener
    extends BrowseButtonListener {
        public siteBrowseButtonListener(CustomerParameter customerParameter) {
            super(customerParameter);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                CustomerParameterServer customerParameterServer = IntegrateRbsController.this.rbs.getCustomerParameterServerObject("AI_oamFilePath");
                if (!customerParameterServer.hasValueChanged()) {
                    customerParameterServer.setLoadedValue(rbsEmProp.getProperty("XML_PATH"));
                }
            }
            catch (Exception exception) {
                IntegrateRbsController.this.reportException(exception, "");
                IntegrateRbsController.this.application.stopApplicationNoCheck();
            }
        }
    }

    static class EnableVlanCheckBoxListener
    implements CustomerParameterListener {
        private final ParameterRestriction ignored = new ParameterRestriction("", 1);
        private final IntegerParameter vidParam;

        public EnableVlanCheckBoxListener(IntegerParameter integerParameter) {
            this.vidParam = integerParameter;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (customerParameter.getValue().equals("YES")) {
                this.vidParam.removeRestriction(this.ignored);
            } else if (customerParameter.getValue().equals("NO")) {
                this.vidParam.addRestriction(this.ignored);
            }
        }
    }

    class oamBrowseButtonListener
    extends BrowseButtonListener {
        public oamBrowseButtonListener(CustomerParameter customerParameter) {
            super(customerParameter);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            try {
                CustomerParameterServer customerParameterServer = IntegrateRbsController.this.rbs.getCustomerParameterServerObject("AI_siteFilePath");
                if (!customerParameterServer.hasValueChanged()) {
                    customerParameterServer.setLoadedValue(rbsEmProp.getProperty("XML_PATH"));
                }
            }
            catch (Exception exception) {
                IntegrateRbsController.this.reportException(exception, "");
                IntegrateRbsController.this.application.stopApplicationNoCheck();
            }
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        private CustomerParameter filePathParam;

        public BrowseButtonListener(CustomerParameter customerParameter) {
            this.filePathParam = customerParameter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.filePathParam.getValue();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setBackground(Color.white);
            BemFileFilter bemFileFilter = new BemFileFilter("xml", "XML files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration File");
            int n = jFileChooser.showOpenDialog(IntegrateRbsController.this.view);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                String string3 = jFileChooser.getCurrentDirectory().getAbsolutePath();
                this.filePathParam.setValue(string2);
                String string4 = "XML_PATH";
                rbsEmProp.setProperty(string4, string3);
                rbsEmProp.storeBemPropInFile();
            }
        }
    }

    class RbsIntegrationPerformer
    implements Runnable {
        private IntegrateRbsController integrateRbsController;

        public RbsIntegrationPerformer(IntegrateRbsController integrateRbsController2) {
            this.integrateRbsController = integrateRbsController2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IntegrateRbsController.this.isCancelled = false;
            ((IntegrateRbsController)this.integrateRbsController).view.getWhatNextButtonPanel().cancelButton.setEnabled(false);
            try {
                IntegrateRbsController.this.integrateRbsUtil.deleteLogFile();
                IntegrateRbsController.this.pm = new ProgressMonitor(IntegrateRbsController.this.view, this.integrateRbsController, "Progress Integrate RBS", 0, 100);
                IntegrateRbsController.this.pm.setWidth(600);
                IntegrateRbsController.this.integrateRbsUtil.startIntegration(this.integrateRbsController, this.integrateRbsController, true);
                IntegrateRbsController.this.checkIfCanceled();
                IntegrateRbsController.this.pm.reportTotalProgress(100, "Ready");
                IntegrateRbsController.this.pm.close();
                IntegrateRbsController.this.checkIfCanceled();
                String string = IntegrateRbsController.this.rbs.getCustomerParameter("AI_waitForOss");
                boolean bl = false;
                if (string.equals("YES")) {
                    bl = true;
                }
                String string2 = "";
                if (bl) {
                    if (IntegrateRbsController.this.isCancelledDuringWaitForOss()) {
                        string2 = "Site Configuration successfully completed.\nNote! OSS integration was canceled or timed out.\nDo you wish to view the configuration report?";
                    } else if (IntegrateRbsController.this.isFailedDuringWaitForOss()) {
                        string2 = "Site Configuration successfully completed.\nNote! OSS integration was failed!\n" + IntegrateRbsController.this.integrateRbsUtil.getOssRcConfigurationMessage() + "Do you wish to view the configuration report?";
                    } else {
                        IntegrateRbsController.this.integrateRbsUtil.deleteLogFile();
                        string2 = "Configuration successfully completed.\nNode was integrated by OSS.\n\nDo you wish to view the configuration report?";
                    }
                } else {
                    IntegrateRbsController.this.integrateRbsUtil.deleteLogFile();
                    string2 = "Site Configuration successfully completed.\nNote! OSS integration was not performed.\n\nDo you wish to view the configuration report?";
                }
                String string3 = IntegrateRbsController.this.integrateRbsUtil.generateConfigurationReport();
                IntegrateRbsController.this.integrateRbsUtil.storeConfigurationReportInRbsConfigurationMO(string3);
                boolean bl2 = IntegrateRbsController.this.displayConfirmDialog(string2);
                if (bl2) {
                    new ConfigReportController(IntegrateRbsController.this.view, IntegrateRbsController.this.rbs, this.integrateRbsController, string3);
                } else {
                    IntegrateRbsController.this.application.stopApplicationNoCheck();
                }
            }
            catch (CustomerParameterException customerParameterException) {
                if (IntegrateRbsController.this.isCancelled) {
                    IntegrateRbsController.this.pm.close();
                    Nal.getFactory().getLog().nalTrace(2, this.getClass(), "Integrate RBS was canceled by user, caught as an CustomerParameterException:", customerParameterException);
                    this.letUserHandleNodeInUndefinedState(IntegrateRbsController.CANCELLED_MESSAGE);
                    return;
                }
                IntegrateRbsController.this.displayCustomerParameterWarning(customerParameterException);
            }
            catch (Exception exception) {
                if (IntegrateRbsController.this.isCancelled) {
                    IntegrateRbsController.this.pm.close();
                    Nal.getFactory().getLog().nalTrace(4, this.getClass(), "Integrate RBS was canceled by user, caught as an Exception:", exception);
                    this.letUserHandleNodeInUndefinedState(IntegrateRbsController.CANCELLED_MESSAGE);
                    return;
                }
                IntegrateRbsController.this.reportException(exception, "Could not integrate the RBS");
                this.letUserHandleNodeInUndefinedState(IntegrateRbsController.ROLLBACK_MESSAGE);
            }
            finally {
                IntegrateRbsController.this.integrateRbsUtil.removeFromObserverList();
                IntegrateRbsController.this.pm = null;
                IntegrateRbsController.this.myIntegrationPerformerThread = null;
            }
        }

        private void letUserHandleNodeInUndefinedState(String string) {
            boolean bl = IntegrateRbsController.this.displayConfirmOkCancelDialog(string, IntegrateRbsController.VALUE_STRING_CONFIRM);
            if (bl) {
                try {
                    boolean bl2 = IntegrateRbsController.this.integrateRbsUtil.isRollbackCVExisting();
                    if (bl2) {
                        IntegrateRbsController.this.integrateRbsUtil.setRollbackCVAsStartable();
                    }
                }
                catch (Exception exception) {
                    Nal.getFactory().getLog().nalTrace(1, this.getClass(), "Failed to set rollback cv as startable!", exception);
                }
                IntegrateRbsController.this.integrateRbsUtil.restartNode(3);
            }
            IntegrateRbsController.this.application.stopApplicationNoCheck();
        }
    }
}

