/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert;

import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert.AbstractConverter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Action;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSynchronization;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class IpSyncRefActionConverter
extends AbstractConverter {
    private Action convertToAction = null;

    public IpSyncRefActionConverter(Action action) {
        super(null, null);
        this.convertToAction = action;
    }

    public Object convert(Object object) {
        try {
            String string = this.getIpSyncRefLdn(object);
            Integer n = this.getSyncRefPriority(string);
            String string2 = BemUtil.extractRdnId(string, MimIpSyncRef.MOTYPENAME);
            if (string2 != null && string2.length() != 0) {
                int n2 = Integer.parseInt(string2) + 6;
                string = string.substring(0, string.length() - string2.length());
                string = string + String.valueOf(n2);
            }
            Object[] objectArray = new Object[]{new BemMoImpl(string), n};
            this.convertToAction.setValue(objectArray);
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
            Nal.getLog().nalTrace(1, this.getClass(), "Failed to convert value: " + object, bemException);
        }
        return this.convertToAction;
    }

    private String getIpSyncRefLdn(Object object) throws BemException {
        String string = (String)object;
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimIpSystem.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "1");
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi2, MimIpSyncRef.MOTYPENAME, string);
        String string2 = fixedRdnMoi.getLdn();
        return string2;
    }

    private Integer getSyncRefPriority(String string) throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimTransportNetwork.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimSynchronization.MOTYPENAME, "1");
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(singleChildMoi2.getLdn());
        Object object = bemMo.getAttribute("syncReference");
        BemMo[] bemMoArray = (BemMo[])object;
        Object object2 = bemMo.getAttribute("syncRefPriority");
        int[] nArray = (int[])object2;
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo2 = bemMoArray[i];
            if (!bemMo2.getDN().equals(string)) continue;
            return nArray[i];
        }
        throw new BemException("Failed in method " + this.getClass() + ".getSyncRefPriority(), synchPriority not found!");
    }
}

