/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.control.PmDataStorageLogic;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.model.PmDataStorageModel;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.util.PmDataStorageHelp;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.view.PmDataStorageViewer;
import se.ericsson.wcdma.rbs.bem.application.common.model.Configurator;
import se.ericsson.wcdma.rbs.bem.application.common.util.InstallController;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemGuiComponents;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class PmDataStorageController
extends AbstractApplicationController
implements ProgressReporter {
    private PmDataStorageViewer myView = null;
    private PmDataStorageLogic pmDataStorageLogic = null;
    private BemGuiComponents components = null;
    private Configurator configurator = null;
    private boolean preconditionError = false;
    private static final String ERROR_PMSERVICE_LDN = "Can not obtain ldn for PmService";
    private static final String ERROR_GPEH_LDN = "Can not obtain ldn for PredefRbsScannerGpeh";
    private static final String PROBABLE_CAUSE = "Probable cause is that there is a problem with the RBS database (MIB)";

    protected void init() {
        this.myView = (PmDataStorageViewer)((Object)this.getView());
        this.pmDataStorageLogic = new PmDataStorageLogic();
        this.components = this.pmDataStorageLogic.getGuiComponents();
        try {
            PmDataStorageModel.initiate();
            this.runPrecontrollers();
            if (this.preconditionError) {
                return;
            }
            PmDataStorageModel pmDataStorageModel = PmDataStorageModel.getTheInstance();
            this.configurator = pmDataStorageModel.getConfigurator();
            this.myView.setBemComponents(this.components);
        }
        catch (Exception exception) {
            this.displayError(exception.toString());
        }
    }

    protected boolean canStop() {
        return true;
    }

    protected void afterVisible() {
        try {
            if (this.preconditionError) {
                return;
            }
            this.setupComponentsFromModel();
            this.myView.getOkButton().addActionListener(new OkButtonListener());
            this.myView.getCancelButton().addActionListener(new CancelButtonListener());
        }
        catch (Exception exception) {
            this.displayError(exception.toString());
        }
    }

    protected void displayError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
        this.endTheApplication();
    }

    protected void displayErrorMsg(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    public void reportComplete(StringBuffer stringBuffer) {
    }

    public void reportError(BemException bemException) {
        this.getEasyPopUp().displayError(bemException);
        this.preconditionError = true;
    }

    public void reportProgress(String string, String string2) {
    }

    public void reportProgress(String string, String string2, int n) {
    }

    public String getReportedProgress() {
        return "";
    }

    private void runPrecontrollers() {
        Class[] classArray = PmDataStorageHelp.getAllPreControllerClasses();
        PmDataStorageModel.getTheInstance();
        try {
            InstallController installController = new InstallController(this, classArray);
            installController.initiate();
            installController.run_subcontrollers();
        }
        catch (BemException bemException) {
            if (this.preconditionError) {
                return;
            }
            this.displayError(bemException.toString());
        }
    }

    private void setupComponentsFromModel() throws BemException {
        String string = PmDataStorageHelp.getPmServiceLdn(this.configurator);
        if (string == null) {
            throw new BemException("Can not obtain ldn for PmService\nProbable cause is that there is a problem with the RBS database (MIB)");
        }
        NalNameValue nalNameValue = this.configurator.getConfiguredAttribute(string, "performanceDataPath");
        this.components.setValue("GUI", "performanceDataPath", nalNameValue.getValue());
        string = PmDataStorageHelp.getPredefRbsScannerGpehLdn(this.configurator);
        if (string == null) {
            throw new BemException("Can not obtain ldn for PredefRbsScannerGpeh\nProbable cause is that there is a problem with the RBS database (MIB)");
        }
        nalNameValue = this.configurator.getConfiguredAttribute(string, "fileLocation");
        this.components.setValue("GUI", "fileLocation", nalNameValue.getValue());
        nalNameValue = this.configurator.getConfiguredAttribute(string, "maxStorageSize");
        this.components.setValue("GUI", "maxStorageSize", nalNameValue.getValue());
    }

    private void endTheApplication() {
        this.getApplication().stopApplication();
    }

    private boolean updateModel() throws BemException {
        boolean bl = true;
        try {
            bl = this.pmDataStorageLogic.checkSyntax("GUI", null);
            if (bl) {
                NalNameValue nalNameValue = this.components.getNameValue("performanceDataPath");
                String string = PmDataStorageHelp.getPmServiceLdn(this.configurator);
                if (string == null) {
                    throw new BemException("Can not obtain ldn for PmService\nProbable cause is that there is a problem with the RBS database (MIB)");
                }
                this.configurator.modifyConfiguredAttribute(string, nalNameValue);
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                Object object = this.components.getNameValue("fileLocation");
                vector.add((NalNameValue)object);
                object = this.components.getNameValue("maxStorageSize");
                vector.add((NalNameValue)object);
                object = PmDataStorageHelp.getPredefRbsScannerGpehLdn(this.configurator);
                if (object == null) {
                    throw new BemException("Can not obtain ldn for PredefRbsScannerGpeh\nProbable cause is that there is a problem with the RBS database (MIB)");
                }
                this.configurator.modifyConfiguredAttributes((String)object, vector);
            }
        }
        catch (Exception exception) {
            String string = exception.toString();
            this.displayErrorMsg(string);
            return false;
        }
        return bl;
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PmDataStorageController.this.endTheApplication();
        }
    }

    class OkButtonListener
    implements ActionListener {
        OkButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Class[] classArray = PmDataStorageHelp.getAllPostControllerClasses();
            PmDataStorageModel.getTheInstance();
            try {
                boolean bl = PmDataStorageController.this.updateModel();
                if (bl) {
                    InstallController installController = new InstallController(PmDataStorageController.this, classArray);
                    installController.initiate();
                    installController.run_subcontrollers();
                    PmDataStorageController.this.endTheApplication();
                }
            }
            catch (BemException bemException) {
                PmDataStorageController.this.displayError(bemException.toString());
            }
        }
    }
}

