/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.postcontrol;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.model.PmDataStorageModel;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.util.PmDataStorageHelp;
import se.ericsson.wcdma.rbs.bem.application.common.model.Configurator;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public class UpdateNodePostController
implements SubInstaller {
    static final String ERROR_NO_DEFAULT = "No default value defined";
    static final String ERROR_ATTRIB = "Attribute:";
    static final String ERROR_LDN = "MO with LDN:";
    static final String ERROR_NO_VALUES_FOUND = "No values could be read fo MO";
    private String theName = null;
    private Installer theInstaller = null;
    private MoHandler theMoHandler = null;
    private Configurator theConfigurator = null;
    private String theDescription = "Updating the RBS";
    private int totalReports = 3;
    private int myProgressReports = 0;

    public UpdateNodePostController(Installer installer) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
        this.myProgressReports = this.totalReports;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public boolean install() throws BemException {
        BemMo bemMo;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        PmDataStorageModel pmDataStorageModel = PmDataStorageModel.getTheInstance();
        this.theConfigurator = pmDataStorageModel.getConfigurator();
        this.theMoHandler = pmDataStorageModel.getMoHandler();
        this.theDescription = "Updating the RBS with PmService Data";
        String string = PmDataStorageHelp.getPmServiceLdn(this.theConfigurator);
        Vector vector = this.theConfigurator.getChangedAttributes(string);
        if (vector != null && vector.size() > 0) {
            bemMo = this.theMoHandler.getMo(string);
            try {
                this.theMoHandler.setAttributes(bemMo, vector);
            }
            catch (MoHandlerException moHandlerException) {
                BemException bemException = new BemException("Failed " + this.theDescription, (Throwable)moHandlerException);
                throw bemException;
            }
        }
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        this.theDescription = "Updating the RBS with PredefRbsScannerGpeh values";
        string = PmDataStorageHelp.getPredefRbsScannerGpehLdn(this.theConfigurator);
        vector = this.theConfigurator.getChangedAttributes(string);
        if (vector != null && vector.size() > 0) {
            bemMo = this.theMoHandler.getMo(string);
            try {
                this.theMoHandler.setAttributes(bemMo, vector);
            }
            catch (MoHandlerException moHandlerException) {
                BemException bemException = new BemException("Failed " + this.theDescription, (Throwable)moHandlerException);
                throw bemException;
            }
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return true;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }
}

