/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.pmmonitorings.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import se.ericsson.wcdma.rbs.bem.application.applications.pmmonitorings.view.PmViewer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemTable;
import se.ericsson.wcdma.rbs.bem.common.proxy.pmpi.ScannerProxy;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class PmController
extends AbstractApplicationController {
    private PmViewer myView = null;
    private ScannerProxy[] pmScanners = null;
    private BemTable bemTable = null;
    private JButton suspendButton = null;
    private JButton refreshButton = null;
    private JButton helpButton = null;
    private JButton closeButton = null;
    private JTable myJTable = null;
    private static final byte tableListenerIndex = 0;
    private static final byte closeButtonListenerIndex = 1;
    private static final byte suspendButtonListenerIndex = 2;
    private static final byte refreshButtonListenerIndex = 3;
    private static final byte helpButtonListenerIndex = 4;
    Object[] listeners = new Object[6];
    static final int STATE_COLUMN = 1;
    private String hostname = null;

    protected void init() {
        this.hostname = this.getHostname();
    }

    protected boolean canStop() {
        return true;
    }

    protected void afterVisible() {
        this.myView = (PmViewer)((Object)this.getView());
        this.closeButton = this.myView.getCloseButton();
        this.suspendButton = this.myView.getSuspendButton();
        this.suspendButton.setEnabled(false);
        this.refreshButton = this.myView.getRefreshButton();
        this.helpButton = this.myView.getHelpButton();
        this.bemTable = this.myView.getScannerTable();
        this.myJTable = this.bemTable.getTable();
        this.setupListeners();
        try {
            this.pmScanners = ScannerProxy.listScanners(this.hostname);
            this.setScannersInGui(this.pmScanners);
        }
        catch (Exception exception) {
            BemLog.logError(" Error in PmController: afterVisible() ", exception);
            String string = exception.toString();
            this.pmScanners = null;
            this.displayErrorMsg(string);
        }
    }

    private String getHostname() {
        AbstractApplication abstractApplication = this.getApplication();
        String string = abstractApplication.getHostname();
        return string;
    }

    protected void displayError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
        this.endTheApplication();
    }

    private void setStatusMessage(String string) {
        this.getApplication().setStatus(string);
    }

    private void endTheApplication() {
        this.removeAllActiveListeners();
        this.getApplication().stopApplication();
    }

    protected void viewClosing() {
        this.endTheApplication();
        super.viewClosing();
    }

    protected void displayErrorMsg(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    private void setScannersInGui(ScannerProxy[] scannerProxyArray) {
        if (scannerProxyArray == null) {
            return;
        }
        for (int i = 0; i < scannerProxyArray.length; ++i) {
            String string = scannerProxyArray[i].getMeasurmentName();
            String string2 = scannerProxyArray[i].getStateString();
            this.myView.addScannerToGui(string, string2);
        }
    }

    private void setupListeners() {
        CloseButtonListener closeButtonListener = new CloseButtonListener();
        this.listeners[1] = closeButtonListener;
        this.closeButton.addActionListener(closeButtonListener);
        RefreshButtonListener refreshButtonListener = new RefreshButtonListener();
        this.listeners[3] = refreshButtonListener;
        this.refreshButton.addActionListener(refreshButtonListener);
        HelpButtonListener helpButtonListener = new HelpButtonListener();
        this.listeners[4] = helpButtonListener;
        this.helpButton.addActionListener(helpButtonListener);
        SuspendButtonListener suspendButtonListener = new SuspendButtonListener();
        this.listeners[2] = suspendButtonListener;
        this.suspendButton.addActionListener(suspendButtonListener);
        PmFocusListener pmFocusListener = new PmFocusListener();
        this.listeners[0] = pmFocusListener;
        this.myJTable.addFocusListener(pmFocusListener);
    }

    private void enableSuspendButton() {
        this.suspendButton.setEnabled(true);
    }

    private void disableSuspendButton() {
        this.suspendButton.setEnabled(false);
    }

    private void removeAllActiveListeners() {
        this.closeButton.removeActionListener((ActionListener)this.listeners[1]);
        this.suspendButton.removeActionListener((ActionListener)this.listeners[2]);
        this.refreshButton.removeActionListener((ActionListener)this.listeners[3]);
        this.helpButton.removeActionListener((ActionListener)this.listeners[4]);
        this.myJTable.removeFocusListener((FocusListener)this.listeners[0]);
    }

    static /* synthetic */ ScannerProxy[] access$902(PmController pmController, ScannerProxy[] scannerProxyArray) {
        pmController.pmScanners = scannerProxyArray;
        return scannerProxyArray;
    }

    private class PmFocusListener
    implements FocusListener {
        private PmFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            PmController.this.setStatusMessage("");
            if (PmController.this.pmScanners != null && PmController.this.pmScanners.length > 0) {
                PmController.this.enableSuspendButton();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PmController.this.setStatusMessage("");
        }
    }

    private class HelpButtonListener
    implements ActionListener {
        private HelpButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PmController.this.setStatusMessage("The help function is currently not available");
        }
    }

    private class SuspendButtonListener
    implements ActionListener {
        private SuspendButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = PmController.this.myJTable.getSelectedRows();
            int n = 0;
            if (nArray != null) {
                n = nArray.length;
            }
            if (n > 0) {
                PmController.this.setStatusMessage("Suspending scanners");
            }
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                boolean bl3 = true;
                try {
                    bl3 = PmController.this.pmScanners[n2].suspendScanner();
                }
                catch (Exception exception) {
                    this.appendError(n2, stringBuffer, exception.toString());
                    bl = true;
                }
                if (!bl3) {
                    this.appendError(n2, stringBuffer, "Unknown");
                    bl = true;
                    continue;
                }
                bl2 = true;
                String string = PmController.this.pmScanners[n2].getStateString();
                PmController.this.myJTable.setValueAt(string, n2, 1);
            }
            if (bl2 && !bl) {
                PmController.this.setStatusMessage("The suspend action was successful\n");
            } else if (!bl2 && bl) {
                String string = "The suspend action failed\n";
                PmController.this.setStatusMessage(string);
                if (n > 1) {
                    string = this.appendHeader(stringBuffer, string);
                }
                PmController.this.displayErrorMsg(string);
            } else if (bl2 && bl) {
                String string = "The suspend action partly failed\n";
                PmController.this.setStatusMessage(string);
                string = this.appendHeader(stringBuffer, string);
                PmController.this.displayErrorMsg(string);
            }
        }

        private void appendError(int n, StringBuffer stringBuffer, String string) {
            String string2 = PmController.this.pmScanners[n].getMeasurmentName();
            stringBuffer.append("\nMonitoring: " + string2 + "\nFailreason:" + string);
        }

        private String appendHeader(StringBuffer stringBuffer, String string) {
            String string2 = string + stringBuffer.toString();
            return string2;
        }
    }

    private class RefreshButtonListener
    implements ActionListener {
        private RefreshButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PmController.this.setStatusMessage("");
            try {
                PmController.this.disableSuspendButton();
                PmController.this.bemTable.deleteAllRows();
                PmController.access$902(PmController.this, ScannerProxy.listScanners(PmController.this.hostname));
                PmController.this.setScannersInGui(PmController.this.pmScanners);
                PmController.this.setStatusMessage("Performance Monitorings fetched from the Radio Base Station");
            }
            catch (Exception exception) {
                BemLog.logError(" Error in PmController:RefreshButtonListener actionPerformed(ActionEvent ae) ", exception);
                String string = exception.toString();
                PmController.access$902(PmController.this, null);
                PmController.this.displayErrorMsg(string);
            }
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PmController.this.endTheApplication();
        }
    }
}

